/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.cif.eventbased.equivalence;

import java.util.Set;
import org.eclipse.escet.cif.eventbased.automata.Automaton;
import org.eclipse.escet.cif.eventbased.automata.Edge;
import org.eclipse.escet.cif.eventbased.automata.Event;
import org.eclipse.escet.cif.eventbased.automata.Location;
import org.eclipse.escet.cif.eventbased.automata.origin.LocationSetOrigin;
import org.eclipse.escet.cif.eventbased.equivalence.Block;
import org.eclipse.escet.cif.eventbased.equivalence.BlockLocation;
import org.eclipse.escet.cif.eventbased.equivalence.BlockPartitioner;
import org.eclipse.escet.cif.eventbased.equivalence.CounterExample;
import org.eclipse.escet.common.java.Lists;
import org.eclipse.escet.common.java.Sets;

public class AutomatonMinimizer
extends BlockPartitioner {
    public AutomatonMinimizer(Automaton aut) {
        super(Lists.list((Object)aut), false);
    }

    public Automaton minimize() {
        this.performBlockPartitioning();
        Automaton orig = (Automaton)this.automs.get(0);
        int initialBlk = ((BlockLocation)this.blockLocs.get((Object)orig.initial)).blockNumber;
        Automaton result = new Automaton(orig.alphabet);
        Location[] resultLocs = new Location[this.blocks.size()];
        int blkNum = 0;
        while (blkNum < this.blocks.size()) {
            Block block = (Block)this.blocks.get(blkNum);
            LocationSetOrigin origin = new LocationSetOrigin((Set)block.locs.stream().map(b -> b.loc).collect(Sets.toSet()));
            Location loc = new Location(result, origin);
            if (blkNum == initialBlk) {
                result.setInitial(loc);
            }
            loc.marked = block.locs.get((int)0).loc.marked;
            resultLocs[blkNum] = loc;
            ++blkNum;
        }
        blkNum = 0;
        while (blkNum < this.blocks.size()) {
            Location loc = resultLocs[blkNum];
            Block block = (Block)this.blocks.get(blkNum);
            int evtNum = 0;
            while (evtNum < this.events.length) {
                int destBlk = block.outEvents[evtNum];
                if (destBlk != -1) {
                    Location destLoc = resultLocs[destBlk];
                    Edge.addEdge(this.events[evtNum], loc, destLoc);
                }
                ++evtNum;
            }
            ++blkNum;
        }
        return result;
    }

    @Override
    protected CounterExample constructCounterExample(Block block, Event finalEvent) {
        throw new AssertionError((Object)"Counter-example construction should not be needed.");
    }
}

