/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.cif.simulator.runtime.distributions;

import org.eclipse.escet.cif.simulator.runtime.CifSimulatorException;
import org.eclipse.escet.cif.simulator.runtime.CifSimulatorMath;
import org.eclipse.escet.cif.simulator.runtime.distributions.BooleanDistribution;
import org.eclipse.escet.cif.simulator.runtime.distributions.CifRandomGenerator;
import org.eclipse.escet.common.java.Strings;

public class BernoulliDistribution
extends BooleanDistribution {
    private final CifRandomGenerator randGen;
    private final double p;

    public BernoulliDistribution(CifRandomGenerator randGen, double p) {
        this.randGen = randGen;
        this.p = p;
        if (p < 0.0 || p > 1.0) {
            String msg1 = Strings.fmt((String)"Invalid operation: %s.", (Object[])new Object[]{this});
            String msg2 = "The chance parameter is not in the range [0.0 .. 1.0].";
            CifSimulatorException e = new CifSimulatorException(msg2);
            throw new CifSimulatorException(msg1, e);
        }
    }

    private BernoulliDistribution(BernoulliDistribution distribution) {
        this.randGen = distribution.randGen.copy();
        this.p = distribution.p;
    }

    @Override
    public BooleanDistribution copy() {
        return new BernoulliDistribution(this);
    }

    @Override
    public boolean sample() {
        return BernoulliDistribution.sample(this.randGen, this.p);
    }

    public static boolean sample(CifRandomGenerator randGen, double p) {
        return randGen.draw() < p;
    }

    @Override
    public String toString() {
        return Strings.fmt((String)"bernoulli(%s)", (Object[])new Object[]{CifSimulatorMath.realToStr(this.p)});
    }
}

