/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.fix;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.ArrayCreation;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.Type;
import org.eclipse.jdt.core.dom.VariableDeclaration;
import org.eclipse.jdt.core.dom.rewrite.ASTRewrite;
import org.eclipse.jdt.core.dom.rewrite.TargetSourceRangeComputer;
import org.eclipse.jdt.internal.corext.dom.ASTNodes;
import org.eclipse.jdt.internal.corext.fix.CompilationUnitRewriteOperationsFixCore;
import org.eclipse.jdt.internal.corext.fix.FixMessages;
import org.eclipse.jdt.internal.corext.fix.LinkedProposalModelCore;
import org.eclipse.jdt.internal.corext.refactoring.structure.CompilationUnitRewrite;
import org.eclipse.jdt.internal.ui.fix.MultiFixMessages;
import org.eclipse.jdt.ui.cleanup.ICleanUpFix;
import org.eclipse.text.edits.TextEditGroup;

public class ArrayWithCurlyFixCore
extends CompilationUnitRewriteOperationsFixCore {
    public static ICleanUpFix createCleanUp(CompilationUnit compilationUnit) {
        ArrayList<ArrayWithCurlyFixOperation> operations = new ArrayList<ArrayWithCurlyFixOperation>();
        ArrayWithCurlyFinder finder = new ArrayWithCurlyFinder(operations);
        compilationUnit.accept((ASTVisitor)finder);
        if (operations.isEmpty()) {
            return null;
        }
        CompilationUnitRewriteOperationsFixCore.CompilationUnitRewriteOperation[] ops = operations.toArray(new CompilationUnitRewriteOperationsFixCore.CompilationUnitRewriteOperation[0]);
        return new ArrayWithCurlyFixCore(FixMessages.ArrayWithCurlyFix_description, compilationUnit, ops);
    }

    protected ArrayWithCurlyFixCore(String name, CompilationUnit compilationUnit, CompilationUnitRewriteOperationsFixCore.CompilationUnitRewriteOperation[] fixRewriteOperations) {
        super(name, compilationUnit, fixRewriteOperations);
    }

    public static final class ArrayWithCurlyFinder
    extends ASTVisitor {
        private List<ArrayWithCurlyFixOperation> fResult;

        public ArrayWithCurlyFinder(List<ArrayWithCurlyFixOperation> ops) {
            this.fResult = ops;
        }

        public boolean visit(ArrayCreation visited) {
            if (visited.getInitializer() != null || this.isVoid(visited)) {
                ITypeBinding arrayType = visited.resolveTypeBinding();
                ITypeBinding destinationType = ASTNodes.getTargetType((Expression)visited);
                if (arrayType != null && Objects.equals(arrayType, destinationType) && this.isDestinationAllowed((ASTNode)visited)) {
                    this.fResult.add(new ArrayWithCurlyFixOperation(visited));
                    return false;
                }
            }
            return true;
        }

        private boolean isVoid(ArrayCreation visited) {
            List dimensions = visited.dimensions();
            for (Expression dimension : dimensions) {
                if (Long.valueOf(0L).equals(ASTNodes.getIntegerLiteral(dimension))) continue;
                return false;
            }
            return true;
        }

        private boolean isDestinationAllowed(ASTNode visited) {
            boolean correctParent;
            ASTNode parent = visited.getParent();
            int parentType = parent.getNodeType();
            boolean bl = correctParent = parentType == 23 || parentType == 58 || parentType == 59 || parentType == 60;
            if (!correctParent) {
                return false;
            }
            if (parent instanceof VariableDeclaration) {
                Type type = ASTNodes.getType((VariableDeclaration)parent);
                return type == null || !type.isVar();
            }
            return true;
        }
    }

    public static class ArrayWithCurlyFixOperation
    extends CompilationUnitRewriteOperationsFixCore.CompilationUnitRewriteOperation {
        private final ArrayCreation visited;

        public ArrayWithCurlyFixOperation(ArrayCreation visited) {
            this.visited = visited;
        }

        @Override
        public void rewriteAST(CompilationUnitRewrite cuRewrite, LinkedProposalModelCore linkedModel) throws CoreException {
            ASTRewrite rewrite = cuRewrite.getASTRewrite();
            AST ast = cuRewrite.getRoot().getAST();
            TextEditGroup group = this.createTextEditGroup(MultiFixMessages.ArrayWithCurlyCleanup_description, cuRewrite);
            rewrite.setTargetSourceRangeComputer(new TargetSourceRangeComputer(){

                public TargetSourceRangeComputer.SourceRange computeSourceRange(ASTNode nodeWithComment) {
                    if (Boolean.TRUE.equals(nodeWithComment.getProperty("untouchComment"))) {
                        return new TargetSourceRangeComputer.SourceRange(nodeWithComment.getStartPosition(), nodeWithComment.getLength());
                    }
                    return super.computeSourceRange(nodeWithComment);
                }
            });
            if (this.visited.getInitializer() != null) {
                ASTNodes.replaceButKeepComment(rewrite, (ASTNode)this.visited, (ASTNode)ASTNodes.createMoveTarget(rewrite, this.visited.getInitializer()), group);
            } else {
                ASTNodes.replaceButKeepComment(rewrite, (ASTNode)this.visited, (ASTNode)ast.newArrayInitializer(), group);
            }
        }
    }
}

