/*
 * Decompiled with CFR 0.152.
 */
package de.cau.cs.kieler.kiml.config;

import de.cau.cs.kieler.core.kgraph.KGraphData;
import de.cau.cs.kieler.core.properties.IProperty;
import de.cau.cs.kieler.kiml.LayoutContext;
import de.cau.cs.kieler.kiml.LayoutOptionData;
import de.cau.cs.kieler.kiml.config.ILayoutConfig;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VolatileLayoutConfig
implements ILayoutConfig {
    public static final int DEFAULT_PRIORITY = 100;
    private final Map<Object, Map<IProperty<?>, Object>> optionMap = new HashMap();
    private final Set<IProperty<?>> contextKeys = new HashSet();
    private int priority;

    public VolatileLayoutConfig() {
        this.priority = 100;
    }

    public VolatileLayoutConfig(int prio) {
        this.priority = prio;
    }

    public String toString() {
        return "VolatileLayoutConfig:" + this.optionMap.toString();
    }

    @Override
    public int getPriority() {
        return this.priority;
    }

    @Override
    public void enrich(LayoutContext context) {
    }

    @Override
    public Object getValue(LayoutOptionData<?> optionData, LayoutContext context) {
        for (IProperty<?> contextKey : this.contextKeys) {
            Object value;
            Object object = context.getProperty(contextKey);
            Map<IProperty<?>, Object> contextOptions = this.optionMap.get(object);
            if (contextOptions == null || (value = contextOptions.get(optionData)) == null) continue;
            return value;
        }
        return null;
    }

    public void setValue(IProperty<?> option, Object contextObj, IProperty<?> contextKey, Object value) {
        this.contextKeys.add(contextKey);
        Map<IProperty<?>, Object> contextOptions = this.optionMap.get(contextObj);
        if (contextOptions == null) {
            contextOptions = new HashMap();
            this.optionMap.put(contextObj, contextOptions);
        }
        if (value == null) {
            contextOptions.remove(option);
        } else {
            contextOptions.put(option, value);
        }
    }

    public void copyValues(VolatileLayoutConfig other) {
        this.contextKeys.addAll(other.contextKeys);
        this.optionMap.putAll(other.optionMap);
    }

    @Override
    public void transferValues(KGraphData graphData, LayoutContext context) {
        for (IProperty<?> contextKey : this.contextKeys) {
            Object object = context.getProperty(contextKey);
            Map<IProperty<?>, Object> contextOptions = this.optionMap.get(object);
            if (contextOptions == null) continue;
            for (Map.Entry<IProperty<?>, Object> option : contextOptions.entrySet()) {
                graphData.setProperty(option.getKey(), option.getValue());
            }
        }
    }
}

