/*
 * Decompiled with CFR 0.152.
 */
package de.cau.cs.kieler.klay.layered;

import de.cau.cs.kieler.core.alg.BasicProgressMonitor;
import de.cau.cs.kieler.core.alg.IKielerProgressMonitor;
import de.cau.cs.kieler.core.kgraph.KNode;
import de.cau.cs.kieler.kiml.AbstractLayoutProvider;
import de.cau.cs.kieler.kiml.klayoutdata.KShapeLayout;
import de.cau.cs.kieler.kiml.options.Direction;
import de.cau.cs.kieler.kiml.options.EdgeRouting;
import de.cau.cs.kieler.kiml.options.LayoutOptions;
import de.cau.cs.kieler.klay.layered.CompoundKGraphImporter;
import de.cau.cs.kieler.klay.layered.ILayoutPhase;
import de.cau.cs.kieler.klay.layered.ILayoutProcessor;
import de.cau.cs.kieler.klay.layered.IntermediateProcessingConfiguration;
import de.cau.cs.kieler.klay.layered.KGraphImporter;
import de.cau.cs.kieler.klay.layered.Util;
import de.cau.cs.kieler.klay.layered.components.ComponentsProcessor;
import de.cau.cs.kieler.klay.layered.graph.LGraph;
import de.cau.cs.kieler.klay.layered.graph.LGraphElement;
import de.cau.cs.kieler.klay.layered.intermediate.LayoutProcessorStrategy;
import de.cau.cs.kieler.klay.layered.p1cycles.CycleBreakingStrategy;
import de.cau.cs.kieler.klay.layered.p1cycles.GreedyCycleBreaker;
import de.cau.cs.kieler.klay.layered.p1cycles.InteractiveCycleBreaker;
import de.cau.cs.kieler.klay.layered.p2layers.InteractiveLayerer;
import de.cau.cs.kieler.klay.layered.p2layers.LayeringStrategy;
import de.cau.cs.kieler.klay.layered.p2layers.LongestPathLayerer;
import de.cau.cs.kieler.klay.layered.p2layers.NetworkSimplexLayerer;
import de.cau.cs.kieler.klay.layered.p3order.CrossingMinimizationStrategy;
import de.cau.cs.kieler.klay.layered.p3order.InteractiveCrossingMinimizer;
import de.cau.cs.kieler.klay.layered.p3order.LayerSweepCrossingMinimizer;
import de.cau.cs.kieler.klay.layered.p4nodes.BKNodePlacer;
import de.cau.cs.kieler.klay.layered.p4nodes.LinearSegmentsNodePlacer;
import de.cau.cs.kieler.klay.layered.p4nodes.NodePlacementStrategy;
import de.cau.cs.kieler.klay.layered.p5edges.OrthogonalEdgeRouter;
import de.cau.cs.kieler.klay.layered.p5edges.PolylineEdgeRouter;
import de.cau.cs.kieler.klay.layered.p5edges.SplineEdgeRouter;
import de.cau.cs.kieler.klay.layered.properties.GraphProperties;
import de.cau.cs.kieler.klay.layered.properties.Properties;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LayeredLayoutProvider
extends AbstractLayoutProvider {
    private ILayoutPhase cycleBreaker;
    private ILayoutPhase layerer;
    private ILayoutPhase crossingMinimizer;
    private ILayoutPhase nodePlacer;
    private ILayoutPhase edgeRouter;
    private ComponentsProcessor componentsProcessor = new ComponentsProcessor();
    private IntermediateProcessingConfiguration intermediateProcessingConfiguration = new IntermediateProcessingConfiguration();
    private Map<LayoutProcessorStrategy, ILayoutProcessor> intermediateLayoutProcessorCache = new HashMap<LayoutProcessorStrategy, ILayoutProcessor>();
    private List<ILayoutProcessor> algorithm = new LinkedList<ILayoutProcessor>();
    private static final IntermediateProcessingConfiguration BASELINE_PROCESSING_CONFIGURATION = new IntermediateProcessingConfiguration(null, null, EnumSet.of(LayoutProcessorStrategy.PORT_LIST_SORTER, LayoutProcessorStrategy.PORT_SIDE_PROCESSOR), EnumSet.of(LayoutProcessorStrategy.NODE_MARGIN_CALCULATOR, LayoutProcessorStrategy.PORT_POSITION_PROCESSOR), null, null);
    private static final IntermediateProcessingConfiguration FLATTENED_HIERARCHY_PROCESSING_ADDITIONS = new IntermediateProcessingConfiguration(EnumSet.of(LayoutProcessorStrategy.COMPOUND_CYCLE_PROCESSOR), null, EnumSet.of(LayoutProcessorStrategy.COMPOUND_DUMMY_EDGE_REMOVER), EnumSet.of(LayoutProcessorStrategy.SUBGRAPH_ORDERING_PROCESSOR, LayoutProcessorStrategy.COMPOUND_SIDE_PROCESSOR), null, EnumSet.of(LayoutProcessorStrategy.COMPOUND_GRAPH_RESTORER));

    public void doLayout(KNode kgraph, IKielerProgressMonitor progressMonitor) {
        progressMonitor.begin("Layered layout", 1.0f);
        LGraphElement.HashCodeCounter hashCodeCounter = new LGraphElement.HashCodeCounter();
        KShapeLayout sourceShapeLayout = (KShapeLayout)kgraph.getData(KShapeLayout.class);
        boolean isCompound = (Boolean)sourceShapeLayout.getProperty(LayoutOptions.LAYOUT_HIERARCHY);
        KGraphImporter graphImporter = isCompound ? new CompoundKGraphImporter(hashCodeCounter) : new KGraphImporter(hashCodeCounter);
        LGraph layeredGraph = graphImporter.importGraph(kgraph);
        this.setOptions(layeredGraph, kgraph);
        this.updateModules(layeredGraph, (KShapeLayout)kgraph.getData(KShapeLayout.class));
        List<LGraph> components = this.componentsProcessor.split(layeredGraph);
        for (LGraph comp : components) {
            this.layout(comp, progressMonitor.subTask(1.0f / (float)components.size()));
        }
        layeredGraph = this.componentsProcessor.pack(components);
        graphImporter.applyLayout(layeredGraph);
        progressMonitor.done();
    }

    public List<LGraph> doLayoutTest(KNode kgraph, IKielerProgressMonitor progressMonitor, Class<? extends ILayoutProcessor> phase) {
        progressMonitor.begin("Layered layout test", 1.0f);
        LGraphElement.HashCodeCounter hashCodeCounter = new LGraphElement.HashCodeCounter();
        KShapeLayout sourceShapeLayout = (KShapeLayout)kgraph.getData(KShapeLayout.class);
        boolean isCompound = (Boolean)sourceShapeLayout.getProperty(LayoutOptions.LAYOUT_HIERARCHY);
        KGraphImporter graphImporter = isCompound ? new CompoundKGraphImporter(hashCodeCounter) : new KGraphImporter(hashCodeCounter);
        LGraph layeredGraph = graphImporter.importGraph(kgraph);
        this.setOptions(layeredGraph, kgraph);
        this.updateModules(layeredGraph, (KShapeLayout)kgraph.getData(KShapeLayout.class));
        List<LGraph> components = this.componentsProcessor.split(layeredGraph);
        boolean phaseExists = false;
        for (ILayoutProcessor processor : this.algorithm) {
            if (!processor.getClass().equals(phase)) continue;
            phaseExists = true;
            break;
        }
        if (phaseExists) {
            for (LGraph comp : components) {
                this.layoutTest(comp, progressMonitor.subTask(1.0f / (float)components.size()), phase);
            }
        }
        progressMonitor.done();
        return components;
    }

    private void setOptions(LGraph layeredGraph, KNode parent) {
        Integer randomSeed = (Integer)layeredGraph.getProperty(LayoutOptions.RANDOM_SEED);
        if (randomSeed != null) {
            int val = randomSeed;
            if (val == 0) {
                layeredGraph.setProperty(Properties.RANDOM, new Random());
            } else {
                layeredGraph.setProperty(Properties.RANDOM, new Random(val));
            }
        } else {
            layeredGraph.setProperty(Properties.RANDOM, new Random(1L));
        }
    }

    private void updateModules(LGraph graph, KShapeLayout parentLayout) {
        CycleBreakingStrategy cycleBreaking = (CycleBreakingStrategy)((Object)parentLayout.getProperty(Properties.CYCLE_BREAKING));
        switch (cycleBreaking) {
            case INTERACTIVE: {
                if (this.cycleBreaker instanceof InteractiveCycleBreaker) break;
                this.cycleBreaker = new InteractiveCycleBreaker();
                break;
            }
            default: {
                if (this.cycleBreaker instanceof GreedyCycleBreaker) break;
                this.cycleBreaker = new GreedyCycleBreaker();
            }
        }
        LayeringStrategy layering = (LayeringStrategy)((Object)parentLayout.getProperty(Properties.NODE_LAYERING));
        switch (layering) {
            case LONGEST_PATH: {
                if (this.layerer instanceof LongestPathLayerer) break;
                this.layerer = new LongestPathLayerer();
                break;
            }
            case INTERACTIVE: {
                if (this.layerer instanceof InteractiveLayerer) break;
                this.layerer = new InteractiveLayerer();
                break;
            }
            default: {
                if (this.layerer instanceof NetworkSimplexLayerer) break;
                this.layerer = new NetworkSimplexLayerer();
            }
        }
        CrossingMinimizationStrategy crossminStrategy = (CrossingMinimizationStrategy)((Object)parentLayout.getProperty(Properties.CROSSMIN));
        switch (crossminStrategy) {
            case INTERACTIVE: {
                if (this.crossingMinimizer instanceof InteractiveCrossingMinimizer) break;
                this.crossingMinimizer = new InteractiveCrossingMinimizer();
                break;
            }
            default: {
                if (this.crossingMinimizer instanceof LayerSweepCrossingMinimizer) break;
                this.crossingMinimizer = new LayerSweepCrossingMinimizer();
            }
        }
        NodePlacementStrategy nodePlaceStrategy = (NodePlacementStrategy)((Object)parentLayout.getProperty(Properties.NODEPLACE));
        switch (nodePlaceStrategy) {
            case LINEAR_SEGMENTS: {
                if (this.nodePlacer instanceof LinearSegmentsNodePlacer) break;
                this.nodePlacer = new LinearSegmentsNodePlacer();
                break;
            }
            case BRANDES_KOEPF: {
                if (this.nodePlacer instanceof BKNodePlacer) break;
                this.nodePlacer = new BKNodePlacer();
                break;
            }
            default: {
                if (this.nodePlacer instanceof LinearSegmentsNodePlacer) break;
                this.nodePlacer = new LinearSegmentsNodePlacer();
            }
        }
        EdgeRouting routing = (EdgeRouting)parentLayout.getProperty(LayoutOptions.EDGE_ROUTING);
        switch (routing) {
            case ORTHOGONAL: {
                if (this.edgeRouter instanceof OrthogonalEdgeRouter) break;
                this.edgeRouter = new OrthogonalEdgeRouter();
                break;
            }
            case SPLINES: {
                if (this.edgeRouter instanceof SplineEdgeRouter) break;
                this.edgeRouter = new SplineEdgeRouter();
                break;
            }
            default: {
                if (this.edgeRouter instanceof PolylineEdgeRouter) break;
                this.edgeRouter = new PolylineEdgeRouter();
            }
        }
        this.intermediateProcessingConfiguration.clear();
        this.intermediateProcessingConfiguration.addAll(this.cycleBreaker.getIntermediateProcessingConfiguration(graph)).addAll(this.layerer.getIntermediateProcessingConfiguration(graph)).addAll(this.crossingMinimizer.getIntermediateProcessingConfiguration(graph)).addAll(this.nodePlacer.getIntermediateProcessingConfiguration(graph)).addAll(this.edgeRouter.getIntermediateProcessingConfiguration(graph)).addAll(this.getIntermediateProcessingConfiguration(graph));
        this.algorithm.clear();
        this.algorithm.addAll(this.getIntermediateProcessorList(0));
        this.algorithm.add(this.cycleBreaker);
        this.algorithm.addAll(this.getIntermediateProcessorList(1));
        this.algorithm.add(this.layerer);
        this.algorithm.addAll(this.getIntermediateProcessorList(2));
        this.algorithm.add(this.crossingMinimizer);
        this.algorithm.addAll(this.getIntermediateProcessorList(3));
        this.algorithm.add(this.nodePlacer);
        this.algorithm.addAll(this.getIntermediateProcessorList(4));
        this.algorithm.add(this.edgeRouter);
        this.algorithm.addAll(this.getIntermediateProcessorList(5));
    }

    private List<ILayoutProcessor> getIntermediateProcessorList(int slotIndex) {
        Set<LayoutProcessorStrategy> processors = this.intermediateProcessingConfiguration.getProcessors(slotIndex);
        ArrayList<ILayoutProcessor> result = new ArrayList<ILayoutProcessor>(processors.size());
        for (LayoutProcessorStrategy processor : processors) {
            ILayoutProcessor processorImpl = this.intermediateLayoutProcessorCache.get((Object)processor);
            if (processorImpl == null) {
                processorImpl = processor.create();
                this.intermediateLayoutProcessorCache.put(processor, processorImpl);
            }
            result.add(processorImpl);
        }
        return result;
    }

    private IntermediateProcessingConfiguration getIntermediateProcessingConfiguration(LGraph graph) {
        Set graphProperties = (Set)graph.getProperty(Properties.GRAPH_PROPERTIES);
        IntermediateProcessingConfiguration configuration = new IntermediateProcessingConfiguration(BASELINE_PROCESSING_CONFIGURATION);
        switch ((Direction)graph.getProperty(LayoutOptions.DIRECTION)) {
            case LEFT: {
                configuration.addLayoutProcessor(0, LayoutProcessorStrategy.LEFT_DIR_PREPROCESSOR);
                configuration.addLayoutProcessor(5, LayoutProcessorStrategy.LEFT_DIR_POSTPROCESSOR);
                break;
            }
            case DOWN: {
                configuration.addLayoutProcessor(0, LayoutProcessorStrategy.DOWN_DIR_PREPROCESSOR);
                configuration.addLayoutProcessor(5, LayoutProcessorStrategy.DOWN_DIR_POSTPROCESSOR);
                break;
            }
            case UP: {
                configuration.addLayoutProcessor(0, LayoutProcessorStrategy.UP_DIR_PREPROCESSOR);
                configuration.addLayoutProcessor(5, LayoutProcessorStrategy.UP_DIR_POSTPROCESSOR);
                break;
            }
        }
        if (graphProperties.contains((Object)GraphProperties.FLAT_HIERARCHICAL)) {
            configuration.addAll(FLATTENED_HIERARCHY_PROCESSING_ADDITIONS);
        }
        if (graphProperties.contains((Object)GraphProperties.COMMENTS)) {
            configuration.addLayoutProcessor(0, LayoutProcessorStrategy.COMMENT_PREPROCESSOR);
            configuration.addLayoutProcessor(5, LayoutProcessorStrategy.COMMENT_POSTPROCESSOR);
        }
        return configuration;
    }

    public void layout(LGraph graph, IKielerProgressMonitor themonitor) {
        IKielerProgressMonitor monitor = themonitor;
        if (monitor == null) {
            monitor = new BasicProgressMonitor();
        }
        monitor.begin("Component Layout", (float)this.algorithm.size());
        if (((Boolean)graph.getProperty(LayoutOptions.DEBUG_MODE)).booleanValue()) {
            System.out.println("KLay Layered uses the following " + this.algorithm.size() + " modules:");
            int i = 0;
            while (i < this.algorithm.size()) {
                System.out.println("   Slot " + String.format("%1$02d", i) + ": " + this.algorithm.get(i).getClass().getName());
                ++i;
            }
            int slotIndex = 0;
            for (ILayoutProcessor processor : this.algorithm) {
                if (monitor.isCanceled()) {
                    return;
                }
                try {
                    graph.writeDotGraph(this.createWriter(graph, slotIndex++));
                }
                catch (IOException iOException) {}
                processor.reset(monitor.subTask(1.0f));
                processor.process(graph);
            }
            try {
                graph.writeDotGraph(this.createWriter(graph, slotIndex++));
            }
            catch (IOException iOException) {}
        } else {
            for (ILayoutProcessor processor : this.algorithm) {
                if (monitor.isCanceled()) {
                    return;
                }
                processor.reset(monitor.subTask(1.0f));
                processor.process(graph);
            }
        }
        monitor.done();
    }

    public void layoutTest(LGraph graph, IKielerProgressMonitor themonitor, Class<? extends ILayoutProcessor> phase) {
        IKielerProgressMonitor monitor = themonitor;
        if (monitor == null) {
            monitor = new BasicProgressMonitor();
        }
        monitor.begin("Component Layout", (float)this.algorithm.size());
        for (ILayoutProcessor processor : this.algorithm) {
            if (monitor.isCanceled()) {
                return;
            }
            processor.reset(monitor.subTask(1.0f));
            processor.process(graph);
            if (processor.getClass().equals(phase)) break;
        }
        monitor.done();
    }

    private Writer createWriter(LGraph graph, int slotIndex) throws IOException {
        String path = Util.getDebugOutputPath();
        new File(path).mkdirs();
        String debugFileName = String.valueOf(Util.getDebugOutputFileBaseName(graph)) + "fulldebug-slot" + String.format("%1$02d", slotIndex);
        return new FileWriter(new File(String.valueOf(path) + File.separator + debugFileName + ".dot"));
    }
}

