/*
 * Decompiled with CFR 0.152.
 */
package de.cau.cs.kieler.klay.layered.graph;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Iterables;
import de.cau.cs.kieler.core.math.KVector;
import de.cau.cs.kieler.core.properties.IProperty;
import de.cau.cs.kieler.kiml.options.PortSide;
import de.cau.cs.kieler.klay.layered.graph.LEdge;
import de.cau.cs.kieler.klay.layered.graph.LGraph;
import de.cau.cs.kieler.klay.layered.graph.LInsets;
import de.cau.cs.kieler.klay.layered.graph.LLabel;
import de.cau.cs.kieler.klay.layered.graph.LPort;
import de.cau.cs.kieler.klay.layered.graph.LShape;
import de.cau.cs.kieler.klay.layered.graph.Layer;
import de.cau.cs.kieler.klay.layered.properties.InteractiveReferencePoint;
import de.cau.cs.kieler.klay.layered.properties.PortType;
import de.cau.cs.kieler.klay.layered.properties.Properties;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LNode
extends LShape {
    private static final long serialVersionUID = -4272570519129722541L;
    private Layer owner;
    private final List<LPort> ports = new LinkedList<LPort>();
    private final List<LLabel> labels = new LinkedList<LLabel>();
    private final LInsets.Double margin = new LInsets.Double();

    public LNode(LGraph graph) {
        super(graph);
    }

    public String toString() {
        String name = this.getName();
        if (name == null) {
            return "n_" + this.id;
        }
        return "n_" + name;
    }

    public String getName() {
        if (!this.labels.isEmpty()) {
            return this.labels.get(0).getText();
        }
        return null;
    }

    public Layer getLayer() {
        return this.owner;
    }

    public void setLayer(Layer layer) {
        if (this.owner != null) {
            this.owner.getNodes().remove(this);
        }
        this.owner = layer;
        if (this.owner != null) {
            this.owner.getNodes().add(this);
        }
    }

    public void setLayer(int index, Layer layer) {
        if (layer != null && (index < 0 || index > layer.getNodes().size())) {
            throw new IllegalArgumentException("index must be >= 0 and <= layer node count");
        }
        if (this.owner != null) {
            this.owner.getNodes().remove(this);
        }
        this.owner = layer;
        if (this.owner != null) {
            this.owner.getNodes().add(index, this);
        }
    }

    public List<LPort> getPorts() {
        return this.ports;
    }

    public Iterable<LPort> getPorts(PortType portType) {
        switch (portType) {
            case INPUT: {
                return Iterables.filter(this.ports, LPort.INPUT_PREDICATE);
            }
            case OUTPUT: {
                return Iterables.filter(this.ports, LPort.OUTPUT_PREDICATE);
            }
        }
        return Collections.emptyList();
    }

    public Iterable<LPort> getPorts(PortSide side) {
        switch (side) {
            case NORTH: {
                return Iterables.filter(this.ports, LPort.NORTH_PREDICATE);
            }
            case EAST: {
                return Iterables.filter(this.ports, LPort.EAST_PREDICATE);
            }
            case SOUTH: {
                return Iterables.filter(this.ports, LPort.SOUTH_PREDICATE);
            }
            case WEST: {
                return Iterables.filter(this.ports, LPort.WEST_PREDICATE);
            }
        }
        return Collections.emptyList();
    }

    public Iterable<LPort> getPorts(PortType portType, PortSide side) {
        Predicate<LPort> typePredicate = null;
        switch (portType) {
            case INPUT: {
                typePredicate = LPort.INPUT_PREDICATE;
                break;
            }
            case OUTPUT: {
                typePredicate = LPort.OUTPUT_PREDICATE;
            }
        }
        Predicate<LPort> sidePredicate = null;
        switch (side) {
            case NORTH: {
                sidePredicate = LPort.NORTH_PREDICATE;
                break;
            }
            case EAST: {
                sidePredicate = LPort.EAST_PREDICATE;
                break;
            }
            case SOUTH: {
                sidePredicate = LPort.SOUTH_PREDICATE;
                break;
            }
            case WEST: {
                sidePredicate = LPort.WEST_PREDICATE;
            }
        }
        if (typePredicate != null && sidePredicate != null) {
            return Iterables.filter(this.ports, (Predicate)Predicates.and(typePredicate, sidePredicate));
        }
        return Collections.emptyList();
    }

    public Iterable<LEdge> getIncomingEdges() {
        LinkedList<List<LEdge>> iterables = new LinkedList<List<LEdge>>();
        for (LPort port : this.ports) {
            iterables.add(port.getIncomingEdges());
        }
        return Iterables.concat(iterables);
    }

    public Iterable<LEdge> getOutgoingEdges() {
        LinkedList<List<LEdge>> iterables = new LinkedList<List<LEdge>>();
        for (LPort port : this.ports) {
            iterables.add(port.getOutgoingEdges());
        }
        return Iterables.concat(iterables);
    }

    public Iterable<LEdge> getConnectedEdges() {
        LinkedList<Iterable<LEdge>> iterables = new LinkedList<Iterable<LEdge>>();
        for (LPort port : this.ports) {
            iterables.add(port.getConnectedEdges());
        }
        return Iterables.concat(iterables);
    }

    public List<LLabel> getLabels() {
        return this.labels;
    }

    public LInsets.Double getMargin() {
        return this.margin;
    }

    public int getIndex() {
        if (this.owner == null) {
            return -1;
        }
        return this.owner.getNodes().indexOf(this);
    }

    public void borderToContentAreaCoordinates(boolean horizontal, boolean vertical) {
        if (this.owner == null || this.owner.getGraph() == null) {
            throw new IllegalStateException("node is not assigned to a layer in a graph.");
        }
        LGraph graph = this.owner.getGraph();
        LInsets.Double insets = graph.getInsets();
        float borderSpacing = ((Float)graph.getProperty((IProperty)Properties.BORDER_SPACING)).floatValue();
        KVector offset = graph.getOffset();
        KVector pos = this.getPosition();
        if (horizontal) {
            pos.x = pos.x - insets.left - (double)borderSpacing - offset.x;
        }
        if (vertical) {
            pos.y = pos.y - insets.top - (double)borderSpacing - offset.y;
        }
    }

    public KVector getInteractiveReferencePoint(LGraph graph) {
        switch ((InteractiveReferencePoint)((Object)graph.getProperty(Properties.INTERACTIVE_REFERENCE_POINT))) {
            case CENTER: {
                KVector nodePos = this.getPosition();
                KVector nodeSize = this.getSize();
                return new KVector(nodePos.x + nodeSize.x / 2.0, nodePos.y + nodeSize.y / 2.0);
            }
            case TOP_LEFT: {
                return new KVector(this.getPosition());
            }
        }
        return null;
    }
}

