/*
 * Decompiled with CFR 0.152.
 */
package de.cau.cs.kieler.klay.force.graph;

import de.cau.cs.kieler.core.math.KVector;
import de.cau.cs.kieler.core.properties.IProperty;
import de.cau.cs.kieler.klay.force.graph.FEdge;
import de.cau.cs.kieler.klay.force.graph.FParticle;
import de.cau.cs.kieler.klay.force.properties.Properties;

public class FLabel
extends FParticle {
    private static final long serialVersionUID = 9047772256368142239L;
    private FEdge edge;
    private String text;

    public FLabel(FEdge fedge, String text) {
        this.edge = fedge;
        this.text = text;
        this.edge.getLabels().add(this);
    }

    public String toString() {
        if (this.text == null || this.text.length() == 0) {
            return "l[" + this.edge.toString() + "]";
        }
        return "l_" + this.text;
    }

    public String getText() {
        return this.text;
    }

    public FEdge getEdge() {
        return this.edge;
    }

    public void refreshPosition() {
        double spacing = ((Float)this.edge.getProperty((IProperty)Properties.LABEL_SPACING)).floatValue();
        KVector src = this.edge.getSource().getPosition();
        KVector tgt = this.edge.getTarget().getPosition();
        KVector pos = this.getPosition();
        if (src.x >= tgt.x) {
            if (src.y >= tgt.y) {
                pos.x = tgt.x + (src.x - tgt.x) / 2.0 + spacing;
                pos.y = tgt.y + (src.y - tgt.y) / 2.0 - spacing;
            } else {
                pos.x = tgt.x + (src.x - tgt.x) / 2.0 + spacing;
                pos.y = src.y + (tgt.y - src.y) / 2.0 + spacing;
            }
        } else if (src.y >= tgt.y) {
            pos.x = src.x + (tgt.x - src.x) / 2.0 + spacing;
            pos.y = tgt.y + (src.y - tgt.y) / 2.0 + spacing;
        } else {
            pos.x = src.x + (tgt.x - src.x) / 2.0 + spacing;
            pos.y = src.y + (tgt.y - src.y) / 2.0 - spacing;
        }
    }
}

