/*
 * Decompiled with CFR 0.152.
 */
package de.cau.cs.kieler.klay.force.graph;

import de.cau.cs.kieler.core.math.KVector;
import de.cau.cs.kieler.klay.force.graph.FParticle;
import java.util.LinkedList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FNode
extends FParticle {
    private static final long serialVersionUID = 8663670492984978893L;
    public int id;
    private KVector displacement = new KVector();
    private String label;
    private FNode parent;
    private List<FNode> children;

    public FNode() {
    }

    public FNode(String label) {
        this.label = label;
    }

    public FNode(String label, FNode theParent) {
        this.label = label;
        this.parent = theParent;
    }

    public String toString() {
        if (this.label == null || this.label.length() == 0) {
            return "n_" + this.id;
        }
        return "n_" + this.label;
    }

    public final KVector getDisplacement() {
        return this.displacement;
    }

    public boolean isCompound() {
        return this.children != null && this.children.size() > 0;
    }

    public String getLabel() {
        return this.label;
    }

    public FNode getParent() {
        return this.parent;
    }

    public List<FNode> getChildren() {
        if (this.children == null) {
            this.children = new LinkedList<FNode>();
        }
        return this.children;
    }

    public int getDepth() {
        int depth = 0;
        FNode node = this.parent;
        while (node != null) {
            node = node.getParent();
            ++depth;
        }
        return depth;
    }
}

