/**
 * Copyright (c) 2017 Inria and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     Inria - initial API and implementation
 */
package fr.inria.diverse.melange.jvmmodel;

import com.google.common.base.Objects;
import com.google.inject.Inject;
import fr.inria.diverse.melange.ast.ASTHelper;
import fr.inria.diverse.melange.ast.LanguageExtensions;
import fr.inria.diverse.melange.ast.ModelTypeExtensions;
import fr.inria.diverse.melange.ast.ModelingElementExtensions;
import fr.inria.diverse.melange.ast.NamingHelper;
import fr.inria.diverse.melange.jvmmodel.LanguageInferrer;
import fr.inria.diverse.melange.jvmmodel.ModelTypeInferrer;
import fr.inria.diverse.melange.jvmmodel.TransformationInferrer;
import fr.inria.diverse.melange.metamodel.melange.ExternalLanguage;
import fr.inria.diverse.melange.metamodel.melange.Language;
import fr.inria.diverse.melange.metamodel.melange.ModelType;
import fr.inria.diverse.melange.metamodel.melange.ModelTypingSpace;
import fr.inria.diverse.melange.metamodel.melange.ResourceType;
import fr.inria.diverse.melange.metamodel.melange.Subtyping;
import fr.inria.diverse.melange.metamodel.melange.XbaseTransformation;
import fr.inria.diverse.melange.preferences.MelangePreferencesAccess;
import fr.inria.diverse.melange.resource.MelangeRegistry;
import fr.inria.diverse.melange.resource.MelangeRegistryImpl;
import fr.inria.diverse.melange.resource.MelangeResourceFactoryImpl;
import java.util.Arrays;
import java.util.Set;
import java.util.function.Consumer;
import org.apache.log4j.Logger;
import org.eclipse.emf.codegen.ecore.genmodel.GenPackage;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.xmi.impl.XMIResourceFactoryImpl;
import org.eclipse.xtend2.lib.StringConcatenationClient;
import org.eclipse.xtext.common.types.JvmGenericType;
import org.eclipse.xtext.common.types.JvmMember;
import org.eclipse.xtext.common.types.JvmOperation;
import org.eclipse.xtext.naming.IQualifiedNameConverter;
import org.eclipse.xtext.naming.IQualifiedNameProvider;
import org.eclipse.xtext.naming.QualifiedName;
import org.eclipse.xtext.xbase.jvmmodel.AbstractModelInferrer;
import org.eclipse.xtext.xbase.jvmmodel.IJvmDeclaredTypeAcceptor;
import org.eclipse.xtext.xbase.jvmmodel.JvmTypesBuilder;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.Functions.Function1;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.Procedures.Procedure1;
import org.eclipse.xtext.xbase.lib.StringExtensions;

/**
 * Entry point for the generation of a JVM model from which Xtext will
 * ultimately generate Java code.
 */
@SuppressWarnings("all")
public class MelangeJvmModelInferrer extends AbstractModelInferrer {
  @Inject
  @Extension
  private ASTHelper _aSTHelper;
  
  @Inject
  @Extension
  private ModelTypeInferrer _modelTypeInferrer;
  
  @Inject
  @Extension
  private LanguageInferrer _languageInferrer;
  
  @Inject
  @Extension
  private TransformationInferrer _transformationInferrer;
  
  @Inject
  @Extension
  private LanguageExtensions _languageExtensions;
  
  @Inject
  @Extension
  private ModelingElementExtensions _modelingElementExtensions;
  
  @Inject
  @Extension
  private ModelTypeExtensions _modelTypeExtensions;
  
  @Inject
  @Extension
  private JvmTypesBuilder _jvmTypesBuilder;
  
  @Inject
  @Extension
  private NamingHelper _namingHelper;
  
  @Inject
  @Extension
  private IQualifiedNameProvider _iQualifiedNameProvider;
  
  @Inject
  @Extension
  private IQualifiedNameConverter _iQualifiedNameConverter;
  
  private static final Logger log = Logger.getLogger(MelangeJvmModelInferrer.class);
  
  /**
   * Generates all the Java code supporting languages, interfaces, and
   * adapters. {@code infer} is invoked right after the fully derived state
   * of the Melange model is computed by
   * {@link MelangeDerivedStateComputer#installDerivedState}. Essentially
   * delegates to the other inferrers.
   * 
   * @param root The Melange model for which we want to generate code
   * @param acceptor Automatically filled by Xtext
   * @param isPreIndexingPhase Automatically filled by Xtext
   */
  protected void _infer(final ModelTypingSpace root, final IJvmDeclaredTypeAcceptor acceptor, final boolean isPreIndexingPhase) {
    if ((IterableExtensions.<Language>exists(this._aSTHelper.getLanguages(root), new Function1<Language, Boolean>() {
      @Override
      public Boolean apply(final Language it) {
        return Boolean.valueOf(((!MelangeJvmModelInferrer.this._languageExtensions.isValid(it)) || (!MelangeJvmModelInferrer.this._languageExtensions.getRuntimeHasBeenGenerated(it))));
      }
    }) || IterableExtensions.<ModelType>exists(this._aSTHelper.getModelTypes(root), new Function1<ModelType, Boolean>() {
      @Override
      public Boolean apply(final ModelType it) {
        boolean _isValid = MelangeJvmModelInferrer.this._modelTypeExtensions.isValid(it);
        return Boolean.valueOf((!_isValid));
      }
    }))) {
      return;
    }
    try {
      final Consumer<ModelType> _function = new Consumer<ModelType>() {
        @Override
        public void accept(final ModelType it) {
          MelangeJvmModelInferrer.this._modelTypeInferrer.generateInterfaces(it, acceptor, MelangeJvmModelInferrer.this._typeReferenceBuilder);
        }
      };
      this._aSTHelper.getModelTypes(root).forEach(_function);
      if ((MelangePreferencesAccess.getInstance().isGenerateAdaptersCode() || (MelangePreferencesAccess.getInstance().isUserLaunch() && (!isPreIndexingPhase)))) {
        this._languageExtensions.makeAllSemantics(root);
        final Consumer<Language> _function_1 = new Consumer<Language>() {
          @Override
          public void accept(final Language it) {
            MelangeJvmModelInferrer.this._languageInferrer.generateAdapters(it, root, acceptor, MelangeJvmModelInferrer.this._typeReferenceBuilder);
          }
        };
        this._aSTHelper.getLanguages(root).forEach(_function_1);
        final Consumer<XbaseTransformation> _function_2 = new Consumer<XbaseTransformation>() {
          @Override
          public void accept(final XbaseTransformation it) {
            MelangeJvmModelInferrer.this._transformationInferrer.generateTransformation(it, acceptor, MelangeJvmModelInferrer.this._typeReferenceBuilder);
          }
        };
        this._aSTHelper.getTransformations(root).forEach(_function_2);
        this.createStandaloneSetup(root, acceptor);
        MelangePreferencesAccess.getInstance().disableCodeGenerator();
      }
    } catch (final Throwable _t) {
      if (_t instanceof Exception) {
        final Exception e = (Exception)_t;
        MelangeJvmModelInferrer.log.error("Error while generating", e);
      } else {
        throw Exceptions.sneakyThrow(_t);
      }
    }
  }
  
  /**
   * Creates a generic StandaloneSetup class meant to be used for
   * registering languages, interfaces and adapters in a standalone context.
   */
  public void createStandaloneSetup(final ModelTypingSpace root, final IJvmDeclaredTypeAcceptor acceptor) {
    final Procedure1<JvmGenericType> _function = new Procedure1<JvmGenericType>() {
      @Override
      public void apply(final JvmGenericType it) {
        EList<JvmMember> _members = it.getMembers();
        final Procedure1<JvmOperation> _function = new Procedure1<JvmOperation>() {
          @Override
          public void apply(final JvmOperation it) {
            it.setStatic(true);
            StringConcatenationClient _client = new StringConcatenationClient() {
              @Override
              protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                _builder.append("StandaloneSetup setup = new StandaloneSetup();");
                _builder.newLine();
                _builder.append("setup.doEMFRegistration();");
                _builder.newLine();
                _builder.append("setup.doAdaptersRegistration();");
                _builder.newLine();
              }
            };
            MelangeJvmModelInferrer.this._jvmTypesBuilder.setBody(it, _client);
          }
        };
        JvmOperation _method = MelangeJvmModelInferrer.this._jvmTypesBuilder.toMethod(root, "doSetup", MelangeJvmModelInferrer.this._typeReferenceBuilder.typeRef(Void.TYPE), _function);
        MelangeJvmModelInferrer.this._jvmTypesBuilder.<JvmOperation>operator_add(_members, _method);
        EList<JvmMember> _members_1 = it.getMembers();
        final Procedure1<JvmOperation> _function_1 = new Procedure1<JvmOperation>() {
          @Override
          public void apply(final JvmOperation it) {
            StringConcatenationClient _client = new StringConcatenationClient() {
              @Override
              protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                {
                  Iterable<Language> _languages = MelangeJvmModelInferrer.this._aSTHelper.getLanguages(root);
                  for(final Language l : _languages) {
                    {
                      if ((Objects.equal(l.getResourceType(), ResourceType.XTEXT) && (l.getXtextSetupRef() != null))) {
                        String _qualifiedName = l.getXtextSetupRef().getQualifiedName();
                        _builder.append(_qualifiedName);
                        _builder.append(".doSetup();");
                        _builder.newLineIfNotEmpty();
                      } else {
                        {
                          Set<GenPackage> _allGenPkgs = MelangeJvmModelInferrer.this._modelingElementExtensions.getAllGenPkgs(l.getSyntax());
                          for(final GenPackage gp : _allGenPkgs) {
                            _builder.append(EPackage.Registry.class);
                            _builder.append(".INSTANCE.put(");
                            _builder.newLineIfNotEmpty();
                            _builder.append("\t");
                            String _qualifiedPackageInterfaceName = gp.getQualifiedPackageInterfaceName();
                            _builder.append(_qualifiedPackageInterfaceName, "\t");
                            _builder.append(".eNS_URI,");
                            _builder.newLineIfNotEmpty();
                            _builder.append("\t");
                            String _qualifiedPackageInterfaceName_1 = gp.getQualifiedPackageInterfaceName();
                            _builder.append(_qualifiedPackageInterfaceName_1, "\t");
                            _builder.append(".eINSTANCE");
                            _builder.newLineIfNotEmpty();
                            _builder.append(");");
                            _builder.newLine();
                          }
                        }
                      }
                    }
                  }
                }
                _builder.newLine();
                _builder.append(Resource.Factory.Registry.class);
                _builder.append(".INSTANCE.getExtensionToFactoryMap().put(");
                _builder.newLineIfNotEmpty();
                _builder.append("\t");
                _builder.append("\"*\",");
                _builder.newLine();
                _builder.append("\t");
                _builder.append("new ");
                _builder.append(XMIResourceFactoryImpl.class, "\t");
                _builder.append("()");
                _builder.newLineIfNotEmpty();
                _builder.append(");");
                _builder.newLine();
                _builder.append(Resource.Factory.Registry.class);
                _builder.append(".INSTANCE.getProtocolToFactoryMap().put(");
                _builder.newLineIfNotEmpty();
                _builder.append("\t");
                _builder.append("\"melange\",");
                _builder.newLine();
                _builder.append("\t");
                _builder.append("new ");
                _builder.append(MelangeResourceFactoryImpl.class, "\t");
                _builder.append("()");
                _builder.newLineIfNotEmpty();
                _builder.append(");");
                _builder.newLine();
              }
            };
            MelangeJvmModelInferrer.this._jvmTypesBuilder.setBody(it, _client);
          }
        };
        JvmOperation _method_1 = MelangeJvmModelInferrer.this._jvmTypesBuilder.toMethod(root, "doEMFRegistration", MelangeJvmModelInferrer.this._typeReferenceBuilder.typeRef(Void.TYPE), _function_1);
        MelangeJvmModelInferrer.this._jvmTypesBuilder.<JvmOperation>operator_add(_members_1, _method_1);
        EList<JvmMember> _members_2 = it.getMembers();
        final Procedure1<JvmOperation> _function_2 = new Procedure1<JvmOperation>() {
          @Override
          public void apply(final JvmOperation it) {
            StringConcatenationClient _client = new StringConcatenationClient() {
              @Override
              protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                {
                  Iterable<Language> _languages = MelangeJvmModelInferrer.this._aSTHelper.getLanguages(root);
                  for(final Language l : _languages) {
                    _builder.append(MelangeRegistry.LanguageDescriptor.class);
                    _builder.append(" ");
                    String _firstLower = StringExtensions.toFirstLower(MelangeJvmModelInferrer.this._iQualifiedNameConverter.toQualifiedName(l.getName()).getLastSegment());
                    _builder.append(_firstLower);
                    _builder.append(" = new ");
                    _builder.append(MelangeRegistryImpl.LanguageDescriptorImpl.class);
                    _builder.append("(");
                    _builder.newLineIfNotEmpty();
                    _builder.append("\t");
                    _builder.append("\"");
                    QualifiedName _fullyQualifiedName = MelangeJvmModelInferrer.this._iQualifiedNameProvider.getFullyQualifiedName(l);
                    _builder.append(_fullyQualifiedName, "\t");
                    _builder.append("\", \"");
                    String _documentation = MelangeJvmModelInferrer.this._jvmTypesBuilder.getDocumentation(l);
                    String _replace = null;
                    if (_documentation!=null) {
                      _replace=_documentation.replace("\"", "\'");
                    }
                    String _replace_1 = null;
                    if (_replace!=null) {
                      _replace_1=_replace.replace("\n", " ");
                    }
                    _builder.append(_replace_1, "\t");
                    _builder.append("\", \"");
                    String _rootPackageUri = MelangeJvmModelInferrer.this._modelingElementExtensions.getRootPackageUri(l.getSyntax());
                    _builder.append(_rootPackageUri, "\t");
                    _builder.append("\", \"");
                    QualifiedName _fullyQualifiedName_1 = MelangeJvmModelInferrer.this._iQualifiedNameProvider.getFullyQualifiedName(l.getExactType());
                    _builder.append(_fullyQualifiedName_1, "\t");
                    _builder.append("\"");
                    _builder.newLineIfNotEmpty();
                    _builder.append(");");
                    _builder.newLine();
                    {
                      EList<ModelType> _implements = l.getImplements();
                      for(final ModelType mt : _implements) {
                        {
                          boolean _not = (!((l instanceof ExternalLanguage) && Objects.equal(l.getExactType(), mt)));
                          if (_not) {
                            String _firstLower_1 = StringExtensions.toFirstLower(MelangeJvmModelInferrer.this._iQualifiedNameConverter.toQualifiedName(l.getName()).getLastSegment());
                            _builder.append(_firstLower_1);
                            _builder.append(".addAdapter(\"");
                            QualifiedName _fullyQualifiedName_2 = MelangeJvmModelInferrer.this._iQualifiedNameProvider.getFullyQualifiedName(mt);
                            _builder.append(_fullyQualifiedName_2);
                            _builder.append("\", ");
                            String _adapterNameFor = MelangeJvmModelInferrer.this._namingHelper.adapterNameFor(l.getSyntax(), mt);
                            _builder.append(_adapterNameFor);
                            _builder.append(".class);");
                            _builder.newLineIfNotEmpty();
                          }
                        }
                      }
                    }
                    _builder.append(MelangeRegistry.class);
                    _builder.append(".INSTANCE.getLanguageMap().put(");
                    _builder.newLineIfNotEmpty();
                    _builder.append("\t");
                    _builder.append("\"");
                    QualifiedName _fullyQualifiedName_3 = MelangeJvmModelInferrer.this._iQualifiedNameProvider.getFullyQualifiedName(l);
                    _builder.append(_fullyQualifiedName_3, "\t");
                    _builder.append("\",");
                    _builder.newLineIfNotEmpty();
                    _builder.append("\t");
                    String _firstLower_2 = StringExtensions.toFirstLower(MelangeJvmModelInferrer.this._iQualifiedNameConverter.toQualifiedName(l.getName()).getLastSegment());
                    _builder.append(_firstLower_2, "\t");
                    _builder.newLineIfNotEmpty();
                    _builder.append(");");
                    _builder.newLine();
                  }
                }
                {
                  Iterable<ModelType> _modelTypes = MelangeJvmModelInferrer.this._aSTHelper.getModelTypes(root);
                  for(final ModelType mt_1 : _modelTypes) {
                    _builder.append(MelangeRegistry.ModelTypeDescriptor.class);
                    _builder.append(" ");
                    String _firstLower_3 = StringExtensions.toFirstLower(MelangeJvmModelInferrer.this._iQualifiedNameConverter.toQualifiedName(mt_1.getName()).getLastSegment());
                    _builder.append(_firstLower_3);
                    _builder.append(" = new ");
                    _builder.append(MelangeRegistryImpl.ModelTypeDescriptorImpl.class);
                    _builder.append("(");
                    _builder.newLineIfNotEmpty();
                    _builder.append("\t");
                    _builder.append("\"");
                    QualifiedName _fullyQualifiedName_4 = MelangeJvmModelInferrer.this._iQualifiedNameProvider.getFullyQualifiedName(mt_1);
                    _builder.append(_fullyQualifiedName_4, "\t");
                    _builder.append("\", \"");
                    String _documentation_1 = MelangeJvmModelInferrer.this._jvmTypesBuilder.getDocumentation(mt_1);
                    _builder.append(_documentation_1, "\t");
                    _builder.append("\", \"");
                    String _uri = MelangeJvmModelInferrer.this._modelTypeExtensions.getUri(mt_1);
                    _builder.append(_uri, "\t");
                    _builder.append("\"");
                    _builder.newLineIfNotEmpty();
                    _builder.append(");");
                    _builder.newLine();
                    {
                      EList<Subtyping> _subtypingRelations = mt_1.getSubtypingRelations();
                      for(final Subtyping superMt : _subtypingRelations) {
                        String _firstLower_4 = StringExtensions.toFirstLower(MelangeJvmModelInferrer.this._iQualifiedNameConverter.toQualifiedName(mt_1.getName()).getLastSegment());
                        _builder.append(_firstLower_4);
                        _builder.append(".addSuperType(\"");
                        QualifiedName _fullyQualifiedName_5 = MelangeJvmModelInferrer.this._iQualifiedNameProvider.getFullyQualifiedName(superMt.getSuperType());
                        _builder.append(_fullyQualifiedName_5);
                        _builder.append("\");");
                        _builder.newLineIfNotEmpty();
                      }
                    }
                    _builder.append(MelangeRegistry.class);
                    _builder.append(".INSTANCE.getModelTypeMap().put(");
                    _builder.newLineIfNotEmpty();
                    _builder.append("\t");
                    _builder.append("\"");
                    QualifiedName _fullyQualifiedName_6 = MelangeJvmModelInferrer.this._iQualifiedNameProvider.getFullyQualifiedName(mt_1);
                    _builder.append(_fullyQualifiedName_6, "\t");
                    _builder.append("\",");
                    _builder.newLineIfNotEmpty();
                    _builder.append("\t");
                    String _firstLower_5 = StringExtensions.toFirstLower(MelangeJvmModelInferrer.this._iQualifiedNameConverter.toQualifiedName(mt_1.getName()).getLastSegment());
                    _builder.append(_firstLower_5, "\t");
                    _builder.newLineIfNotEmpty();
                    _builder.append(");");
                    _builder.newLine();
                  }
                }
              }
            };
            MelangeJvmModelInferrer.this._jvmTypesBuilder.setBody(it, _client);
          }
        };
        JvmOperation _method_2 = MelangeJvmModelInferrer.this._jvmTypesBuilder.toMethod(root, "doAdaptersRegistration", MelangeJvmModelInferrer.this._typeReferenceBuilder.typeRef(Void.TYPE), _function_2);
        MelangeJvmModelInferrer.this._jvmTypesBuilder.<JvmOperation>operator_add(_members_2, _method_2);
      }
    };
    acceptor.<JvmGenericType>accept(this._jvmTypesBuilder.toClass(root, this._namingHelper.getStandaloneSetupClassName(root)), _function);
  }
  
  public void infer(final EObject root, final IJvmDeclaredTypeAcceptor acceptor, final boolean isPreIndexingPhase) {
    if (root instanceof ModelTypingSpace) {
      _infer((ModelTypingSpace)root, acceptor, isPreIndexingPhase);
      return;
    } else if (root != null) {
      _infer(root, acceptor, isPreIndexingPhase);
      return;
    } else {
      throw new IllegalArgumentException("Unhandled parameter types: " +
        Arrays.<Object>asList(root, acceptor, isPreIndexingPhase).toString());
    }
  }
}
