/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gendoc.tags.impl;

import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.eclipse.gendoc.services.AbstractService;
import org.eclipse.gendoc.tags.ITagExtensionService;
import org.eclipse.gendoc.tags.TagsExtensionPoint;
import org.eclipse.gendoc.tags.impl.CategoryExtension;
import org.eclipse.gendoc.tags.impl.TagExtension;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TagExtensionService
extends AbstractService
implements ITagExtensionService {
    private Set<CategoryExtension> categoryExtensions = new HashSet<CategoryExtension>();
    private Set<TagExtension> tagExtensions = new HashSet<TagExtension>();

    public TagExtensionService() {
        IConfigurationElement[] configElements;
        IConfigurationElement[] iConfigurationElementArray = configElements = Platform.getExtensionRegistry().getConfigurationElementsFor(TagsExtensionPoint.EXTENSION_POINT_ID);
        int n = configElements.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement configElement = iConfigurationElementArray[n2];
            if (configElement.getName().equals(TagsExtensionPoint.CATEGORY)) {
                CategoryExtension.load(this, configElement);
            } else if (configElement.getName().equals(TagsExtensionPoint.TAG)) {
                TagExtension.load(this, configElement);
            }
            ++n2;
        }
    }

    public void clear() {
        this.categoryExtensions.clear();
        this.tagExtensions.clear();
    }

    public CategoryExtension getCategoryExtension(String name) {
        for (CategoryExtension tagCategoryExtension : this.getCategoryExtensions()) {
            if (!tagCategoryExtension.getName().equals(name)) continue;
            return tagCategoryExtension;
        }
        return null;
    }

    public Set<CategoryExtension> getCategoryExtensions() {
        return this.categoryExtensions;
    }

    @Override
    public TagExtension getTagExtension(String name) {
        for (TagExtension tagExtension : this.getTagExtensions()) {
            if (!tagExtension.getName().equals(name)) continue;
            return tagExtension;
        }
        return null;
    }

    public Set<TagExtension> getTagExtensions() {
        return this.tagExtensions;
    }

    public Set<TagExtension> getTopLevelTagExtensions() {
        CategoryExtension categoryExtension = this.getCategoryExtension(TagsExtensionPoint.TOP_LEVEL_CATEGORY);
        if (categoryExtension != null) {
            return categoryExtension.getSubTags();
        }
        return null;
    }

    @Override
    public List<String> getTopLevelTagNames() {
        LinkedList<String> tagNames = new LinkedList<String>();
        for (TagExtension tagExtension : this.getTopLevelTagExtensions()) {
            tagNames.add(tagExtension.getName());
        }
        return tagNames;
    }

    @Override
    public List<String> getAllTagNames() {
        LinkedList<String> tagNames = new LinkedList<String>();
        for (TagExtension tagExtension : this.getTagExtensions()) {
            tagNames.add(tagExtension.getName());
        }
        return tagNames;
    }
}

