/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gendoc.document.parser.documents;

import java.util.Collection;
import java.util.LinkedList;
import org.eclipse.gendoc.document.parser.documents.XMLParser;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XmlParsers {
    private LinkedList<XMLParser> parsers = new LinkedList();
    private XMLParser pointer = null;
    private int index;

    public XmlParsers(Collection<XMLParser> xmlParsers) {
        this.addAll(xmlParsers);
        this.pointer = this.parsers.get(0);
        this.index = 0;
    }

    public void addAll(Collection<XMLParser> xmlParser) {
        this.parsers.addAll(xmlParser);
    }

    public void add(XMLParser xmlParser) {
        this.parsers.add(xmlParser);
    }

    public XMLParser getCurrent() {
        return this.pointer;
    }

    public boolean next() {
        boolean result = this.pointer.next();
        if (!result) {
            result = this.nextXMLParser();
        }
        return result;
    }

    private boolean nextXMLParser() {
        ++this.index;
        boolean result = false;
        if (this.index < this.parsers.size()) {
            this.pointer = this.parsers.get(this.index);
            result = this.pointer.getCurrentNode() == null ? this.next() : true;
        }
        return result;
    }

    public boolean jumpToNextFile() {
        return this.nextXMLParser();
    }

    public void jumpToStart() {
        for (XMLParser p : this.parsers) {
            p.setCurrentNode(p.getDocument().getFirstChild());
        }
        this.index = 0;
        this.pointer = this.parsers.get(this.index);
    }
}

