/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gendoc.bundle.acceleo.papyrus.service;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.EMap;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EAnnotation;
import org.eclipse.emf.ecore.EModelElement;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gendoc.bundle.acceleo.gmf.service.GMFServices;
import org.eclipse.gendoc.bundle.acceleo.papyrus.Activator;
import org.eclipse.gendoc.services.GendocServices;
import org.eclipse.gendoc.services.exception.ModelNotFoundException;
import org.eclipse.gendoc.tags.handlers.IEMFModelLoaderService;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.uml2.uml.Comment;
import org.eclipse.uml2.uml.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PapyrusServices
extends GMFServices {
    private static final String ASSOCIATED_RESOURCES_SOURCE = "http://www.topcased.org/resources";
    private static final String PAPYRUS_DOCUMENTATION_STEREOTYPE_QUALIFIED_NAME = "Papyrus::Documentation::Documentation";
    private static final String PREFIX_WORKSPACE_RESOURCE = "WR";
    private static final String PREFIX_EXTERNAL_RESOURCE = "ER";
    private static final String PREFIX_REMOTE_RESOURCE = "RR";

    public List<Diagram> getDiagrams(EObject e, URI uri) {
        IEMFModelLoaderService modelLoader = (IEMFModelLoaderService)GendocServices.getDefault().getService(IEMFModelLoaderService.class);
        try {
            modelLoader.getModel(uri);
        }
        catch (ModelNotFoundException e1) {
            Activator.getDefault().getLog().log((IStatus)new Status(2, "org.eclipse.gendoc.bundle.acceleo.papyrus", e1.getMessage(), (Throwable)e1));
        }
        return super.getDiagrams(e, uri);
    }

    public List<Diagram> getPapyrusDiagrams(EObject object) {
        List result = this.getDiagramsUsingNotation(object);
        return result;
    }

    public String getDocumentation(EObject eObject) {
        if (eObject instanceof Element) {
            EList ownedComments = ((Element)eObject).getOwnedComments();
            for (Comment comment : ownedComments) {
                if (comment.getAppliedStereotype(PAPYRUS_DOCUMENTATION_STEREOTYPE_QUALIFIED_NAME) == null) continue;
                return comment.getBody();
            }
        }
        return null;
    }

    public List<String> getDocumentationResources(EObject object) {
        ArrayList<String> absolutePaths = new ArrayList<String>();
        List<URI> uris = this.getAssociatedResources(object);
        for (URI uri : uris) {
            String absolutePath;
            if (uri.isPlatform()) {
                IPath filePath = Path.fromPortableString((String)uri.toPlatformString(true));
                absolutePath = String.valueOf(ResourcesPlugin.getWorkspace().getRoot().getLocation().toOSString()) + filePath;
            } else {
                absolutePath = uri.isFile() ? uri.toFileString() : uri.toString();
            }
            absolutePaths.add(absolutePath);
        }
        return absolutePaths;
    }

    private List<URI> getAssociatedResources(EObject eObject) {
        EAnnotation annotation;
        if (eObject instanceof EModelElement && !(eObject instanceof EAnnotation) && (annotation = ((EModelElement)eObject).getEAnnotation(ASSOCIATED_RESOURCES_SOURCE)) != null) {
            return PapyrusServices.convertDetailsToURIs((EMap<String, String>)annotation.getDetails());
        }
        return Collections.emptyList();
    }

    private static List<URI> convertDetailsToURIs(EMap<String, String> details) {
        LinkedList<URI> uris = new LinkedList<URI>();
        for (Map.Entry detail : details) {
            String value = (String)detail.getValue();
            String prefix = ((String)detail.getKey()).substring(0, 2);
            URI uri = null;
            if (PREFIX_REMOTE_RESOURCE.equals(prefix)) {
                uri = URI.createURI((String)value, (boolean)false);
            } else if (PREFIX_EXTERNAL_RESOURCE.equals(prefix)) {
                uri = URI.createFileURI((String)value);
            } else if (PREFIX_WORKSPACE_RESOURCE.equals(prefix)) {
                uri = URI.createPlatformResourceURI((String)value, (boolean)true);
            }
            uris.add(uri);
        }
        return uris;
    }
}

