/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gendoc.wizard;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.regex.Pattern;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.eclipse.gendoc.wizard.IGendocRunner;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Utils {
    private static List<IGendocRunner> runners = null;

    public static IFile[] getIFiles(Object o) {
        if (o instanceof IFile) {
            return new IFile[]{(IFile)o};
        }
        IFile f = (IFile)Platform.getAdapterManager().getAdapter(o, IFile.class);
        if (f != null) {
            return new IFile[]{f};
        }
        Collection collec = (Collection)Platform.getAdapterManager().getAdapter(o, Collection.class);
        if (collec != null) {
            boolean ok = true;
            for (Object o2 : collec) {
                if (o2 instanceof IFile) continue;
                ok = false;
                break;
            }
            if (ok) {
                return collec.toArray(new IFile[0]);
            }
        }
        return null;
    }

    public static List<IGendocRunner> getAllRunners() {
        if (runners == null) {
            IConfigurationElement[] elements;
            runners = new LinkedList<IGendocRunner>();
            IConfigurationElement[] iConfigurationElementArray = elements = Platform.getExtensionRegistry().getConfigurationElementsFor("org.eclipse.gendoc.wizard", "runner");
            int n = elements.length;
            int n2 = 0;
            while (n2 < n) {
                IConfigurationElement e = iConfigurationElementArray[n2];
                try {
                    IGendocRunner runner = (IGendocRunner)e.createExecutableExtension("Instance");
                    runners.add(runner);
                }
                catch (CoreException e1) {
                    e1.printStackTrace();
                }
                ++n2;
            }
        }
        return runners;
    }

    public static List<Pattern> getAllExtensions() {
        List<IGendocRunner> runners = Utils.getAllRunners();
        LinkedList<Pattern> result = new LinkedList<Pattern>();
        for (IGendocRunner r : runners) {
            if (r.getPattern() == null) continue;
            result.add(r.getPattern());
        }
        return result;
    }

    public static boolean matches(IFile[] files) {
        List<Pattern> patterns = Utils.getAllExtensions();
        for (Pattern p : patterns) {
            if (p == null) continue;
            IFile[] iFileArray = files;
            int n = files.length;
            int n2 = 0;
            while (n2 < n) {
                IFile f = iFileArray[n2];
                if (p.matcher(f.getName()).matches()) {
                    return true;
                }
                ++n2;
            }
        }
        return false;
    }

    public static List<IGendocRunner> getRunners(IFile[] files) {
        List<IGendocRunner> runners = Utils.getAllRunners();
        ArrayList<IGendocRunner> result = new ArrayList<IGendocRunner>(runners.size());
        for (IGendocRunner g : runners) {
            IFile[] iFileArray = files;
            int n = files.length;
            int n2 = 0;
            while (n2 < n) {
                IFile f = iFileArray[n2];
                if (g.getPattern().matcher(f.getName()).matches()) {
                    result.add(g);
                }
                ++n2;
            }
        }
        return result;
    }
}

