/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gendoc.services.impl;

import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.eclipse.gendoc.services.AbstractService;
import org.eclipse.gendoc.services.GendocServices;
import org.eclipse.gendoc.services.ILogger;
import org.eclipse.gendoc.services.IRegistryService;

public class RegistryService
extends AbstractService
implements IRegistryService {
    private final Map<Object, Object> registry = new HashMap<Object, Object>();
    private final List<Runnable> runnables = new LinkedList<Runnable>();

    @Override
    public void addCleaner(Runnable cleaner) {
        this.runnables.add(cleaner);
    }

    @Override
    public void clear() {
        for (Runnable runnable : this.runnables) {
            try {
                runnable.run();
            }
            catch (Exception e) {
                ILogger logger = (ILogger)GendocServices.getDefault().getService(ILogger.class);
                if (logger == null) continue;
                logger.log(String.format("An unexpected error occurs during cleaning process : %s", e.getMessage()), 4);
                e.printStackTrace();
            }
        }
        this.runnables.clear();
        this.registry.clear();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.registry.containsKey(this.checkLowerCase(key));
    }

    @Override
    public Object get(Object key) {
        return this.registry.get(this.checkLowerCase(key));
    }

    @Override
    public Object put(Object key, Object value) {
        return this.registry.put(this.checkLowerCase(key), value);
    }

    private Object checkLowerCase(Object key) {
        if (key != null && key instanceof String) {
            return ((String)key).toLowerCase();
        }
        return key;
    }
}

