/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver.data.handlers.admin;

import com.sun.messaging.jmq.io.Packet;
import com.sun.messaging.jmq.jmsserver.Globals;
import com.sun.messaging.jmq.jmsserver.cluster.api.ha.HAMonitorService;
import com.sun.messaging.jmq.jmsserver.core.Destination;
import com.sun.messaging.jmq.jmsserver.core.DestinationList;
import com.sun.messaging.jmq.jmsserver.core.DestinationUID;
import com.sun.messaging.jmq.jmsserver.data.handlers.admin.AdminCmdHandler;
import com.sun.messaging.jmq.jmsserver.data.handlers.admin.AdminDataHandler;
import com.sun.messaging.jmq.jmsserver.memory.MemoryGlobals;
import com.sun.messaging.jmq.jmsserver.service.imq.IMQConnection;
import com.sun.messaging.jmq.jmsserver.util.ConflictException;
import com.sun.messaging.jmq.util.DestType;
import com.sun.messaging.jmq.util.SizeString;
import com.sun.messaging.jmq.util.admin.DestinationInfo;
import java.util.Hashtable;

public class CreateDestinationHandler
extends AdminCmdHandler {
    private static boolean DEBUG = CreateDestinationHandler.getDEBUG();

    public CreateDestinationHandler(AdminDataHandler parent) {
        super(parent);
    }

    @Override
    public boolean handle(IMQConnection con, Packet cmd_msg, Hashtable cmd_props) {
        SizeString maxMessageSize;
        SizeString maxMessageBytes;
        int maxMessages;
        int type;
        String errMsg;
        int status;
        Packet reply;
        DestinationInfo info;
        block37: {
            info = (DestinationInfo)this.getBodyObject(cmd_msg);
            if (DEBUG) {
                this.logger.log(4, this.getClass().getName() + ": Creating destination: " + cmd_props + ": " + info.toString());
            }
            reply = new Packet(con.useDirectBuffers());
            reply.setPacketType(5);
            status = 200;
            errMsg = null;
            type = 257;
            maxMessages = -1;
            maxMessageBytes = null;
            maxMessageSize = null;
            HAMonitorService hamonitor = Globals.getHAMonitorService();
            if (hamonitor != null && hamonitor.inTakeover()) {
                status = 500;
                errMsg = this.rb.getString("B3233");
                this.logger.log(32, this.getClass().getName() + ": " + errMsg);
            } else if (MemoryGlobals.getMEM_DISALLOW_CREATE_DEST()) {
                status = 500;
                errMsg = "B2077";
            } else if (info.isModified(1)) {
                if (info.isModified(2)) {
                    type = info.type;
                }
                if (info.isModified(4)) {
                    maxMessages = info.maxMessages;
                }
                if (info.isModified(8)) {
                    maxMessageBytes = new SizeString();
                    maxMessageBytes.setBytes(info.maxMessageBytes);
                }
                if (info.isModified(16)) {
                    maxMessageSize = new SizeString();
                    maxMessageSize.setBytes(info.maxMessageSize);
                }
            } else {
                status = 500;
                errMsg = "B4089";
            }
            if (status == 200) {
                if (DestType.destNameIsInternal((String)info.name)) {
                    status = 500;
                    errMsg = this.rb.getKString("B4175", info.name, "mq.");
                } else if (CreateDestinationHandler.isValidDestinationName(info.name)) {
                    try {
                        DestinationList.createDestination(null, info.name, type);
                    }
                    catch (Exception ex) {
                        status = 500;
                        errMsg = this.rb.getKString("B4090", info.name, CreateDestinationHandler.getMessageFromException(ex));
                        if (ex instanceof ConflictException) {
                            this.logger.log(8, errMsg, (Throwable)ex);
                            break block37;
                        }
                        this.logger.logStack(8, errMsg, (Throwable)ex);
                    }
                } else {
                    status = 500;
                    errMsg = this.rb.getKString("B4091", info.name);
                }
            }
        }
        if (status == 200) {
            try {
                int maxcons;
                Destination[] ds = DestinationList.getDestination(null, info.name, DestType.isQueue((int)type));
                Destination d = ds[0];
                d.setCapacity(maxMessages);
                d.setByteCapacity(maxMessageBytes);
                d.setMaxByteSize(maxMessageSize);
                if (info.isModified(32)) {
                    int scope = info.destScope;
                    d.setScope(scope);
                }
                if (info.isModified(64)) {
                    int destlimit = info.destLimitBehavior;
                    d.setLimitBehavior(destlimit);
                }
                if (info.isModified(128)) {
                    int prefetch = info.maxPrefetch;
                    d.setMaxPrefetch(prefetch);
                }
                if (info.isModified(256)) {
                    int clusterdeliverypolicy = info.destCDP;
                    d.setClusterDeliveryPolicy(clusterdeliverypolicy);
                }
                if (info.isModified(512)) {
                    maxcons = info.maxActiveConsumers;
                    d.setMaxActiveConsumers(maxcons);
                }
                if (info.isModified(2048)) {
                    int maxp = info.maxProducers;
                    d.setMaxProducers(maxp);
                }
                if (info.isModified(1024)) {
                    maxcons = info.maxFailoverConsumers;
                    d.setMaxFailoverConsumers(maxcons);
                }
                if (info.isModified(4096)) {
                    int maxsharedcons = info.maxNumSharedConsumers;
                    d.setMaxSharedConsumers(maxsharedcons);
                }
                if (info.isModified(8192)) {
                    int sflowlimit = info.sharedConsumerFlowLimit;
                    d.setSharedFlowLimit(sflowlimit);
                }
                if (info.isModified(16384)) {
                    boolean dmq = info.useDMQ;
                    d.setUseDMQ(dmq);
                }
                if (info.isModified(32768)) {
                    d.setValidateXMLSchemaEnabled(info.validateXMLSchemaEnabled);
                }
                if (info.isModified(65536)) {
                    d.setXMLSchemaUriList(info.XMLSchemaUriList);
                }
                if (info.isModified(131072)) {
                    d.setReloadXMLSchemaOnFailure(info.reloadXMLSchemaOnFailure);
                }
                d.update();
                Globals.getAuditSession().destinationOperation(con.getUserName(), con.remoteHostString(), "create destination", d.isQueue() ? "queue" : "topic", d.getDestinationName());
            }
            catch (Exception ex) {
                try {
                    DestinationUID duid = DestinationUID.getUID(info.name, DestType.isQueue((int)type));
                    DestinationList.removeDestination(null, duid, false, ex.toString());
                }
                catch (Exception exception) {
                    // empty catch block
                }
                status = 500;
                errMsg = this.rb.getString("B4092", info.name, CreateDestinationHandler.getMessageFromException(ex));
                this.logger.logStack(16, errMsg, (Throwable)ex);
            }
        }
        CreateDestinationHandler.setProperties(reply, 11, status, errMsg);
        this.parent.sendReply(con, cmd_msg, reply);
        return true;
    }

    public static boolean isValidDestinationName(String name) {
        if (name == null) {
            return false;
        }
        char[] namechars = name.toCharArray();
        if (namechars.length < 1) {
            return false;
        }
        if (Character.isJavaIdentifierStart(namechars[0])) {
            for (int i = 1; i < namechars.length; ++i) {
                if (Character.isJavaIdentifierPart(namechars[i]) || namechars[i] == '.') continue;
                return false;
            }
        } else {
            return false;
        }
        return true;
    }
}

