/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver.service.imq.websocket;

import com.sun.messaging.jmq.jmsserver.Globals;
import com.sun.messaging.jmq.jmsserver.config.BrokerConfig;
import com.sun.messaging.jmq.jmsserver.data.PacketRouter;
import com.sun.messaging.jmq.jmsserver.net.Protocol;
import com.sun.messaging.jmq.jmsserver.service.Service;
import com.sun.messaging.jmq.jmsserver.service.imq.IMQIPServiceFactory;
import com.sun.messaging.jmq.jmsserver.service.imq.IMQService;
import com.sun.messaging.jmq.jmsserver.service.imq.websocket.WebSocketIPService;
import com.sun.messaging.jmq.jmsserver.service.imq.websocket.WebSocketProtocolImpl;
import com.sun.messaging.jmq.jmsserver.util.BrokerException;
import java.io.IOException;
import java.util.Map;

public class WebSocketIPServiceFactory
extends IMQIPServiceFactory {
    private static final String myHandlerName = "websocket";

    @Override
    public void enforceServiceHandler(String service, BrokerConfig config) throws BrokerException {
        String prototype = config.getProperty("imq." + service + ".protocoltype");
        if (prototype == null) {
            return;
        }
        if (!prototype.equalsIgnoreCase("ws") && !prototype.equalsIgnoreCase("wss")) {
            return;
        }
        if (WebSocketIPServiceFactory.isDefaultStandardServiceName(service)) {
            throw new BrokerException(Globals.getBrokerResources().getKString("B4450", prototype, service));
        }
        String hn = config.getProperty("imq." + service + ".handler_name");
        if (hn != null && !hn.equals(myHandlerName)) {
            throw new BrokerException(Globals.getBrokerResources().getKString("B4450", prototype, service + "[" + hn + "]"));
        }
        if (hn == null) {
            try {
                config.updateProperty("imq." + service + ".handler_name", myHandlerName, false);
            }
            catch (Exception e) {
                throw new BrokerException(e.getMessage(), e);
            }
            String tpmodel = config.getProperty("imq." + service + ".threadpool_model");
            if (tpmodel != null) {
                Globals.getLogger().log(16, Globals.getBrokerResources().getKString("B2219", "imq." + service + ".threadpool_model" + "=" + tpmodel));
            }
        }
    }

    @Override
    public void checkFactoryHandlerName(String handlerName) throws IllegalAccessException {
        if (!myHandlerName.equals(handlerName)) {
            throw new IllegalAccessException("Unexpected service Handler name " + handlerName + ", expected " + myHandlerName);
        }
    }

    @Override
    public void updateService(Service s) throws BrokerException {
        if (!(s instanceof WebSocketIPService)) {
            throw new BrokerException(this.br.getKString("B3100", "Unexpected service class: " + s));
        }
        WebSocketIPService ss = (WebSocketIPService)s;
        try {
            ss.updateService(((WebSocketProtocolImpl)ss.getProtocol()).getPort(), this.getThreadMin(s.getName()), this.getThreadMax(s.getName()), false);
        }
        catch (Exception e) {
            throw new BrokerException(e.getMessage(), e);
        }
    }

    @Override
    public Service createService(String name, int type) throws BrokerException {
        WebSocketIPService s = new WebSocketIPService(name, type, Globals.getPacketRouter(type), this.getThreadMin(name), this.getThreadMax(name), this);
        long timeout = this.getPoolTimeout(name);
        if (timeout > 0L) {
            s.setDestroyWaitTime(timeout);
        }
        return s;
    }

    @Override
    protected IMQService createService(String instancename, Protocol proto, PacketRouter router, int type, int min, int max) throws IOException {
        throw new UnsupportedOperationException("Unexpected call");
    }

    @Override
    protected Map getProtocolParams(String protoname, String prefix) {
        return super.getProtocolParams(protoname, prefix);
    }
}

