/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jms.ra;

import com.sun.messaging.Destination;
import com.sun.messaging.Queue;
import com.sun.messaging.Topic;
import com.sun.messaging.XAConnectionFactory;
import com.sun.messaging.jmq.jmsclient.XAConnectionImpl;
import com.sun.messaging.jmq.jmsclient.XASessionImpl;
import com.sun.messaging.jmq.jmsservice.JMSService;
import com.sun.messaging.jms.notification.Event;
import com.sun.messaging.jms.notification.EventListener;
import com.sun.messaging.jms.ra.ActivationSpec;
import com.sun.messaging.jms.ra.ConnectionFactoryAdapter;
import com.sun.messaging.jms.ra.DirectConnection;
import com.sun.messaging.jms.ra.DirectConnectionFactory;
import com.sun.messaging.jms.ra.DirectSession;
import com.sun.messaging.jms.ra.ManagedConnectionFactory;
import com.sun.messaging.jms.ra.MessageListener;
import com.sun.messaging.jms.ra.ResourceAdapter;
import com.sun.messaging.jms.ra.Util;
import com.sun.messaging.jms.ra.api.JMSRAEndpointConsumer;
import com.sun.messaging.jms.ra.util.CustomTokenizer;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.logging.Logger;
import javax.jms.ExceptionListener;
import javax.jms.JMSException;
import javax.jms.MessageConsumer;
import javax.jms.XASession;
import javax.naming.NamingException;
import javax.resource.NotSupportedException;
import javax.resource.ResourceException;
import javax.resource.spi.InvalidPropertyException;
import javax.resource.spi.endpoint.MessageEndpointFactory;

public class EndpointConsumer
implements ExceptionListener,
EventListener,
JMSRAEndpointConsumer {
    private static final String QUEUE = "javax.jms.Queue";
    private static final String TOPIC = "javax.jms.Topic";
    protected ResourceAdapter ra = null;
    private XAConnectionFactory xacf = null;
    protected DirectConnectionFactory dcf = null;
    private int cID = 0;
    private int fID = 0;
    private int destinationType = 0;
    protected boolean isDeliveryTransacted = false;
    protected boolean noAckDelivery = false;
    protected Method onMessageMethod = null;
    protected boolean isDurable = false;
    protected String clientId = null;
    protected String mName = null;
    protected boolean deactivated = false;
    protected XAConnectionImpl xac = null;
    protected XASessionImpl xas = null;
    private DirectConnection dc = null;
    private DirectSession ds = null;
    protected MessageListener msgListener = null;
    protected MessageConsumer msgConsumer = null;
    protected MessageConsumer msgConsumer2 = null;
    protected javax.jms.Destination destination = null;
    protected boolean useRADirect = false;
    protected ActivationSpec aSpec = null;
    protected MessageEndpointFactory endpointFactory = null;
    protected String username = null;
    protected String password = null;
    protected String selector = null;
    protected String subscriptionName = null;
    protected int exRedeliveryAttempts = 0;
    protected int exRedeliveryInterval = 0;
    private boolean stopping = false;
    private boolean logRCFailures = true;
    private int maxLoopDelay = 120000;
    private static final transient String _className = "com.sun.messaging.jms.ra.EndpointConsumer";
    protected static final transient String _lgrNameInboundMessage = "javax.resourceadapter.mqjmsra.inbound.message";
    protected static final transient Logger _loggerIM = Logger.getLogger("javax.resourceadapter.mqjmsra.inbound.message");
    protected static final transient String _lgrMIDPrefix = "MQJMSRA_EC";
    protected static final transient String _lgrMID_EET = "MQJMSRA_EC1001: ";
    protected static final transient String _lgrMID_INF = "MQJMSRA_EC1101: ";
    protected static final transient String _lgrMID_WRN = "MQJMSRA_EC2001: ";
    protected static final transient String _lgrMID_ERR = "MQJMSRA_EC3001: ";
    protected static final transient String _lgrMID_EXC = "MQJMSRA_EC4001: ";

    private EndpointConsumer() {
    }

    public EndpointConsumer(ResourceAdapter ra, MessageEndpointFactory endpointFactory, javax.resource.spi.ActivationSpec spec) throws ResourceException {
        if (ra == null || endpointFactory == null || spec == null) {
            throw new NotSupportedException("MQRA:EC:const:null RA||EPF||AS");
        }
        if (!(spec instanceof ActivationSpec)) {
            throw new NotSupportedException("MQRA:EC:const:Unsupported ActivationSpec Class-" + spec.getClass());
        }
        this.aSpec = (ActivationSpec)spec;
        this.endpointFactory = endpointFactory;
        this.ra = ra;
        this._init();
    }

    protected void _init() throws ResourceException {
        if (!this.ra.getInAppClientContainer()) {
            AccessController.doPrivileged(new PrivilegedAction<Object>(){

                @Override
                public Object run() {
                    System.setProperty("imq.DaemonThreads", "true");
                    return null;
                }
            });
        }
        this.useRADirect = this.aSpec.useRADirect();
        Object cfObj = null;
        String connectionFactoryLookup = this.aSpec.getConnectionFactoryLookup();
        if (connectionFactoryLookup != null) {
            try {
                cfObj = Util.jndiLookup(connectionFactoryLookup);
            }
            catch (NamingException e) {
                String errorMessage = "MQRA:EC:Invalid connectionFactoryLookup " + connectionFactoryLookup + " configured in ActivationSpec of MDB for no JNDI name found";
                throw new ResourceException(errorMessage, (Throwable)e);
            }
        }
        if (this.useRADirect) {
            JMSService jmsservice = this.ra._getJMSService();
            this.dcf = new DirectConnectionFactory(jmsservice, null);
            if (cfObj != null) {
                DirectConnectionFactory cfd = (DirectConnectionFactory)cfObj;
                ManagedConnectionFactory mcf = cfd.getMCF();
                cfd.setMCF(mcf);
                this.aSpec.setMCF(mcf);
            }
            this.username = this.aSpec.getUserName();
            this.password = this.aSpec.getPassword();
        } else {
            this.xacf = new XAConnectionFactory();
            try {
                if (cfObj != null) {
                    ConnectionFactoryAdapter cfa = (ConnectionFactoryAdapter)cfObj;
                    ManagedConnectionFactory mcf = cfa.getMCF();
                    this.aSpec.setMCF(mcf);
                }
                this.xacf.setProperty("imqAddressList", this.aSpec._AddressList());
                this.xacf.setProperty("imqAddressListBehavior", this.aSpec.getAddressListBehavior());
                this.xacf.setProperty("imqDefaultUsername", this.aSpec.getUserName());
                this.xacf.setProperty("imqDefaultPassword", this.aSpec.getPassword());
                this.xacf.setProperty("imqAddressListIterations", Integer.toString(this.aSpec.getAddressListIterations()));
                this.xacf.setProperty("imqReconnectAttempts", Integer.toString(this.aSpec.getReconnectAttempts()));
                this.xacf.setProperty("imqReconnectEnabled", Boolean.toString(this.aSpec.getReconnectEnabled()));
                this.xacf.setProperty("imqReconnectInterval", Integer.toString(this.aSpec.getReconnectInterval()));
                this.setAdditionalConnectionFactoryProperties(this.aSpec.getOptions());
            }
            catch (JMSException jmse) {
                System.err.println("MQRA:EC:constr:Exception setting connection factory properties: " + jmse.getMessage());
            }
        }
        this.onMessageMethod = this.ra._getOnMessageMethod();
        this.exRedeliveryAttempts = this.aSpec.getEndpointExceptionRedeliveryAttempts();
        this.exRedeliveryInterval = this.aSpec.getEndpointExceptionRedeliveryInterval();
        this.mName = this.aSpec.getMdbName();
        this.selector = this.aSpec.getMessageSelector();
        this.subscriptionName = this.aSpec.getSubscriptionName();
        String cId = this.aSpec.getClientId();
        this.clientId = cId != null && !"".equals(cId) && cId.length() > 0 ? cId : null;
        try {
            this.isDeliveryTransacted = this.endpointFactory.isDeliveryTransacted(this.onMessageMethod);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
        this.setDestinationType();
        if (this.destinationType == 2) {
            this.setIsDurable();
        }
        this.checkSubscriptionScopeAndClientId();
        if (this.isDurable) {
            if (!this.aSpec.isUseSharedSubscriptionInClusteredContainer()) {
                throw new NotSupportedException("MQRA:EC:Error:Must not set useSharedSubscriptionInClusteredContainer flag for durable subscriptions");
            }
            if (this.clientId == null && this.aSpec.getSubscriptionScope() == null) {
                this.clientId = this.aSpec._getGroupName() != null ? this.aSpec._getGroupName() + "{m:" + this.mName + "}" : "{m:" + this.mName + "}";
            }
        } else {
            if (this.aSpec._isNoAckDeliverySet() && this.destination instanceof Topic && !this.isDeliveryTransacted) {
                this.noAckDelivery = true;
            }
            if (this.aSpec._isInClusteredContainerSet() && this.aSpec.isUseSharedSubscriptionInClusteredContainer() && this.clientId == null && this.aSpec.getSubscriptionScope() == null) {
                if (this.mName == null || "".equals(this.mName)) {
                    throw new NotSupportedException("MQRA:EC:Error:Clustered Message Consumer requires non-null clientID OR mdbName:clientID=" + this.clientId + ":mdbName=" + this.mName);
                }
                this.clientId = this.aSpec._getGroupName() != null ? this.aSpec._getGroupName() + "{m:" + this.mName + "}" : "{m:" + this.mName + "}";
            }
        }
        if (this.useRADirect) {
            this.createDirectMessageConsumer();
        } else {
            this.createRemoteMessageConsumer();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onException(JMSException exception) {
        _loggerIM.severe("MQJMSRA_EC4001: onException:" + exception.getMessage());
        this.logRCFailures = true;
        if (this.msgListener != null) {
            this.msgListener.invalidateOnMessageRunners();
        }
        int loopDelay = this.aSpec.getReconnectInterval();
        int loopCount = 0;
        while (!this.stopping) {
            try {
                Thread.sleep(loopDelay);
            }
            catch (Exception exception2) {
                // empty catch block
            }
            try {
                ++loopCount;
                if (this.logRCFailures) {
                    _loggerIM.severe("MQJMSRA_EC4001: onException:" + this.aSpec.toString());
                }
                _loggerIM.severe("MQJMSRA_EC4001: onException:reconnect attempt loop# " + loopCount + " :Delayed " + loopDelay + " milliseconds.");
                EndpointConsumer endpointConsumer = this;
                synchronized (endpointConsumer) {
                    if (!this.stopping) {
                        this.createRemoteMessageConsumer();
                        _loggerIM.severe("MQJMSRA_EC4001: onException:reconnect success on loop# " + loopCount + " for " + this.aSpec.toString());
                    }
                    break;
                }
            }
            catch (Exception e) {
                if (this.logRCFailures) {
                    _loggerIM.severe("MQJMSRA_EC4001: onException:Unable to re-establish connection for " + this.aSpec.toString() + "\nin " + this.ra.toString());
                } else {
                    this.logRCFailures = false;
                }
                if (loopDelay >= this.maxLoopDelay || (loopDelay *= 3) <= this.maxLoopDelay) continue;
                loopDelay = this.maxLoopDelay;
            }
        }
    }

    @Override
    public void onEvent(Event evnt) {
        _loggerIM.entering(_className, "onEvent()", evnt);
        _loggerIM.info("MQJMSRA_EC1101: onEvent:Connection Event:" + evnt.toString());
    }

    public ResourceAdapter getResourceAdapter() {
        return this.ra;
    }

    public int getConsumerID() {
        return this.cID;
    }

    public int getFactoryID() {
        return this.fID;
    }

    public MessageEndpointFactory getMessageEndpointFactory() {
        MessageEndpointFactory epf = this.ra._getMessageFactory(this.fID);
        return epf;
    }

    @Override
    public XASession getXASession() {
        return this.xas;
    }

    public DirectSession getDirectSession() {
        return this.ds;
    }

    public void setDeactivated() {
        this.deactivated = true;
    }

    public void createRemoteMessageConsumer() throws ResourceException {
        try {
            this.xac = (XAConnectionImpl)this.xacf.createXAConnection();
            if (this.xac == null) {
                throw new ResourceException("MQRA:EC:Error:createRemoteMessageConsumer failed: cannot create XAConnection");
            }
            if (this.aSpec._isInClusteredContainerSet() && this.aSpec.isUseSharedSubscriptionInClusteredContainer()) {
                this.xac.setRANamespaceUID(this.aSpec._getRAUID());
            }
            _loggerIM.fine("MQRA:EC:createRemoteMessageConsumer setting clientID to " + this.clientId);
            if (this.clientId != null) {
                this.xac.setClientID(this.clientId);
            }
            this.xac.setExceptionListener(this);
            this.xac.setEventListener(this);
        }
        catch (JMSException jmse) {
            if (this.xac != null) {
                try {
                    this.xac.close();
                }
                catch (JMSException jMSException) {
                    // empty catch block
                }
                this.xac = null;
            }
            if (this.logRCFailures) {
                jmse.printStackTrace();
            }
            NotSupportedException nse = new NotSupportedException("MQRA:EC:Error:createRemoteMessageConsumer failed:aborting due to:" + jmse.getMessage());
            nse.initCause((Throwable)jmse);
            throw nse;
        }
        try {
            this.xas = this.isDurable ? (XASessionImpl)this.xac.createSession(false, 2) : (this.noAckDelivery ? (XASessionImpl)this.xac.createSession(32768) : (XASessionImpl)this.xac.createSession(false, 2));
            this.xas._setRAEndpointSession();
            if (this.aSpec.getSubscriptionScope() != null) {
                this.subscriptionName = this.getSubscriptionName();
                this.msgConsumer = this.isDurable ? this.xas.createSharedDurableConsumer((javax.jms.Topic)this.destination, this.subscriptionName, this.aSpec.getMessageSelector()) : this.xas.createSharedConsumer((javax.jms.Topic)this.destination, this.subscriptionName, this.aSpec.getMessageSelector());
            } else if (this.isDurable) {
                this.msgConsumer = this.xas.createDurableSubscriber((javax.jms.Topic)this.destination, this.aSpec.getSubscriptionName(), this.aSpec.getMessageSelector(), false);
            } else {
                this.msgConsumer = this.xas.createConsumer(this.destination, this.aSpec.getMessageSelector());
                if (this.destination instanceof javax.jms.Queue && this.aSpec._isInClusteredContainerSet()) {
                    try {
                        this.msgConsumer2 = this.xas.createConsumer(this.destination, this.aSpec.getMessageSelector());
                        this.msgConsumer2.close();
                        this.msgConsumer2 = null;
                    }
                    catch (JMSException jmse) {
                        try {
                            this.xac.close();
                        }
                        catch (JMSException nse) {
                            // empty catch block
                        }
                        this.xac = null;
                        NotSupportedException nse = new NotSupportedException("MQRA:EC:Error clustering multiple consumers on Queue:\n" + jmse.getMessage());
                        nse.initCause((Throwable)jmse);
                        throw nse;
                    }
                }
            }
            this.msgListener = new MessageListener(this, this.endpointFactory, this.aSpec);
            this.msgConsumer.setMessageListener((javax.jms.MessageListener)this.msgListener);
            this.xac.start();
            this.updateFactoryConsumerTables(this.endpointFactory, this.aSpec);
        }
        catch (JMSException jmse) {
            if (this.xac != null) {
                try {
                    this.xac.close();
                }
                catch (JMSException nse) {
                    // empty catch block
                }
                this.xac = null;
            }
            NotSupportedException nse = new NotSupportedException("MQRA:EC:Error creating Remote Message Consumer:\n" + jmse.getMessage());
            nse.initCause((Throwable)jmse);
            throw nse;
        }
    }

    private void setAdditionalConnectionFactoryProperties(String stringProps) {
        if (stringProps == null) {
            return;
        }
        HashMap<String, String> originalAdditionalCFProperties = new HashMap<String, String>();
        Hashtable<String, String> props = null;
        try {
            props = CustomTokenizer.parseToProperties(stringProps);
        }
        catch (InvalidPropertyException ipe) {
            IllegalArgumentException iae = new IllegalArgumentException("MQJMSRA_EC4001: Invalid value for activation spec property options: " + stringProps);
            iae.initCause(ipe);
            throw iae;
        }
        Enumeration<String> keysEnum = props.keys();
        while (keysEnum.hasMoreElements()) {
            String thisPropertyName = keysEnum.nextElement();
            if (thisPropertyName.equals("imqReconnectEnabled") || thisPropertyName.equals("imqReconnectInterval") || thisPropertyName.equals("imqDefaultUsername") || thisPropertyName.equals("imqDefaultPassword") || thisPropertyName.equals("imqAddressList") || thisPropertyName.equals("imqAddressListIterations") || thisPropertyName.equals("imqAddressListBehavior") || thisPropertyName.equals("imqReconnectAttempts")) {
                _loggerIM.warning("MQJMSRA_EC2001: Cannot use activation spec property options to set property " + thisPropertyName + ": ignoring");
                continue;
            }
            try {
                originalAdditionalCFProperties.put(thisPropertyName, this.xacf.getProperty(thisPropertyName));
                this.xacf.setProperty(thisPropertyName, props.get(thisPropertyName));
            }
            catch (JMSException e) {
                IllegalArgumentException iae = new IllegalArgumentException("MQJMSRA_EC4001: Error setting connection factory property " + thisPropertyName + " (defined in activation spec property options) to " + props.get(thisPropertyName));
                iae.initCause(e);
                throw iae;
            }
        }
    }

    protected void startMessageConsumer() throws Exception {
    }

    public void stopMessageConsumer() throws Exception {
        if (this.useRADirect) {
            this.stopDirectMessageConsumer();
        } else {
            this.stopRemoteMessageConsumer();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopRemoteMessageConsumer() throws Exception {
        this.stopping = true;
        EndpointConsumer endpointConsumer = this;
        synchronized (endpointConsumer) {
            if (this.msgConsumer != null) {
                try {
                    if (this.msgListener != null) {
                        XASessionImpl mqsess = this.xas;
                        mqsess._stopFromRA();
                        this.msgListener.waitForAllOnMessageRunners();
                        this.msgListener.releaseOnMessageRunners();
                        this.xas.close();
                    }
                }
                catch (JMSException jmse) {
                    ResourceException re = new ResourceException("MQRA:EC:Error on closing MessageConsumer");
                    re.initCause((Throwable)jmse);
                    throw re;
                }
            }
            if (this.xac != null) {
                try {
                    this.xac.close();
                }
                catch (JMSException jmse) {
                    ResourceException re = new ResourceException("MQRA:EC:Error closing JMS Connection");
                    re.initCause((Throwable)jmse);
                    throw re;
                }
            }
        }
    }

    private void updateFactoryConsumerTables(MessageEndpointFactory endpointFactory, ActivationSpec spec) {
        this.cID = this.ra.addEndpointConsumer(this);
        this.fID = this.ra.addMessageFactory(endpointFactory);
        this.ra.addFactorytoConsumerLink(this.fID, this.cID);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void setDestinationType() throws ResourceException {
        String destName = this.aSpec.getDestination();
        String destinationLookup = this.aSpec.getDestinationLookup();
        Object destObj = null;
        if (destinationLookup != null) {
            try {
                destObj = Util.jndiLookup(destinationLookup);
            }
            catch (NamingException e) {
                String errorMessage = "MQRA:EC:Invalid destinationLookup " + destinationLookup + " configured in ActivationSpec of MDB for no JNDI name found";
                throw new ResourceException(errorMessage, (Throwable)e);
            }
            if (destObj == null) {
                String errorMessage = "MQRA:EC:Invalid destinationLookup " + destinationLookup + " configured in ActivationSpec of MDB for JNDI object is null";
                throw new NotSupportedException(errorMessage);
            }
            if (!(destObj instanceof Destination)) {
                String errorMessage = "MQRA:EC:Invalid destinationLookup " + destinationLookup + " configured in ActivationSpec of MDB, The JNDI object is required to be a Destination";
                throw new NotSupportedException(errorMessage);
            }
            destName = ((Destination)destObj).getName();
        }
        try {
            if (destObj != null) {
                if (destObj instanceof Queue) {
                    if (this.aSpec._isDestTypeTopicSet()) {
                        throw new InvalidPropertyException("MQRA:EC:Inconsistent destinationType is set for destinationLookup " + destinationLookup);
                    }
                    this.destination = new Queue(destName);
                    this.destinationType = 1;
                    return;
                }
                if (!(destObj instanceof Topic)) return;
                if (this.aSpec._isDestTypeQueueSet()) {
                    throw new InvalidPropertyException("MQRA:EC:Inconsistent destinationType is set for destinationLookup " + destinationLookup);
                }
                this.destination = new Topic(destName);
                this.destinationType = 2;
                return;
            }
            if (this.aSpec._isDestTypeQueueSet()) {
                this.destination = new Queue(destName);
                this.destinationType = 1;
                return;
            }
            this.destination = new Topic(destName);
            this.destinationType = 2;
            return;
        }
        catch (JMSException jmse) {
            String errorMessage = destName == null ? "MQRA:EC:No destination configured in ActivationSpec of MDB" : "MQRA:EC:Invalid destination " + destName + " configured in ActivationSpec of MDB";
            NotSupportedException nse = new NotSupportedException(errorMessage);
            nse.initCause((Throwable)jmse);
            throw nse;
        }
    }

    private void setIsDurable() throws NotSupportedException {
        if (this.aSpec._isDurableSet()) {
            String sName;
            if (this.aSpec.getSubscriptionScope() == null && ((sName = this.subscriptionName) == null || sName.length() <= 0)) {
                throw new NotSupportedException("MQRA:EC:Need Valid SubscriptionName-" + sName);
            }
            this.isDurable = true;
        }
    }

    protected void createDirectMessageConsumer() throws NotSupportedException {
        try {
            this.dc = (DirectConnection)this.dcf._createConnection(this.username, this.password);
            if (this.clientId != null) {
                this.dc._setClientID(this.clientId);
            }
            this.ds = ResourceAdapter._isFixCR6760301() ? (DirectSession)this.dc.createSessionForRAEndpoint() : (DirectSession)this.dc.createSession(false, 2);
            this.ds._setMDBSession(true);
            if (this.aSpec.getSubscriptionScope() != null) {
                this.subscriptionName = this.getSubscriptionName();
                this.msgConsumer = this.isDurable ? this.ds.createSharedDurableConsumer((javax.jms.Topic)this.destination, this.subscriptionName, this.selector) : this.ds.createSharedConsumer((javax.jms.Topic)this.destination, this.subscriptionName, this.selector);
            } else {
                this.msgConsumer = this.isDurable ? this.ds.createDurableSubscriber((javax.jms.Topic)this.destination, this.subscriptionName, this.selector, false) : this.ds.createConsumer(this.destination, this.selector);
            }
            this.msgListener = new MessageListener(this, this.endpointFactory, this.aSpec, this.noAckDelivery, this.useRADirect);
            this.msgConsumer.setMessageListener((javax.jms.MessageListener)this.msgListener);
            this.dc.start();
            this.updateFactoryConsumerTables(this.endpointFactory, this.aSpec);
        }
        catch (JMSException jmse) {
            if (this.dc != null) {
                try {
                    this.dc.close();
                }
                catch (JMSException jMSException) {
                    // empty catch block
                }
                this.dc = null;
            }
            NotSupportedException nse = new NotSupportedException("MQRA:EC:Error creating Direct Message Consumer:\n" + jmse.getMessage());
            nse.initCause((Throwable)jmse);
            throw nse;
        }
    }

    protected void startDirectConsumer() throws NotSupportedException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void stopDirectMessageConsumer() throws Exception {
        this.stopping = true;
        EndpointConsumer endpointConsumer = this;
        synchronized (endpointConsumer) {
            if (this.msgConsumer != null) {
                try {
                    if (this.msgListener != null) {
                        this.ds._stop();
                        this.msgListener.waitForAllOnMessageRunners();
                        this.msgListener.releaseOnMessageRunners();
                    }
                }
                catch (JMSException jmse) {
                    ResourceException re = new ResourceException("MQRA:EC:Error on closing Direct MessageConsumer");
                    re.initCause((Throwable)jmse);
                    throw re;
                }
            }
            if (this.dc != null) {
                try {
                    this.dc.close();
                }
                catch (JMSException jmse) {
                    ResourceException re = new ResourceException("MQRA:EC:Error closing DircetConnection");
                    re.initCause((Throwable)jmse);
                    throw re;
                }
            }
        }
    }

    protected String getSubscriptionName() {
        if (this.aSpec.getSubscriptionScope() == null) {
            return this.aSpec.getSubscriptionName();
        }
        String subscriptionName = null;
        if (this.aSpec.getSubscriptionName() == null) {
            String activationName = this.endpointFactory.getActivationName();
            if (this.aSpec.getSubscriptionScope().equals("Cluster")) {
                subscriptionName = activationName;
            } else if (!this.aSpec._isInClusteredContainerSet()) {
                subscriptionName = activationName;
            }
        } else if (this.aSpec.getSubscriptionScope().equals("Instance")) {
            if (!this.aSpec._isInClusteredContainerSet()) {
                subscriptionName = this.aSpec.getSubscriptionName();
            }
        } else {
            subscriptionName = this.aSpec.getSubscriptionName();
        }
        _loggerIM.fine("MQRA:EC:Use subscription name '" + subscriptionName + "' for endpoint activation");
        return subscriptionName;
    }

    protected void checkSubscriptionScopeAndClientId() throws NotSupportedException {
        if (this.aSpec.getSubscriptionScope() != null) {
            if (QUEUE.equals(this.aSpec.getDestinationType())) {
                NotSupportedException nse = new NotSupportedException("MQRA:EC:Error:Bad parameter");
                nse.initCause((Throwable)new InvalidPropertyException("MQJMSRA_EC4001: subscriptionScope must not be set if destinationType is javax.jms.Queue"));
                throw nse;
            }
            if (TOPIC.equals(this.aSpec.getDestinationType()) && this.clientId != null) {
                NotSupportedException nse = new NotSupportedException("MQRA:EC:Error:Bad parameter");
                nse.initCause((Throwable)new InvalidPropertyException("MQJMSRA_EC4001: clientId must not be set if subscriptionScope is set"));
                throw nse;
            }
        }
    }
}

