/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jms.ra;

import com.sun.messaging.jmq.jmsservice.ConsumerClosedNoDeliveryException;
import com.sun.messaging.jms.JMSException;
import com.sun.messaging.jms.ra.ActivationSpec;
import com.sun.messaging.jms.ra.EndpointConsumer;
import com.sun.messaging.jms.ra.OnMessageRunner;
import java.util.ArrayList;
import java.util.Vector;
import java.util.logging.Logger;
import javax.resource.spi.endpoint.MessageEndpointFactory;

public class OnMessageRunnerPool {
    private int max;
    private int min;
    private int freeCount;
    private int slackCount;
    private MessageEndpointFactory epFactory;
    private EndpointConsumer epConsumer;
    private ActivationSpec spec = null;
    private boolean useDirect = false;
    private ArrayList<OnMessageRunner> onMessageRunners;
    private Vector<OnMessageRunner> available;
    private volatile boolean deactivating;
    private static final transient String _className = "com.sun.messaging.jms.ra.OnMessageRunnerPool";
    protected static final transient String _lgrNameInboundMessage = "javax.resourceadapter.mqjmsra.inbound.message";
    protected static final transient Logger _loggerIM = Logger.getLogger("javax.resourceadapter.mqjmsra.inbound.message");
    protected static final transient String _lgrMIDPrefix = "MQJMSRA_RP";
    protected static final transient String _lgrMID_EET = "MQJMSRA_RP1001: ";
    protected static final transient String _lgrMID_INF = "MQJMSRA_RP1101: ";
    protected static final transient String _lgrMID_WRN = "MQJMSRA_RP2001: ";
    protected static final transient String _lgrMID_ERR = "MQJMSRA_RP3001: ";
    protected static final transient String _lgrMID_EXC = "MQJMSRA_RP4001: ";

    public OnMessageRunnerPool(MessageEndpointFactory epFactory, EndpointConsumer epConsumer, ActivationSpec spec, boolean useDirect) {
        Object[] params = new Object[]{epFactory, epConsumer, spec, useDirect};
        _loggerIM.entering(_className, "constructor()", params);
        this.epFactory = epFactory;
        this.epConsumer = epConsumer;
        this.spec = spec;
        this.useDirect = useDirect;
        int minimum = spec.getEndpointPoolSteadySize();
        int maximum = spec.getEndpointPoolMaxSize();
        this.max = maximum < 1 ? 10 : maximum;
        this.min = minimum < 1 || minimum > this.max ? 1 : minimum;
        this.available = new Vector(this.min);
        this.onMessageRunners = new ArrayList(this.min);
        for (int i = 0; i < this.min; ++i) {
            OnMessageRunner omr = new OnMessageRunner(i, this, epFactory, epConsumer, spec, useDirect);
            this.onMessageRunners.add(omr);
            this.available.addElement(omr);
        }
        this.freeCount = this.min;
        this.slackCount = this.max - this.min;
    }

    public synchronized OnMessageRunner getOnMessageRunner() throws javax.jms.JMSException {
        if (this.available.size() == 0) {
            if (this.deactivating) {
                throw new ConsumerClosedNoDeliveryException("MQRA:OMRP:getOMR:OnMessageRunnerPool is in deactivating");
            }
            if (this.slackCount > 0) {
                OnMessageRunner omr = new OnMessageRunner(this.onMessageRunners.size(), this, this.epFactory, this.epConsumer, this.spec, this.useDirect);
                this.onMessageRunners.add(omr);
                --this.slackCount;
                return omr;
            }
        }
        while (this.available.size() == 0) {
            if (this.deactivating) {
                throw new ConsumerClosedNoDeliveryException("MQRA:OMRP:getOMR:OnMessageRunnerPool is in deactivating");
            }
            try {
                this.wait();
            }
            catch (InterruptedException ie) {
                JMSException jmse = new JMSException("MQRA:OMRP:Unable to get OMR from pool:" + ie.getMessage());
                jmse.setLinkedException(ie);
                throw jmse;
            }
        }
        OnMessageRunner omr = this.available.elementAt(this.available.size() - 1);
        this.available.removeElementAt(this.available.size() - 1);
        --this.freeCount;
        return omr;
    }

    public synchronized void putOnMessageRunner(OnMessageRunner omr) {
        this.available.addElement(omr);
        ++this.freeCount;
        this.notifyAll();
    }

    public synchronized void removeOnMessageRunner(OnMessageRunner omr) {
        int index = this.onMessageRunners.indexOf(omr);
        if (index != -1) {
            this.onMessageRunners.remove(index);
            this.notifyAll();
            ++this.freeCount;
            if (this.slackCount < this.max - this.min) {
                ++this.slackCount;
            }
        }
    }

    public synchronized void waitForAllOnMessageRunners() throws javax.jms.JMSException {
        while (this.available.size() < this.onMessageRunners.size()) {
            try {
                this.wait();
            }
            catch (InterruptedException ie) {
                JMSException jmse = new JMSException("MQRA:OMRP:Didnot finish waiting for OMRs to return:" + ie.getMessage());
                jmse.setLinkedException(ie);
                throw jmse;
            }
        }
    }

    public synchronized void releaseOnMessageRunners() {
        this.deactivating = true;
        for (int i = 0; i < this.onMessageRunners.size(); ++i) {
            this.onMessageRunners.get(i).releaseEndpoint();
        }
        this.onMessageRunners.clear();
        this.available.removeAllElements();
        this.notifyAll();
        this.freeCount = 0;
        this.slackCount = this.max;
    }

    public synchronized void invalidateOnMessageRunners() {
        for (int i = 0; i < this.onMessageRunners.size(); ++i) {
            this.onMessageRunners.get(i).invalidate();
        }
        this.releaseOnMessageRunners();
    }
}

