/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jms.ra;

import com.sun.messaging.jmq.jmsclient.ContextableSession;
import com.sun.messaging.jmq.jmsclient.XAConnectionImpl;
import com.sun.messaging.jmq.jmsclient.XASessionImpl;
import com.sun.messaging.jms.IllegalStateException;
import com.sun.messaging.jms.ra.ConnectionAdapter;
import com.sun.messaging.jms.ra.api.JMSRASessionAdapter;
import com.sun.messaging.jms.ra.api.JMSRAXASession;
import java.io.Serializable;
import java.util.logging.Logger;
import javax.jms.BytesMessage;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.MapMessage;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.MessageListener;
import javax.jms.MessageProducer;
import javax.jms.ObjectMessage;
import javax.jms.Queue;
import javax.jms.QueueBrowser;
import javax.jms.QueueReceiver;
import javax.jms.QueueSender;
import javax.jms.QueueSession;
import javax.jms.Session;
import javax.jms.StreamMessage;
import javax.jms.TemporaryQueue;
import javax.jms.TemporaryTopic;
import javax.jms.TextMessage;
import javax.jms.Topic;
import javax.jms.TopicPublisher;
import javax.jms.TopicSession;
import javax.jms.TopicSubscriber;

public class SessionAdapter
implements Session,
QueueSession,
TopicSession,
JMSRASessionAdapter,
ContextableSession {
    private ConnectionAdapter ca = null;
    private XAConnectionImpl xac = null;
    private XASessionImpl xas = null;
    private boolean queueSession = false;
    private boolean topicSession = false;
    private boolean closed = false;
    private static final transient String _className = "com.sun.messaging.jms.ra.SessionAdapter";
    protected static final transient String _lgrNameOutboundConnection = "javax.resourceadapter.mqjmsra.outbound.connection";
    protected static final transient String _lgrNameJMSSession = "javax.jms.Session.mqjmsra";
    protected static final transient Logger _loggerOC = Logger.getLogger("javax.resourceadapter.mqjmsra.outbound.connection");
    protected static final transient Logger _loggerJS = Logger.getLogger("javax.jms.Session.mqjmsra");
    protected static final transient String _lgrMIDPrefix = "MQJMSRA_SA";
    protected static final transient String _lgrMID_EET = "MQJMSRA_SA1001: ";
    protected static final transient String _lgrMID_INF = "MQJMSRA_SA1101: ";
    protected static final transient String _lgrMID_WRN = "MQJMSRA_SA2001: ";
    protected static final transient String _lgrMID_ERR = "MQJMSRA_SA3001: ";
    protected static final transient String _lgrMID_EXC = "MQJMSRA_SA4001: ";

    public SessionAdapter(ConnectionAdapter ca, XAConnectionImpl xac, XASessionImpl xas) {
        Object[] params = new Object[]{ca, xac, xas};
        _loggerOC.entering(_className, "constructor()", params);
        this.ca = ca;
        this.xac = xac;
        this.xas = xas;
    }

    public XAConnectionImpl getXAConnection() {
        return this.xac;
    }

    public XASessionImpl getXASession() {
        return this.xas;
    }

    @Override
    public JMSRAXASession getJMSRAXASession() {
        return this.xas;
    }

    public void setQueueSession() {
        this.queueSession = true;
    }

    public void setTopicSession() {
        this.topicSession = true;
    }

    public void setConnectionAdapter(ConnectionAdapter ca) {
        this.ca = ca;
    }

    protected void startLocalTransaction() throws JMSException {
        this.xas._startLocalTransaction();
    }

    protected void closeAdapter() {
        if (this.closed) {
            return;
        }
        try {
            this.xas.close();
            this.closed = true;
        }
        catch (JMSException jmse) {
            System.err.println("MQRA:SA:closeAdapter:Exception-" + jmse.getMessage());
            jmse.printStackTrace();
        }
    }

    public BytesMessage createBytesMessage() throws JMSException {
        return this.xas.createBytesMessage();
    }

    public MapMessage createMapMessage() throws JMSException {
        return this.xas.createMapMessage();
    }

    public Message createMessage() throws JMSException {
        return this.xas.createMessage();
    }

    public ObjectMessage createObjectMessage() throws JMSException {
        return this.xas.createObjectMessage();
    }

    public ObjectMessage createObjectMessage(Serializable object) throws JMSException {
        return this.xas.createObjectMessage(object);
    }

    public StreamMessage createStreamMessage() throws JMSException {
        return this.xas.createStreamMessage();
    }

    public TextMessage createTextMessage() throws JMSException {
        return this.xas.createTextMessage();
    }

    public TextMessage createTextMessage(String string) throws JMSException {
        return this.xas.createTextMessage(string);
    }

    public MessageProducer createProducer(Destination destination) throws JMSException {
        return this.xas.createProducer(destination);
    }

    public MessageConsumer createConsumer(Destination destination) throws JMSException {
        return this.xas.createConsumer(destination);
    }

    public MessageConsumer createConsumer(Destination destination, String messageSelector) throws JMSException {
        return this.xas.createConsumer(destination, messageSelector);
    }

    public MessageConsumer createConsumer(Destination destination, String messageSelector, boolean noLocal) throws JMSException {
        return this.xas.createConsumer(destination, messageSelector, noLocal);
    }

    public QueueReceiver createReceiver(Queue queue) throws JMSException {
        return this.xas.createReceiver(queue);
    }

    public QueueReceiver createReceiver(Queue queue, String messageSelector) throws JMSException {
        return this.xas.createReceiver(queue, messageSelector);
    }

    public QueueSender createSender(Queue queue) throws JMSException {
        if (this.topicSession) {
            throw new javax.jms.IllegalStateException("MQRA:createSender() disallowed on TopicSession");
        }
        return this.xas.createSender(queue);
    }

    public QueueBrowser createBrowser(Queue queue) throws JMSException {
        if (this.topicSession) {
            throw new javax.jms.IllegalStateException("MQRA:createBrowser() disallowed on TopicSession");
        }
        return this.xas.createBrowser(queue);
    }

    public QueueBrowser createBrowser(Queue queue, String messageSelector) throws JMSException {
        if (this.topicSession) {
            throw new javax.jms.IllegalStateException("MQRA:createBrowser() disallowed on TopicSession");
        }
        return this.xas.createBrowser(queue, messageSelector);
    }

    public TopicSubscriber createSubscriber(Topic topic) throws JMSException {
        return this.xas.createSubscriber(topic);
    }

    public TopicSubscriber createSubscriber(Topic topic, String messageSelector, boolean noLocal) throws JMSException {
        return this.xas.createSubscriber(topic, messageSelector, noLocal);
    }

    public TopicSubscriber createDurableSubscriber(Topic topic, String name) throws JMSException {
        return this.xas.createDurableSubscriber(topic, name);
    }

    public TopicSubscriber createDurableSubscriber(Topic topic, String name, String messageSelector, boolean noLocal) throws JMSException {
        return this.xas.createDurableSubscriber(topic, name, messageSelector, noLocal);
    }

    public MessageConsumer createDurableConsumer(Topic topic, String name) throws JMSException {
        return this.createDurableSubscriber(topic, name);
    }

    public MessageConsumer createDurableConsumer(Topic topic, String name, String messageSelector, boolean noLocal) throws JMSException {
        return this.createDurableSubscriber(topic, name, messageSelector, noLocal);
    }

    public MessageConsumer createSharedConsumer(Topic topic, String sharedSubscriptionName) throws JMSException {
        return this.xas.createSharedConsumer(topic, sharedSubscriptionName, null);
    }

    public MessageConsumer createSharedConsumer(Topic topic, String sharedSubscriptionName, String messageSelector) throws JMSException {
        return this.xas.createSharedConsumer(topic, sharedSubscriptionName, messageSelector);
    }

    public MessageConsumer createSharedDurableConsumer(Topic topic, String name) throws JMSException {
        return this.xas.createSharedDurableConsumer(topic, name, null);
    }

    public MessageConsumer createSharedDurableConsumer(Topic topic, String name, String messageSelector) throws JMSException {
        return this.xas.createSharedDurableConsumer(topic, name, messageSelector);
    }

    public TopicPublisher createPublisher(Topic topic) throws JMSException {
        return this.xas.createPublisher(topic);
    }

    public void unsubscribe(String name) throws JMSException {
        if (this.queueSession) {
            throw new javax.jms.IllegalStateException("MQRA:unsubscribe() disallowed on QueueSession");
        }
        this.xas.unsubscribe(name);
    }

    public Topic createTopic(String topicName) throws JMSException {
        return this.xas.createTopic(topicName);
    }

    public Queue createQueue(String queueName) throws JMSException {
        return this.xas.createQueue(queueName);
    }

    public TemporaryTopic createTemporaryTopic() throws JMSException {
        if (this.queueSession) {
            throw new javax.jms.IllegalStateException("MQRA:createTemporaryTopic() disallowed on QueueSession");
        }
        return this.xas.createTemporaryTopic();
    }

    public TemporaryQueue createTemporaryQueue() throws JMSException {
        if (this.topicSession) {
            throw new javax.jms.IllegalStateException("MQRA:createTemporaryQueue() disallowed on TopicSession");
        }
        return this.xas.createTemporaryQueue();
    }

    public void setMessageListener(MessageListener listener) throws JMSException {
        this.xas.setMessageListener(listener);
    }

    public MessageListener getMessageListener() throws JMSException {
        return this.xas.getMessageListener();
    }

    public void run() {
        _loggerJS.entering(_className, "run()");
        throw new UnsupportedOperationException("MQRA:SA:Disallowed - Session.run()");
    }

    public void commit() throws JMSException {
        this.xas.commit();
    }

    public void rollback() throws JMSException {
        this.xas.rollback();
    }

    public void recover() throws JMSException {
        this.xas.recover();
    }

    @Override
    public void clientAcknowledge() throws JMSException {
        this.xas.clientAcknowledge();
    }

    public void close() throws JMSException {
        this.close(false);
    }

    protected void close(boolean fromConnection) throws JMSException {
        _loggerJS.entering(_className, "close()");
        if (this.closed) {
            return;
        }
        if (!fromConnection) {
            this.ca.removeSessionAdapter(this);
        }
        this.xas.close();
        this.closed = true;
    }

    public int getAcknowledgeMode() throws JMSException {
        return this.xas.getAcknowledgeMode();
    }

    public boolean getTransacted() throws JMSException {
        return this.xas.getTransacted();
    }

    protected void checkClosed() throws JMSException {
        if (this.closed) {
            throw new IllegalStateException("MQRA:SA:IllegalState-Session is closed");
        }
    }
}

