/*
 * Decompiled with CFR 0.152.
 */
package com.sun.connector.jaxr;

import com.sun.connector.jaxr.JaxrConnectionFactory;
import com.sun.connector.jaxr.JaxrConnectionRequestInfo;
import com.sun.connector.jaxr.JaxrManagedConnection;
import java.io.PrintWriter;
import java.io.Serializable;
import java.net.PasswordAuthentication;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.resource.ResourceException;
import javax.resource.spi.ConnectionManager;
import javax.resource.spi.ConnectionRequestInfo;
import javax.resource.spi.EISSystemException;
import javax.resource.spi.ManagedConnection;
import javax.resource.spi.ManagedConnectionFactory;
import javax.resource.spi.ResourceAdapter;
import javax.security.auth.Subject;
import javax.xml.registry.Connection;
import javax.xml.registry.ConnectionFactory;
import org.glassfish.logging.annotation.LogMessagesResourceBundle;

public class NoTxManagedConnectionFactory
implements ManagedConnectionFactory,
Serializable {
    static final String QUERY_URL_PROP = "javax.xml.registry.queryManagerURL";
    static final String LIFE_CYCLE_URL_PROP = "javax.xml.registry.lifeCycleManagerURL";
    static final String HTTP_PROXY_HOST = "com.sun.xml.registry.http.proxyHost";
    static final String HTTP_PROXY_PORT = "com.sun.xml.registry.http.proxyPort";
    static final String HTTPS_PROXY_HOST = "com.sun.xml.registry.https.proxyHost";
    static final String HTTPS_PROXY_PORT = "com.sun.xml.registry.https.proxyPort";
    static final String PROXY_USER_NAME = "com.sun.xml.registry.http.proxyUserName";
    static final String PROXY_PASSWORD = "com.sun.xml.registry.http.proxyPassword";
    static final String USER_DEF_TAXONOMIES = "com.sun.xml.registry.userTaxonomyFilenames";
    static final String USERNAME = "com.sun.xml.registry.userName";
    static final String PASSWORD = "com.sun.xml.registry.userPassword";
    static final String APPSERV_PROPERTY = "com.sun.appserv.uddi";
    private transient ResourceAdapter ra;
    private String queryManagerURL;
    private String lifeCycleManagerURL;
    private String httpProxyHost;
    private String httpProxyPort;
    private String httpsProxyHost;
    private String httpsProxyPort;
    private String proxyUsername;
    private String proxyUserPassword;
    private Properties properties;
    private transient PrintWriter out;
    private String userName;
    private String userPassword;
    private Boolean appserverUDDI = true;
    @LogMessagesResourceBundle
    private static final Logger log = Logger.getLogger("com.sun.connector.jaxr");

    public Object createConnectionFactory(ConnectionManager paramConnectionManager) throws ResourceException {
        if (log.isLoggable(Level.FINE)) {
            log.fine("NoTxManagedConnectionFactory returing JAXRConnectionFactory with ConnectionManager");
            log.fine("NoTxManagedConnectionFactory - ConnectionManager class is " + paramConnectionManager.getClass().getName());
        }
        return new JaxrConnectionFactory(this, paramConnectionManager);
    }

    public Object createConnectionFactory() throws ResourceException {
        return new JaxrConnectionFactory(this, null);
    }

    public ManagedConnection createManagedConnection(Subject paramSubject, ConnectionRequestInfo paramConnectionRequestInfo) throws ResourceException {
        Properties localProperties = null;
        try {
            Connection localConnection = null;
            if (paramConnectionRequestInfo != null) {
                localProperties = ((JaxrConnectionRequestInfo)paramConnectionRequestInfo).getProperties();
            }
            log.fine("NoTxManagedConnectionFactory creating JAXRManagedConnection");
            ConnectionFactory localObject = ConnectionFactory.newInstance();
            this.populateProperties(localProperties);
            if (this.properties != null) {
                localObject.setProperties(this.properties);
            }
            log.fine("NoTxManagedConnectionFactory creating actual jaxr ConnectionImpl");
            localConnection = localObject.createConnection();
            if (this.userName != null) {
                PasswordAuthentication localPasswordAuthentication = new PasswordAuthentication(this.userName, this.userPassword.toCharArray());
                HashSet<PasswordAuthentication> localHashSet = new HashSet<PasswordAuthentication>();
                localHashSet.add(localPasswordAuthentication);
                localConnection.setCredentials(localHashSet);
            }
            log.fine("NoTxManagedConnectionFactory returning new JAXRManagedConnection");
            return new JaxrManagedConnection(this, this.properties, null, localConnection);
        }
        catch (Exception localException) {
            EISSystemException localObject = new EISSystemException(ResourceBundle.getBundle("com/sun/connector/jaxr/LocalStrings").getString("JAXRException:") + localException.getMessage());
            ((ResourceException)localObject).setLinkedException(localException);
            throw (ResourceException)localObject;
        }
    }

    public ManagedConnection matchManagedConnections(Set paramSet, Subject paramSubject, ConnectionRequestInfo paramConnectionRequestInfo) throws ResourceException {
        log.fine("NoTxManagedConnectionFactory MatchingManagedConnections");
        log.fine("NoTxManagedConnectionFactory mC - let's interate through the connectionSet passed as parameter by Appserer");
        Iterator localIterator = paramSet.iterator();
        int i = 0;
        while (localIterator.hasNext()) {
            JaxrManagedConnection localJaxrManagedConnection = (JaxrManagedConnection)localIterator.next();
            localJaxrManagedConnection.destroy();
            log.fine("NoTxManagedConnectionFactory mC - interate - got JaxrManagedconnection ");
            ++i;
            if (!log.isLoggable(Level.FINE)) continue;
            log.fine("NoTxManagedConnec - JaxrManagedconnection number " + i);
        }
        paramSet.clear();
        log.fine("NoTxManagedConnec - returning noMantched Connections");
        return null;
    }

    public void setLogWriter(PrintWriter paramPrintWriter) throws ResourceException {
        this.out = paramPrintWriter;
    }

    public PrintWriter getLogWriter() throws ResourceException {
        return this.out;
    }

    public boolean equals(Object paramObject) {
        if (paramObject == null) {
            return false;
        }
        if (paramObject instanceof NoTxManagedConnectionFactory) {
            Properties localProperties1 = ((NoTxManagedConnectionFactory)paramObject).properties;
            Properties localProperties2 = this.properties;
            return localProperties1 == null ? false : (localProperties2 == null ? true : localProperties1.equals(localProperties2));
        }
        return false;
    }

    public int hashCode() {
        if (this.properties == null) {
            return "".hashCode();
        }
        return this.properties.hashCode();
    }

    public ResourceAdapter getResourceAdapter() {
        return this.ra;
    }

    public void setResourceAdapter(ResourceAdapter paramResourceAdapter) {
        this.ra = paramResourceAdapter;
    }

    public String getQueryManagerURL() {
        return this.queryManagerURL;
    }

    public void setQueryManagerURL(String paramString) {
        this.queryManagerURL = paramString;
    }

    public String getLifeCycleManagerURL() {
        return this.lifeCycleManagerURL;
    }

    public void setLifeCycleManagerURL(String paramString) {
        this.lifeCycleManagerURL = paramString;
    }

    public void setUserName(String paramString) {
        this.userName = paramString;
    }

    public String getUserName() {
        return this.userName;
    }

    public void setUserPassword(String paramString) {
        this.userPassword = paramString;
    }

    public String getUserPassword() {
        return this.userPassword;
    }

    public Boolean getAppserverUDDI() {
        return this.appserverUDDI;
    }

    public void setAppserverUDDI(Boolean paramBoolean) {
        this.appserverUDDI = paramBoolean;
    }

    public String getHttpProxyHost() {
        return this.httpProxyHost;
    }

    public void setHttpProxyHost(String paramString) {
        this.httpProxyHost = paramString;
    }

    public String getHttpProxyPort() {
        return this.httpProxyPort;
    }

    public void setHttpProxyPort(String paramString) {
        this.httpProxyPort = paramString;
    }

    public String getHttpsProxyHost() {
        return this.httpsProxyHost;
    }

    public void setHttpsProxyHost(String paramString) {
        this.httpsProxyHost = paramString;
    }

    public String getHttpsProxyPort() {
        return this.httpsProxyPort;
    }

    public void setHttpsProxyPort(String paramString) {
        this.httpsProxyPort = paramString;
    }

    public String getProxyUsername() {
        return this.proxyUsername;
    }

    public void setProxyUsername(String paramString) {
        this.proxyUsername = paramString;
    }

    public String getProxyUserPassword() {
        return this.proxyUserPassword;
    }

    public void setProxyUserPassword(String paramString) {
        this.proxyUserPassword = paramString;
    }

    void populateDefaultProperties(Properties paramProperties) {
        if (paramProperties == null) {
            paramProperties = new Properties();
        }
        if (this.queryManagerURL != null) {
            paramProperties.put(QUERY_URL_PROP, this.queryManagerURL);
        }
        if (this.lifeCycleManagerURL != null) {
            paramProperties.put(LIFE_CYCLE_URL_PROP, this.lifeCycleManagerURL);
        }
        if (this.httpProxyHost != null) {
            paramProperties.put(HTTP_PROXY_HOST, this.httpProxyHost);
        }
        if (this.httpProxyPort != null) {
            paramProperties.put(HTTP_PROXY_PORT, this.httpProxyPort);
        }
        if (this.httpsProxyHost != null) {
            paramProperties.put(HTTPS_PROXY_HOST, this.httpsProxyHost);
        }
        if (this.httpsProxyPort != null) {
            paramProperties.put(HTTPS_PROXY_PORT, this.httpsProxyPort);
        }
        if (this.proxyUsername != null) {
            paramProperties.put(PROXY_USER_NAME, this.proxyUsername);
        }
        if (this.proxyUserPassword != null) {
            paramProperties.put(PROXY_PASSWORD, this.proxyUserPassword);
        }
        if (this.userName != null) {
            paramProperties.put(USERNAME, this.userName);
        }
        if (this.userPassword != null) {
            paramProperties.put(PASSWORD, this.userPassword);
        }
        if (this.appserverUDDI != null) {
            paramProperties.put(APPSERV_PROPERTY, this.appserverUDDI);
        }
    }

    void populateProperties(Properties paramProperties) {
        Boolean localBoolean;
        String str10;
        String str9;
        String str8;
        String str7;
        String str6;
        String str5;
        String str4;
        String str3;
        String str2;
        if (this.properties == null) {
            this.properties = new Properties();
        }
        if (paramProperties == null) {
            this.populateDefaultProperties(this.properties);
            return;
        }
        String str1 = paramProperties.getProperty(QUERY_URL_PROP);
        if (str1 == null) {
            str1 = this.queryManagerURL;
        }
        if (str1 != null) {
            this.properties.put(QUERY_URL_PROP, str1);
        }
        if ((str2 = paramProperties.getProperty(LIFE_CYCLE_URL_PROP)) == null) {
            str2 = this.lifeCycleManagerURL;
        }
        if (str2 != null) {
            this.properties.put(LIFE_CYCLE_URL_PROP, str2);
        }
        if ((str3 = paramProperties.getProperty(HTTP_PROXY_HOST)) == null) {
            str3 = this.httpProxyHost;
        }
        if (str3 != null) {
            this.properties.put(HTTP_PROXY_HOST, str3);
        }
        if ((str4 = paramProperties.getProperty(HTTP_PROXY_PORT)) == null) {
            str4 = this.httpProxyPort;
        }
        if (str4 != null) {
            this.properties.put(HTTP_PROXY_PORT, str4);
        }
        if ((str5 = paramProperties.getProperty(HTTPS_PROXY_HOST)) == null) {
            str5 = this.httpsProxyHost;
        }
        if (str5 != null) {
            this.properties.put(HTTPS_PROXY_HOST, str5);
        }
        if ((str6 = paramProperties.getProperty(HTTPS_PROXY_PORT)) == null) {
            str6 = this.httpsProxyPort;
        }
        if (str6 != null) {
            this.properties.put(HTTPS_PROXY_PORT, str6);
        }
        if ((str7 = paramProperties.getProperty(PROXY_USER_NAME)) == null) {
            str7 = this.proxyUsername;
        }
        if (str7 != null) {
            this.properties.put(PROXY_USER_NAME, str7);
        }
        if ((str8 = paramProperties.getProperty(PROXY_PASSWORD)) == null) {
            str8 = this.proxyUserPassword;
        }
        if (str8 != null) {
            this.properties.put(PROXY_PASSWORD, str8);
        }
        if ((str9 = paramProperties.getProperty(USERNAME)) == null) {
            str9 = this.userName;
        }
        if (str9 != null) {
            this.properties.put(USERNAME, str9);
        }
        if ((str10 = paramProperties.getProperty(PASSWORD)) == null) {
            str10 = this.userPassword;
        }
        if (str10 != null) {
            this.properties.put(PASSWORD, str10);
        }
        if ((localBoolean = Boolean.valueOf(paramProperties.getProperty(APPSERV_PROPERTY))) == null) {
            localBoolean = this.appserverUDDI;
        }
        this.properties.put(APPSERV_PROPERTY, Boolean.toString(localBoolean));
    }
}

