/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.ejb.mdb;

import com.sun.appserv.connectors.internal.api.ConnectorRuntime;
import com.sun.appserv.connectors.internal.api.ResourceHandle;
import com.sun.appserv.connectors.internal.api.TransactedPoolManager;
import com.sun.ejb.ComponentContext;
import com.sun.ejb.EjbInvocation;
import com.sun.ejb.containers.BaseContainer;
import com.sun.ejb.containers.EJBContextImpl;
import com.sun.ejb.containers.EJBLocalRemoteObject;
import com.sun.ejb.containers.EJBObjectImpl;
import com.sun.ejb.containers.EJBTimerService;
import com.sun.ejb.containers.EjbContainerUtilImpl;
import com.sun.ejb.containers.RuntimeTimerState;
import com.sun.ejb.containers.util.pool.AbstractPool;
import com.sun.ejb.containers.util.pool.NonBlockingPool;
import com.sun.ejb.containers.util.pool.ObjectFactory;
import com.sun.ejb.monitoring.stats.EjbMonitoringStatsProvider;
import com.sun.ejb.monitoring.stats.EjbPoolStatsProvider;
import com.sun.ejb.spi.container.OptionalLocalInterfaceProvider;
import com.sun.enterprise.admin.monitor.callflow.ComponentType;
import com.sun.enterprise.config.serverbeans.Config;
import com.sun.enterprise.deployment.EjbMessageBeanDescriptor;
import com.sun.enterprise.deployment.LifecycleCallbackDescriptor;
import com.sun.enterprise.deployment.runtime.BeanPoolDescriptor;
import com.sun.enterprise.security.SecurityManager;
import com.sun.enterprise.util.LocalStringManagerImpl;
import com.sun.enterprise.util.Utility;
import com.sun.logging.LogDomains;
import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.ejb.CreateException;
import javax.ejb.EJBException;
import javax.ejb.EJBHome;
import javax.ejb.MessageDrivenBean;
import javax.ejb.RemoveException;
import javax.resource.spi.endpoint.MessageEndpoint;
import org.glassfish.api.invocation.ComponentInvocation;
import org.glassfish.api.invocation.InvocationManager;
import org.glassfish.api.invocation.ResourceHandler;
import org.glassfish.ejb.api.MessageBeanListener;
import org.glassfish.ejb.api.MessageBeanProtocolManager;
import org.glassfish.ejb.api.ResourcesExceededException;
import org.glassfish.ejb.config.MdbContainer;
import org.glassfish.ejb.deployment.descriptor.EjbBundleDescriptorImpl;
import org.glassfish.ejb.deployment.descriptor.EjbDescriptor;
import org.glassfish.ejb.mdb.MessageBeanContextImpl;
import org.glassfish.ejb.mdb.MessageBeanInterfaceGenerator;
import org.glassfish.ejb.mdb.MessageBeanListenerImpl;
import org.glassfish.ejb.mdb.monitoring.stats.MessageDrivenBeanStatsProvider;
import org.glassfish.ejb.spi.MessageBeanClient;
import org.glassfish.ejb.spi.MessageBeanClientFactory;

public final class MessageBeanContainer
extends BaseContainer
implements MessageBeanProtocolManager {
    private static final Logger _logger = LogDomains.getLogger(MessageBeanContainer.class, (String)"javax.enterprise.system.container.ejb.mdb");
    private String appEJBName_;
    private static LocalStringManagerImpl localStrings = new LocalStringManagerImpl(MessageBeanContainer.class);
    private static final int POOLED = 1;
    private static final int INVOKING = 2;
    private static final int DESTROYED = 3;
    private MessageBeanClient messageBeanClient_ = null;
    private AbstractPool messageBeanPool_ = null;
    private BeanPoolDescriptor beanPoolDesc_ = null;
    private int maxMessageBeanListeners_;
    private int numMessageBeanListeners_;
    private Class messageBeanInterface_;
    private Class messageBeanSubClass_;
    private static final String MESSAGE_BEAN_CLIENT_FACTORY_PROP = "com.sun.enterprise.MessageBeanClientFactory";
    private static final String DEFAULT_MESSAGE_BEAN_CLIENT_FACTORY = "ConnectorMessageBeanClientFactory";
    private static final int DEFAULT_RESIZE_QUANTITY = 8;
    private static final int DEFAULT_STEADY_SIZE = 0;
    private static final int DEFAULT_MAX_POOL_SIZE = 32;
    private static final int DEFAULT_IDLE_TIMEOUT = 600;
    private static final int MIN_IDLE_TIMEOUT = 0;
    private int statMessageCount = 0;
    private TransactedPoolManager poolMgr;
    private final Class<?> messageListenerType_;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    MessageBeanContainer(EjbDescriptor desc, ClassLoader loader, SecurityManager sm) throws Exception {
        super(BaseContainer.ContainerType.MESSAGE_DRIVEN, desc, loader, sm);
        this.initializeProtocolManager();
        this.isMessageDriven = true;
        this.appEJBName_ = desc.getApplication().getRegistrationName() + ":" + desc.getName();
        org.glassfish.ejb.deployment.descriptor.EjbMessageBeanDescriptor msgBeanDesc = (org.glassfish.ejb.deployment.descriptor.EjbMessageBeanDescriptor)desc;
        ComponentInvocation componentInvocation = null;
        try {
            Class<?> beanClass = loader.loadClass(desc.getEjbClassName());
            Class<?> messageListenerType_1 = this.messageListenerType_ = loader.loadClass(msgBeanDesc.getMessageListenerType());
            if (MessageBeanContainer.isModernMessageListener(messageListenerType_1)) {
                MessageBeanInterfaceGenerator generator = new MessageBeanInterfaceGenerator(loader);
                this.messageBeanInterface_ = generator.generateMessageBeanInterface(beanClass);
                this.messageBeanSubClass_ = generator.generateMessageBeanSubClass(beanClass, this.messageBeanInterface_);
            }
            Method[] msgListenerMethods = msgBeanDesc.getMessageListenerInterfaceMethods(loader);
            for (int i = 0; i < msgListenerMethods.length; ++i) {
                Method next = msgListenerMethods[i];
                this.addInvocationInfo(next, "Bean", null);
            }
            this.poolMgr = (TransactedPoolManager)this.ejbContainerUtilImpl.getServices().getService(TransactedPoolManager.class, new Annotation[0]);
            String factoryClassName = System.getProperty(MESSAGE_BEAN_CLIENT_FACTORY_PROP);
            MessageBeanClientFactory clientFactory = null;
            if (factoryClassName != null) {
                Class<?> clientFactoryClass = loader.loadClass(factoryClassName);
                clientFactory = (MessageBeanClientFactory)clientFactoryClass.newInstance();
            } else {
                clientFactory = (MessageBeanClientFactory)this.ejbContainerUtilImpl.getServices().getService(MessageBeanClientFactory.class, DEFAULT_MESSAGE_BEAN_CLIENT_FACTORY, new Annotation[0]);
            }
            _logger.log(Level.FINE, "Using " + clientFactory.getClass().getName() + " for message bean client factory in " + this.appEJBName_);
            this.createMessageBeanPool(msgBeanDesc);
            this.maxMessageBeanListeners_ = this.beanPoolDesc_.getMaxPoolSize();
            this.numMessageBeanListeners_ = 0;
            this.messageBeanClient_ = clientFactory.createMessageBeanClient((EjbMessageBeanDescriptor)msgBeanDesc);
            componentInvocation = this.createComponentInvocation();
            componentInvocation.container = this;
            this.invocationManager.preInvoke(componentInvocation);
            this.messageBeanClient_.setup((MessageBeanProtocolManager)this);
            this.registerMonitorableComponents(msgListenerMethods);
            this.createCallFlowAgent(ComponentType.MDB);
            if (componentInvocation == null) return;
        }
        catch (Exception ex) {
            try {
                if (this.messageBeanClient_ != null) {
                    this.messageBeanClient_.close();
                }
                _logger.log(Level.SEVERE, "containers.mdb.create_container_exception", new Object[]{desc.getName(), ex.toString()});
                _logger.log(Level.SEVERE, ex.getClass().getName(), ex);
                throw ex;
            }
            catch (Throwable throwable) {
                if (componentInvocation == null) throw throwable;
                this.invocationManager.postInvoke(componentInvocation);
                throw throwable;
            }
        }
        this.invocationManager.postInvoke(componentInvocation);
        return;
    }

    protected void registerMonitorableComponents(Method[] msgListenerMethods) {
        super.registerMonitorableComponents();
        this.poolProbeListener = new EjbPoolStatsProvider(this.messageBeanPool_, this.getContainerId(), this.containerInfo.appName, this.containerInfo.modName, this.containerInfo.ejbName);
        this.poolProbeListener.register();
        _logger.log(Level.FINE, "[MessageBeanContainer] registered monitorable");
    }

    @Override
    protected EjbMonitoringStatsProvider getMonitoringStatsProvider(String appName, String modName, String ejbName) {
        return new MessageDrivenBeanStatsProvider(this.getContainerId(), appName, modName, ejbName);
    }

    @Override
    public boolean scanForEjbCreateMethod() {
        return true;
    }

    @Override
    protected void initializeHome() throws Exception {
        throw new UnsupportedOperationException("MessageDrivenBean needn't initialize home");
    }

    @Override
    protected void addLocalRemoteInvocationInfo() throws Exception {
    }

    @Override
    protected final boolean isCreateHomeFinder(Method method) {
        return false;
    }

    private void createMessageBeanPool(org.glassfish.ejb.deployment.descriptor.EjbMessageBeanDescriptor descriptor) {
        this.beanPoolDesc_ = descriptor.getIASEjbExtraDescriptors().getBeanPool();
        if (this.beanPoolDesc_ == null) {
            this.beanPoolDesc_ = new BeanPoolDescriptor();
        }
        MdbContainer mdbc = (MdbContainer)((Config)this.ejbContainerUtilImpl.getServices().getService(Config.class, "default-instance-name", new Annotation[0])).getExtensionByType(MdbContainer.class);
        int maxPoolSize = this.beanPoolDesc_.getMaxPoolSize();
        if (maxPoolSize < 0) {
            maxPoolSize = MessageBeanContainer.stringToInt(mdbc.getMaxPoolSize(), this.appEJBName_, _logger);
        }
        maxPoolSize = this.validateValue(maxPoolSize, 1, -1, 32, "max-pool-size", this.appEJBName_, _logger);
        this.beanPoolDesc_.setMaxPoolSize(maxPoolSize);
        int value = this.beanPoolDesc_.getSteadyPoolSize();
        if (value < 0) {
            value = MessageBeanContainer.stringToInt(mdbc.getSteadyPoolSize(), this.appEJBName_, _logger);
        }
        value = this.validateValue(value, 0, maxPoolSize, 0, "steady-pool-size", this.appEJBName_, _logger);
        this.beanPoolDesc_.setSteadyPoolSize(value);
        value = this.beanPoolDesc_.getPoolResizeQuantity();
        if (value < 0) {
            value = MessageBeanContainer.stringToInt(mdbc.getPoolResizeQuantity(), this.appEJBName_, _logger);
        }
        value = this.validateValue(value, 1, maxPoolSize, 8, "pool-resize-quantity", this.appEJBName_, _logger);
        this.beanPoolDesc_.setPoolResizeQuantity(value);
        value = this.beanPoolDesc_.getPoolIdleTimeoutInSeconds();
        if (value < 0) {
            value = MessageBeanContainer.stringToInt(mdbc.getIdleTimeoutInSeconds(), this.appEJBName_, _logger);
        }
        value = this.validateValue(value, 0, -1, 600, "idle-timeout-in-seconds", this.appEJBName_, _logger);
        this.beanPoolDesc_.setPoolIdleTimeoutInSeconds(value);
        if (_logger.isLoggable(Level.FINE)) {
            _logger.log(Level.FINE, this.appEJBName_ + ": Setting message-driven bean pool max-pool-size=" + this.beanPoolDesc_.getMaxPoolSize() + ", steady-pool-size=" + this.beanPoolDesc_.getSteadyPoolSize() + ", pool-resize-quantity=" + this.beanPoolDesc_.getPoolResizeQuantity() + ", idle-timeout-in-seconds=" + this.beanPoolDesc_.getPoolIdleTimeoutInSeconds());
        }
        MessageBeanContextFactory objFactory = new MessageBeanContextFactory();
        String val = descriptor.getEjbBundleDescriptor().getEnterpriseBeansProperty("singleton-bean-pool");
        this.messageBeanPool_ = new NonBlockingPool(this.getContainerId(), this.appEJBName_, objFactory, this.beanPoolDesc_.getSteadyPoolSize(), this.beanPoolDesc_.getPoolResizeQuantity(), this.beanPoolDesc_.getMaxPoolSize(), this.beanPoolDesc_.getPoolIdleTimeoutInSeconds(), this.loader, Boolean.parseBoolean(val));
    }

    protected static int stringToInt(String val, String appName, Logger logger) {
        int value = -1;
        try {
            value = Integer.parseInt(val);
        }
        catch (Exception e) {
            _logger.log(Level.WARNING, "containers.mdb.invalid_value", new Object[]{appName, val, e.toString(), "0"});
            _logger.log(Level.WARNING, "", e);
        }
        return value;
    }

    protected int validateValue(int value, int lowLimit, int highLimit, int deft, String emsg, String appName, Logger logger) {
        if (value < lowLimit) {
            _logger.log(Level.WARNING, "containers.mdb.invalid_value", new Object[]{appName, value, emsg, deft});
            value = deft;
        }
        if (highLimit >= 0 && value > highLimit) {
            _logger.log(Level.WARNING, "containers.mdb.invalid_value", new Object[]{appName, value, emsg, highLimit});
            value = highLimit;
        }
        return value;
    }

    private boolean containerStartsTx(Method method) {
        int txMode = this.getTxAttr(method, "Bean");
        return this.isEjbTimeoutMethod(method) ? txMode == 5 || txMode == 3 : txMode == 3;
    }

    public String getMonitorAttributeValues() {
        StringBuffer sbuf = new StringBuffer();
        sbuf.append("MESSAGEDRIVEN ");
        sbuf.append(this.appEJBName_);
        sbuf.append(this.messageBeanPool_.getAllAttrValues());
        sbuf.append("]");
        return sbuf.toString();
    }

    @Override
    public boolean userTransactionMethodsAllowed(ComponentInvocation inv) {
        boolean utMethodsAllowed = false;
        if (this.isBeanManagedTran && inv instanceof EjbInvocation) {
            EjbInvocation ejbInvocation = (EjbInvocation)inv;
            MessageBeanContextImpl mdc = (MessageBeanContextImpl)ejbInvocation.context;
            utMethodsAllowed = mdc.operationsAllowed();
        }
        return utMethodsAllowed;
    }

    public void setEJBHome(EJBHome ejbHome) throws Exception {
        throw new Exception("Can't set EJB Home on Message-driven bean");
    }

    @Override
    public EJBObjectImpl getEJBObjectImpl(byte[] instanceKey) {
        throw new EJBException("No EJBObject for message-driven beans");
    }

    @Override
    public EJBObjectImpl createEJBObjectImpl() throws CreateException {
        throw new EJBException("No EJBObject for message-driven beans");
    }

    @Override
    protected void removeBean(EJBLocalRemoteObject ejbo, Method removeMethod, boolean local) throws RemoveException, EJBException {
        throw new EJBException("not used in message-driven beans");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected boolean callEJBTimeout(RuntimeTimerState timerState, EJBTimerService timerService) throws Exception {
        boolean redeliver = false;
        try {
            Method method = this.getTimeoutMethod(timerState);
            this.beforeMessageDelivery(method, MessageDeliveryType.Timer, false, null);
            ComponentInvocation componentInvocation = this.invocationManager.getCurrentInvocation();
            if (componentInvocation instanceof EjbInvocation) {
                this.prepareEjbTimeoutParams((EjbInvocation)componentInvocation, timerState, timerService);
            }
            this.deliverMessage(null);
        }
        catch (Throwable t) {
            try {
                redeliver = true;
                _logger.log(Level.FINE, "ejbTimeout threw Runtime exception", t);
            }
            catch (Throwable throwable) {
                if (!this.isBeanManagedTran && this.transactionManager.getStatus() == 1) {
                    redeliver = true;
                    _logger.log(Level.FINE, "ejbTimeout called setRollbackOnly");
                }
                if (!redeliver) {
                    boolean successfulPostEjbTimeout = this.postEjbTimeout(timerState, timerService);
                    redeliver = !successfulPostEjbTimeout;
                }
                boolean successfulAfterMessageDelivery = this.afterMessageDeliveryInternal(null);
                if (!redeliver && !successfulAfterMessageDelivery) {
                    redeliver = true;
                }
                throw throwable;
            }
            if (!this.isBeanManagedTran && this.transactionManager.getStatus() == 1) {
                redeliver = true;
                _logger.log(Level.FINE, "ejbTimeout called setRollbackOnly");
            }
            if (!redeliver) {
                boolean successfulPostEjbTimeout = this.postEjbTimeout(timerState, timerService);
                redeliver = !successfulPostEjbTimeout;
            }
            boolean successfulAfterMessageDelivery = this.afterMessageDeliveryInternal(null);
            if (!redeliver && !successfulAfterMessageDelivery) {
                redeliver = true;
            }
        }
        if (!this.isBeanManagedTran && this.transactionManager.getStatus() == 1) {
            redeliver = true;
            _logger.log(Level.FINE, "ejbTimeout called setRollbackOnly");
        }
        if (!redeliver) {
            boolean successfulPostEjbTimeout = this.postEjbTimeout(timerState, timerService);
            redeliver = !successfulPostEjbTimeout;
        }
        boolean successfulAfterMessageDelivery = this.afterMessageDeliveryInternal(null);
        if (!redeliver && !successfulAfterMessageDelivery) {
            redeliver = true;
        }
        return redeliver;
    }

    @Override
    protected void forceDestroyBean(EJBContextImpl sc) {
        MessageBeanContextImpl mbc = (MessageBeanContextImpl)sc;
        if (mbc.isInState(EJBContextImpl.BeanState.DESTROYED)) {
            return;
        }
        mbc.setState(EJBContextImpl.BeanState.DESTROYED);
        this.messageBeanPool_.destroyObject(sc);
    }

    @Override
    public void preInvoke(EjbInvocation inv) {
        throw new EJBException("preInvoke(Invocation) not supported");
    }

    @Override
    protected ComponentContext _getContext(EjbInvocation inv) {
        MessageBeanContextImpl context = null;
        try {
            context = (MessageBeanContextImpl)this.messageBeanPool_.getObject(null);
            context.setState(EJBContextImpl.BeanState.INVOKING);
        }
        catch (Exception e) {
            throw new EJBException(e);
        }
        return context;
    }

    @Override
    public void releaseContext(EjbInvocation inv) {
        MessageBeanContextImpl beanContext = (MessageBeanContextImpl)inv.context;
        if (beanContext.isInState(EJBContextImpl.BeanState.DESTROYED)) {
            return;
        }
        beanContext.setState(EJBContextImpl.BeanState.POOLED);
        beanContext.setTransaction(null);
        beanContext.touch();
        this.messageBeanPool_.returnObject(beanContext);
    }

    @Override
    public void postInvoke(EjbInvocation inv) {
        throw new EJBException("postInvoke(Invocation) not supported in message-driven bean container");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MessageBeanListener createMessageBeanListener(ResourceHandle resource) throws ResourcesExceededException {
        boolean resourcesExceeded = false;
        MessageBeanContainer messageBeanContainer = this;
        synchronized (messageBeanContainer) {
            if (this.numMessageBeanListeners_ < this.maxMessageBeanListeners_) {
                ++this.numMessageBeanListeners_;
            } else {
                resourcesExceeded = true;
            }
        }
        if (resourcesExceeded) {
            ResourcesExceededException ree = new ResourcesExceededException("Message Bean Resources exceeded for message bean " + this.appEJBName_);
            _logger.log(Level.FINE, "exceeded max of " + this.maxMessageBeanListeners_, (Throwable)ree);
            throw ree;
        }
        return new MessageBeanListenerImpl(this, resource);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroyMessageBeanListener(MessageBeanListener listener) {
        MessageBeanContainer messageBeanContainer = this;
        synchronized (messageBeanContainer) {
            --this.numMessageBeanListeners_;
        }
    }

    public boolean isDeliveryTransacted(Method method) {
        return this.containerStartsTx(method);
    }

    public BeanPoolDescriptor getPoolDescriptor() {
        return this.beanPoolDesc_;
    }

    public Object createMessageBeanProxy(InvocationHandler handler) throws Exception {
        if (MessageBeanContainer.isModernMessageListener(this.messageListenerType_)) {
            Proxy proxy = (Proxy)Proxy.newProxyInstance(this.loader, new Class[]{this.messageBeanInterface_}, handler);
            OptionalLocalInterfaceProvider provider = (OptionalLocalInterfaceProvider)this.messageBeanSubClass_.newInstance();
            provider.setOptionalLocalIntfProxy(proxy);
            return provider;
        }
        return Proxy.newProxyInstance(this.loader, new Class[]{this.messageListenerType_, MessageEndpoint.class}, handler);
    }

    private static boolean isModernMessageListener(Class<?> messageListenerType) {
        return messageListenerType.getMethods().length == 0;
    }

    @Override
    protected EJBContextImpl _constructEJBContextImpl(Object instance) {
        return new MessageBeanContextImpl(instance, this);
    }

    private MessageBeanContextImpl createMessageDrivenEJB() throws CreateException {
        MessageBeanContextImpl context;
        EjbInvocation inv;
        block9: {
            inv = null;
            context = null;
            ClassLoader originalClassLoader = null;
            boolean methodCalled = false;
            boolean methodCallFailed = false;
            try {
                originalClassLoader = Utility.setContextClassLoader((ClassLoader)this.getClassLoader());
                context = (MessageBeanContextImpl)this.createEjbInstanceAndContext();
                Object ejb = context.getEJB();
                inv = this.createEjbInvocation(ejb, context);
                inv.isMessageDriven = true;
                this.invocationManager.preInvoke((ComponentInvocation)inv);
                if (ejb instanceof MessageDrivenBean) {
                    ((MessageDrivenBean)ejb).setMessageDrivenContext(context);
                }
                this.injectEjbInstance(context);
                context.setContextCalled();
                this.intercept(LifecycleCallbackDescriptor.CallbackType.POST_CONSTRUCT, context);
                this.ejbProbeNotifier.ejbBeanCreatedEvent(this.getContainerId(), this.containerInfo.appName, this.containerInfo.modName, this.containerInfo.ejbName);
                context.setState(EJBContextImpl.BeanState.POOLED);
                if (originalClassLoader == null) break block9;
            }
            catch (Throwable t) {
                try {
                    _logger.log(Level.SEVERE, "containers.mdb.ejb_creation_exception", new Object[]{this.appEJBName_, t.toString()});
                    if (t instanceof InvocationTargetException) {
                        _logger.log(Level.SEVERE, t.getClass().getName(), t.getCause());
                    }
                    _logger.log(Level.SEVERE, t.getClass().getName(), t);
                    CreateException ce = new CreateException("Could not create Message-Driven EJB");
                    ce.initCause(t);
                    throw ce;
                }
                catch (Throwable throwable) {
                    if (originalClassLoader != null) {
                        Utility.setContextClassLoader((ClassLoader)originalClassLoader);
                    }
                    if (inv != null) {
                        this.invocationManager.postInvoke(inv);
                    }
                    throw throwable;
                }
            }
            Utility.setContextClassLoader((ClassLoader)originalClassLoader);
        }
        if (inv != null) {
            this.invocationManager.postInvoke((ComponentInvocation)inv);
        }
        return context;
    }

    private void registerMessageBeanResource(ResourceHandle resourceHandle) throws Exception {
        if (resourceHandle != null) {
            this.poolMgr.registerResource(resourceHandle);
        }
    }

    private void unregisterMessageBeanResource(ResourceHandle resourceHandle) {
        if (resourceHandle != null) {
            this.poolMgr.unregisterResource(resourceHandle, 0x4000000);
        }
    }

    @Override
    protected void afterBegin(EJBContextImpl context) {
    }

    @Override
    protected void beforeCompletion(EJBContextImpl context) {
    }

    @Override
    protected void afterCompletion(EJBContextImpl ctx, int status) {
    }

    @Override
    public boolean passivateEJB(ComponentContext context) {
        return false;
    }

    public void activateEJB(Object ctx, Object instanceKey) {
    }

    @Override
    public void startApplication(boolean deploy) {
        super.startApplication(deploy);
        try {
            this.messageBeanClient_.start();
        }
        catch (Exception e) {
            _logger.log(Level.FINE, e.getClass().getName(), e);
            throw new RuntimeException("MessageBeanContainer.start failure for app " + this.appEJBName_, e);
        }
    }

    private ComponentInvocation createComponentInvocation() {
        EjbBundleDescriptorImpl ejbBundleDesc = this.getEjbDescriptor().getEjbBundleDescriptor();
        ComponentInvocation newInv = new ComponentInvocation(this.getComponentId(), ComponentInvocation.ComponentInvocationType.SERVLET_INVOCATION, (Object)this, ejbBundleDesc.getApplication().getAppName(), ejbBundleDesc.getModuleName());
        return newInv;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cleanupResources() {
        block16: {
            ComponentInvocation componentInvocation = this.createComponentInvocation();
            ASyncClientShutdownTask task = new ASyncClientShutdownTask(this.appEJBName_, this.messageBeanClient_, this.loader, this.messageBeanPool_, componentInvocation);
            long timeout = 0L;
            try {
                ConnectorRuntime cr = (ConnectorRuntime)this.ejbContainerUtilImpl.getServices().getService(ConnectorRuntime.class, new Annotation[0]);
                timeout = cr.getShutdownTimeout();
            }
            catch (Throwable th) {
                _logger.log(Level.WARNING, "[MDBContainer] Got exception while trying  to get shutdown timeout", th);
            }
            try {
                boolean addedAsyncTask = false;
                if (timeout > 0L) {
                    try {
                        this.ejbContainerUtilImpl.addWork(task);
                        addedAsyncTask = true;
                    }
                    catch (Throwable th) {
                        addedAsyncTask = false;
                        _logger.log(Level.WARNING, "[MDBContainer] Got exception while trying to add task to ContainerWorkPool. Will execute cleanupResources on current thread", th);
                    }
                }
                if (addedAsyncTask) {
                    ASyncClientShutdownTask aSyncClientShutdownTask = task;
                    synchronized (aSyncClientShutdownTask) {
                        if (!task.isDone()) {
                            long timeTillTimeout;
                            _logger.log(Level.FINE, "[MDBContainer] Going to wait for a maximum of " + timeout + " mili-seconds.");
                            long maxWaitTime = System.currentTimeMillis() + timeout;
                            while ((timeTillTimeout = maxWaitTime - System.currentTimeMillis()) > 0L) {
                                task.wait(timeTillTimeout);
                                if (!task.isDone()) continue;
                            }
                        }
                        if (!task.isDone()) {
                            _logger.log(Level.WARNING, "[MDBContainer] ASync task has not finished. Giving up after " + timeout + " mili-seconds.");
                        } else {
                            _logger.log(Level.FINE, "[MDBContainer] ASync task has completed");
                        }
                        break block16;
                    }
                }
                _logger.log(Level.FINE, "[MDBContainer] Attempting to do cleanup()in current thread...");
                task.run();
                _logger.log(Level.FINE, "[MDBContainer] Current thread done cleanup()... ");
            }
            catch (InterruptedException inEx) {
                _logger.log(Level.SEVERE, "containers.mdb.cleanup_exception", new Object[]{this.appEJBName_, inEx.toString()});
            }
            catch (Exception ex) {
                _logger.log(Level.SEVERE, "containers.mdb.cleanup_exception", new Object[]{this.appEJBName_, ex.toString()});
            }
        }
    }

    @Override
    protected void doConcreteContainerShutdown(boolean appBeingUndeployed) {
        _logger.log(Level.FINE, "containers.mdb.shutdown_cleanup_start", this.appEJBName_);
        this.monitorOn = false;
        this.cleanupResources();
        _logger.log(Level.FINE, "containers.mdb.shutdown_cleanup_end", this.appEJBName_);
    }

    public void beforeMessageDelivery(Method method, MessageDeliveryType deliveryType, boolean txImported, ResourceHandle resourceHandle) {
        if (this.containerState != 0) {
            String errorMsg = localStrings.getLocalString("containers.mdb.invocation_closed", this.appEJBName_ + ": Message-driven bean invocation closed by container", new Object[]{this.appEJBName_});
            throw new EJBException(errorMsg);
        }
        EjbInvocation invocation = this.createEjbInvocation();
        try {
            MessageBeanContextImpl context = (MessageBeanContextImpl)this.getContext(invocation);
            if (deliveryType == MessageDeliveryType.Timer) {
                invocation.isTimerCallback = true;
            }
            invocation.setOriginalContextClassLoader(Utility.setContextClassLoader((ClassLoader)this.getClassLoader()));
            invocation.isMessageDriven = true;
            invocation.method = method;
            context.setState(EJBContextImpl.BeanState.INVOKING);
            invocation.context = context;
            invocation.instance = context.getEJB();
            invocation.ejb = context.getEJB();
            invocation.container = this;
            boolean startTx = false;
            if (!txImported) {
                startTx = this.containerStartsTx(method);
            }
            invocation.setContainerStartsTx(startTx);
            this.invocationManager.preInvoke((ComponentInvocation)invocation);
            if (startTx) {
                this.registerMessageBeanResource(resourceHandle);
            }
            this.preInvokeTx(invocation);
        }
        catch (Throwable c) {
            if (this.containerState != 0) {
                _logger.log(Level.SEVERE, "containers.mdb.preinvoke_exception", new Object[]{this.appEJBName_, c.toString()});
                _logger.log(Level.SEVERE, c.getClass().getName(), c);
            }
            invocation.exception = c;
        }
    }

    public Object deliverMessage(Object[] params) throws Throwable {
        EjbInvocation invocation = null;
        boolean methodCalled = false;
        Object result = null;
        invocation = (EjbInvocation)this.invocationManager.getCurrentInvocation();
        if (invocation == null && _logger.isLoggable(Level.FINEST)) {
            if (this.containerState != 0) {
                _logger.log(Level.FINEST, "No invocation in onMessage  (container closing)");
            } else {
                _logger.log(Level.FINEST, "No invocation in onMessage : ");
            }
        }
        if (invocation != null && invocation.exception == null) {
            try {
                methodCalled = true;
                if (this.isTimedObject() && this.isEjbTimeoutMethod(invocation.method)) {
                    invocation.beanMethod = invocation.method;
                    this.intercept(invocation);
                }
                invocation.methodParams = params;
                invocation.beanMethod = invocation.ejb.getClass().getMethod(invocation.method.getName(), invocation.method.getParameterTypes());
                result = super.intercept(invocation);
            }
            catch (InvocationTargetException ite) {
                Throwable cause;
                invocation.exception = cause = ite.getCause();
                if (this.isSystemUncheckedException(cause)) {
                    EJBException ejbEx = new EJBException("message-driven bean method " + invocation.method + " system exception");
                    ejbEx.initCause(cause);
                    cause = ejbEx;
                }
                throw cause;
            }
            catch (Throwable t) {
                EJBException ejbEx = new EJBException("message-bean container dispatch error");
                ejbEx.initCause(t);
                invocation.exception = ejbEx;
                throw ejbEx;
            }
        } else {
            if (invocation == null) {
                String errorMsg = localStrings.getLocalString("containers.mdb.invocation_closed", this.appEJBName_ + ": Message-driven bean invocation closed by container", new Object[]{this.appEJBName_});
                throw new EJBException(errorMsg);
            }
            _logger.log(Level.SEVERE, "containers.mdb.invocation_exception", new Object[]{this.appEJBName_, invocation.exception.toString()});
            _logger.log(Level.SEVERE, invocation.exception.getClass().getName(), invocation.exception);
            EJBException ejbEx = new EJBException();
            ejbEx.initCause(invocation.exception);
            throw ejbEx;
        }
        return result;
    }

    public void afterMessageDelivery(ResourceHandle resourceHandle) {
        this.afterMessageDeliveryInternal(resourceHandle);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean afterMessageDeliveryInternal(ResourceHandle resourceHandle) {
        boolean success = false;
        EjbInvocation invocation = null;
        invocation = (EjbInvocation)this.invocationManager.getCurrentInvocation();
        if (invocation == null) {
            _logger.log(Level.SEVERE, "containers.mdb.no_invocation", new Object[]{this.appEJBName_, ""});
        } else {
            try {
                if (invocation.isContainerStartsTx()) {
                    this.unregisterMessageBeanResource(resourceHandle);
                }
                this.invocationManager.postInvoke((ComponentInvocation)invocation);
                this.postInvokeTx(invocation);
                success = true;
                this.ejbProbeNotifier.messageDeliveredEvent(this.getContainerId(), this.containerInfo.appName, this.containerInfo.modName, this.containerInfo.ejbName);
            }
            catch (Throwable ce) {
                _logger.log(Level.SEVERE, "containers.mdb.postinvoke_exception", new Object[]{this.appEJBName_, ce.toString()});
                _logger.log(Level.SEVERE, ce.getClass().getName(), ce);
            }
            finally {
                this.releaseContext(invocation);
            }
            Utility.setContextClassLoader((ClassLoader)invocation.getOriginalContextClassLoader());
            if (invocation.exception != null) {
                if (this.isSystemUncheckedException(invocation.exception)) {
                    success = false;
                }
                Level exLogLevel = this.isSystemUncheckedException(invocation.exception) ? Level.WARNING : Level.FINE;
                _logger.log(exLogLevel, "containers.mdb.invocation_exception", new Object[]{this.appEJBName_, invocation.exception.toString()});
                _logger.log(exLogLevel, invocation.exception.getClass().getName(), invocation.exception);
            }
        }
        return success;
    }

    public long getMessageCount() {
        return this.statMessageCount;
    }

    public static enum MessageDeliveryType {
        Message,
        Timer;

    }

    private static class ASyncClientShutdownTask
    implements Runnable {
        private boolean done = false;
        String appName;
        MessageBeanClient mdbClient;
        ClassLoader clsLoader;
        AbstractPool mdbPool;
        ComponentInvocation componentInvocation;

        ASyncClientShutdownTask(String appName, MessageBeanClient mdbClient, ClassLoader loader, AbstractPool mdbPool, ComponentInvocation componentInvocation) {
            this.appName = appName;
            this.mdbClient = mdbClient;
            this.clsLoader = loader;
            this.mdbPool = mdbPool;
            this.componentInvocation = componentInvocation;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            ClassLoader previousClassLoader = null;
            InvocationManager invocationManager = EjbContainerUtilImpl.getInstance().getInvocationManager();
            try {
                previousClassLoader = Utility.setContextClassLoader((ClassLoader)this.clsLoader);
                invocationManager.preInvoke(this.componentInvocation);
                this.mdbClient.close();
                _logger.log(Level.FINE, "[MDBContainer] ASync thread done with mdbClient.close()");
            }
            catch (Exception e) {
                _logger.log(Level.SEVERE, "containers.mdb.cleanup_exception", new Object[]{this.appName, e.toString()});
                _logger.log(Level.SEVERE, e.getClass().getName(), e);
            }
            finally {
                ASyncClientShutdownTask e = this;
                synchronized (e) {
                    this.done = true;
                    this.notifyAll();
                }
                try {
                    this.mdbPool.close();
                }
                catch (Exception ex) {
                    _logger.log(Level.FINE, "Exception while closing pool", ex);
                }
                invocationManager.postInvoke(this.componentInvocation);
                if (previousClassLoader != null) {
                    Utility.setContextClassLoader((ClassLoader)previousClassLoader);
                }
            }
        }

        public synchronized boolean isDone() {
            return this.done;
        }
    }

    private class MessageBeanContextFactory
    implements ObjectFactory {
        private MessageBeanContextFactory() {
        }

        @Override
        public Object create(Object param) {
            try {
                return MessageBeanContainer.this.createMessageDrivenEJB();
            }
            catch (CreateException ex) {
                throw new EJBException(ex);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void destroy(Object obj) {
            MessageBeanContextImpl beanContext = (MessageBeanContextImpl)obj;
            Object ejb = beanContext.getEJB();
            if (!beanContext.isInState(EJBContextImpl.BeanState.DESTROYED)) {
                EjbInvocation inv = null;
                try {
                    inv = MessageBeanContainer.this.createEjbInvocation(ejb, beanContext);
                    inv.isMessageDriven = true;
                    MessageBeanContainer.this.invocationManager.preInvoke((ComponentInvocation)inv);
                    beanContext.setInEjbRemove(true);
                    MessageBeanContainer.this.intercept(LifecycleCallbackDescriptor.CallbackType.PRE_DESTROY, beanContext);
                    MessageBeanContainer.this.cleanupInstance(beanContext);
                    MessageBeanContainer.this.ejbProbeNotifier.ejbBeanDestroyedEvent(MessageBeanContainer.this.getContainerId(), ((MessageBeanContainer)MessageBeanContainer.this).containerInfo.appName, ((MessageBeanContainer)MessageBeanContainer.this).containerInfo.modName, ((MessageBeanContainer)MessageBeanContainer.this).containerInfo.ejbName);
                }
                catch (Throwable t) {
                    _logger.log(Level.SEVERE, "containers.mdb_preinvoke_exception_indestroy", new Object[]{MessageBeanContainer.this.appEJBName_, t.toString()});
                    _logger.log(Level.SEVERE, t.getClass().getName(), t);
                }
                finally {
                    beanContext.setInEjbRemove(false);
                    if (inv != null) {
                        MessageBeanContainer.this.invocationManager.postInvoke((ComponentInvocation)inv);
                    }
                }
                beanContext.setState(EJBContextImpl.BeanState.DESTROYED);
            }
            MessageBeanContainer.this.transactionManager.componentDestroyed((ResourceHandler)beanContext);
            beanContext.setTransaction(null);
        }
    }
}

