/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver.auth;

import com.sun.messaging.jmq.auth.api.FailedLoginException;
import com.sun.messaging.jmq.auth.api.server.AccessControlContext;
import com.sun.messaging.jmq.auth.api.server.AuthenticationProtocolHandler;
import com.sun.messaging.jmq.auth.api.server.model.UserRepository;
import com.sun.messaging.jmq.auth.jaas.MQUser;
import com.sun.messaging.jmq.jmsserver.Globals;
import com.sun.messaging.jmq.jmsserver.auth.JMQAccessControlContext;
import com.sun.messaging.jmq.util.BASE64Decoder;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.util.Properties;
import javax.security.auth.Refreshable;
import javax.security.auth.Subject;
import javax.security.auth.login.LoginException;

public class JMQBasicAuthenticationHandler
implements AuthenticationProtocolHandler {
    private AccessControlContext acc = null;
    private Properties authProps;
    private Refreshable cacheData = null;
    private UserRepository repository = null;
    private boolean logout = false;

    @Override
    public String getType() {
        return "basic";
    }

    @Override
    public byte[] init(int sequence, Properties authProperties, Refreshable cacheData) throws LoginException {
        this.authProps = authProperties;
        this.cacheData = cacheData;
        return null;
    }

    @Override
    public synchronized byte[] handleResponse(byte[] authResponse, int sequence) throws LoginException {
        if (this.repository == null && this.logout) {
            throw new LoginException(Globals.getBrokerResources().getKString("B4108"));
        }
        if (this.repository != null) {
            this.repository.close();
        }
        Subject subject = null;
        this.acc = null;
        try {
            ByteArrayInputStream bis = new ByteArrayInputStream(authResponse);
            DataInputStream dis = new DataInputStream(bis);
            String username = dis.readUTF();
            BASE64Decoder decoder = new BASE64Decoder();
            String pass = dis.readUTF();
            String password = new String(decoder.decodeBuffer(pass), "UTF8");
            dis.close();
            String rep = this.authProps.getProperty("imq.authentication." + this.getType() + ".user_repository");
            if (rep == null || rep.trim().equals("")) {
                throw new LoginException(Globals.getBrokerResources().getKString("B4041", this.getType()));
            }
            String className = this.authProps.getProperty("imq.user_repository." + rep + ".class");
            if (className == null) {
                throw new LoginException(Globals.getBrokerResources().getKString("B4042", rep, this.getType()));
            }
            this.repository = (UserRepository)Class.forName(className).newInstance();
            this.repository.open(this.getType(), this.authProps, this.cacheData);
            subject = this.repository.findMatch(username, password, null, this.getMatchType());
            this.cacheData = this.repository.getCacheData();
            if (subject == null) {
                FailedLoginException ex = new FailedLoginException(Globals.getBrokerResources().getKString("B4051", username));
                ex.setUser(username);
                throw ex;
            }
            this.acc = new JMQAccessControlContext(new MQUser(username), subject, this.authProps);
            return null;
        }
        catch (ClassNotFoundException e) {
            throw new LoginException(Globals.getBrokerResources().getString("B4117", "ClassNotFoundException: " + e.getMessage()));
        }
        catch (IOException e) {
            throw new LoginException(Globals.getBrokerResources().getString("B4117", "IOException: " + e.getMessage()));
        }
        catch (InstantiationException e) {
            throw new LoginException(Globals.getBrokerResources().getString("B4117", "InstantiationException: " + e.getMessage()));
        }
        catch (IllegalAccessException e) {
            throw new LoginException(Globals.getBrokerResources().getString("B4117", "IllegalAccessException: " + e.getMessage()));
        }
        catch (ClassCastException e) {
            throw new LoginException(Globals.getBrokerResources().getString("B4117", "ClassCastException: " + e.getMessage()));
        }
    }

    @Override
    public AccessControlContext getAccessControlContext() {
        return this.acc;
    }

    @Override
    public Refreshable getCacheData() {
        return this.cacheData;
    }

    @Override
    public synchronized void logout() throws LoginException {
        this.logout = true;
        if (this.repository != null) {
            this.repository.close();
        }
    }

    public String getMatchType() {
        return this.getType();
    }
}

