/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver.service.imq;

import com.sun.messaging.jmq.jmsserver.Globals;
import com.sun.messaging.jmq.jmsserver.auth.AuthCacheData;
import com.sun.messaging.jmq.jmsserver.config.PropertyUpdateException;
import com.sun.messaging.jmq.jmsserver.net.Protocol;
import com.sun.messaging.jmq.jmsserver.service.ConnectionManager;
import com.sun.messaging.jmq.jmsserver.service.ConnectionUID;
import com.sun.messaging.jmq.jmsserver.service.Service;
import com.sun.messaging.jmq.jmsserver.service.ServiceRestriction;
import com.sun.messaging.jmq.jmsserver.service.ServiceRestrictionListener;
import com.sun.messaging.jmq.jmsserver.service.imq.IMQConnection;
import com.sun.messaging.jmq.jmsserver.util.BrokerException;
import com.sun.messaging.jmq.util.ServiceState;
import com.sun.messaging.jmq.util.log.Logger;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;

public abstract class IMQService
implements Service {
    protected static boolean DEBUG = false;
    protected ConnectionManager connectionList = Globals.getConnectionManager();
    private boolean serviceRunning = false;
    private boolean shuttingDown = false;
    private int state = 0;
    private int type = 0;
    protected Logger logger = Globals.getLogger();
    protected String name = null;
    private AuthCacheData authCacheData = new AuthCacheData();
    protected static final long DESTROY_WAIT_DEFAULT = 30000L;
    private long serviceDestroyWait = 30000L;
    HashMap serviceprops = null;
    private HashSet serviceress = new HashSet();
    private ArrayList serviceressListeners = new ArrayList();

    public IMQService(String name, int type) {
        this.name = name;
        this.type = type;
    }

    protected boolean getDEBUG() {
        return DEBUG;
    }

    protected void addServiceProp(String name, String value) {
        if (this.serviceprops == null) {
            this.serviceprops = new HashMap();
        }
        this.serviceprops.put(name, value);
    }

    public void resetCounters() {
        List cons = this.connectionList.getConnectionList(this);
        Iterator itr = cons.iterator();
        while (itr.hasNext()) {
            ((IMQConnection)itr.next()).resetCounters();
        }
    }

    @Override
    public Hashtable getDebugState() {
        Hashtable<String, Object> ht = new Hashtable<String, Object>();
        ht.put("name", this.name);
        ht.put("state", ServiceState.getString(this.state));
        ht.put("shuttingDown", String.valueOf(this.isShuttingDown()));
        if (this.serviceprops != null) {
            ht.put("props", new Hashtable(this.serviceprops));
        }
        ht.put("connections", this.connectionList.getDebugState(this));
        return ht;
    }

    public Hashtable getPoolDebugState() {
        return new Hashtable();
    }

    @Override
    public int size() {
        List list = this.connectionList.getConnectionList(this);
        return list.size();
    }

    @Override
    public List getConsumers() {
        ArrayList list = new ArrayList();
        List cons = this.connectionList.getConnectionList(this);
        Iterator itr = cons.iterator();
        while (itr.hasNext()) {
            List newList = ((IMQConnection)itr.next()).getConsumers();
            list.addAll(newList);
        }
        return list;
    }

    @Override
    public List getProducers() {
        ArrayList list = new ArrayList();
        List cons = this.connectionList.getConnectionList(this);
        Iterator itr = cons.iterator();
        while (itr.hasNext()) {
            List newList = ((IMQConnection)itr.next()).getProducers();
            list.addAll(newList);
        }
        return list;
    }

    public Protocol getProtocol() {
        return null;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public int getState() {
        return this.state;
    }

    public void setState(int state) {
        this.state = state;
    }

    @Override
    public int getServiceType() {
        return this.type;
    }

    public synchronized int getMinThreadpool() {
        return 0;
    }

    public synchronized int getMaxThreadpool() {
        return 0;
    }

    public synchronized int getActiveThreadpool() {
        return 0;
    }

    public void setPriority(int priority) {
    }

    public synchronized int[] setMinMaxThreadpool(int min, int max) {
        return null;
    }

    public void setDestroyWaitTime(long value) {
        this.serviceDestroyWait = value;
    }

    public long getDestroyWaitTime() {
        return this.serviceDestroyWait;
    }

    public void setServiceRunning(boolean value) {
        this.serviceRunning = value;
    }

    public boolean isServiceRunning() {
        return this.serviceRunning;
    }

    public void setShuttingDown(boolean value) {
        this.shuttingDown = value;
    }

    public boolean isShuttingDown() {
        return this.shuttingDown;
    }

    @Override
    public void stopNewConnections() throws IOException, IllegalStateException {
        if (this.state != 3) {
            throw new IllegalStateException(Globals.getBrokerResources().getKString("B4254"));
        }
        this.state = 8;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void startNewConnections() throws IOException {
        if (this.state != 8 && this.state != 4) {
            throw new IllegalStateException(Globals.getBrokerResources().getKString("B4255"));
        }
        IMQService iMQService = this;
        synchronized (iMQService) {
            this.setState(3);
            this.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void destroyService() {
        if (this.getState() < 6) {
            this.stopService(true);
        }
        IMQService iMQService = this;
        synchronized (iMQService) {
            this.setState(7);
            this.notifyAll();
        }
    }

    public void updateService(int port, int min, int max) throws IOException, PropertyUpdateException, BrokerException {
    }

    public AuthCacheData getAuthCacheData() {
        return this.authCacheData;
    }

    @Override
    public void removeConnection(ConnectionUID uid, int reason, String str) {
        this.connectionList.removeConnection(uid, true, reason, str);
    }

    public HashMap getServiceProperties() {
        return this.serviceprops;
    }

    public boolean isDirect() {
        return false;
    }

    public String toString() {
        return this.getName();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addServiceRestriction(ServiceRestriction sr) {
        HashSet hashSet = this.serviceress;
        synchronized (hashSet) {
            this.serviceress.add(sr);
            this.notifyServiceRestrictionChanged();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeServiceRestriction(ServiceRestriction sr) {
        HashSet hashSet = this.serviceress;
        synchronized (hashSet) {
            this.serviceress.remove(sr);
            this.notifyServiceRestrictionChanged();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ServiceRestriction[] getServiceRestrictions() {
        HashSet hashSet = this.serviceress;
        synchronized (hashSet) {
            return this.serviceress.toArray(new ServiceRestriction[this.serviceress.size()]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addServiceRestrictionListener(ServiceRestrictionListener l) {
        HashSet hashSet = this.serviceress;
        synchronized (hashSet) {
            this.serviceressListeners.add(l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeServiceRestrictionListener(ServiceRestrictionListener l) {
        HashSet hashSet = this.serviceress;
        synchronized (hashSet) {
            this.serviceressListeners.remove(l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyServiceRestrictionChanged() {
        HashSet hashSet = this.serviceress;
        synchronized (hashSet) {
            Iterator itr = this.serviceressListeners.iterator();
            ServiceRestrictionListener l = null;
            while (itr.hasNext()) {
                l = (ServiceRestrictionListener)itr.next();
                l.serviceRestrictionChanged(this);
            }
        }
    }
}

