/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.portunif;

import com.sun.messaging.portunif.EndProtocolFinder;
import com.sun.messaging.portunif.PUServiceCallback;
import java.io.IOException;
import java.net.SocketAddress;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.Properties;
import org.glassfish.grizzly.Processor;
import org.glassfish.grizzly.filterchain.Filter;
import org.glassfish.grizzly.filterchain.FilterChain;
import org.glassfish.grizzly.filterchain.FilterChainBuilder;
import org.glassfish.grizzly.filterchain.TransportFilter;
import org.glassfish.grizzly.nio.transport.TCPNIOServerConnection;
import org.glassfish.grizzly.nio.transport.TCPNIOTransport;
import org.glassfish.grizzly.nio.transport.TCPNIOTransportBuilder;
import org.glassfish.grizzly.portunif.PUFilter;
import org.glassfish.grizzly.portunif.PUProtocol;
import org.glassfish.grizzly.portunif.ProtocolFinder;
import org.glassfish.grizzly.portunif.finders.SSLProtocolFinder;
import org.glassfish.grizzly.ssl.SSLContextConfigurator;
import org.glassfish.grizzly.ssl.SSLEngineConfigurator;
import org.glassfish.grizzly.ssl.SSLFilter;

public class PUService {
    private PUFilter rootpuf = new PUFilter();
    private PUFilter sslpuf = null;
    private TCPNIOTransport puTransport = null;
    private SocketAddress bindAddr = null;
    private boolean sslClientAuthRequired = false;
    private PUProtocol endPUProtocol = null;
    private PUProtocol endPUProtocolSSL = null;
    private TCPNIOServerConnection serverConn = null;
    public static final String KEYSTORE_ALGORITHM = "ssl.KeyManagerFactory.algorithm";
    public static final String KEYSTORE_TYPE = "javax.net.ssl.keyStoreType";
    public static final String KEYSTORE_FILE = "javax.net.ssl.keyStore";
    public static final String KEYSTORE_PASSWORD = "javax.net.ssl.keyStorePassword";
    public static final String TRUSTSTORE_ALGORITHM = "ssl.TrustManagerFactory.algorithm";
    public static final String TRUSTSTORE_TYPE = "javax.net.ssl.trustStoreType";
    public static final String TRUSTSTORE_FILE = "javax.net.ssl.trustStore";
    public static final String TRUSTSTORE_PASSWORD = "javax.net.ssl.trustStorePassword";
    public static final String SECURESOCKET_PROTOCOL = "securesocket.protocol";

    public PUService() {
        FilterChainBuilder puFilterChainBuilder = FilterChainBuilder.stateless().add((Filter)new TransportFilter()).add((Filter)this.rootpuf);
        this.puTransport = TCPNIOTransportBuilder.newInstance().build();
        this.puTransport.setProcessor((Processor)puFilterChainBuilder.build());
    }

    public synchronized void bind(SocketAddress saddr, int backlog) throws IOException {
        if (this.puTransport == null) {
            throw new IOException("Illegal call: PUService not initialized");
        }
        if (this.bindAddr == null) {
            this.serverConn = this.puTransport.bind(saddr, backlog);
            this.bindAddr = saddr;
        } else if (!this.bindAddr.equals(saddr)) {
            this.puTransport.stop();
            this.serverConn = this.puTransport.bind(saddr, backlog);
            this.bindAddr = saddr;
        }
    }

    public synchronized void rebind(SocketAddress saddr, int backlog) throws IOException {
        if (this.puTransport == null) {
            throw new IOException("Illegal call: PUService not initialized");
        }
        if (!saddr.equals(this.bindAddr)) {
            this.puTransport.stop();
            this.serverConn = this.puTransport.bind(saddr, backlog);
            this.bindAddr = saddr;
        }
    }

    public synchronized SocketAddress start() throws IOException {
        if (this.puTransport == null) {
            throw new IOException("Illegal call: PUService not initialized");
        }
        this.puTransport.start();
        return this.bindAddr;
    }

    public synchronized SocketAddress getBindSocketAddress() throws IOException {
        if (this.puTransport == null) {
            throw new IOException("Illegal call: PUService not initialized");
        }
        if (this.bindAddr == null) {
            throw new IOException("PUService not bound yet");
        }
        return this.bindAddr;
    }

    public synchronized void setBacklog(int backlog) throws IOException {
        if (this.puTransport == null) {
            throw new IOException("Illegal call: PUService not initialized");
        }
        this.puTransport.setServerConnectionBackLog(backlog);
    }

    private synchronized void preRegister(PUServiceCallback cb) throws IOException {
        if (this.endPUProtocol == null) {
            this.endPUProtocol = new PUProtocol((ProtocolFinder)new EndProtocolFinder(cb), this.rootpuf.getPUFilterChainBuilder().build());
        }
        this.rootpuf.deregister(this.endPUProtocol);
    }

    private synchronized void postRegister() throws IOException {
        this.rootpuf.register(this.endPUProtocol);
    }

    private synchronized void preRegisterSSL(PUServiceCallback cb) throws IOException {
        if (this.endPUProtocolSSL == null) {
            this.endPUProtocolSSL = new PUProtocol((ProtocolFinder)new EndProtocolFinder(cb), this.sslpuf.getPUFilterChainBuilder().build());
        }
        this.sslpuf.deregister(this.endPUProtocolSSL);
    }

    private synchronized void postRegisterSSL() throws IOException {
        this.sslpuf.register(this.endPUProtocolSSL);
    }

    public synchronized void register(PUProtocol pp, PUServiceCallback cb) throws IOException {
        if (this.rootpuf == null) {
            throw new IOException("Illegal call: PUService not initialized");
        }
        this.preRegister(cb);
        try {
            this.rootpuf.register(pp);
        }
        finally {
            this.postRegister();
        }
    }

    public synchronized void deregister(PUProtocol pp) throws IOException {
        if (this.rootpuf == null) {
            throw new IOException("Illegal call: PUService not initialized");
        }
        this.rootpuf.deregister(pp);
    }

    public synchronized void registerSSL(PUProtocol pp, PUServiceCallback cb) throws IOException {
        if (this.rootpuf == null) {
            throw new IOException("Illegal call: PUService not initialized");
        }
        if (this.sslpuf == null) {
            throw new IOException("Illegal call: PUService SSL not initialized");
        }
        this.preRegisterSSL(cb);
        try {
            this.sslpuf.register(pp);
        }
        finally {
            this.postRegisterSSL();
        }
    }

    public synchronized void deregisterSSL(PUProtocol pp) throws IOException {
        if (this.rootpuf == null) {
            throw new IOException("Illegal call: PUService not initialized");
        }
        if (this.sslpuf == null) {
            throw new IOException("Illegal call: PUService SSL not initialized");
        }
        this.sslpuf.deregister(pp);
    }

    public synchronized void stop() throws IOException {
        if (this.puTransport == null) {
            throw new IOException("Illegal call: PUService not initialized");
        }
        this.puTransport.stop();
    }

    public synchronized void destroy() throws IOException {
        if (this.puTransport != null) {
            this.puTransport.stop();
            this.puTransport = null;
            this.rootpuf = null;
        }
    }

    public synchronized FilterChainBuilder getPUFilterChainBuilder() throws IOException {
        if (this.rootpuf == null) {
            throw new IOException("Illegal call: PUService not initialized");
        }
        return this.rootpuf.getPUFilterChainBuilder();
    }

    public synchronized FilterChainBuilder getSSLPUFilterChainBuilder() throws IOException {
        if (this.rootpuf == null) {
            throw new IOException("Illegal call: PUService not initialized");
        }
        if (this.sslpuf == null) {
            throw new IOException("Illegal call: PUService SSL not initialized");
        }
        return this.sslpuf.getPUFilterChainBuilder();
    }

    public synchronized boolean getSSLClientAuthRequired() {
        return this.sslClientAuthRequired;
    }

    public synchronized boolean initializeSSL(Properties props, boolean clientAuthRequired, PUServiceCallback cb, boolean poodleFixEnabled, String[] knownSSLEnabledProtocols) throws IOException {
        if (this.rootpuf == null) {
            throw new IOException("Illegal call: PUService not initialized");
        }
        if (this.sslpuf != null) {
            return false;
        }
        SSLContextConfigurator sslcf = PUService.createSSLContextConfigrattor(props);
        if (!sslcf.validateConfiguration(true)) {
            throw new IOException("Invalid SSL context configuration:" + sslcf);
        }
        SSLEngineConfigurator clientc = new SSLEngineConfigurator(sslcf.createSSLContext());
        SSLEngineConfigurator serverc = new SSLEngineConfigurator(sslcf.createSSLContext(), false, clientAuthRequired, clientAuthRequired);
        if (poodleFixEnabled) {
            PUService.applyPoodleFix(clientc, knownSSLEnabledProtocols, "PUService");
            PUService.applyPoodleFix(serverc, knownSSLEnabledProtocols, "PUService");
        }
        this.sslpuf = new PUFilter();
        FilterChain sslProtocolFilterChain = this.rootpuf.getPUFilterChainBuilder().add((Filter)new SSLFilter(serverc, clientc)).add((Filter)this.sslpuf).build();
        PUProtocol pu = new PUProtocol((ProtocolFinder)new SSLProtocolFinder(serverc), sslProtocolFilterChain);
        try {
            this.register(pu, cb);
            this.sslClientAuthRequired = clientAuthRequired;
            return true;
        }
        catch (Exception e) {
            this.sslpuf = null;
            this.sslClientAuthRequired = false;
            if (e instanceof IOException) {
                throw (IOException)e;
            }
            throw new IOException(e.toString(), e);
        }
    }

    public static SSLContextConfigurator createSSLContextConfigrattor(Properties props) {
        SSLContextConfigurator sslcf = new SSLContextConfigurator();
        sslcf.setKeyManagerFactoryAlgorithm(props.getProperty(KEYSTORE_ALGORITHM));
        sslcf.setKeyStoreType(props.getProperty(KEYSTORE_TYPE));
        sslcf.setKeyStoreFile(props.getProperty(KEYSTORE_FILE));
        sslcf.setKeyStorePass(props.getProperty(TRUSTSTORE_PASSWORD));
        sslcf.setTrustManagerFactoryAlgorithm(props.getProperty(TRUSTSTORE_ALGORITHM));
        sslcf.setTrustStoreType(props.getProperty(TRUSTSTORE_TYPE));
        sslcf.setTrustStoreFile(props.getProperty(TRUSTSTORE_FILE));
        sslcf.setTrustStorePass(props.getProperty(TRUSTSTORE_PASSWORD));
        sslcf.setSecurityProtocol(props.getProperty(SECURESOCKET_PROTOCOL));
        return sslcf;
    }

    public static void applyPoodleFix(SSLEngineConfigurator ec, String[] knownSSLEnabledProtocols, String caller) {
        Object[] protocols = ec.getEnabledProtocols();
        if (protocols == null) {
            protocols = knownSSLEnabledProtocols;
        }
        String orig = Arrays.toString(protocols);
        LinkedHashSet<Object> set = new LinkedHashSet<Object>();
        for (Object s : protocols) {
            if (((String)s).equals("SSLv3")) continue;
            set.add(s);
        }
        protocols = set.toArray(new String[set.size()]);
        System.out.println("[" + caller + "]: [" + orig + "], setEnabledProtocols:[" + Arrays.toString(protocols) + "]");
        ec.setEnabledProtocols((String[])protocols);
    }
}

