/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.docs.intent.client.ui.editor;

import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.source.ICharacterPairMatcher;

public class IntentPairMatcher
implements ICharacterPairMatcher {
    protected static final char[] BLOCKS = new char[]{'(', ')', '[', ']', '{', '}'};
    private int fAnchor = -1;
    private final CharPairs fPairs;

    public IntentPairMatcher() {
        Assert.isLegal((BLOCKS.length % 2 == 0 ? 1 : 0) != 0);
        this.fPairs = new CharPairs(BLOCKS);
    }

    public IRegion match(IDocument doc, int offset) {
        if (doc == null || offset < 0 || offset > doc.getLength()) {
            return null;
        }
        try {
            return this.performMatch(doc, offset);
        }
        catch (BadLocationException badLocationException) {
            return null;
        }
    }

    private IRegion performMatch(IDocument doc, int caretOffset) throws BadLocationException {
        int adjustedEndOffset;
        int charOffset = caretOffset - 1;
        char prevChar = doc.getChar(Math.max(charOffset, 0));
        if (!this.fPairs.contains(prevChar)) {
            return null;
        }
        boolean isForward = this.fPairs.isStartCharacter(prevChar);
        this.fAnchor = isForward ? 1 : 0;
        int searchStartPosition = isForward ? caretOffset : caretOffset - 2;
        int adjustedOffset = isForward ? charOffset : caretOffset;
        int endOffset = this.findMatchingPeer(doc, prevChar, this.fPairs.getMatching(prevChar), isForward, isForward ? doc.getLength() : -1, searchStartPosition);
        if (endOffset == -1) {
            return null;
        }
        int n = adjustedEndOffset = isForward ? endOffset + 1 : endOffset;
        if (adjustedEndOffset == adjustedOffset) {
            return null;
        }
        return new Region(Math.min(adjustedOffset, adjustedEndOffset), Math.abs(adjustedEndOffset - adjustedOffset));
    }

    private int findMatchingPeer(IDocument doc, char start, char end, boolean searchForward, int boundary, int startPos) throws BadLocationException {
        int pos = startPos;
        while (pos != boundary) {
            char c = doc.getChar(pos);
            if (doc.getChar(pos) == end) {
                return pos;
            }
            if (c == start && (pos = this.findMatchingPeer(doc, start, end, searchForward, boundary, this.simpleIncrement(pos, searchForward))) == -1) {
                return -1;
            }
            pos = this.simpleIncrement(pos, searchForward);
        }
        return -1;
    }

    public int getAnchor() {
        return this.fAnchor;
    }

    public void dispose() {
    }

    public void clear() {
        this.fAnchor = -1;
    }

    private int simpleIncrement(int pos, boolean searchForward) {
        return pos + (searchForward ? 1 : -1);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class CharPairs {
        private final char[] fPairs;
        private Set<Character> fCharsCache = null;

        public CharPairs(char[] pairs) {
            this.fPairs = pairs;
        }

        public boolean contains(char c) {
            return this.getAllCharacters().contains(Character.valueOf(c));
        }

        private Set<Character> getAllCharacters() {
            if (this.fCharsCache == null) {
                HashSet<Character> set = new HashSet<Character>();
                int i = 0;
                while (i < this.fPairs.length) {
                    set.add(Character.valueOf(this.fPairs[i]));
                    ++i;
                }
                this.fCharsCache = set;
            }
            return this.fCharsCache;
        }

        public boolean isOpeningCharacter(char c, boolean searchForward) {
            int i = 0;
            while (i < this.fPairs.length) {
                if (searchForward && this.getStartChar(i) == c) {
                    return true;
                }
                if (!searchForward && this.getEndChar(i) == c) {
                    return true;
                }
                i += 2;
            }
            return false;
        }

        public boolean isStartCharacter(char c) {
            return this.isOpeningCharacter(c, true);
        }

        public char getMatching(char c) {
            int i = 0;
            while (i < this.fPairs.length) {
                if (this.getStartChar(i) == c) {
                    return this.getEndChar(i);
                }
                if (this.getEndChar(i) == c) {
                    return this.getStartChar(i);
                }
                i += 2;
            }
            Assert.isTrue((boolean)false);
            return '\u0000';
        }

        private char getStartChar(int i) {
            return this.fPairs[i];
        }

        private char getEndChar(int i) {
            return this.fPairs[i + 1];
        }
    }
}

