/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.jaspic.tssv.util;

import com.sun.ts.tests.jaspic.tssv.util.ProviderConfigurationEntry;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Collection;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.Vector;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class ProviderConfigurationXMLFileProcessor {
    private static Collection<ProviderConfigurationEntry> providerConfigurationEntriesCollection = new Vector<ProviderConfigurationEntry>();
    private static Document document = null;
    private static File providerConfigFile = null;

    public ProviderConfigurationXMLFileProcessor(String fileName) throws Exception {
        try {
            providerConfigurationEntriesCollection.clear();
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            documentBuilder.setEntityResolver(new DTDResolver());
            if (fileName != null) {
                providerConfigFile = new File(fileName);
            }
            if (!providerConfigFile.exists()) {
                throw new Exception("Provider Config File : " + fileName + " does not exists");
            }
            FileInputStream fis = new FileInputStream(providerConfigFile);
            document = documentBuilder.parse(fis);
            Element rootElement = document.getDocumentElement();
            NodeList nodes = rootElement.getChildNodes();
            this.setProviderConfigEntryCollection(nodes);
        }
        catch (ParserConfigurationException pce) {
            throw new Exception("PaserConfigurationException :" + pce.getMessage());
        }
        catch (SAXException se) {
            throw new Exception("SAXException :" + se.getMessage());
        }
        catch (IOException ioe) {
            throw new Exception("IOException :" + ioe.getMessage());
        }
        catch (SecurityException se) {
            throw new Exception("SecurityException :" + se.getMessage());
        }
    }

    private void setProviderConfigEntryCollection(NodeList nodes) throws Exception {
        for (int i = 0; i < nodes.getLength(); ++i) {
            Node providerConfigEntryNode = nodes.item(i);
            NodeList providerConfigEntryNodeChildren = providerConfigEntryNode.getChildNodes();
            if (providerConfigEntryNode.getNodeName().equals("#text")) continue;
            ProviderConfigurationEntry pce = new ProviderConfigurationEntry(providerConfigEntryNode);
            providerConfigurationEntriesCollection.add(pce);
        }
    }

    public Collection<ProviderConfigurationEntry> getProviderConfigurationEntriesCollection() {
        return providerConfigurationEntriesCollection;
    }

    public static boolean addProviderConfigEntry(String className, Map props, String messageLayer, String appContextId, String description) {
        boolean result = false;
        Node providerConfigEntry = ProviderConfigurationXMLFileProcessor.createProviderConfigEntry(className, props, messageLayer, appContextId, description);
        boolean alreadyExists = ProviderConfigurationXMLFileProcessor.checkIfAlreadyPresent(providerConfigEntry);
        if (!alreadyExists) {
            Element rootElement = document.getDocumentElement();
            try {
                rootElement.appendChild(providerConfigEntry);
                ProviderConfigurationXMLFileProcessor.updateProviderConfigurationXMLFile();
                result = true;
            }
            catch (DOMException dome) {
                result = false;
            }
        }
        return result;
    }

    public static Node createProviderConfigEntry(String className, Map props, String messageLayer, String appContextId, String description) {
        Element providerConfigEntry = null;
        Element rootElement = document.getDocumentElement();
        providerConfigEntry = document.createElement("provider-config-entry");
        if (className != null) {
            Element providerClassEntry = document.createElement("provider-class");
            Text classNameText = document.createTextNode(className);
            providerClassEntry.appendChild(classNameText);
            providerConfigEntry.appendChild(providerClassEntry);
        }
        if (props != null) {
            Element propertiesNode = document.createElement("properties");
            Set entries = props.entrySet();
            for (Map.Entry entry : entries) {
                Element entryNode = document.createElement("entry");
                entryNode.setAttribute("key", entry.getKey().toString());
                Text keyValueText = document.createTextNode(entry.getValue().toString());
                entryNode.appendChild(keyValueText);
                propertiesNode.appendChild(entryNode);
            }
            providerConfigEntry.appendChild(propertiesNode);
        }
        if (messageLayer != null) {
            Element messageLayerEntry = document.createElement("message-layer");
            Text messageLayerText = document.createTextNode(messageLayer);
            messageLayerEntry.appendChild(messageLayerText);
            providerConfigEntry.appendChild(messageLayerEntry);
        }
        if (appContextId != null) {
            Element appContextIdEntry = document.createElement("app-context-id");
            Text appContextIdText = document.createTextNode(appContextId);
            appContextIdEntry.appendChild(appContextIdText);
            providerConfigEntry.appendChild(appContextIdEntry);
        }
        if (description != null) {
            Element regDescriptionEntry = document.createElement("reg-description");
            Text regDescriptionText = document.createTextNode(description);
            regDescriptionEntry.appendChild(regDescriptionText);
            providerConfigEntry.appendChild(regDescriptionEntry);
        }
        return providerConfigEntry;
    }

    public static boolean deleteProviderConfigEntry(String className, String messageLayer, String appContextId, String description) {
        boolean result = false;
        Node providerConfigEntry = ProviderConfigurationXMLFileProcessor.createProviderConfigEntry(className, null, messageLayer, appContextId, description);
        boolean alreadyExists = ProviderConfigurationXMLFileProcessor.checkIfAlreadyPresent(providerConfigEntry);
        Element rootElement = document.getDocumentElement();
        if (alreadyExists) {
            try {
                rootElement.removeChild(providerConfigEntry);
                ProviderConfigurationXMLFileProcessor.updateProviderConfigurationXMLFile();
                result = true;
            }
            catch (DOMException dome) {
                result = false;
            }
        }
        return result;
    }

    public static boolean checkIfAlreadyPresent(Node node) {
        Node topLevelChildNode = null;
        boolean result = false;
        Element rootElement = document.getDocumentElement();
        NodeList nodes = rootElement.getChildNodes();
        for (int i = 0; i < nodes.getLength(); ++i) {
            topLevelChildNode = nodes.item(i);
            String topLevelNodeName = topLevelChildNode.getNodeName();
            if (topLevelNodeName.equals("#text") || !topLevelNodeName.equals("provider-config-entry")) continue;
            topLevelChildNode.normalize();
            node.normalize();
            if (!ProviderConfigurationXMLFileProcessor.compareNode(topLevelChildNode, node)) continue;
            return true;
        }
        return result;
    }

    private static boolean compareNode(Node source, Node target) {
        String nodeName;
        Node childNode;
        int j;
        boolean classNameMatch = false;
        boolean propertiesMatch = true;
        boolean messageLayerMatch = false;
        boolean appContextIdMatch = false;
        boolean descriptionMatch = false;
        String className = null;
        String messageLayer = null;
        String appContextId = null;
        Map properties = null;
        String description = null;
        String targetClassName = null;
        String targetMessageLayer = null;
        String targetAppContextId = null;
        String targetDescription = null;
        NodeList topLevelChildren = source.getChildNodes();
        for (j = 0; j < topLevelChildren.getLength(); ++j) {
            childNode = topLevelChildren.item(j);
            nodeName = childNode.getNodeName();
            if (nodeName.equals("#text")) continue;
            if (nodeName.equals("provider-class")) {
                className = childNode.getFirstChild().getNodeValue().trim();
            }
            if (nodeName.equals("properties")) {
                properties = ProviderConfigurationXMLFileProcessor.getPropertiesMap(childNode);
                continue;
            }
            if (nodeName.equals("message-layer")) {
                messageLayer = childNode.getFirstChild().getNodeValue().trim();
                continue;
            }
            if (nodeName.equals("app-context-id")) {
                appContextId = childNode.getFirstChild().getNodeValue().trim();
                continue;
            }
            if (!nodeName.equals("reg-description")) continue;
            description = childNode.getFirstChild().getNodeValue().trim();
        }
        topLevelChildren = target.getChildNodes();
        for (j = 0; j < topLevelChildren.getLength(); ++j) {
            childNode = topLevelChildren.item(j);
            nodeName = childNode.getNodeName();
            if (nodeName.equals("#text")) continue;
            if (nodeName.equals("provider-class")) {
                targetClassName = childNode.getFirstChild().getNodeValue().trim();
            }
            if (nodeName.equals("properties")) continue;
            if (nodeName.equals("message-layer")) {
                targetMessageLayer = childNode.getFirstChild().getNodeValue().trim();
                continue;
            }
            if (nodeName.equals("app-context-id")) {
                targetAppContextId = childNode.getFirstChild().getNodeValue().trim();
                continue;
            }
            if (!nodeName.equals("reg-description")) continue;
            targetDescription = childNode.getFirstChild().getNodeValue().trim();
        }
        if (ProviderConfigurationXMLFileProcessor.stringCompare(className, targetClassName)) {
            classNameMatch = true;
        }
        if (ProviderConfigurationXMLFileProcessor.stringCompare(messageLayer, targetMessageLayer)) {
            messageLayerMatch = true;
        }
        if (ProviderConfigurationXMLFileProcessor.stringCompare(appContextId, targetAppContextId)) {
            appContextIdMatch = true;
        }
        if (ProviderConfigurationXMLFileProcessor.stringCompare(description, targetDescription)) {
            descriptionMatch = true;
        }
        return classNameMatch && propertiesMatch && messageLayerMatch && appContextIdMatch && descriptionMatch;
    }

    private static boolean stringCompare(String source, String target) {
        boolean result = false;
        if (source == null && target == null) {
            result = true;
        } else if (source != null && target != null && source.equals(target)) {
            result = true;
        }
        return result;
    }

    private static Map getPropertiesMap(Node node) {
        Node topLevelChildNode = null;
        String key = null;
        String value = null;
        NamedNodeMap namedNodeMap = null;
        Properties nodeProperties = new Properties();
        NodeList nodes = node.getChildNodes();
        for (int i = 0; i < nodes.getLength(); ++i) {
            topLevelChildNode = nodes.item(i);
            String topLevelNodeName = topLevelChildNode.getNodeName();
            if (topLevelNodeName.equals("#text") || !topLevelNodeName.equals("entry")) continue;
            namedNodeMap = topLevelChildNode.getAttributes();
            Node tempKeyNode = namedNodeMap.getNamedItem("key");
            key = tempKeyNode.getNodeValue();
            value = topLevelChildNode.getFirstChild().getNodeValue();
            nodeProperties.put(key, value);
        }
        return nodeProperties;
    }

    private static boolean matchProperties(Node node, Map verifyProperties) {
        Node topLevelChildNode = null;
        String key = null;
        String value = null;
        NamedNodeMap namedNodeMap = null;
        Properties nodeProperties = new Properties();
        boolean result = false;
        NodeList nodes = node.getChildNodes();
        for (int i = 0; i < nodes.getLength(); ++i) {
            topLevelChildNode = nodes.item(i);
            String topLevelNodeName = topLevelChildNode.getNodeName();
            if (topLevelNodeName.equals("#text") || !topLevelNodeName.equals("entry")) continue;
            namedNodeMap = topLevelChildNode.getAttributes();
            Node tempKeyNode = namedNodeMap.getNamedItem("key");
            key = tempKeyNode.getNodeValue();
            value = topLevelChildNode.getFirstChild().getNodeValue();
            nodeProperties.put(key, value);
        }
        if (nodeProperties.equals(verifyProperties)) {
            result = true;
        }
        return result;
    }

    private static void updateProviderConfigurationXMLFile() {
        String styleSheet = "<xsl:stylesheet     xmlns:xsl=\"http://www.w3.org/1999/XSL/Transform\"     xmlns:xalan=\"http://xml.apache.org/xslt\">  <xsl:output method=\"xml\" indent=\"yes\" xalan:indent-amount=\"4\"/>  <xsl:template match=\"* | @*\">    <xsl:copy>      <xsl:copy-of select=\"@*\"/>      <xsl:apply-templates/>    </xsl:copy>  </xsl:template></xsl:stylesheet>";
        try {
            StreamSource styleSource = new StreamSource(new ByteArrayInputStream(styleSheet.getBytes()));
            TransformerFactory tFactory = TransformerFactory.newInstance();
            Transformer transformer = tFactory.newTransformer(styleSource);
            DOMSource source = new DOMSource(document);
            String systemValue = new File(document.getDoctype().getSystemId()).getName();
            if (providerConfigFile.exists()) {
                providerConfigFile.delete();
                providerConfigFile.createNewFile();
            }
            FileOutputStream fos = new FileOutputStream(providerConfigFile);
            StreamResult result = new StreamResult(fos);
            transformer.setOutputProperty("doctype-system", systemValue);
            transformer.setOutputProperty("indent", "yes");
            transformer.setOutputProperty("method", "xml");
            transformer.transform(source, result);
            fos.close();
        }
        catch (TransformerConfigurationException tce) {
            System.out.println("\n** Transformer Factory error");
            System.out.println("   " + tce.getMessage());
            Throwable x = tce;
            if (tce.getException() != null) {
                x = tce.getException();
            }
            ((Throwable)x).printStackTrace();
        }
        catch (TransformerException te) {
            System.out.println("\n** Transformation error");
            System.out.println("   " + te.getMessage());
            Throwable x = te;
            if (te.getException() != null) {
                x = te.getException();
            }
            ((Throwable)x).printStackTrace();
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
    }

    private static void printNodes(NodeList nodes) {
        int nodeCount = 1;
        for (int i = 0; i < nodes.getLength(); ++i) {
            Node topLevelChildNode = nodes.item(i);
            String topLevelNodeName = topLevelChildNode.getNodeName();
            if (topLevelNodeName.equals("#text")) continue;
            ProviderConfigurationXMLFileProcessor.printNode(topLevelChildNode, nodeCount++);
        }
    }

    private static void printNode(Node node, int index) {
        System.out.println(" ");
        NodeList topLevelChildren = node.getChildNodes();
        for (int j = 0; j < topLevelChildren.getLength(); ++j) {
            Node childNode = topLevelChildren.item(j);
            String nodeName = childNode.getNodeName();
            if (nodeName.equals("#text")) continue;
            if (nodeName.equals("provider-class")) {
                System.out.println(index + " ) provider-class = " + ProviderConfigurationXMLFileProcessor.getText(childNode));
                continue;
            }
            if (nodeName.equals("properties")) {
                ProviderConfigurationXMLFileProcessor.printProperties(childNode);
                continue;
            }
            if (nodeName.equals("message-layer")) {
                System.out.println(index + " ) message-layer = " + ProviderConfigurationXMLFileProcessor.getText(childNode));
                continue;
            }
            if (nodeName.equals("app-context-id")) {
                System.out.println(index + " ) app-context-id = " + ProviderConfigurationXMLFileProcessor.getText(childNode));
                continue;
            }
            if (!nodeName.equals("reg-description")) continue;
            System.out.println(index + " ) reg-description = " + ProviderConfigurationXMLFileProcessor.getText(childNode));
        }
        System.out.println("-----------------");
    }

    private static void printProperties(Node node) {
        Node topLevelChildNode = null;
        String key = null;
        String value = null;
        NamedNodeMap namedNodeMap = null;
        Properties nodeProperties = new Properties();
        NodeList nodes = node.getChildNodes();
        for (int i = 0; i < nodes.getLength(); ++i) {
            topLevelChildNode = nodes.item(i);
            String topLevelNodeName = topLevelChildNode.getNodeName();
            if (topLevelNodeName.equals("#text") || !topLevelNodeName.equals("entry")) continue;
            namedNodeMap = topLevelChildNode.getAttributes();
            Node tempKeyNode = namedNodeMap.getNamedItem("key");
            key = tempKeyNode.getNodeValue();
            value = topLevelChildNode.getFirstChild().getNodeValue();
            nodeProperties.put(key, value);
        }
        if (nodeProperties != null && !nodeProperties.isEmpty()) {
            nodeProperties.list(System.out);
        } else {
            System.out.println("No Properties to list");
        }
    }

    private static String getText(Node textNode) {
        String result = "";
        NodeList nodes = textNode.getChildNodes();
        for (int i = 0; i < nodes.getLength(); ++i) {
            Node node = nodes.item(i);
            if (node.getNodeType() != 3) continue;
            result = node.getNodeValue();
            break;
        }
        if (result != null) {
            result = result.trim();
        }
        return result;
    }

    public class DTDResolver
    implements EntityResolver {
        @Override
        public InputSource resolveEntity(String publicID, String systemId) throws SAXException {
            String providerConfigurationFile = null;
            String providerConfigurationFileLocation = null;
            int indexof = 0;
            providerConfigurationFile = System.getProperty("provider.configuration.file");
            if (providerConfigurationFile != null) {
                indexof = providerConfigurationFile.indexOf("ProviderConfiguration.xml");
                if (indexof > 0) {
                    providerConfigurationFileLocation = providerConfigurationFile.substring(0, indexof);
                }
                if (systemId.contains("provider-configuration.xsd")) {
                    String schemaLocation = System.getProperty("schema.file.location");
                    return new InputSource(schemaLocation + File.separator + "provider-configuration.xsd");
                }
            }
            return null;
        }
    }
}

