/*
 * Decompiled with CFR 0.152.
 */
package ee.jakarta.tck.concurrent.spec.ManagedThreadFactory.context_servlet;

import ee.jakarta.tck.concurrent.common.RunnableTask;
import ee.jakarta.tck.concurrent.framework.TestServlet;
import ee.jakarta.tck.concurrent.framework.TestUtil;
import jakarta.enterprise.concurrent.ManagedThreadFactory;
import jakarta.servlet.annotation.WebServlet;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import javax.naming.InitialContext;
import org.testng.Assert;

@WebServlet(value={"/ContextServlet"})
public class ContextServlet
extends TestServlet {
    private static final String TEST_JNDI_EVN_ENTRY_VALUE = "hello";
    private static final String TEST_JNDI_EVN_ENTRY_JNDI_NAME = "java:comp/env/ManagedThreadFactory_test_string";
    private static final String TEST_CLASSLOADER_CLASS_NAME = ContextServlet.class.getCanonicalName();

    public void jndiClassloaderPropagationTest(HttpServletRequest req, HttpServletResponse res) throws Exception {
        InitialContext context = new InitialContext();
        ManagedThreadFactory factory = (ManagedThreadFactory)context.lookup("java:comp/DefaultManagedThreadFactory");
        CounterRunnableWithContext task = new CounterRunnableWithContext();
        Thread thread = factory.newThread((Runnable)task);
        thread.start();
        TestUtil.waitTillThreadFinish(thread);
        Assert.assertEquals((int)task.getCount(), (int)1);
    }

    public static class CounterRunnableWithContext
    extends RunnableTask {
        private volatile int count = 0;

        public int getCount() {
            return this.count;
        }

        public CounterRunnableWithContext() {
            super(ContextServlet.TEST_JNDI_EVN_ENTRY_JNDI_NAME, ContextServlet.TEST_JNDI_EVN_ENTRY_VALUE, TEST_CLASSLOADER_CLASS_NAME);
        }

        @Override
        public void run() {
            super.run();
            ++this.count;
        }
    }
}

