/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javatest.tool;

import com.sun.javatest.TemplateUtilities;
import com.sun.javatest.TestSuite;
import com.sun.javatest.WorkDirectory;
import com.sun.javatest.tool.Preferences;
import com.sun.javatest.tool.SelectedWorkDirApprover;
import com.sun.javatest.tool.TestSuiteChooser;
import com.sun.javatest.tool.UIFactory;
import com.sun.javatest.tool.WDC_FileFilter;
import com.sun.javatest.tool.WDC_FileView;
import java.awt.Component;
import java.awt.Dimension;
import java.io.File;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.swing.JFileChooser;

public class WorkDirChooser
extends JFileChooser {
    public static final int NEW = 0;
    public static final int OPEN_FOR_ANY_TESTSUITE = 1;
    public static final int OPEN_FOR_GIVEN_TESTSUITE = 2;
    private int mode;
    private TestSuite testSuite;
    private TestSuiteChooser testSuiteChooser;
    private WorkDirectory workDir;
    private boolean allowNoTemplate = false;
    private UIFactory uif;
    private SelectedWorkDirApprover swda;
    private Dimension size;
    private LinkedHashMap fileData;
    private LinkedHashMap wdData;

    public WorkDirChooser(boolean usePrefs) {
        this(WorkDirChooser.getDefaultDirFromPrefs(usePrefs));
        this.size = this.getPreferredSize();
    }

    private static File getDefaultDirFromPrefs(boolean usePrefs) {
        if (!usePrefs) {
            return new File(System.getProperty("user.dir"));
        }
        Preferences prefs = Preferences.access();
        String defaultDir = prefs.getPreference("wdct.default_wd_path");
        if (defaultDir != null) {
            return new File(defaultDir);
        }
        return new File(System.getProperty("user.dir"));
    }

    public WorkDirChooser(File initialDir) {
        super(WorkDirChooser.normalize(initialDir));
        this.setName("wdc");
        this.uif = new UIFactory(this, null);
        this.setAcceptAllFileFilterUsed(false);
        this.setFileSelectionMode(2);
        this.swda = new SelectedWorkDirApprover(this.mode, this);
        this.setFileView(new WDC_FileView(this.swda));
        this.setAcceptAllFileFilterUsed(true);
        this.setFileFilter(new WDC_FileFilter(this.uif.getI18NString("wdc.ft")));
    }

    public void setMode(int mode) {
        this.mode = mode;
        switch (mode) {
            case 0: {
                this.setApproveButtonText(this.uif.getI18NString("wdc.new.btn"));
                this.setApproveButtonMnemonic(this.uif.getI18NMnemonic("wdc.new.mne"));
                this.setApproveButtonToolTipText(this.uif.getI18NString("wdc.new.tip"));
                this.setDialogTitle(this.uif.getI18NString("wdc.new.title"));
                break;
            }
            case 1: 
            case 2: {
                this.setApproveButtonMnemonic(this.uif.getI18NMnemonic("wdc.open.mne"));
                this.setApproveButtonText(this.uif.getI18NString("wdc.open.btn"));
                this.setApproveButtonToolTipText(this.uif.getI18NString("wdc.open.tip"));
                this.setDialogTitle(this.uif.getI18NString("wdc.open.title"));
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
    }

    public void setTestSuite(TestSuite ts) {
        this.testSuite = ts;
    }

    public void setTestSuiteChooser(TestSuiteChooser tsc) {
        this.testSuiteChooser = tsc;
    }

    public WorkDirectory getSelectedWorkDirectory() {
        return this.workDir;
    }

    public void setSelectedWorkDirectory(WorkDirectory wd) {
        if (wd != null) {
            this.setSelectedFile(wd.getRoot());
        }
        this.workDir = wd;
    }

    public int showDialog(Component parent) {
        return this.showDialog(parent, this.getApproveButtonText());
    }

    @Override
    public void approveSelection() {
        File wd = this.getSelectedFile();
        this.swda.setMode(this.mode);
        this.swda.setAllowNoTemplate(this.allowNoTemplate);
        boolean b = this.mode == 0 ? this.swda.approveNewSelection(wd, this.testSuite) : this.swda.approveOpenSelection(wd, this.testSuite);
        if (b) {
            if (this.swda.isApprovedOpenSelection_dirExists()) {
                this.approveOpenSelection_dirExists(wd);
            }
            this.workDir = this.swda.getWorkDirectory();
            try {
                Preferences prefs = Preferences.access();
                String defaultDir = this.workDir.getRoot().getParentFile().getCanonicalPath();
                prefs.setPreference("wdct.default_wd_path", defaultDir);
            }
            catch (IOException iOException) {
                // empty catch block
            }
            super.approveSelection();
        }
    }

    private static File normalize(File dir) {
        for (File d = dir; d != null && !d.getName().equals(""); d = d.getParentFile()) {
            if (!WorkDirectory.isWorkDirectory(d)) continue;
            File p = d.getParentFile();
            return p != null ? p : dir;
        }
        return dir;
    }

    private void approveOpenSelection_dirExists(File dir) {
        this.setCurrentDirectory(dir);
        this.setSelectedFile(null);
        this.setSelectedFiles(null);
    }

    @Override
    public String getName(File f) {
        String baseName = super.getName(f);
        if (!this.isWorkDir(f)) {
            return baseName;
        }
        String[] info = this.getInfo(f);
        if (info != null && info[1] != null && !"".equals(info[1])) {
            return baseName + " (" + info[1] + ")";
        }
        return super.getName(f);
    }

    private boolean isWorkDir(File dir) {
        if (this.wdData == null) {
            this.wdData = new LinkedHashMap(){

                protected boolean removeEldestEntry(Map.Entry eldest) {
                    return this.size() > 500;
                }
            };
        }
        if (dir.getParent() == null || dir.getParent().startsWith("::")) {
            return false;
        }
        String key = dir.getAbsolutePath();
        Boolean value = (Boolean)this.wdData.get(key);
        if (value != null) {
            return value;
        }
        value = new Boolean(WorkDirectory.isWorkDirectory(dir));
        this.wdData.put(key, value);
        return value;
    }

    private String[] getInfo(File file) {
        String key;
        String[] value;
        if (this.fileData == null) {
            this.fileData = new LinkedHashMap(){

                protected boolean removeEldestEntry(Map.Entry eldest) {
                    return this.size() > 500;
                }
            };
        }
        if ((value = (String[])this.fileData.get(key = file.getAbsolutePath())) != null) {
            return value;
        }
        try {
            TemplateUtilities.ConfigInfo ci;
            String[] data = new String[]{"", ""};
            String path = TemplateUtilities.getTemplateFromWd(file);
            if (path != null && (ci = TemplateUtilities.getConfigInfo(new File(path))) != null) {
                data = new String[]{ci.getName(), ci.getDescription()};
            }
            this.fileData.put(key, data);
            return data;
        }
        catch (Exception e) {
            return new String[]{"", ""};
        }
    }

    public void setAllowNoTemplate(boolean allowNoTemplate) {
        this.allowNoTemplate = allowNoTemplate;
    }
}

