/*
 * Copyright (c) 2017, 2020 Oracle and/or its affiliates. All rights reserved.
 */


/*
 *  @(#)AbstUnmarImpl.test.xml	1.2 11/20/02 15:25:26 Evgueni Astigueevitch
 * Generated from : api/jakarta_xml/bind/helpers/AbstractUnmarshallerImpl/AbstUnmarImpl.test.xml
 *
 * Tests for AbstractUnmarshallerImpl class methods
 * Tests for AbstractUnmarshallerImpl class methods.
 */

package javasoft.sqe.tests.api.jakarta.xml.bind.helpers.AbstractUnmarshallerImpl;

import jakarta.xml.bind.JAXBException;
import jakarta.xml.bind.UnmarshalException;
import jakarta.xml.bind.UnmarshallerHandler;
import jakarta.xml.bind.helpers.AbstractUnmarshallerImpl;
import jakarta.xml.bind.helpers.DefaultValidationEventHandler;
import java.io.File;
import javasoft.sqe.javatest.Status;
import javasoft.sqe.javatest.lib.MultiTest;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;


public class AbstUnmarImplTests extends MultiTest {

    class Stub extends AbstractUnmarshallerImpl{
        public Stub() {
            super();
        }
        
        protected Object unmarshal(XMLReader reader, InputSource source) throws JAXBException {
            return null;
        }
        
        public UnmarshallerHandler getUnmarshallerHandler() {
            return null;
        }
        
        public Object unmarshal(Node node) throws JAXBException {
            return null;
        }
        
        public Status test() {
            return Status.passed("OKEY");
        }
    }

    /* standalone interface */
    public static void main(String argv[]) {
        AbstUnmarImplTests test = new AbstUnmarImplTests();
        test.run(argv, System.err, System.out).exit();
    }

    /**
     * Assertion testing
     * for public AbstractUnmarshallerImpl(),
     * AbstractUnmarshallerImpl(): no exception is thrown if it is invoked by the child class.
     * <br><b>Expected results</b>: no exceptions
     */
    public Status AbstUnmarImpl001() {
        Stub s = new Stub();
        return Status.passed("OK");
    }

    /**
     * Assertion testing
     * for protected UnmarshalException createUnmarshalException(org.xml.sax.SAXException e),
     * createUnmarshalException(org.xml.sax.SAXException e): creates an UnmarshalException from a SAXException.
     * <br><b>Expected results</b>: UnmarshalException object with the specified SAXException object
     */
    public Status AbstUnmarImpl002() {
        final SAXException saxException = new SAXException("Test");
        Stub s = new Stub() {
            public Status test() {
                UnmarshalException unmException = super.createUnmarshalException(saxException);
                if (unmException == null) {
                    return Status.failed("null was returned.");
                }

                if (!saxException.equals(unmException.getLinkedException())) {
                    return Status.failed("Unexpected linked exception.");
                }

                return Status.passed("OK");
            }
        };
        return s.test();
    }

    /**
     * Assertion testing
     * for public void setEventHandler(ValidationEventHandler handler) throws JAXBException,
     * setEventHandler(): sets the ValidationEventHandler.
     * <br><b>Expected results</b>: no exceptions, the current ValidationEventHandler will be set to the specified one
     */
    public Status AbstUnmarImpl003() {
        DefaultValidationEventHandler handler = new DefaultValidationEventHandler();
        Stub s = new Stub();
        try {
            s.setEventHandler(handler);
            if (!handler.equals(s.getEventHandler())) {
                return Status.failed("Wrong event handler returned.");
            }

            return Status.passed("OK");
        } catch (JAXBException e) {
            return Status.failed(e.toString());
        }
    }

    /**
     * Assertion testing
     * for protected org.xml.sax.XMLReader getXMLReader() throws JAXBException,
     * getXMLReader(): obtains a configured XMLReader.
     * <br><b>Expected results</b>: XMLReader object
     */
    public Status AbstUnmarImpl005() {
        Stub s = new Stub() {
            public Status test() {
                try {
                    XMLReader reader = super.getXMLReader();
                    if (reader == null) {
                        return Status.failed("null was returned.");
                    }

                    return Status.passed("OK");
                } catch (JAXBException e) {
                    return Status.failed(e.toString());
                }
            }
        };
        return s.test();
    }
}
