/*
 * Copyright (c) 2017, 2020 Oracle and/or its affiliates. All rights reserved.
 */

package javasoft.sqe.tests.elemdecl.name.name008.name00803.name00803;

import javasoft.sqe.javatest.Status;
import java.io.PrintWriter;
import javasoft.sqe.tests.api.jakarta.xml.bind.CTTest;

public class name00803_CTTests extends CTTest {

    /**
     * Command line starter.
     */
    public static void main(String[] args) {
        name00803_CTTests test = new name00803_CTTests();
        PrintWriter err = new PrintWriter(System.err, true);
        PrintWriter out = new PrintWriter(System.out, true);
        Status status = test.run(args, err, out);
        err.flush();
        out.flush();
        status.exit();
    }

    public Status Get001( ) {
        Root root = (Root)unmarshal("name00803_p.xml");
        String failure = "";

        if (root.getAa111A2Aa() != 0) {
            failure += "; root.getAa111A2Aa() returns " + root.getAa111A2Aa();
        }
        if (root.getAa22B3C() != 1) {
            failure += "; root.getAa22B3C() returns " + root.getAa22B3C();
        }
        if (root.getAa34() != 2) {
            failure += "; root.getAa34() returns " + root.getAa34();
        }

        if (failure.length() == 0) {
            return Status.passed("OK");
        }

        return Status.failed(failure.substring(2));
    }

    public Status Set001( ) {
        Root root = (Root)unmarshal("name00803_p.xml");
        String failure = "";

        root.setAa111A2Aa(11);
        root.setAa22B3C(22);
        root.setAa34(33);

        if (root.getAa111A2Aa() != 11) {
            failure += "; root.getAa111A2Aa() returns " + root.getAa111A2Aa();
        }
        if (root.getAa22B3C() != 22) {
            failure += "; root.getAa22B3C() returns " + root.getAa22B3C();
        }
        if (root.getAa34() != 33) {
            failure += "; root.getAa34() returns " + root.getAa34();
        }

        if (failure.length() == 0) {
            return Status.passed("OK");
        }

        return Status.failed(failure.substring(2));
    }


}

