/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.january.metadata.internal;

import java.io.Serializable;
import java.util.Arrays;
import org.eclipse.january.DatasetException;
import org.eclipse.january.MetadataException;
import org.eclipse.january.dataset.Dataset;
import org.eclipse.january.dataset.DoubleDataset;
import org.eclipse.january.dataset.IDataset;
import org.eclipse.january.dataset.ILazyDataset;
import org.eclipse.january.dataset.Random;
import org.eclipse.january.dataset.Slice;
import org.eclipse.january.metadata.AxesMetadata;
import org.eclipse.january.metadata.ErrorMetadata;
import org.eclipse.january.metadata.MetadataFactory;
import org.eclipse.january.metadata.MetadataType;
import org.junit.Assert;
import org.junit.Test;

public class AxesMetadataTest {
    @Test
    public void testAxesMetadata() throws MetadataException {
        AxesMetadata tmd;
        int i;
        AxesMetadata tmd2;
        int[] shape = new int[]{1, 1, 2, 3, 4, 1, 1};
        int r = shape.length;
        AxesMetadata amd = (AxesMetadata)MetadataFactory.createMetadata(AxesMetadata.class, (Object[])new Object[]{r});
        int i2 = 0;
        while (i2 < r) {
            DoubleDataset[] array = new DoubleDataset[i2 + 1];
            int j = 0;
            while (j < i2 + 1) {
                array[j] = Random.randn((int[])shape);
                ++j;
            }
            amd.setAxis(i2, (ILazyDataset[])array);
            ++i2;
        }
        ILazyDataset dataset = Random.lazyRand((int)3, (String)"Main", (int[])shape);
        dataset.addMetadata((MetadataType)amd);
        try {
            tmd2 = (AxesMetadata)dataset.getMetadata(AxesMetadata.class).get(0);
            Assert.assertEquals((Object)amd, (Object)tmd2);
            Assert.assertEquals((long)r, (long)tmd2.getAxes().length);
            i = 0;
            while (i < r) {
                Assert.assertEquals((long)(i + 1), (long)tmd2.getAxis(i).length);
                ++i;
            }
            Assert.assertEquals((long)r, (long)tmd2.getAxis(0)[0].getRank());
        }
        catch (Exception e) {
            Assert.fail((String)("Should not fail: " + e));
        }
        dataset.squeezeEnds();
        r = dataset.getRank();
        try {
            tmd2 = (AxesMetadata)dataset.getMetadata(AxesMetadata.class).get(0);
            Assert.assertEquals((long)r, (long)tmd2.getAxes().length);
            i = 0;
            while (i < r) {
                Assert.assertEquals((long)(i + 3), (long)tmd2.getAxis(i).length);
                ++i;
            }
            Assert.assertEquals((long)r, (long)tmd2.getAxis(0)[0].getRank());
        }
        catch (Exception e) {
            Assert.fail((String)("Should not fail: " + e));
        }
        Slice[] sliceArray = new Slice[3];
        sliceArray[0] = new Slice(Integer.valueOf(1));
        sliceArray[2] = new Slice(null, null, Integer.valueOf(2));
        Slice[] slice = sliceArray;
        ILazyDataset sliced = dataset.getSliceView(slice);
        int[] nshape = new int[]{1, 3, 2};
        Assert.assertArrayEquals((int[])nshape, (int[])sliced.getShape());
        try {
            tmd = (AxesMetadata)sliced.getMetadata(AxesMetadata.class).get(0);
            Assert.assertEquals((long)sliced.getRank(), (long)tmd.getAxes().length);
            Assert.assertEquals((long)3L, (long)tmd.getAxis(0).length);
            Assert.assertArrayEquals((int[])nshape, (int[])tmd.getAxis(0)[0].getShape());
            Assert.assertEquals((long)4L, (long)tmd.getAxis(1).length);
            Assert.assertArrayEquals((int[])nshape, (int[])tmd.getAxis(1)[0].getShape());
            Assert.assertEquals((long)5L, (long)tmd.getAxis(2).length);
            Assert.assertArrayEquals((int[])nshape, (int[])tmd.getAxis(2)[0].getShape());
        }
        catch (Exception e) {
            Assert.fail((String)("Should not fail: " + e));
        }
        nshape = new int[]{3, 2, 1, 1};
        sliced.setShape(nshape);
        try {
            tmd = (AxesMetadata)sliced.getMetadata(AxesMetadata.class).get(0);
            Assert.assertEquals((long)sliced.getRank(), (long)tmd.getAxes().length);
            Assert.assertArrayEquals((int[])nshape, (int[])tmd.getAxis(0)[0].getShape());
            Assert.assertArrayEquals(null, (Object[])tmd.getAxis(2));
        }
        catch (Exception e) {
            Assert.fail((String)("Should not fail: " + e));
        }
        nshape = new int[]{1, 1, 3, 2};
        sliced.setShape(nshape);
        try {
            tmd = (AxesMetadata)sliced.getMetadata(AxesMetadata.class).get(0);
            Assert.assertEquals((long)sliced.getRank(), (long)tmd.getAxes().length);
            Assert.assertArrayEquals((int[])nshape, (int[])tmd.getAxis(2)[0].getShape());
            Assert.assertArrayEquals(null, (Object[])tmd.getAxis(0));
        }
        catch (Exception e) {
            Assert.fail((String)("Should not fail: " + e));
        }
    }

    @Test
    public void testAxesMetadataReshape() throws MetadataException {
        int[] shape = new int[]{1, 2, 3, 1};
        int[] reshape = new int[]{1, 1, 2, 3, 1};
        int r = shape.length;
        int[] nShape = new int[r];
        AxesMetadata amd = (AxesMetadata)MetadataFactory.createMetadata(AxesMetadata.class, (Object[])new Object[]{r});
        int i = 0;
        while (i < r) {
            Arrays.fill(nShape, 1);
            nShape[i] = shape[i];
            DoubleDataset array = Random.randn((int[])nShape);
            amd.setAxis(i, new ILazyDataset[]{array});
            ++i;
        }
        ILazyDataset dataset = Random.lazyRand((int)3, (String)"Main", (int[])shape);
        dataset.addMetadata((MetadataType)amd);
        dataset.setShape(reshape);
    }

    @Test
    public void testAxesMetadataReshapeEmpty() throws Exception {
        int[] shape = new int[]{1, 2, 3, 1};
        int r = shape.length;
        ILazyDataset dataset = Random.lazyRand((int)3, (String)"Main", (int[])shape);
        AxesMetadata amd = (AxesMetadata)MetadataFactory.createMetadata(AxesMetadata.class, (Object[])new Object[]{r});
        dataset.addMetadata((MetadataType)amd);
        ILazyDataset v = dataset.getSliceView(new Slice[0]);
        v.squeezeEnds();
        Assert.assertEquals((long)2L, (long)((AxesMetadata)v.getMetadata(AxesMetadata.class).get(0)).getAxes().length);
        IDataset d = v.getSlice(new Slice[]{new Slice(Integer.valueOf(1)), null});
        Assert.assertEquals((long)2L, (long)((AxesMetadata)d.getMetadata(AxesMetadata.class).get(0)).getAxes().length);
        int[] reshape = new int[]{1, 1, 2, 3, 1};
        v.setShape(reshape);
        Assert.assertEquals((long)5L, (long)((AxesMetadata)v.getMetadata(AxesMetadata.class).get(0)).getAxes().length);
        d = v.getSlice(new Slice[]{null, null, new Slice(Integer.valueOf(1))});
        Assert.assertEquals((long)5L, (long)((AxesMetadata)d.getMetadata(AxesMetadata.class).get(0)).getAxes().length);
    }

    @Test
    public void testAxesMetadataRecursion() throws MetadataException {
        int[] shape = new int[]{1, 2, 3, 1};
        int r = shape.length;
        ILazyDataset axis = Random.lazyRand((int)3, (String)"axis", (int[])new int[]{2});
        AxesMetadata amd = (AxesMetadata)MetadataFactory.createMetadata(AxesMetadata.class, (Object[])new Object[]{1});
        amd.setAxis(0, new ILazyDataset[]{Random.lazyRand((int)3, (String)"axis2", (int[])new int[]{2})});
        axis.addMetadata((MetadataType)amd);
        amd = (AxesMetadata)MetadataFactory.createMetadata(AxesMetadata.class, (Object[])new Object[]{r});
        amd.setAxis(1, new ILazyDataset[]{axis});
        ILazyDataset dataset = Random.lazyRand((int)3, (String)"Main", (int[])shape);
        dataset.addMetadata((MetadataType)amd);
        dataset.setShape(new int[]{2, 3, 1, 1});
        ErrorMetadata emd = (ErrorMetadata)MetadataFactory.createMetadata(ErrorMetadata.class, (Object[])new Object[0]);
        ILazyDataset axisErr = Random.lazyRand((int)3, (String)"axis2_err", (int[])new int[]{2});
        emd.setError(axisErr);
        axis.addMetadata((MetadataType)emd);
        amd = (AxesMetadata)MetadataFactory.createMetadata(AxesMetadata.class, (Object[])new Object[]{1});
        amd.setAxis(0, new ILazyDataset[]{axis});
        axisErr.addMetadata((MetadataType)amd);
        axisErr.setShape(new int[]{2, 1});
        axisErr.getSliceView(new Slice[]{new Slice(Integer.valueOf(1))});
        axisErr.getTransposedView(new int[0]);
    }

    @Test
    public void testAxesMetadataTranspose() throws Exception {
        int[] shape = new int[]{1, 2, 3, 4};
        int r = shape.length;
        int[] nShape = new int[r];
        AxesMetadata amd = (AxesMetadata)MetadataFactory.createMetadata(AxesMetadata.class, (Object[])new Object[]{r});
        int i = 0;
        while (i < r) {
            Arrays.fill(nShape, 1);
            nShape[i] = shape[i];
            DoubleDataset array = Random.randn((int[])nShape);
            amd.setAxis(i, new ILazyDataset[]{array});
            ++i;
        }
        DoubleDataset dataset = Random.rand((int[])shape);
        dataset.addMetadata((MetadataType)amd);
        int[] nArray = new int[4];
        nArray[0] = 3;
        nArray[1] = 1;
        nArray[2] = 2;
        int[] map = nArray;
        Dataset t = dataset.getTransposedView(map);
        Assert.assertArrayEquals((int[])new int[]{4, 2, 3, 1}, (int[])t.getShape());
        amd = (AxesMetadata)t.getMetadata(AxesMetadata.class).get(0);
        int i2 = 0;
        while (i2 < r) {
            ILazyDataset a = amd.getAxis(i2)[0];
            Assert.assertEquals((long)shape[map[i2]], (long)a.getSize());
            ++i2;
        }
    }

    @Test
    public void testAxesMetadataError() throws DatasetException {
        int[] shape = new int[]{1, 2, 3, 1};
        int r = shape.length;
        ILazyDataset axis = Random.lazyRand((int)3, (String)"axis", (int[])new int[]{2});
        AxesMetadata amd = (AxesMetadata)MetadataFactory.createMetadata(AxesMetadata.class, (Object[])new Object[]{1});
        amd.setAxis(0, new ILazyDataset[]{Random.lazyRand((int)3, (String)"axis2", (int[])new int[]{2})});
        axis.addMetadata((MetadataType)amd);
        amd = (AxesMetadata)MetadataFactory.createMetadata(AxesMetadata.class, (Object[])new Object[]{r});
        amd.setAxis(1, new ILazyDataset[]{axis});
        ILazyDataset dataset = Random.lazyRand((int)3, (String)"Main", (int[])shape);
        dataset.addMetadata((MetadataType)amd);
        ILazyDataset datasetErr = Random.lazyRand((int)3, (String)"dataset_err", (int[])new int[]{1, 2, 1, 1});
        dataset.setErrors((Serializable)datasetErr);
        dataset.setShape(new int[]{2, 3, 1, 1});
        ILazyDataset axisErr = Random.lazyRand((int)3, (String)"axis2_err", (int[])new int[]{2});
        amd = (AxesMetadata)MetadataFactory.createMetadata(AxesMetadata.class, (Object[])new Object[]{1});
        amd.setAxis(0, new ILazyDataset[]{axis});
        axisErr.addMetadata((MetadataType)amd);
        axis.setErrors((Serializable)axisErr);
        ILazyDataset d = dataset.getSliceView(new Slice[0]);
        d.squeezeEnds();
        IDataset slice = d.getSlice(new Slice[0]);
        Assert.assertTrue((slice != null ? 1 : 0) != 0);
    }

    @Test
    public void testSliceFromView() throws DatasetException {
        int[] shape = new int[]{3, 10, 11};
        int[] ashape = new int[]{3};
        ILazyDataset dataset = Random.lazyRand((int)3, (String)"Main", (int[])shape);
        ILazyDataset ax = Random.lazyRand((int)3, (String)"Axis", (int[])ashape);
        AxesMetadata amd = (AxesMetadata)MetadataFactory.createMetadata(AxesMetadata.class, (Object[])new Object[]{shape.length});
        amd.setAxis(0, new ILazyDataset[]{ax});
        dataset.setMetadata((MetadataType)amd);
        ILazyDataset view = dataset.getSliceView(new Slice[]{new Slice(Integer.valueOf(1), Integer.valueOf(2)), null, null});
        IDataset slice = view.getSlice(new Slice[0]);
        Assert.assertTrue((slice != null ? 1 : 0) != 0);
    }
}

