/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.january.dataset;

import org.eclipse.january.dataset.IOperation;

public interface UnaryOperation
extends IOperation {
    public boolean booleanOperate(long var1);

    public long longOperate(long var1);

    public double doubleOperate(double var1);

    public void complexOperate(double[] var1, double var2, double var4);

    public String toString(String var1);

    public static class Stub
    implements UnaryOperation {
        double[] z = new double[2];

        @Override
        public double doubleOperate(double a) {
            this.complexOperate(this.z, a, 0.0);
            return this.z[0];
        }

        @Override
        public boolean booleanOperate(long a) {
            return this.doubleOperate(a) != 0.0;
        }

        private static long toLong(double d) {
            if (Double.isInfinite(d) || Double.isNaN(d)) {
                return 0L;
            }
            return (long)d;
        }

        @Override
        public long longOperate(long a) {
            return Stub.toLong(this.doubleOperate(a));
        }

        @Override
        public void complexOperate(double[] out, double ra, double ia) {
        }

        @Override
        public String toString(String a) {
            return null;
        }
    }
}

