/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.january.form;

import java.util.Stack;
import org.eclipse.january.form.AbstractTreeCompositeIterator;
import org.eclipse.january.form.TreeComposite;

public class PostOrderTreeCompositeIterator
extends AbstractTreeCompositeIterator {
    private final Stack<TreeComposite> stack = new Stack();
    private TreeComposite lastNodeVisited = null;

    public PostOrderTreeCompositeIterator(TreeComposite root) {
        super(root != null ? root : new TreeComposite());
        if (root == null) {
            throw new IllegalArgumentException("PostOrderTreeCompositeIterator error: Root cannot be null.");
        }
        this.stack.push(root);
    }

    @Override
    public boolean hasNext() {
        return !this.stack.isEmpty();
    }

    @Override
    public TreeComposite next() {
        TreeComposite next = super.next();
        TreeComposite node = this.stack.peek();
        if (this.lastNodeVisited == node.getChildAtIndex(node.getNumberOfChildren() - 1)) {
            this.lastNodeVisited = next = this.stack.pop();
        } else {
            node = this.lastNodeVisited != null ? this.lastNodeVisited.getNextSibling() : this.stack.pop();
            while (node.getNumberOfChildren() > 0) {
                this.stack.push(node);
                node = node.getChildAtIndex(0);
            }
            this.lastNodeVisited = next = node;
        }
        return next;
    }
}

