/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.january.form;

import java.util.ArrayList;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAnyElement;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementRef;
import javax.xml.bind.annotation.XmlElementRefs;
import javax.xml.bind.annotation.XmlElementWrapper;
import javax.xml.bind.annotation.XmlElements;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import org.eclipse.january.form.AdaptiveTreeComposite;
import org.eclipse.january.form.Component;
import org.eclipse.january.form.Composite;
import org.eclipse.january.form.DataComponent;
import org.eclipse.january.form.GeometryComponent;
import org.eclipse.january.form.ICEObject;
import org.eclipse.january.form.IComponentVisitor;
import org.eclipse.january.form.IEntry;
import org.eclipse.january.form.IReactorComponent;
import org.eclipse.january.form.IUpdateableListener;
import org.eclipse.january.form.ListComponent;
import org.eclipse.january.form.MasterDetailsComponent;
import org.eclipse.january.form.MatrixComponent;
import org.eclipse.january.form.MeshComponent;
import org.eclipse.january.form.ResourceComponent;
import org.eclipse.january.form.TableComponent;
import org.eclipse.january.form.TimeDataComponent;
import org.eclipse.january.form.emf.EMFComponent;

@XmlRootElement(name="TreeComposite")
@XmlAccessorType(value=XmlAccessType.FIELD)
public class TreeComposite
extends ICEObject
implements Composite,
IComponentVisitor {
    @XmlTransient
    protected TreeComposite previousSibling = null;
    @XmlTransient
    protected TreeComposite nextSibling = null;
    @XmlElementWrapper(name="Children")
    @XmlElements(value={@XmlElement(name="TreeComposite", type=TreeComposite.class), @XmlElement(name="AdaptiveTreeComposite", type=AdaptiveTreeComposite.class)})
    protected ArrayList<TreeComposite> children = new ArrayList();
    @XmlTransient
    private int currentChildIndex = 0;
    @XmlAnyElement
    @XmlElementRefs(value={@XmlElementRef(name="ResourceComponent", type=ResourceComponent.class), @XmlElementRef(name="TableComponent", type=TableComponent.class), @XmlElementRef(name="MatrixComponent", type=MatrixComponent.class), @XmlElementRef(name="GeometryComponent", type=GeometryComponent.class), @XmlElementRef(name="MasterDetailsComponent", type=MasterDetailsComponent.class), @XmlElementRef(name="DataComponent", type=DataComponent.class)})
    private ArrayList<Component> dataNodes = new ArrayList();
    @XmlTransient
    protected TreeComposite parent = null;
    @XmlTransient
    private Component activeDataNode = null;
    @XmlAttribute
    private boolean allowActiveDataNodes = true;
    @XmlElement(name="exemplar")
    protected ArrayList<TreeComposite> childExemplars;
    @XmlAttribute
    private boolean active = false;

    public TreeComposite() {
        this.listeners = new ArrayList();
        this.childExemplars = new ArrayList();
    }

    public void setParent(TreeComposite pNode) {
        if (pNode != null) {
            if (this.parent != null) {
                this.parent.removeChild(this);
            }
            this.nextSibling = null;
            this.previousSibling = null;
            this.parent = pNode;
            pNode.setNextChild(this);
            this.notifyListeners();
        }
    }

    public TreeComposite getParent() {
        return this.parent;
    }

    public TreeComposite getNextChild() {
        TreeComposite currentChild = null;
        if (this.currentChildIndex < this.children.size()) {
            currentChild = this.children.get(this.currentChildIndex);
            ++this.currentChildIndex;
        }
        return currentChild;
    }

    protected boolean checkExemplars(TreeComposite cNode) {
        boolean canAdd = true;
        if (this.hasChildExemplars()) {
            canAdd = this.childExemplars.contains(cNode);
        }
        return canAdd;
    }

    public void setNextChild(TreeComposite cNode) {
        TreeComposite lastChild = null;
        if (cNode != null && !this.children.contains(cNode) && cNode != this && this.checkExemplars(cNode)) {
            if (!this.children.isEmpty()) {
                lastChild = this.children.get(this.children.size() - 1);
                lastChild.nextSibling = cNode;
                cNode.previousSibling = lastChild;
            }
            this.children.add(cNode);
            cNode.parent = this;
            for (IUpdateableListener listener : this.listeners) {
                cNode.register(listener);
            }
            this.notifyListeners();
        }
    }

    public TreeComposite getPreviousChild() {
        TreeComposite currentChild = null;
        if (this.currentChildIndex > 0) {
            --this.currentChildIndex;
            currentChild = this.children.get(this.currentChildIndex);
        }
        return currentChild;
    }

    public void removeChild(TreeComposite cNode) {
        if (cNode != null && this.children.contains(cNode)) {
            if (cNode.previousSibling != null) {
                cNode.previousSibling.nextSibling = cNode.nextSibling;
            }
            if (cNode.nextSibling != null) {
                cNode.nextSibling.previousSibling = cNode.previousSibling;
            }
            int i = this.children.indexOf(cNode);
            this.children.remove(cNode);
            cNode.parent = null;
            if (this.currentChildIndex > i) {
                --this.currentChildIndex;
            }
            for (IUpdateableListener listener : this.listeners) {
                cNode.unregister(listener);
            }
            this.notifyListeners();
        }
    }

    public int getNumberOfChildren() {
        return this.children.size();
    }

    public void resetChildIterator() {
        this.currentChildIndex = 0;
    }

    public TreeComposite getChildAtIndex(int index) {
        if (index > -1 && index < this.children.size()) {
            return this.children.get(index);
        }
        return null;
    }

    public TreeComposite getNextSibling() {
        return this.nextSibling;
    }

    public TreeComposite getPreviousSibling() {
        return this.previousSibling;
    }

    public ArrayList<Component> getDataNodes() {
        return this.dataNodes;
    }

    public int getNumberOfDataNodes() {
        return this.dataNodes.size();
    }

    public Component getActiveDataNode() {
        if (this.allowActiveDataNodes) {
            return this.activeDataNode;
        }
        return null;
    }

    public void setActiveDataNode(Component node) {
        if (this.allowActiveDataNodes && node != null && this.dataNodes.contains(node)) {
            this.activeDataNode = node;
        }
        this.notifyListeners();
    }

    public void allowActiveDataNodes(boolean allow) {
        this.allowActiveDataNodes = allow;
        this.notifyListeners();
    }

    @Override
    public boolean equals(Object otherTreeComposite) {
        boolean equalVal = false;
        TreeComposite tree = null;
        if (otherTreeComposite != null && otherTreeComposite instanceof TreeComposite) {
            if (this == otherTreeComposite) {
                equalVal = true;
            } else {
                tree = (TreeComposite)otherTreeComposite;
                equalVal = this.uniqueId == tree.uniqueId && this.objectName.equals(tree.objectName) && this.objectDescription.equals(tree.objectDescription) && this.children.equals(tree.children) && this.dataNodes.equals(tree.dataNodes) && (this.activeDataNode != null ? this.activeDataNode.equals(tree.activeDataNode) : tree.activeDataNode == null) && this.allowActiveDataNodes == tree.allowActiveDataNodes && this.currentChildIndex == tree.currentChildIndex && this.childExemplars.equals(tree.childExemplars);
            }
        }
        return equalVal;
    }

    @Override
    public int hashCode() {
        int hash = 8;
        hash = 31 * super.hashCode();
        hash = 31 * hash + this.children.hashCode();
        hash = 31 * hash + this.dataNodes.hashCode();
        hash = 31 * hash + (this.activeDataNode != null ? this.activeDataNode.hashCode() : 0);
        hash = 31 * hash + (this.allowActiveDataNodes ? 1 : 0);
        hash = 31 * hash + this.currentChildIndex;
        hash = 31 * hash + this.childExemplars.hashCode();
        return hash;
    }

    public void copy(TreeComposite otherTreeComposite) {
        this.copy(otherTreeComposite, false);
    }

    public void copy(TreeComposite otherTreeComposite, boolean copyInPlace) {
        if (otherTreeComposite == null) {
            return;
        }
        ArrayList listenersCopy = new ArrayList(this.listeners);
        for (IUpdateableListener listener : listenersCopy) {
            this.unregister(listener);
        }
        super.copy(otherTreeComposite);
        if (!copyInPlace) {
            this.parent = null;
            this.nextSibling = null;
            this.previousSibling = null;
        }
        this.children.clear();
        int i = 0;
        while (i < otherTreeComposite.children.size()) {
            this.children.add((TreeComposite)otherTreeComposite.children.get(i).clone());
            this.children.get(i).setParent(this);
            ++i;
        }
        int j = 0;
        while (j < otherTreeComposite.children.size() - 1) {
            this.children.get((int)j).nextSibling = this.children.get(j + 1);
            ++j;
        }
        j = otherTreeComposite.children.size() - 1;
        while (j > 0) {
            this.children.get((int)j).previousSibling = this.children.get(j - 1);
            --j;
        }
        this.currentChildIndex = otherTreeComposite.currentChildIndex;
        this.dataNodes.clear();
        this.activeDataNode = null;
        this.allowActiveDataNodes = otherTreeComposite.allowActiveDataNodes;
        i = 0;
        while (i < otherTreeComposite.dataNodes.size()) {
            Component dataNode = otherTreeComposite.dataNodes.get(i);
            Component clone = (Component)((ICEObject)((Object)dataNode)).clone();
            this.dataNodes.add(clone);
            if (dataNode == otherTreeComposite.activeDataNode) {
                this.activeDataNode = clone;
            }
            ++i;
        }
        this.active = otherTreeComposite.active;
        this.childExemplars.clear();
        i = 0;
        while (i < otherTreeComposite.childExemplars.size()) {
            this.childExemplars.add((TreeComposite)otherTreeComposite.childExemplars.get(i).clone());
            ++i;
        }
        for (IUpdateableListener listener : listenersCopy) {
            this.register(listener);
        }
        this.notifyListeners();
    }

    @Override
    public Object clone() {
        TreeComposite treeComposite = new TreeComposite();
        treeComposite.copy(this);
        return treeComposite;
    }

    public void setChildExemplars(ArrayList<TreeComposite> exemplars) {
        if (exemplars != null) {
            this.childExemplars = (ArrayList)exemplars.clone();
        }
    }

    public void addChildExemplar(TreeComposite exemplar) {
        if (exemplar != null) {
            int i = 0;
            while (i < this.childExemplars.size()) {
                TreeComposite currExemplar = this.childExemplars.get(i);
                if (currExemplar.getName().equals(exemplar.getName())) {
                    this.childExemplars.remove(i);
                    break;
                }
                ++i;
            }
            TreeComposite cloneExemplar = (TreeComposite)exemplar.clone();
            this.childExemplars.add(cloneExemplar);
        }
    }

    public ArrayList<TreeComposite> getChildExemplars() {
        return (ArrayList)this.childExemplars.clone();
    }

    public boolean hasChildExemplars() {
        return !this.childExemplars.isEmpty();
    }

    public boolean isActive() {
        return this.active;
    }

    public void setActive(boolean flag) {
        this.active = flag;
        this.notifyListeners();
    }

    private void addDataNodeToList(Component comp) {
        this.dataNodes.add(comp);
        for (IUpdateableListener listener : this.listeners) {
            comp.register(listener);
        }
    }

    @Override
    public void accept(IComponentVisitor visitor) {
        if (visitor != null) {
            visitor.visit(this);
        }
    }

    @Override
    public void addComponent(Component child) {
        if (child != null) {
            child.accept(this);
            this.notifyListeners();
        }
    }

    @Override
    public void removeComponent(int childId) {
        int i = 0;
        while (i < this.dataNodes.size()) {
            Component component = this.dataNodes.get(i);
            if (component.getId() == childId) {
                this.dataNodes.remove(i);
                for (IUpdateableListener listener : this.listeners) {
                    component.unregister(listener);
                }
                this.notifyListeners();
                return;
            }
            ++i;
        }
        i = 0;
        while (i < this.children.size()) {
            TreeComposite child = this.children.get(i);
            if (child.getId() == childId) {
                this.removeChild(child);
                this.notifyListeners();
                return;
            }
            ++i;
        }
    }

    @Override
    public Component getComponent(int childId) {
        if (childId < 1) {
            return null;
        }
        for (Component component : this.dataNodes) {
            if (component.getId() != childId) continue;
            return component;
        }
        for (Component component : this.children) {
            if (component.getId() != childId) continue;
            return component;
        }
        return null;
    }

    @Override
    public int getNumberOfComponents() {
        return this.dataNodes.size() + this.children.size();
    }

    @Override
    public ArrayList<Component> getComponents() {
        ArrayList<Component> componentList = new ArrayList<Component>(this.dataNodes);
        componentList.addAll(this.children);
        return componentList;
    }

    @Override
    public void visit(DataComponent component) {
        if (component != null) {
            this.addDataNodeToList(component);
            for (IEntry entry : component.retrieveAllEntries()) {
                for (IUpdateableListener listener : this.listeners) {
                    entry.register(listener);
                }
            }
        }
    }

    @Override
    public void visit(ResourceComponent component) {
        if (component != null) {
            this.addDataNodeToList(component);
        }
    }

    @Override
    public void visit(TableComponent component) {
        if (component != null) {
            this.addDataNodeToList(component);
        }
    }

    @Override
    public void visit(MatrixComponent component) {
        if (component != null) {
            this.addDataNodeToList(component);
        }
    }

    @Override
    public void visit(GeometryComponent component) {
        if (component != null) {
            this.addDataNodeToList(component);
        }
    }

    @Override
    public void visit(MasterDetailsComponent component) {
        if (component != null) {
            this.addDataNodeToList(component);
        }
    }

    @Override
    public void visit(TreeComposite component) {
        if (component != null) {
            this.setNextChild(component);
        }
    }

    @Override
    public void visit(IReactorComponent component) {
    }

    @Override
    public void visit(TimeDataComponent component) {
        if (component != null) {
            this.addDataNodeToList(component);
        }
    }

    @Override
    public void visit(MeshComponent component) {
    }

    @Override
    public void visit(AdaptiveTreeComposite component) {
    }

    @Override
    public void register(IUpdateableListener listener) {
        if (listener != null) {
            this.listeners.add(listener);
            for (Component component : this.dataNodes) {
                component.register(listener);
            }
            for (TreeComposite child : this.children) {
                child.register(listener);
            }
        }
    }

    @Override
    public void unregister(IUpdateableListener listener) {
        if (listener != null && this.listeners.contains(listener)) {
            this.listeners.remove(listener);
            for (Component component : this.dataNodes) {
                component.unregister(listener);
            }
            for (TreeComposite child : this.children) {
                child.unregister(listener);
            }
        }
    }

    @Override
    public void visit(EMFComponent component) {
    }

    public void visit(ListComponent component) {
    }
}

