/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.january.dataset;

import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.math3.complex.Complex;
import org.eclipse.january.asserts.TestUtils;
import org.eclipse.january.dataset.ComplexDoubleDataset;
import org.eclipse.january.dataset.CompoundDataset;
import org.eclipse.january.dataset.CompoundDoubleDataset;
import org.eclipse.january.dataset.CompoundShortDataset;
import org.eclipse.january.dataset.Dataset;
import org.eclipse.january.dataset.DatasetFactory;
import org.eclipse.january.dataset.DatasetUtils;
import org.eclipse.january.dataset.DoubleDataset;
import org.eclipse.january.dataset.IDataset;
import org.eclipse.january.dataset.Maths;
import org.eclipse.january.dataset.Random;
import org.eclipse.january.dataset.Slice;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class MathsTest {
    private static final int SSTEP = 15;
    private static final int SITER = 3;
    private static final double ABSERRD = 1.0E-8;
    private static final double ABSERRF = 1.0E-5;
    private static final double RELERR = 1.0E-5;
    private static final int ISIZEA = 2;
    private static final int ISIZEB = 3;
    private static final int MAXISIZE = Math.max(2, 3);
    private Map<String, Integer> classes;

    @Before
    public void setUpClass() {
        this.classes = new LinkedHashMap<String, Integer>();
        this.classes.put("Byte", 1);
        this.classes.put("Short", 2);
        this.classes.put("Integer", 3);
        this.classes.put("Long", 4);
        this.classes.put("Float", 5);
        this.classes.put("Double", 6);
        this.classes.put("ComplexF", 7);
        this.classes.put("ComplexD", 8);
        this.classes.put("ArrayB", 100);
        this.classes.put("ArrayS", 200);
        this.classes.put("ArrayI", 300);
        this.classes.put("ArrayL", 400);
        this.classes.put("ArrayF", 500);
        this.classes.put("ArrayD", 600);
        TestUtils.setVerbosity((TestUtils.Verbosity)TestUtils.Verbosity.QUIET);
    }

    @After
    public void closeDown() {
        TestUtils.setVerbosity((TestUtils.Verbosity)TestUtils.Verbosity.QUIET);
    }

    /*
     * Unable to fully structure code
     */
    private void checkDatasets(Object a, Object b, Dataset c, Dataset d) {
        block17: {
            Assert.assertNotNull((Object)c);
            Assert.assertNotNull((Object)d);
            Assert.assertEquals((String)"Dtype does not match", (long)c.getDType(), (long)d.getDType());
            Assert.assertEquals((String)"Size does not match", (long)c.getSize(), (long)d.getSize());
            Assert.assertEquals((String)"ISize does not match", (long)c.getElementsPerItem(), (long)d.getElementsPerItem());
            Assert.assertArrayEquals((String)"Shape does not match", (int[])c.getShape(), (int[])d.getShape());
            ci = c.getIterator(true);
            di = d.getIterator();
            is = c.getElementsPerItem();
            v0 = abserr = c.getDType() == 5 || c.getDType() == 7 || c.getDType() == 500 ? 1.0E-5 : 1.0E-8;
            if (is != 1) ** GOTO lbl61
            while (ci.hasNext() && di.hasNext()) {
                av = c.getElementDoubleAbs(ci.index);
                bv = d.getElementDoubleAbs(di.index);
                tol = Math.max(abserr, Math.abs(av * 1.0E-5));
                if (Math.abs(av - bv) > tol) {
                    if (a != null) {
                        if (a instanceof Dataset) {
                            System.err.printf("A was %s ", new Object[]{((Dataset)a).getString(ci.getPos())});
                        } else {
                            System.err.printf("A was %s ", new Object[]{a});
                        }
                    }
                    if (b != null) {
                        if (b instanceof Dataset) {
                            System.err.printf("B was %s ", new Object[]{((Dataset)b).getString(ci.getPos())});
                        } else {
                            System.err.printf("B was %s ", new Object[]{b});
                        }
                    }
                    System.err.printf("at %s\n", new Object[]{Arrays.toString(ci.getPos())});
                }
                Assert.assertEquals((String)("Value does not match at " + Arrays.toString(ci.getPos()) + ", with tol " + tol + ": "), (double)av, (double)bv, (double)tol);
            }
            break block17;
lbl-1000:
            // 1 sources

            {
                j = 0;
                while (j < is) {
                    av = c.getElementDoubleAbs(ci.index + j);
                    bv = d.getElementDoubleAbs(di.index + j);
                    tol = Math.max(abserr, Math.abs(av * 1.0E-5));
                    if (Math.abs(av - bv) > tol) {
                        if (a != null) {
                            if (a instanceof Dataset) {
                                System.err.printf("A was %s ", new Object[]{((Dataset)a).getString(ci.getPos())});
                            } else {
                                System.err.printf("A was %s ", new Object[]{a});
                            }
                        }
                        if (b != null) {
                            if (b instanceof Dataset) {
                                System.err.printf("B was %s ", new Object[]{((Dataset)b).getString(ci.getPos())});
                            } else {
                                System.err.printf("B was %s ", new Object[]{b});
                            }
                        }
                        System.err.printf("at %s\n", new Object[]{Arrays.toString(ci.getPos())});
                    }
                    Assert.assertEquals((String)("Value does not match at " + Arrays.toString(ci.getPos()) + "; " + j + ", with tol " + tol + ": "), (double)av, (double)bv, (double)tol);
                    ++j;
                }
lbl61:
                // 2 sources

                ** while (ci.hasNext() && di.hasNext())
            }
        }
    }

    /*
     * Unable to fully structure code
     */
    @Test
    public void testAddition() {
        c = null;
        d = null;
        zv = new Complex(-3.5, 0.0);
        dv = zv.getReal();
        eCount = 0;
        block4: for (String dn : this.classes.keySet()) {
            dtype = this.classes.get(dn);
            Random.seed((long)12735L);
            block5: for (String en : this.classes.keySet()) {
                etype = this.classes.get(en);
                TestUtils.verbosePrintf((String)"%s to %s, ", (Object[])new Object[]{dn, en});
                n = 32;
                i = 0;
                while (i < 3) {
                    block36: {
                        block39: {
                            block43: {
                                block42: {
                                    block41: {
                                        block40: {
                                            block38: {
                                                if (dtype < 100) {
                                                    a = Random.randn((int[])new int[]{n}).imultiply((Object)100);
                                                    a = a.cast(dtype);
                                                } else {
                                                    aa = new Dataset[2];
                                                    j = 0;
                                                    while (j < 2) {
                                                        aa[j] = Random.randn((int[])new int[]{n}).imultiply((Object)100);
                                                        ++j;
                                                    }
                                                    a = DatasetUtils.cast((Dataset[])aa, (int)dtype);
                                                }
                                                if (etype < 100) {
                                                    b = Random.randn((int[])new int[]{n}).imultiply((Object)100);
                                                    b = b.cast(etype);
                                                } else {
                                                    ab = new Dataset[3];
                                                    j = 0;
                                                    while (j < 3) {
                                                        ab[j] = Random.randn((int[])new int[]{n}).imultiply((Object)100);
                                                        ++j;
                                                    }
                                                    b = DatasetUtils.cast((Dataset[])ab, (int)etype);
                                                }
                                                start = -System.nanoTime();
                                                try {
                                                    c = Maths.add((Object)a, (Object)b);
                                                }
                                                catch (IllegalArgumentException e) {
                                                    TestUtils.verbosePrintf((String)"Could not perform this operation: %s\n\n", (Object[])new Object[]{e.getMessage()});
                                                    ++eCount;
                                                    break block36;
                                                }
                                                ntime = (double)(start += System.nanoTime()) / (double)c.getSize();
                                                d = DatasetFactory.zeros((Dataset)c);
                                                start = -System.nanoTime();
                                                ita = a.getIterator();
                                                itb = b.getIterator();
                                                j = 0;
                                                if (dtype != 7 && dtype != 8 || etype != 7 && etype != 8) break block38;
                                                is = d.getElementsPerItem();
                                                while (ita.hasNext() && itb.hasNext()) {
                                                    d.setObjectAbs(j, (Object)((Complex)a.getObjectAbs(ita.index)).add((Complex)b.getObjectAbs(itb.index)));
                                                    j += is;
                                                }
                                                break block39;
                                            }
                                            if (dtype != 7 && dtype != 8 || etype == 7 || etype == 8) break block40;
                                            is = d.getElementsPerItem();
                                            while (ita.hasNext() && itb.hasNext()) {
                                                d.setObjectAbs(j, (Object)((Complex)a.getObjectAbs(ita.index)).add(new Complex(b.getElementDoubleAbs(itb.index), 0.0)));
                                                j += is;
                                            }
                                            break block39;
                                        }
                                        if (dtype == 7 || dtype == 8 || etype != 7 && etype != 8) break block41;
                                        is = d.getElementsPerItem();
                                        while (ita.hasNext() && itb.hasNext()) {
                                            d.setObjectAbs(j, (Object)new Complex(a.getElementDoubleAbs(ita.index), 0.0).add((Complex)b.getObjectAbs(itb.index)));
                                            j += is;
                                        }
                                        break block39;
                                    }
                                    if (dtype >= 100 || etype >= 100) break block42;
                                    while (ita.hasNext() && itb.hasNext()) {
                                        d.setObjectAbs(j++, (Object)(((Number)a.getObjectAbs(ita.index)).doubleValue() + ((Number)b.getObjectAbs(itb.index)).doubleValue()));
                                    }
                                    break block39;
                                }
                                answer = new double[MathsTest.MAXISIZE];
                                is = d.getElementsPerItem();
                                if (a.getElementsPerItem() >= is) break block43;
                                while (ita.hasNext() && itb.hasNext()) {
                                    da = a.getElementDoubleAbs(ita.index);
                                    k = 0;
                                    while (k < 3) {
                                        answer[k] = da + b.getElementDoubleAbs(itb.index + k);
                                        ++k;
                                    }
                                    d.setObjectAbs(j, (Object)answer);
                                    j += is;
                                }
                                break block39;
                            }
                            if (b.getElementsPerItem() >= is) ** GOTO lbl115
                            while (ita.hasNext() && itb.hasNext()) {
                                db = b.getElementDoubleAbs(itb.index);
                                k = 0;
                                while (k < 2) {
                                    answer[k] = a.getElementDoubleAbs(ita.index + k) + db;
                                    ++k;
                                }
                                d.setObjectAbs(j, (Object)answer);
                                j += is;
                            }
                            break block39;
lbl-1000:
                            // 1 sources

                            {
                                k = 0;
                                while (k < is) {
                                    answer[k] = a.getElementDoubleAbs(ita.index + k) + b.getElementDoubleAbs(itb.index + k);
                                    ++k;
                                }
                                d.setObjectAbs(j, (Object)answer);
                                j += is;
lbl115:
                                // 2 sources

                                ** while (ita.hasNext() && itb.hasNext())
                            }
                        }
                        if (d == null) continue block5;
                        otime = (double)(start += System.nanoTime()) / (double)d.getSize();
                        TestUtils.verbosePrintf((String)"Time taken by add for %s: %s; %s (%.1f%%)\n", (Object[])new Object[]{n, otime, ntime, 100.0 * (otime - ntime) / otime});
                        this.checkDatasets(a, b, c, d);
                        n *= 15;
                    }
                    ++i;
                }
            }
            Random.seed((long)12735L);
            n = 32;
            TestUtils.verbosePrintf((String)"constant to %s, ", (Object[])new Object[]{dn});
            i = 0;
            while (i < 3) {
                block37: {
                    if (dtype < 100) {
                        a = Random.randn((int[])new int[]{n});
                        a.imultiply((Object)100);
                        a = a.cast(dtype);
                    } else {
                        aa = new Dataset[2];
                        j = 0;
                        while (j < 2) {
                            aa[j] = Random.randn((int[])new int[]{n}).imultiply((Object)100);
                            ++j;
                        }
                        a = DatasetUtils.cast((Dataset[])aa, (int)dtype);
                    }
                    start = -System.nanoTime();
                    try {
                        c = Maths.add((Object)a, (Object)dv);
                    }
                    catch (IllegalArgumentException e) {
                        TestUtils.verbosePrintf((String)"Could not perform this operation: %s\n\n", (Object[])new Object[]{e.getMessage()});
                        ++eCount;
                        break block37;
                    }
                    ntime = (double)(start += System.nanoTime()) / (double)c.getSize();
                    d = DatasetFactory.zeros((Dataset)c);
                    start = -System.nanoTime();
                    ita = a.getIterator();
                    j = 0;
                    if (dtype == 7 || dtype == 8) {
                        is = d.getElementsPerItem();
                        while (ita.hasNext()) {
                            d.setObjectAbs(j, (Object)((Complex)a.getObjectAbs(ita.index)).add(zv));
                            j += is;
                        }
                    } else if (dtype < 100) {
                        while (ita.hasNext()) {
                            d.setObjectAbs(j++, (Object)(((Number)a.getObjectAbs(ita.index)).doubleValue() + dv));
                        }
                    } else {
                        answer = new double[2];
                        while (ita.hasNext()) {
                            k = 0;
                            while (k < 2) {
                                answer[k] = a.getElementDoubleAbs(ita.index + k) + dv;
                                ++k;
                            }
                            d.setObjectAbs(j, (Object)answer);
                            j += 2;
                        }
                    }
                    if (d == null) continue block4;
                    otime = (double)(start += System.nanoTime()) / (double)d.getSize();
                    TestUtils.verbosePrintf((String)"Time taken by add for %s: %s; %s (%.1f%%)\n", (Object[])new Object[]{n, otime, ntime, 100.0 * (otime - ntime) / otime});
                    this.checkDatasets(a, dv, c, d);
                    n *= 15;
                }
                ++i;
            }
        }
        if (eCount > 0) {
            TestUtils.verbosePrintf((String)"Number of exceptions caught: %d\n", (Object[])new Object[]{eCount});
        }
    }

    /*
     * Unable to fully structure code
     */
    @Test
    public void testSubtraction() {
        c = null;
        d = null;
        zv = new Complex(-3.5, 0.0);
        dv = zv.getReal();
        eCount = 0;
        block6: for (String dn : this.classes.keySet()) {
            dtype = this.classes.get(dn);
            Random.seed((long)12735L);
            block7: for (String en : this.classes.keySet()) {
                etype = this.classes.get(en);
                TestUtils.verbosePrintf((String)"%s to %s, ", (Object[])new Object[]{dn, en});
                n = 32;
                i = 0;
                while (i < 3) {
                    block50: {
                        block54: {
                            block58: {
                                block57: {
                                    block56: {
                                        block55: {
                                            block53: {
                                                if (dtype < 100) {
                                                    a = Random.randn((int[])new int[]{n}).imultiply((Object)100);
                                                    a = a.cast(dtype);
                                                } else {
                                                    aa = new Dataset[2];
                                                    j = 0;
                                                    while (j < 2) {
                                                        aa[j] = Random.randn((int[])new int[]{n}).imultiply((Object)100);
                                                        ++j;
                                                    }
                                                    a = DatasetUtils.cast((Dataset[])aa, (int)dtype);
                                                }
                                                if (etype < 100) {
                                                    b = Random.randn((int[])new int[]{n}).imultiply((Object)100);
                                                    b = b.cast(etype);
                                                } else {
                                                    ab = new Dataset[3];
                                                    j = 0;
                                                    while (j < 3) {
                                                        ab[j] = Random.randn((int[])new int[]{n}).imultiply((Object)100);
                                                        ++j;
                                                    }
                                                    b = DatasetUtils.cast((Dataset[])ab, (int)etype);
                                                }
                                                start = -System.nanoTime();
                                                try {
                                                    c = Maths.subtract((Object)a, (Object)b);
                                                }
                                                catch (IllegalArgumentException e) {
                                                    TestUtils.verbosePrintf((String)"Could not perform this operation: %s\n", (Object[])new Object[]{e.getMessage()});
                                                    ++eCount;
                                                    break block50;
                                                }
                                                ntime = (double)(start += System.nanoTime()) / (double)c.getSize();
                                                d = DatasetFactory.zeros((Dataset)c);
                                                start = -System.nanoTime();
                                                ita = a.getIterator();
                                                itb = b.getIterator();
                                                j = 0;
                                                if (dtype != 7 && dtype != 8 || etype != 7 && etype != 8) break block53;
                                                is = d.getElementsPerItem();
                                                while (ita.hasNext() && itb.hasNext()) {
                                                    d.setObjectAbs(j, (Object)((Complex)a.getObjectAbs(ita.index)).subtract((Complex)b.getObjectAbs(itb.index)));
                                                    j += is;
                                                }
                                                break block54;
                                            }
                                            if (dtype != 7 && dtype != 8 || etype == 7 || etype == 8) break block55;
                                            is = d.getElementsPerItem();
                                            while (ita.hasNext() && itb.hasNext()) {
                                                d.setObjectAbs(j, (Object)((Complex)a.getObjectAbs(ita.index)).subtract(new Complex(b.getElementDoubleAbs(itb.index), 0.0)));
                                                j += is;
                                            }
                                            break block54;
                                        }
                                        if (dtype == 7 || dtype == 8 || etype != 7 && etype != 8) break block56;
                                        is = d.getElementsPerItem();
                                        while (ita.hasNext() && itb.hasNext()) {
                                            d.setObjectAbs(j, (Object)new Complex(a.getElementDoubleAbs(ita.index), 0.0).subtract((Complex)b.getObjectAbs(itb.index)));
                                            j += is;
                                        }
                                        break block54;
                                    }
                                    if (dtype >= 100 || etype >= 100) break block57;
                                    while (ita.hasNext() && itb.hasNext()) {
                                        d.setObjectAbs(j++, (Object)(((Number)a.getObjectAbs(ita.index)).doubleValue() - ((Number)b.getObjectAbs(itb.index)).doubleValue()));
                                    }
                                    break block54;
                                }
                                answer = new double[MathsTest.MAXISIZE];
                                is = d.getElementsPerItem();
                                if (a.getElementsPerItem() >= is) break block58;
                                while (ita.hasNext() && itb.hasNext()) {
                                    da = a.getElementDoubleAbs(ita.index);
                                    k = 0;
                                    while (k < 3) {
                                        answer[k] = da - b.getElementDoubleAbs(itb.index + k);
                                        ++k;
                                    }
                                    d.setObjectAbs(j, (Object)answer);
                                    j += is;
                                }
                                break block54;
                            }
                            if (b.getElementsPerItem() >= is) ** GOTO lbl115
                            while (ita.hasNext() && itb.hasNext()) {
                                db = b.getElementDoubleAbs(itb.index);
                                k = 0;
                                while (k < 2) {
                                    answer[k] = a.getElementDoubleAbs(ita.index + k) - db;
                                    ++k;
                                }
                                d.setObjectAbs(j, (Object)answer);
                                j += is;
                            }
                            break block54;
lbl-1000:
                            // 1 sources

                            {
                                k = 0;
                                while (k < is) {
                                    answer[k] = a.getElementDoubleAbs(ita.index + k) - b.getElementDoubleAbs(itb.index + k);
                                    ++k;
                                }
                                d.setObjectAbs(j, (Object)answer);
                                j += is;
lbl115:
                                // 2 sources

                                ** while (ita.hasNext() && itb.hasNext())
                            }
                        }
                        if (d == null) continue block7;
                        otime = (double)(start += System.nanoTime()) / (double)d.getSize();
                        TestUtils.verbosePrintf((String)"Time taken by sub for %s: %s; %s (%.1f%%)\n", (Object[])new Object[]{n, otime, ntime, 100.0 * (otime - ntime) / otime});
                        this.checkDatasets(a, b, c, d);
                        n *= 15;
                    }
                    ++i;
                }
            }
            Random.seed((long)12735L);
            n = 32;
            TestUtils.verbosePrintf((String)"constant from %s, ", (Object[])new Object[]{dn});
            i = 0;
            while (i < 3) {
                block51: {
                    if (dtype < 100) {
                        a = Random.randn((int[])new int[]{n});
                        a.imultiply((Object)100);
                        a = a.cast(dtype);
                    } else {
                        aa = new Dataset[2];
                        j = 0;
                        while (j < 2) {
                            aa[j] = Random.randn((int[])new int[]{n}).imultiply((Object)100);
                            ++j;
                        }
                        a = DatasetUtils.cast((Dataset[])aa, (int)dtype);
                    }
                    start = -System.nanoTime();
                    try {
                        c = Maths.subtract((Object)a, (Object)dv);
                    }
                    catch (IllegalArgumentException e) {
                        TestUtils.verbosePrintf((String)"Could not perform this operation: %s\n", (Object[])new Object[]{e.getMessage()});
                        ++eCount;
                        break block51;
                    }
                    ntime = (double)(start += System.nanoTime()) / (double)c.getSize();
                    d = DatasetFactory.zeros((Dataset)c);
                    start = -System.nanoTime();
                    ita = a.getIterator();
                    j = 0;
                    if (dtype == 7 || dtype == 8) {
                        is = d.getElementsPerItem();
                        while (ita.hasNext()) {
                            d.setObjectAbs(j, (Object)((Complex)a.getObjectAbs(ita.index)).subtract(zv));
                            j += is;
                        }
                    } else if (dtype < 100) {
                        while (ita.hasNext()) {
                            d.setObjectAbs(j++, (Object)(((Number)a.getObjectAbs(ita.index)).doubleValue() - dv));
                        }
                    } else {
                        answer = new double[2];
                        while (ita.hasNext()) {
                            k = 0;
                            while (k < 2) {
                                answer[k] = a.getElementDoubleAbs(ita.index + k) - dv;
                                ++k;
                            }
                            d.setObjectAbs(j, (Object)answer);
                            j += 2;
                        }
                    }
                    if (d == null) break;
                    otime = (double)(start += System.nanoTime()) / (double)d.getSize();
                    TestUtils.verbosePrintf((String)"Time taken by add for %s: %s; %s (%.1f%%)\n", (Object[])new Object[]{n, otime, ntime, 100.0 * (otime - ntime) / otime});
                    this.checkDatasets(a, dv, c, d);
                    n *= 15;
                }
                ++i;
            }
            Random.seed((long)12735L);
            n = 32;
            TestUtils.verbosePrintf((String)"%s from constant, ", (Object[])new Object[]{dn});
            i = 0;
            while (i < 3) {
                block52: {
                    if (dtype < 100) {
                        a = Random.randn((int[])new int[]{n});
                        a.imultiply((Object)100);
                        a = a.cast(dtype);
                    } else {
                        aa = new Dataset[2];
                        j = 0;
                        while (j < 2) {
                            aa[j] = Random.randn((int[])new int[]{n}).imultiply((Object)100);
                            ++j;
                        }
                        a = DatasetUtils.cast((Dataset[])aa, (int)dtype);
                    }
                    start = -System.nanoTime();
                    try {
                        c = Maths.subtract((Object)dv, (Object)a);
                    }
                    catch (IllegalArgumentException e) {
                        TestUtils.verbosePrintf((String)"Could not perform this operation: %s\n", (Object[])new Object[]{e.getMessage()});
                        ++eCount;
                        break block52;
                    }
                    ntime = (double)(start += System.nanoTime()) / (double)c.getSize();
                    d = DatasetFactory.zeros((Dataset)c);
                    start = -System.nanoTime();
                    ita = a.getIterator();
                    j = 0;
                    if (dtype == 7 || dtype == 8) {
                        is = d.getElementsPerItem();
                        while (ita.hasNext()) {
                            d.setObjectAbs(j, (Object)zv.subtract((Complex)a.getObjectAbs(ita.index)));
                            j += is;
                        }
                    } else if (dtype < 100) {
                        while (ita.hasNext()) {
                            d.setObjectAbs(j++, (Object)(dv - ((Number)a.getObjectAbs(ita.index)).doubleValue()));
                        }
                    } else {
                        answer = new double[2];
                        while (ita.hasNext()) {
                            k = 0;
                            while (k < 2) {
                                answer[k] = dv - a.getElementDoubleAbs(ita.index + k);
                                ++k;
                            }
                            d.setObjectAbs(j, (Object)answer);
                            j += 2;
                        }
                    }
                    if (d == null) continue block6;
                    otime = (double)(start += System.nanoTime()) / (double)d.getSize();
                    TestUtils.verbosePrintf((String)"Time taken by sub for %s: %s; %s (%.1f%%)\n", (Object[])new Object[]{n, otime, ntime, 100.0 * (otime - ntime) / otime});
                    this.checkDatasets(dv, a, c, d);
                    n *= 15;
                }
                ++i;
            }
        }
        if (eCount > 0) {
            TestUtils.verbosePrintf((String)"Number of exceptions caught: %d\n", (Object[])new Object[]{eCount});
        }
    }

    /*
     * Unable to fully structure code
     */
    @Test
    public void testMultiplication() {
        c = null;
        d = null;
        zv = new Complex(-3.5, 0.0);
        dv = zv.getReal();
        eCount = 0;
        block4: for (String dn : this.classes.keySet()) {
            dtype = this.classes.get(dn);
            Random.seed((long)12735L);
            block5: for (String en : this.classes.keySet()) {
                etype = this.classes.get(en);
                TestUtils.verbosePrintf((String)"%s by %s, ", (Object[])new Object[]{dn, en});
                n = 32;
                i = 0;
                while (i < 3) {
                    block36: {
                        block39: {
                            block43: {
                                block42: {
                                    block41: {
                                        block40: {
                                            block38: {
                                                if (dtype < 100) {
                                                    a = Random.randn((int[])new int[]{n}).imultiply((Object)100);
                                                    a = a.cast(dtype);
                                                } else {
                                                    aa = new Dataset[2];
                                                    j = 0;
                                                    while (j < 2) {
                                                        aa[j] = Random.randn((int[])new int[]{n}).imultiply((Object)100);
                                                        ++j;
                                                    }
                                                    a = DatasetUtils.cast((Dataset[])aa, (int)dtype);
                                                }
                                                if (etype < 100) {
                                                    b = Random.randn((int[])new int[]{n}).imultiply((Object)100);
                                                    b = b.cast(etype);
                                                } else {
                                                    ab = new Dataset[3];
                                                    j = 0;
                                                    while (j < 3) {
                                                        ab[j] = Random.randn((int[])new int[]{n}).imultiply((Object)100);
                                                        ++j;
                                                    }
                                                    b = DatasetUtils.cast((Dataset[])ab, (int)etype);
                                                }
                                                start = -System.nanoTime();
                                                try {
                                                    c = Maths.multiply((Object)a, (Object)b);
                                                }
                                                catch (IllegalArgumentException e) {
                                                    TestUtils.verbosePrintf((String)"Could not perform this operation: %s\n", (Object[])new Object[]{e.getMessage()});
                                                    ++eCount;
                                                    break block36;
                                                }
                                                ntime = (double)(start += System.nanoTime()) / (double)c.getSize();
                                                d = DatasetFactory.zeros((Dataset)c);
                                                start = -System.nanoTime();
                                                ita = a.getIterator();
                                                itb = b.getIterator();
                                                j = 0;
                                                if (dtype != 7 && dtype != 8 || etype != 7 && etype != 8) break block38;
                                                is = d.getElementsPerItem();
                                                while (ita.hasNext() && itb.hasNext()) {
                                                    d.setObjectAbs(j, (Object)((Complex)a.getObjectAbs(ita.index)).multiply((Complex)b.getObjectAbs(itb.index)));
                                                    j += is;
                                                }
                                                break block39;
                                            }
                                            if (dtype != 7 && dtype != 8 || etype == 7 || etype == 8) break block40;
                                            is = d.getElementsPerItem();
                                            while (ita.hasNext() && itb.hasNext()) {
                                                d.setObjectAbs(j, (Object)((Complex)a.getObjectAbs(ita.index)).multiply(b.getElementDoubleAbs(itb.index)));
                                                j += is;
                                            }
                                            break block39;
                                        }
                                        if (dtype == 7 || dtype == 8 || etype != 7 && etype != 8) break block41;
                                        is = d.getElementsPerItem();
                                        while (ita.hasNext() && itb.hasNext()) {
                                            d.setObjectAbs(j, (Object)new Complex(a.getElementDoubleAbs(ita.index), 0.0).multiply((Complex)b.getObjectAbs(itb.index)));
                                            j += is;
                                        }
                                        break block39;
                                    }
                                    if (dtype >= 100 || etype >= 100) break block42;
                                    while (ita.hasNext() && itb.hasNext()) {
                                        d.setObjectAbs(j++, (Object)(((Number)a.getObjectAbs(ita.index)).doubleValue() * ((Number)b.getObjectAbs(itb.index)).doubleValue()));
                                    }
                                    break block39;
                                }
                                answer = new double[MathsTest.MAXISIZE];
                                is = d.getElementsPerItem();
                                if (a.getElementsPerItem() >= is) break block43;
                                while (ita.hasNext() && itb.hasNext()) {
                                    da = a.getElementDoubleAbs(ita.index);
                                    k = 0;
                                    while (k < 3) {
                                        answer[k] = da * b.getElementDoubleAbs(itb.index + k);
                                        ++k;
                                    }
                                    d.setObjectAbs(j, (Object)answer);
                                    j += is;
                                }
                                break block39;
                            }
                            if (b.getElementsPerItem() >= is) ** GOTO lbl115
                            while (ita.hasNext() && itb.hasNext()) {
                                db = b.getElementDoubleAbs(itb.index);
                                k = 0;
                                while (k < 2) {
                                    answer[k] = a.getElementDoubleAbs(ita.index + k) * db;
                                    ++k;
                                }
                                d.setObjectAbs(j, (Object)answer);
                                j += is;
                            }
                            break block39;
lbl-1000:
                            // 1 sources

                            {
                                k = 0;
                                while (k < is) {
                                    answer[k] = a.getElementDoubleAbs(ita.index + k) * b.getElementDoubleAbs(itb.index + k);
                                    ++k;
                                }
                                d.setObjectAbs(j, (Object)answer);
                                j += is;
lbl115:
                                // 2 sources

                                ** while (ita.hasNext() && itb.hasNext())
                            }
                        }
                        if (d == null) continue block5;
                        otime = (double)(start += System.nanoTime()) / (double)d.getSize();
                        TestUtils.verbosePrintf((String)"Time taken by mul for %s: %s; %s (%.1f%%)\n", (Object[])new Object[]{n, otime, ntime, 100.0 * (otime - ntime) / otime});
                        this.checkDatasets(a, b, c, d);
                        n *= 15;
                    }
                    ++i;
                }
            }
            Random.seed((long)12735L);
            n = 32;
            TestUtils.verbosePrintf((String)"constant with %s, ", (Object[])new Object[]{dn});
            i = 0;
            while (i < 3) {
                block37: {
                    if (dtype < 100) {
                        a = Random.randn((int[])new int[]{n});
                        a.imultiply((Object)100);
                        a = a.cast(dtype);
                    } else {
                        aa = new Dataset[2];
                        j = 0;
                        while (j < 2) {
                            aa[j] = Random.randn((int[])new int[]{n}).imultiply((Object)100);
                            ++j;
                        }
                        a = DatasetUtils.cast((Dataset[])aa, (int)dtype);
                    }
                    start = -System.nanoTime();
                    try {
                        c = Maths.multiply((Object)a, (Object)dv);
                    }
                    catch (IllegalArgumentException e) {
                        TestUtils.verbosePrintf((String)"Could not perform this operation: %s\n", (Object[])new Object[]{e.getMessage()});
                        ++eCount;
                        break block37;
                    }
                    ntime = (double)(start += System.nanoTime()) / (double)c.getSize();
                    d = DatasetFactory.zeros((Dataset)c);
                    start = -System.nanoTime();
                    ita = a.getIterator();
                    j = 0;
                    if (dtype == 7 || dtype == 8) {
                        is = d.getElementsPerItem();
                        while (ita.hasNext()) {
                            d.setObjectAbs(j, (Object)((Complex)a.getObjectAbs(ita.index)).multiply(zv));
                            j += is;
                        }
                    } else if (dtype < 100) {
                        while (ita.hasNext()) {
                            d.setObjectAbs(j++, (Object)(((Number)a.getObjectAbs(ita.index)).doubleValue() * dv));
                        }
                    } else {
                        answer = new double[2];
                        while (ita.hasNext()) {
                            k = 0;
                            while (k < 2) {
                                answer[k] = a.getElementDoubleAbs(ita.index + k) * dv;
                                ++k;
                            }
                            d.setObjectAbs(j, (Object)answer);
                            j += 2;
                        }
                    }
                    if (d == null) continue block4;
                    otime = (double)(start += System.nanoTime()) / (double)d.getSize();
                    TestUtils.verbosePrintf((String)"Time taken by mul for %s: %s; %s (%.1f%%)\n", (Object[])new Object[]{n, otime, ntime, 100.0 * (otime - ntime) / otime});
                    this.checkDatasets(a, dv, c, d);
                    n *= 15;
                }
                ++i;
            }
        }
        if (eCount > 0) {
            TestUtils.verbosePrintf((String)"Number of exceptions caught: %d\n", (Object[])new Object[]{eCount});
        }
    }

    /*
     * Unable to fully structure code
     */
    @Test
    public void testDivision() {
        c = null;
        d = null;
        zv = new Complex(-3.5, 0.0);
        dv = zv.getReal();
        eCount = 0;
        block6: for (String dn : this.classes.keySet()) {
            dtype = this.classes.get(dn);
            Random.seed((long)12735L);
            for (String en : this.classes.keySet()) {
                etype = this.classes.get(en);
                TestUtils.verbosePrintf((String)"%s by %s, ", (Object[])new Object[]{dn, en});
                n = 32;
                i = 0;
                while (i < 3) {
                    block64: {
                        block68: {
                            block72: {
                                block71: {
                                    block70: {
                                        block69: {
                                            block67: {
                                                if (dtype < 100) {
                                                    a = Random.randn((int[])new int[]{n}).imultiply((Object)100);
                                                    a = a.cast(dtype);
                                                } else {
                                                    aa = new Dataset[2];
                                                    j = 0;
                                                    while (j < 2) {
                                                        aa[j] = Random.randn((int[])new int[]{n}).imultiply((Object)100);
                                                        ++j;
                                                    }
                                                    a = DatasetUtils.cast((Dataset[])aa, (int)dtype);
                                                }
                                                if (etype < 100) {
                                                    b = Random.randn((int[])new int[]{n}).imultiply((Object)100);
                                                    b = b.cast(etype);
                                                } else {
                                                    ab = new Dataset[3];
                                                    j = 0;
                                                    while (j < 3) {
                                                        ab[j] = Random.randn((int[])new int[]{n}).imultiply((Object)100);
                                                        ++j;
                                                    }
                                                    b = DatasetUtils.cast((Dataset[])ab, (int)etype);
                                                }
                                                start = -System.nanoTime();
                                                try {
                                                    c = Maths.divide((Object)a, (Object)b);
                                                }
                                                catch (IllegalArgumentException e) {
                                                    TestUtils.verbosePrintf((String)"Could not perform this operation: %s\n", (Object[])new Object[]{e.getMessage()});
                                                    ++eCount;
                                                    break block64;
                                                }
                                                ntime = (double)(start += System.nanoTime()) / (double)c.getSize();
                                                d = DatasetFactory.zeros((Dataset)c);
                                                start = -System.nanoTime();
                                                ita = a.getIterator();
                                                itb = b.getIterator();
                                                j = 0;
                                                if (dtype != 7 && dtype != 8 || etype != 7 && etype != 8) break block67;
                                                is = d.getElementsPerItem();
                                                while (ita.hasNext() && itb.hasNext()) {
                                                    d.setObjectAbs(j, (Object)((Complex)a.getObjectAbs(ita.index)).divide((Complex)b.getObjectAbs(itb.index)));
                                                    j += is;
                                                }
                                                break block68;
                                            }
                                            if (dtype != 7 && dtype != 8 || etype == 7 || etype == 8) break block69;
                                            is = d.getElementsPerItem();
                                            while (ita.hasNext() && itb.hasNext()) {
                                                z = (Complex)a.getObjectAbs(ita.index);
                                                br = b.getElementDoubleAbs(itb.index);
                                                zr = z.divide(br);
                                                if (br == 0.0) {
                                                    zr = new Complex(z.getReal() != 0.0 ? z.getReal() / br : zr.getReal(), z.getImaginary() != 0.0 ? z.getImaginary() / br : zr.getImaginary());
                                                }
                                                d.setObjectAbs(j, (Object)zr);
                                                j += is;
                                            }
                                            break block68;
                                        }
                                        if (dtype == 7 || dtype == 8 || etype != 7 && etype != 8) break block70;
                                        is = d.getElementsPerItem();
                                        while (ita.hasNext() && itb.hasNext()) {
                                            d.setObjectAbs(j, (Object)new Complex(a.getElementDoubleAbs(ita.index), 0.0).divide((Complex)b.getObjectAbs(itb.index)));
                                            j += is;
                                        }
                                        break block68;
                                    }
                                    if (dtype >= 100 || etype >= 100) break block71;
                                    if (!d.hasFloatingPointElements()) ** GOTO lbl88
                                    while (ita.hasNext() && itb.hasNext()) {
                                        d.setObjectAbs(j++, (Object)(((Number)a.getObjectAbs(ita.index)).doubleValue() / ((Number)b.getObjectAbs(itb.index)).doubleValue()));
                                    }
                                    break block68;
lbl-1000:
                                    // 1 sources

                                    {
                                        bv = ((Number)b.getObjectAbs(itb.index)).doubleValue();
                                        d.setObjectAbs(j++, (Object)(bv == 0.0 ? 0.0 : ((Number)a.getObjectAbs(ita.index)).doubleValue() / bv));
lbl88:
                                        // 2 sources

                                        ** while (ita.hasNext() && itb.hasNext())
                                    }
lbl89:
                                    // 1 sources

                                    break block68;
                                }
                                answer = new double[MathsTest.MAXISIZE];
                                is = d.getElementsPerItem();
                                if (a.getElementsPerItem() >= is) break block72;
                                while (ita.hasNext() && itb.hasNext()) {
                                    xa = a.getElementDoubleAbs(ita.index);
                                    if (d.hasFloatingPointElements()) {
                                        k = 0;
                                        while (k < 3) {
                                            answer[k] = xa / b.getElementDoubleAbs(itb.index + k);
                                            ++k;
                                        }
                                    } else {
                                        k = 0;
                                        while (k < 3) {
                                            v = xa / b.getElementDoubleAbs(itb.index + k);
                                            answer[k] = Double.isInfinite(v) != false || Double.isNaN(v) != false ? 0.0 : v;
                                            ++k;
                                        }
                                    }
                                    d.setObjectAbs(j, (Object)answer);
                                    j += is;
                                }
                                break block68;
                            }
                            if (b.getElementsPerItem() >= is) ** GOTO lbl156
                            while (ita.hasNext() && itb.hasNext()) {
                                xb = b.getElementDoubleAbs(itb.index);
                                if (d.hasFloatingPointElements()) {
                                    k = 0;
                                    while (k < 2) {
                                        answer[k] = a.getElementDoubleAbs(ita.index + k) / xb;
                                        ++k;
                                    }
                                } else if (xb == 0.0) {
                                    k = 0;
                                    while (k < 2) {
                                        answer[k] = 0.0;
                                        ++k;
                                    }
                                } else {
                                    k = 0;
                                    while (k < 2) {
                                        answer[k] = a.getElementDoubleAbs(ita.index + k) / xb;
                                        ++k;
                                    }
                                }
                                d.setObjectAbs(j, (Object)answer);
                                j += is;
                            }
                            break block68;
lbl-1000:
                            // 1 sources

                            {
                                if (d.hasFloatingPointElements()) {
                                    k = 0;
                                    while (k < is) {
                                        v = a.getElementDoubleAbs(ita.index + k) / b.getElementDoubleAbs(itb.index + k);
                                        answer[k] = Double.isInfinite(v) != false || Double.isNaN(v) != false ? 0.0 : v;
                                        ++k;
                                    }
                                } else {
                                    k = 0;
                                    while (k < is) {
                                        v = a.getElementDoubleAbs(ita.index + k) / b.getElementDoubleAbs(itb.index + k);
                                        answer[k] = Double.isInfinite(v) != false || Double.isNaN(v) != false ? 0.0 : v;
                                        ++k;
                                    }
                                }
                                d.setObjectAbs(j, (Object)answer);
                                j += is;
lbl156:
                                // 2 sources

                                ** while (ita.hasNext() && itb.hasNext())
                            }
                        }
                        otime = (double)(start += System.nanoTime()) / (double)d.getSize();
                        TestUtils.verbosePrintf((String)"Time taken by div for %s: %s; %s (%.1f%%)\n", (Object[])new Object[]{n, otime, ntime, 100.0 * (otime - ntime) / otime});
                        this.checkDatasets(a, b, c, d);
                        n *= 15;
                    }
                    ++i;
                }
            }
            Random.seed((long)12735L);
            n = 32;
            TestUtils.verbosePrintf((String)"%s by constant, ", (Object[])new Object[]{dn});
            i = 0;
            while (i < 3) {
                block65: {
                    if (dtype < 100) {
                        a = Random.randn((int[])new int[]{n});
                        a.imultiply((Object)100);
                        a = a.cast(dtype);
                    } else {
                        aa = new Dataset[2];
                        j = 0;
                        while (j < 2) {
                            aa[j] = Random.randn((int[])new int[]{n}).imultiply((Object)100);
                            ++j;
                        }
                        a = DatasetUtils.cast((Dataset[])aa, (int)dtype);
                    }
                    start = -System.nanoTime();
                    try {
                        c = Maths.divide((Object)a, (Object)dv);
                    }
                    catch (IllegalArgumentException e) {
                        TestUtils.verbosePrintf((String)"Could not perform this operation: %s\n", (Object[])new Object[]{e.getMessage()});
                        ++eCount;
                        break block65;
                    }
                    ntime = (double)(start += System.nanoTime()) / (double)c.getSize();
                    d = DatasetFactory.zeros((Dataset)c);
                    start = -System.nanoTime();
                    ita = a.getIterator();
                    j = 0;
                    if (dtype == 7 || dtype == 8) {
                        is = d.getElementsPerItem();
                        while (ita.hasNext()) {
                            d.setObjectAbs(j, (Object)((Complex)a.getObjectAbs(ita.index)).divide(zv));
                            j += is;
                        }
                    } else if (dtype < 100) {
                        while (ita.hasNext()) {
                            d.setObjectAbs(j++, (Object)(((Number)a.getObjectAbs(ita.index)).doubleValue() / dv));
                        }
                    } else {
                        answer = new double[2];
                        while (ita.hasNext()) {
                            k = 0;
                            while (k < 2) {
                                answer[k] = a.getElementDoubleAbs(ita.index + k) / dv;
                                ++k;
                            }
                            d.setObjectAbs(j, (Object)answer);
                            j += 2;
                        }
                    }
                    if (d == null) break;
                    otime = (double)(start += System.nanoTime()) / (double)d.getSize();
                    TestUtils.verbosePrintf((String)"Time taken by div for %s: %s; %s (%.1f%%)\n", (Object[])new Object[]{n, otime, ntime, 100.0 * (otime - ntime) / otime});
                    this.checkDatasets(a, dv, c, d);
                    n *= 15;
                }
                ++i;
            }
            Random.seed((long)12735L);
            n = 32;
            TestUtils.verbosePrintf((String)"constant by %s, ", (Object[])new Object[]{dn});
            i = 0;
            while (i < 3) {
                block66: {
                    if (dtype < 100) {
                        a = Random.randn((int[])new int[]{n});
                        a.imultiply((Object)100);
                        a = a.cast(dtype);
                    } else {
                        aa = new Dataset[2];
                        j = 0;
                        while (j < 2) {
                            aa[j] = Random.randn((int[])new int[]{n}).imultiply((Object)100);
                            ++j;
                        }
                        a = DatasetUtils.cast((Dataset[])aa, (int)dtype);
                    }
                    start = -System.nanoTime();
                    try {
                        c = Maths.divide((Object)dv, (Object)a);
                    }
                    catch (IllegalArgumentException e) {
                        TestUtils.verbosePrintf((String)"Could not perform this operation: %s\n", (Object[])new Object[]{e.getMessage()});
                        ++eCount;
                        break block66;
                    }
                    ntime = (double)(start += System.nanoTime()) / (double)c.getSize();
                    d = DatasetFactory.zeros((Dataset)c);
                    start = -System.nanoTime();
                    ita = a.getIterator();
                    j = 0;
                    if (dtype == 7 || dtype == 8) {
                        is = d.getElementsPerItem();
                        while (ita.hasNext()) {
                            d.setObjectAbs(j, (Object)zv.divide((Complex)a.getObjectAbs(ita.index)));
                            j += is;
                        }
                    } else if (dtype < 100) {
                        while (ita.hasNext()) {
                            d.setObjectAbs(j++, (Object)(dv / ((Number)a.getObjectAbs(ita.index)).doubleValue()));
                        }
                    } else {
                        answer = new double[2];
                        while (ita.hasNext()) {
                            k = 0;
                            while (k < 2) {
                                answer[k] = dv / a.getElementDoubleAbs(ita.index + k);
                                ++k;
                            }
                            d.setObjectAbs(j, (Object)answer);
                            j += 2;
                        }
                    }
                    if (d == null) continue block6;
                    otime = (double)(start += System.nanoTime()) / (double)d.getSize();
                    TestUtils.verbosePrintf((String)"Time taken by div for %s: %s; %s (%.1f%%)\n", (Object[])new Object[]{n, otime, ntime, 100.0 * (otime - ntime) / otime});
                    this.checkDatasets(dv, a, c, d);
                    n *= 15;
                }
                ++i;
            }
        }
        if (eCount > 0) {
            TestUtils.verbosePrintf((String)"Number of exceptions caught: %d\n", (Object[])new Object[]{eCount});
        }
    }

    /*
     * Unable to fully structure code
     */
    @Test
    public void testRemainder() {
        c = null;
        d = null;
        zv = new Complex(-3.5, 0.0);
        dv = zv.getReal();
        eCount = 0;
        for (String dn : this.classes.keySet()) {
            dtype = this.classes.get(dn);
            Random.seed((long)12735L);
            block10: for (String en : this.classes.keySet()) {
                etype = this.classes.get(en);
                TestUtils.verbosePrintf((String)"%s by %s, ", (Object[])new Object[]{dn, en});
                n = 32;
                i = 0;
                while (i < 3) {
                    block44: {
                        block48: {
                            block49: {
                                block47: {
                                    if (dtype < 100) {
                                        a = Random.randn((int[])new int[]{n}).imultiply((Object)100);
                                        a = a.cast(dtype);
                                    } else {
                                        aa = new Dataset[2];
                                        j = 0;
                                        while (j < 2) {
                                            aa[j] = Random.randn((int[])new int[]{n}).imultiply((Object)100);
                                            ++j;
                                        }
                                        a = DatasetUtils.cast((Dataset[])aa, (int)dtype);
                                    }
                                    if (etype < 100) {
                                        b = Random.randn((int[])new int[]{n}).imultiply((Object)100);
                                        b = b.cast(etype);
                                    } else {
                                        ab = new Dataset[3];
                                        j = 0;
                                        while (j < 3) {
                                            ab[j] = Random.randn((int[])new int[]{n}).imultiply((Object)100);
                                            ++j;
                                        }
                                        b = DatasetUtils.cast((Dataset[])ab, (int)etype);
                                    }
                                    start = -System.nanoTime();
                                    try {
                                        c = Maths.remainder((Object)a, (Object)b);
                                    }
                                    catch (IllegalArgumentException e) {
                                        TestUtils.verbosePrintf((String)"Could not perform this operation: ", (Object[])new Object[]{e.getMessage()});
                                        ++eCount;
                                        break block44;
                                    }
                                    catch (UnsupportedOperationException ue) {
                                        TestUtils.verbosePrintf((String)"Could not perform this operation: ", (Object[])new Object[]{ue.getMessage()});
                                        break block44;
                                    }
                                    ntime = (double)(start += System.nanoTime()) / (double)c.getSize();
                                    d = DatasetFactory.zeros((Dataset)c);
                                    start = -System.nanoTime();
                                    ita = a.getIterator();
                                    itb = b.getIterator();
                                    j = 0;
                                    if (dtype >= 100 || etype >= 100) break block47;
                                    while (ita.hasNext() && itb.hasNext()) {
                                        d.setObjectAbs(j++, (Object)(((Number)a.getObjectAbs(ita.index)).doubleValue() % ((Number)b.getObjectAbs(itb.index)).doubleValue()));
                                    }
                                    break block48;
                                }
                                answer = new double[MathsTest.MAXISIZE];
                                is = d.getElementsPerItem();
                                if (a.getElementsPerItem() >= is) break block49;
                                while (ita.hasNext() && itb.hasNext()) {
                                    xa = a.getElementDoubleAbs(ita.index);
                                    k = 0;
                                    while (k < 3) {
                                        answer[k] = xa % b.getElementDoubleAbs(itb.index + k);
                                        ++k;
                                    }
                                    d.setObjectAbs(j, (Object)answer);
                                    j += is;
                                }
                                break block48;
                            }
                            if (b.getElementsPerItem() >= is) ** GOTO lbl94
                            while (ita.hasNext() && itb.hasNext()) {
                                xb = b.getElementDoubleAbs(itb.index);
                                k = 0;
                                while (k < 2) {
                                    answer[k] = a.getElementDoubleAbs(ita.index + k) % xb;
                                    ++k;
                                }
                                d.setObjectAbs(j, (Object)answer);
                                j += is;
                            }
                            break block48;
lbl-1000:
                            // 1 sources

                            {
                                k = 0;
                                while (k < is) {
                                    answer[k] = a.getElementDoubleAbs(ita.index + k) % b.getElementDoubleAbs(itb.index + k);
                                    ++k;
                                }
                                d.setObjectAbs(j, (Object)answer);
                                j += is;
lbl94:
                                // 2 sources

                                ** while (ita.hasNext() && itb.hasNext())
                            }
                        }
                        if (d == null) continue block10;
                        otime = (double)(start += System.nanoTime()) / (double)d.getSize();
                        TestUtils.verbosePrintf((String)"Time taken by rem for %s: %s; %s (%.1f%%)\n", (Object[])new Object[]{n, otime, ntime, 100.0 * (otime - ntime) / otime});
                        this.checkDatasets(a, b, c, d);
                        n *= 15;
                    }
                    ++i;
                }
            }
            Random.seed((long)12735L);
            n = 32;
            TestUtils.verbosePrintf((String)"%s by constant, ", (Object[])new Object[]{dn});
            i = 0;
            while (i < 3) {
                block45: {
                    if (dtype < 100) {
                        a = Random.randn((int[])new int[]{n});
                        a.imultiply((Object)100);
                        a = a.cast(dtype);
                    } else {
                        aa = new Dataset[2];
                        j = 0;
                        while (j < 2) {
                            aa[j] = Random.randn((int[])new int[]{n}).imultiply((Object)100);
                            ++j;
                        }
                        a = DatasetUtils.cast((Dataset[])aa, (int)dtype);
                    }
                    start = -System.nanoTime();
                    try {
                        c = Maths.remainder((Object)a, (Object)dv);
                    }
                    catch (IllegalArgumentException e) {
                        TestUtils.verbosePrintf((String)"Could not perform this operation: ", (Object[])new Object[]{e.getMessage()});
                        ++eCount;
                        break block45;
                    }
                    catch (UnsupportedOperationException ue) {
                        TestUtils.verbosePrintf((String)"Could not perform this operation: ", (Object[])new Object[]{ue.getMessage()});
                        break block45;
                    }
                    ntime = (double)(start += System.nanoTime()) / (double)c.getSize();
                    d = DatasetFactory.zeros((Dataset)c);
                    start = -System.nanoTime();
                    ita = a.getIterator();
                    j = 0;
                    if (dtype < 100) {
                        while (ita.hasNext()) {
                            d.setObjectAbs(j++, (Object)(((Number)a.getObjectAbs(ita.index)).doubleValue() % dv));
                        }
                    } else {
                        answer = new double[2];
                        while (ita.hasNext()) {
                            k = 0;
                            while (k < 2) {
                                answer[k] = a.getElementDoubleAbs(ita.index + k) % dv;
                                ++k;
                            }
                            d.setObjectAbs(j, (Object)answer);
                            j += 2;
                        }
                    }
                    otime = (double)(start += System.nanoTime()) / (double)d.getSize();
                    TestUtils.verbosePrintf((String)"Time taken by rem for %s: %s; %s (%.1f%%)\n", (Object[])new Object[]{n, otime, ntime, 100.0 * (otime - ntime) / otime});
                    this.checkDatasets(a, dv, c, d);
                    n *= 15;
                }
                ++i;
            }
            Random.seed((long)12735L);
            n = 32;
            TestUtils.verbosePrintf((String)"constant by %s, ", (Object[])new Object[]{dn});
            i = 0;
            while (i < 3) {
                block46: {
                    if (dtype < 100) {
                        a = Random.randn((int[])new int[]{n});
                        a.imultiply((Object)100);
                        a = a.cast(dtype);
                    } else {
                        aa = new Dataset[2];
                        j = 0;
                        while (j < 2) {
                            aa[j] = Random.randn((int[])new int[]{n}).imultiply((Object)100);
                            ++j;
                        }
                        a = DatasetUtils.cast((Dataset[])aa, (int)dtype);
                    }
                    start = -System.nanoTime();
                    try {
                        c = Maths.remainder((Object)dv, (Object)a);
                    }
                    catch (IllegalArgumentException e) {
                        TestUtils.verbosePrintf((String)"Could not perform this operation: ", (Object[])new Object[]{e.getMessage()});
                        ++eCount;
                        break block46;
                    }
                    catch (UnsupportedOperationException ue) {
                        TestUtils.verbosePrintf((String)"Could not perform this operation: ", (Object[])new Object[]{ue.getMessage()});
                        break block46;
                    }
                    ntime = (double)(start += System.nanoTime()) / (double)c.getSize();
                    d = DatasetFactory.zeros((Dataset)c);
                    start = -System.nanoTime();
                    ita = a.getIterator();
                    j = 0;
                    if (dtype < 100) {
                        while (ita.hasNext()) {
                            d.setObjectAbs(j++, (Object)(dv % ((Number)a.getObjectAbs(ita.index)).doubleValue()));
                        }
                    } else {
                        answer = new double[2];
                        while (ita.hasNext()) {
                            k = 0;
                            while (k < 2) {
                                answer[k] = dv % a.getElementDoubleAbs(ita.index + k);
                                ++k;
                            }
                            d.setObjectAbs(j, (Object)answer);
                            j += 2;
                        }
                    }
                    otime = (double)(start += System.nanoTime()) / (double)d.getSize();
                    TestUtils.verbosePrintf((String)"Time taken by rem for %s: %s; %s (%.1f%%)\n", (Object[])new Object[]{n, otime, ntime, 100.0 * (otime - ntime) / otime});
                    this.checkDatasets(dv, a, c, d);
                    n *= 15;
                }
                ++i;
            }
        }
        if (eCount > 0) {
            TestUtils.verbosePrintf((String)"Number of exceptions caught: %d\n", (Object[])new Object[]{eCount});
        }
    }

    /*
     * Unable to fully structure code
     */
    @Test
    public void testPower() {
        c = null;
        d = null;
        zv = new Complex(-3.5, 0.0);
        dv = zv.getReal();
        eCount = 0;
        block6: for (String dn : this.classes.keySet()) {
            dtype = this.classes.get(dn);
            Random.seed((long)12735L);
            block7: for (String en : this.classes.keySet()) {
                etype = this.classes.get(en);
                TestUtils.verbosePrintf((String)"%s by %s, ", (Object[])new Object[]{dn, en});
                n = 32;
                i = 0;
                while (i < 3) {
                    block50: {
                        block54: {
                            block58: {
                                block57: {
                                    block56: {
                                        block55: {
                                            block53: {
                                                if (dtype < 100) {
                                                    a = Random.randn((int[])new int[]{n}).imultiply((Object)100);
                                                    a = a.cast(dtype);
                                                } else {
                                                    aa = new Dataset[2];
                                                    j = 0;
                                                    while (j < 2) {
                                                        aa[j] = Random.randn((int[])new int[]{n}).imultiply((Object)100);
                                                        ++j;
                                                    }
                                                    a = DatasetUtils.cast((Dataset[])aa, (int)dtype);
                                                }
                                                if (etype < 100) {
                                                    b = Random.randn((int[])new int[]{n}).imultiply((Object)100);
                                                    b = b.cast(etype);
                                                } else {
                                                    ab = new Dataset[3];
                                                    j = 0;
                                                    while (j < 3) {
                                                        ab[j] = Random.randn((int[])new int[]{n}).imultiply((Object)100);
                                                        ++j;
                                                    }
                                                    b = DatasetUtils.cast((Dataset[])ab, (int)etype);
                                                }
                                                start = -System.nanoTime();
                                                try {
                                                    c = Maths.power((Object)a, (Object)b);
                                                }
                                                catch (IllegalArgumentException e) {
                                                    TestUtils.verbosePrintf((String)"Could not perform this operation: ", (Object[])new Object[]{e.getMessage()});
                                                    ++eCount;
                                                    break block50;
                                                }
                                                ntime = (double)(start += System.nanoTime()) / (double)c.getSize();
                                                d = DatasetFactory.zeros((Dataset)c);
                                                start = -System.nanoTime();
                                                ita = a.getIterator();
                                                itb = b.getIterator();
                                                j = 0;
                                                if (dtype != 7 && dtype != 8 || etype != 7 && etype != 8) break block53;
                                                is = d.getElementsPerItem();
                                                while (ita.hasNext() && itb.hasNext()) {
                                                    d.setObjectAbs(j, (Object)((Complex)a.getObjectAbs(ita.index)).pow((Complex)b.getObjectAbs(itb.index)));
                                                    j += is;
                                                }
                                                break block54;
                                            }
                                            if (dtype != 7 && dtype != 8 || etype == 7 || etype == 8) break block55;
                                            is = d.getElementsPerItem();
                                            while (ita.hasNext() && itb.hasNext()) {
                                                d.setObjectAbs(j, (Object)((Complex)a.getObjectAbs(ita.index)).pow(new Complex(b.getElementDoubleAbs(itb.index), 0.0)));
                                                j += is;
                                            }
                                            break block54;
                                        }
                                        if (dtype == 7 || dtype == 8 || etype != 7 && etype != 8) break block56;
                                        is = d.getElementsPerItem();
                                        while (ita.hasNext() && itb.hasNext()) {
                                            d.setObjectAbs(j, (Object)new Complex(a.getElementDoubleAbs(ita.index), 0.0).pow((Complex)b.getObjectAbs(itb.index)));
                                            j += is;
                                        }
                                        break block54;
                                    }
                                    if (dtype >= 100 || etype >= 100) break block57;
                                    while (ita.hasNext() && itb.hasNext()) {
                                        d.setObjectAbs(j++, (Object)Math.pow(a.getElementDoubleAbs(ita.index), b.getElementDoubleAbs(itb.index)));
                                    }
                                    break block54;
                                }
                                answer = new double[MathsTest.MAXISIZE];
                                is = d.getElementsPerItem();
                                if (a.getElementsPerItem() >= is) break block58;
                                while (ita.hasNext() && itb.hasNext()) {
                                    xa = a.getElementDoubleAbs(ita.index);
                                    k = 0;
                                    while (k < 3) {
                                        answer[k] = Math.pow(xa, b.getElementDoubleAbs(itb.index + k));
                                        ++k;
                                    }
                                    d.setObjectAbs(j, (Object)answer);
                                    j += is;
                                }
                                break block54;
                            }
                            if (b.getElementsPerItem() >= is) ** GOTO lbl115
                            while (ita.hasNext() && itb.hasNext()) {
                                xb = b.getElementDoubleAbs(itb.index);
                                k = 0;
                                while (k < 2) {
                                    answer[k] = Math.pow(a.getElementDoubleAbs(ita.index + k), xb);
                                    ++k;
                                }
                                d.setObjectAbs(j, (Object)answer);
                                j += is;
                            }
                            break block54;
lbl-1000:
                            // 1 sources

                            {
                                k = 0;
                                while (k < is) {
                                    answer[k] = Math.pow(a.getElementDoubleAbs(ita.index + k), b.getElementDoubleAbs(itb.index + k));
                                    ++k;
                                }
                                d.setObjectAbs(j, (Object)answer);
                                j += is;
lbl115:
                                // 2 sources

                                ** while (ita.hasNext() && itb.hasNext())
                            }
                        }
                        if (d == null) continue block7;
                        otime = (double)(start += System.nanoTime()) / (double)d.getSize();
                        TestUtils.verbosePrintf((String)"Time taken by pow for %s: %s; %s (%.1f%%)\n", (Object[])new Object[]{n, otime, ntime, 100.0 * (otime - ntime) / otime});
                        this.checkDatasets(a, b, c, d);
                        n *= 15;
                    }
                    ++i;
                }
            }
            Random.seed((long)12735L);
            n = 32;
            TestUtils.verbosePrintf((String)"%s by constant, ", (Object[])new Object[]{dn});
            i = 0;
            while (i < 3) {
                block51: {
                    if (dtype < 100) {
                        a = Random.randn((int[])new int[]{n});
                        a.imultiply((Object)100);
                        a = a.cast(dtype);
                    } else {
                        aa = new Dataset[2];
                        j = 0;
                        while (j < 2) {
                            aa[j] = Random.randn((int[])new int[]{n}).imultiply((Object)100);
                            ++j;
                        }
                        a = DatasetUtils.cast((Dataset[])aa, (int)dtype);
                    }
                    start = -System.nanoTime();
                    try {
                        c = Maths.power((Object)a, (Object)dv);
                    }
                    catch (IllegalArgumentException e) {
                        TestUtils.verbosePrintf((String)"Could not perform this operation: ", (Object[])new Object[]{e.getMessage()});
                        ++eCount;
                        break block51;
                    }
                    ntime = (double)(start += System.nanoTime()) / (double)c.getSize();
                    d = DatasetFactory.zeros((Dataset)c);
                    start = -System.nanoTime();
                    ita = a.getIterator();
                    j = 0;
                    if (dtype == 7 || dtype == 8) {
                        is = d.getElementsPerItem();
                        while (ita.hasNext()) {
                            d.setObjectAbs(j, (Object)((Complex)a.getObjectAbs(ita.index)).pow(zv));
                            j += is;
                        }
                    } else if (dtype < 100) {
                        while (ita.hasNext()) {
                            d.setObjectAbs(j++, (Object)Math.pow(((Number)a.getObjectAbs(ita.index)).doubleValue(), dv));
                        }
                    } else {
                        answer = new double[2];
                        while (ita.hasNext()) {
                            k = 0;
                            while (k < 2) {
                                answer[k] = Math.pow(a.getElementDoubleAbs(ita.index + k), dv);
                                ++k;
                            }
                            d.setObjectAbs(j, (Object)answer);
                            j += 2;
                        }
                    }
                    if (d == null) break;
                    otime = (double)(start += System.nanoTime()) / (double)d.getSize();
                    TestUtils.verbosePrintf((String)"Time taken by pow for %s: %s; %s (%.1f%%)\n", (Object[])new Object[]{n, otime, ntime, 100.0 * (otime - ntime) / otime});
                    this.checkDatasets(a, dv, c, d);
                    n *= 15;
                }
                ++i;
            }
            Random.seed((long)12735L);
            n = 32;
            TestUtils.verbosePrintf((String)"constant by %s, ", (Object[])new Object[]{dn});
            i = 0;
            while (i < 3) {
                block52: {
                    if (dtype < 100) {
                        a = Random.randn((int[])new int[]{n});
                        a.imultiply((Object)100);
                        a = a.cast(dtype);
                    } else {
                        aa = new Dataset[2];
                        j = 0;
                        while (j < 2) {
                            aa[j] = Random.randn((int[])new int[]{n}).imultiply((Object)100);
                            ++j;
                        }
                        a = DatasetUtils.cast((Dataset[])aa, (int)dtype);
                    }
                    start = -System.nanoTime();
                    try {
                        c = Maths.power((Object)dv, (Object)a);
                    }
                    catch (IllegalArgumentException e) {
                        TestUtils.verbosePrintf((String)"Could not perform this operation: ", (Object[])new Object[]{e.getMessage()});
                        ++eCount;
                        break block52;
                    }
                    ntime = (double)(start += System.nanoTime()) / (double)c.getSize();
                    d = DatasetFactory.zeros((Dataset)c);
                    start = -System.nanoTime();
                    ita = a.getIterator();
                    j = 0;
                    if (dtype == 7 || dtype == 8) {
                        is = d.getElementsPerItem();
                        while (ita.hasNext()) {
                            d.setObjectAbs(j, (Object)zv.pow((Complex)a.getObjectAbs(ita.index)));
                            j += is;
                        }
                    } else if (dtype < 100) {
                        while (ita.hasNext()) {
                            d.setObjectAbs(j++, (Object)Math.pow(dv, ((Number)a.getObjectAbs(ita.index)).doubleValue()));
                        }
                    } else {
                        answer = new double[2];
                        while (ita.hasNext()) {
                            k = 0;
                            while (k < 2) {
                                answer[k] = Math.pow(dv, a.getElementDoubleAbs(ita.index + k));
                                ++k;
                            }
                            d.setObjectAbs(j, (Object)answer);
                            j += 2;
                        }
                    }
                    if (d == null) continue block6;
                    otime = (double)(start += System.nanoTime()) / (double)d.getSize();
                    TestUtils.verbosePrintf((String)"Time taken by pow for %s: %s; %s (%.1f%%)\n", (Object[])new Object[]{n, otime, ntime, 100.0 * (otime - ntime) / otime});
                    this.checkDatasets(dv, a, c, d);
                    n *= 15;
                }
                ++i;
            }
        }
        if (eCount > 0) {
            TestUtils.verbosePrintf((String)"Number of exceptions caught: %d\n", (Object[])new Object[]{eCount});
        }
    }

    @Test
    public void testDifference() {
        int[] nArray = new int[6];
        nArray[1] = 1;
        nArray[2] = 3;
        nArray[3] = 9;
        nArray[4] = 5;
        nArray[5] = 10;
        int[] data = nArray;
        Dataset a = DatasetFactory.createFromObject((Object)data);
        Dataset d = Maths.difference((Dataset)a, (int)1, (int)-1);
        int[] tdata = new int[]{1, 2, 6, -4, 5};
        Dataset ta = DatasetFactory.createFromObject((Object)tdata);
        this.checkDatasets(null, null, d, ta);
        Slice[] slices = new Slice[]{new Slice(Integer.valueOf(3))};
        d = Maths.difference((Dataset)a.getSliceView(slices), (int)1, (int)-1);
        ta = Maths.difference((Dataset)a.getSlice(slices), (int)1, (int)-1);
        this.checkDatasets(null, null, d, ta);
        slices = new Slice[]{new Slice(Integer.valueOf(-2), null, Integer.valueOf(-1))};
        d = Maths.difference((Dataset)a.getSliceView(slices), (int)1, (int)-1);
        ta = Maths.difference((Dataset)a.getSlice(slices), (int)1, (int)-1);
        this.checkDatasets(null, null, d, ta);
        a = DatasetFactory.createFromObject(ComplexDoubleDataset.class, (Object)new double[]{0.0, 1.0, 2.0, 3.0, 4.0, 5.0}, (int[])new int[0]);
        d = Maths.difference((Dataset)a, (int)1, (int)-1);
        ta = DatasetFactory.createFromObject(ComplexDoubleDataset.class, (Object)new double[]{2.0, 2.0, 2.0, 2.0}, (int[])new int[0]);
        this.checkDatasets(null, null, d, ta);
        d = Maths.difference((Dataset)a.getSliceView(slices), (int)1, (int)-1);
        ta = Maths.difference((Dataset)a.getSlice(slices), (int)1, (int)-1);
        this.checkDatasets(null, null, d, ta);
        a = DatasetFactory.createFromObject((int)2, CompoundDoubleDataset.class, (Object)new double[]{0.0, 1.0, 2.0, 3.0, 4.0, 5.0}, (int[])new int[0]);
        d = Maths.difference((Dataset)a, (int)1, (int)-1);
        ta = DatasetFactory.createFromObject((int)2, CompoundDoubleDataset.class, (Object)new double[]{2.0, 2.0, 2.0, 2.0}, (int[])new int[0]);
        this.checkDatasets(null, null, d, ta);
        d = Maths.difference((Dataset)a.getSliceView(slices), (int)1, (int)-1);
        ta = Maths.difference((Dataset)a.getSlice(slices), (int)1, (int)-1);
        this.checkDatasets(null, null, d, ta);
        byte[] byArray = new byte[6];
        byArray[1] = 1;
        byArray[2] = 2;
        byArray[3] = 4;
        byArray[4] = 7;
        byArray[5] = 11;
        a = DatasetFactory.createFromObject((Object)byArray);
        d = Maths.difference((Dataset)a, (int)2, (int)-1);
        byte[] byArray2 = new byte[4];
        byArray2[1] = 1;
        byArray2[2] = 1;
        byArray2[3] = 1;
        ta = DatasetFactory.createFromObject((Object)byArray2);
        this.checkDatasets(null, null, d, ta);
        d = Maths.difference((Dataset)a.getSliceView(slices), (int)2, (int)-1);
        ta = Maths.difference((Dataset)a.getSlice(slices), (int)2, (int)-1);
        this.checkDatasets(null, null, d, ta);
        short[] sArray = new short[8];
        sArray[1] = 1;
        sArray[2] = 2;
        sArray[3] = 3;
        sArray[4] = 4;
        sArray[5] = 5;
        sArray[6] = 7;
        sArray[7] = 6;
        a = DatasetFactory.createFromObject((int)2, CompoundShortDataset.class, (Object)sArray, (int[])new int[0]);
        d = Maths.difference((Dataset)a, (int)2, (int)-1);
        short[] sArray2 = new short[4];
        sArray2[2] = 1;
        sArray2[3] = -1;
        ta = DatasetFactory.createFromObject((int)2, CompoundShortDataset.class, (Object)sArray2, (int[])new int[0]);
        this.checkDatasets(null, null, d, ta);
        d = Maths.difference((Dataset)a.getSliceView(slices), (int)2, (int)-1);
        ta = Maths.difference((Dataset)a.getSlice(slices), (int)2, (int)-1);
        this.checkDatasets(null, null, d, ta);
        a = DatasetFactory.createFromObject((int)2, CompoundDoubleDataset.class, (Object)new double[]{0.0, 1.0, 2.0, 3.0, 4.0, 5.0, 7.0, 6.0}, (int[])new int[0]);
        d = Maths.difference((Dataset)a, (int)2, (int)-1);
        ta = DatasetFactory.createFromObject((int)2, CompoundDoubleDataset.class, (Object)new double[]{0.0, 0.0, 1.0, -1.0}, (int[])new int[0]);
        this.checkDatasets(null, null, d, ta);
        d = Maths.difference((Dataset)a.getSliceView(slices), (int)2, (int)-1);
        ta = Maths.difference((Dataset)a.getSlice(slices), (int)2, (int)-1);
        this.checkDatasets(null, null, d, ta);
    }

    @Test
    public void testGradient() {
        double[] data = new double[]{1.0, 2.0, 4.0, 7.0, 11.0, 16.0};
        Dataset a = DatasetFactory.createFromObject((Object)data);
        Dataset d = (Dataset)Maths.gradient((Dataset)a, (Dataset[])new Dataset[0]).get(0);
        double[] tdata = new double[]{1.0, 1.5, 2.5, 3.5, 4.5, 5.0};
        Dataset ta = DatasetFactory.createFromObject((Object)tdata);
        this.checkDatasets(null, null, d, ta);
        Slice[] slices = new Slice[]{new Slice(Integer.valueOf(3))};
        d = (Dataset)Maths.gradient((Dataset)a.getSliceView(slices), (Dataset[])new Dataset[0]).get(0);
        ta = (Dataset)Maths.gradient((Dataset)a.getSlice(slices), (Dataset[])new Dataset[0]).get(0);
        this.checkDatasets(null, null, d, ta);
        Dataset b = DatasetFactory.createRange((double)a.getShape()[0], (int)a.getDType());
        b.imultiply((Object)2);
        tdata = new double[]{0.5, 0.75, 1.25, 1.75, 2.25, 2.5};
        ta = DatasetFactory.createFromObject((Object)tdata);
        d = (Dataset)Maths.gradient((Dataset)a, (Dataset[])new Dataset[]{b}).get(0);
        this.checkDatasets(null, null, d, ta);
        d = (Dataset)Maths.gradient((Dataset)a.getSliceView(slices), (Dataset[])new Dataset[]{b.getSliceView(slices)}).get(0);
        ta = (Dataset)Maths.gradient((Dataset)a.getSlice(slices), (Dataset[])new Dataset[]{b.getSlice(slices)}).get(0);
        this.checkDatasets(null, null, d, ta);
        data = new double[]{1.0, 2.0, 6.0, 3.0, 4.0, 5.0};
        a = DatasetFactory.createFromObject((Object)data, (int[])new int[]{2, 3});
        List l = Maths.gradient((Dataset)a, (Dataset[])new Dataset[0]);
        tdata = new double[]{2.0, 2.0, -1.0, 2.0, 2.0, -1.0};
        ta = DatasetFactory.createFromObject((Object)tdata, (int[])new int[]{2, 3});
        this.checkDatasets(null, null, (Dataset)l.get(0), ta);
        tdata = new double[]{1.0, 2.5, 4.0, 1.0, 1.0, 1.0};
        ta = DatasetFactory.createFromObject((Object)tdata, (int[])new int[]{2, 3});
        this.checkDatasets(null, null, (Dataset)l.get(1), ta);
        b = DatasetFactory.createRange((double)a.getShape()[0], (int)a.getDType());
        b.imultiply((Object)2);
        Dataset c = DatasetFactory.createRange((double)a.getShape()[1], (int)a.getDType());
        c.imultiply((Object)-1.5);
        l = Maths.gradient((Dataset)a, (Dataset[])new Dataset[]{b, c});
        tdata = new double[]{2.0, 2.0, -1.0, 2.0, 2.0, -1.0};
        ta = DatasetFactory.createFromObject((Object)tdata, (int[])new int[]{2, 3});
        ta.idivide((Object)2);
        this.checkDatasets(null, null, (Dataset)l.get(0), ta);
        tdata = new double[]{1.0, 2.5, 4.0, 1.0, 1.0, 1.0};
        ta = DatasetFactory.createFromObject((Object)tdata, (int[])new int[]{2, 3});
        ta.idivide((Object)-1.5);
        this.checkDatasets(null, null, (Dataset)l.get(1), ta);
        byte[] byArray = new byte[6];
        byArray[1] = 1;
        byArray[2] = 2;
        byArray[3] = 4;
        byArray[4] = 7;
        byArray[5] = 11;
        a = DatasetFactory.createFromObject((Object)byArray);
        d = (Dataset)Maths.gradient((Dataset)a, (Dataset[])new Dataset[0]).get(0);
        ta = DatasetFactory.createFromObject((Object)new byte[]{1, 1, 1, 2, 3, 4});
        this.checkDatasets(null, null, d, ta);
        slices = new Slice[]{new Slice(Integer.valueOf(-2), null, Integer.valueOf(-1))};
        d = (Dataset)Maths.gradient((Dataset)a.getSliceView(slices), (Dataset[])new Dataset[0]).get(0);
        ta = (Dataset)Maths.gradient((Dataset)a.getSlice(slices), (Dataset[])new Dataset[0]).get(0);
        this.checkDatasets(null, null, d, ta);
        a = DatasetFactory.createFromObject(ComplexDoubleDataset.class, (Object)new double[]{0.0, 1.0, 2.0, 3.0, 4.0, 5.0}, (int[])new int[0]);
        d = (Dataset)Maths.gradient((Dataset)a, (Dataset[])new Dataset[0]).get(0);
        ta = DatasetFactory.createFromObject(ComplexDoubleDataset.class, (Object)new double[]{2.0, 2.0, 2.0, 2.0, 2.0, 2.0}, (int[])new int[0]);
        this.checkDatasets(null, null, d, ta);
        d = (Dataset)Maths.gradient((Dataset)a.getSliceView(slices), (Dataset[])new Dataset[0]).get(0);
        ta = (Dataset)Maths.gradient((Dataset)a.getSlice(slices), (Dataset[])new Dataset[0]).get(0);
        this.checkDatasets(null, null, d, ta);
        short[] sArray = new short[8];
        sArray[1] = 1;
        sArray[2] = 2;
        sArray[3] = 3;
        sArray[4] = 4;
        sArray[5] = 5;
        sArray[6] = 7;
        sArray[7] = 6;
        a = DatasetFactory.createFromObject((int)2, CompoundShortDataset.class, (Object)sArray, (int[])new int[0]);
        d = (Dataset)Maths.gradient((Dataset)a, (Dataset[])new Dataset[0]).get(0);
        ta = DatasetFactory.createFromObject((int)2, CompoundShortDataset.class, (Object)new short[]{2, 2, 2, 2, 2, 1, 3, 1}, (int[])new int[0]);
        this.checkDatasets(null, null, d, ta);
        d = (Dataset)Maths.gradient((Dataset)a.getSliceView(slices), (Dataset[])new Dataset[0]).get(0);
        ta = (Dataset)Maths.gradient((Dataset)a.getSlice(slices), (Dataset[])new Dataset[0]).get(0);
        this.checkDatasets(null, null, d, ta);
        a = DatasetFactory.createFromObject((int)2, CompoundDoubleDataset.class, (Object)new double[]{0.0, 1.0, 2.0, 3.0, 4.0, 5.0, 7.0, 6.0}, (int[])new int[0]);
        d = (Dataset)Maths.gradient((Dataset)a, (Dataset[])new Dataset[0]).get(0);
        ta = DatasetFactory.createFromObject((int)2, CompoundDoubleDataset.class, (Object)new double[]{2.0, 2.0, 2.0, 2.0, 2.5, 1.5, 3.0, 1.0}, (int[])new int[0]);
        this.checkDatasets(null, null, d, ta);
        d = (Dataset)Maths.gradient((Dataset)a.getSliceView(slices), (Dataset[])new Dataset[0]).get(0);
        ta = (Dataset)Maths.gradient((Dataset)a.getSlice(slices), (Dataset[])new Dataset[0]).get(0);
        this.checkDatasets(null, null, d, ta);
    }

    @Test
    public void testRounding() {
        double tol = 1.0E-6;
        double[] val = new double[]{-1.7, -1.5, -1.2, 0.3, 1.4, 1.5, 1.6};
        DoubleDataset t = (DoubleDataset)DatasetFactory.createFromObject(DoubleDataset.class, (Object)val, (int[])new int[0]);
        double[] resFloor = new double[]{-2.0, -2.0, -2.0, 0.0, 1.0, 1.0, 1.0};
        DoubleDataset x = (DoubleDataset)Maths.floor((Object)t);
        int i = 0;
        int imax = t.getSize();
        while (i < imax) {
            Assert.assertEquals((double)resFloor[i], (double)x.get(i), (double)tol);
            ++i;
        }
        double[] resCeil = new double[]{-1.0, -1.0, -1.0, 1.0, 2.0, 2.0, 2.0};
        x = (DoubleDataset)Maths.ceil((Object)t);
        int i2 = 0;
        int imax2 = t.getSize();
        while (i2 < imax2) {
            Assert.assertEquals((double)resCeil[i2], (double)x.get(i2), (double)tol);
            ++i2;
        }
        double[] resRint = new double[]{-2.0, -2.0, -1.0, 0.0, 1.0, 2.0, 2.0};
        x = (DoubleDataset)Maths.rint((Object)t);
        int i3 = 0;
        int imax3 = t.getSize();
        while (i3 < imax3) {
            Assert.assertEquals((double)resRint[i3], (double)x.get(i3), (double)tol);
            ++i3;
        }
    }

    private void checkInterpolate(Dataset a, double x) {
        int s = a.getShapeRef()[0];
        double v = Maths.interpolate((Dataset)a, (double[])new double[]{x});
        if (x <= -1.0 || x >= (double)s) {
            Assert.assertEquals((double)0.0, (double)v, (double)1.0E-15);
            return;
        }
        int i = (int)Math.floor(x);
        double f1 = 0.0;
        double f2 = 0.0;
        double t = x - (double)i;
        if (x < 0.0) {
            f2 = a.getDouble(0);
        } else if (x >= (double)(s - 1)) {
            f1 = a.getDouble(i);
        } else {
            f1 = a.getDouble(i);
            f2 = a.getDouble(i + 1);
        }
        Assert.assertEquals((double)((1.0 - t) * f1 + t * f2), (double)v, (double)1.0E-15);
    }

    private void checkInterpolate2(Dataset a, double x) {
        int s = a.getShapeRef()[0];
        Dataset xa = DatasetFactory.createRange((double)s, (int)6);
        double a1 = this.checkInterpolate2(xa, a, x, false);
        xa = DatasetFactory.createRange((double)(s - 1), (double)-1.0, (double)-1.0, (int)6);
        double a2 = this.checkInterpolate2(xa.getSliceView(new Slice[]{new Slice(null, null, Integer.valueOf(-1))}), a, x, false);
        TestUtils.assertEquals((String)"Flipped x - but reflipped", (double)a1, (double)a2);
        a2 = this.checkInterpolate2(xa, a.getSliceView(new Slice[]{new Slice(null, null, Integer.valueOf(-1))}), x, true);
        TestUtils.assertEquals((String)"Flipped x and flipped a", (double)a1, (double)a2);
        try {
            Random.seed((int)1231);
            xa = Random.randint((int)0, (int)s, (int[])a.getShapeRef());
            this.checkInterpolate2(xa, a, x, false);
            Assert.fail((String)"No exception raised");
        }
        catch (IllegalArgumentException illegalArgumentException) {
        }
        catch (Exception exception) {
            Assert.fail((String)"Wrong exception raised");
        }
    }

    private double checkInterpolate2(Dataset xa, Dataset a, double x, boolean isXaReversed) {
        int s = a.getShapeRef()[0];
        Dataset dv = Maths.interpolate((Dataset)xa, (Dataset)a, (IDataset)DatasetFactory.createFromObject((Object)x), null, null);
        double v = dv.getElementDoubleAbs(0);
        if (x <= -1.0 || x >= (double)s) {
            Assert.assertEquals((double)0.0, (double)v, (double)1.0E-15);
            return v;
        }
        int i = (int)Math.floor(x);
        double f1 = 0.0;
        double f2 = 0.0;
        double t = x - (double)i;
        if (x < 0.0) {
            f2 = a.getDouble(isXaReversed ? s - 1 : 0);
        } else if (x >= (double)(s - 1)) {
            f1 = a.getDouble(isXaReversed ? 0 : s - 1);
        } else if (isXaReversed) {
            i = s - 1 - i;
            f1 = a.getDouble(i);
            f2 = a.getDouble(i - 1);
        } else {
            f1 = a.getDouble(i);
            f2 = a.getDouble(i + 1);
        }
        Assert.assertEquals((double)((1.0 - t) * f1 + t * f2), (double)v, (double)1.0E-15);
        return v;
    }

    private void checkInterpolate3(Dataset a, double x) {
        int s = a.getShapeRef()[0];
        Dataset dv = Maths.interpolate((Dataset)DatasetFactory.createRange((double)s, (int)3), (Dataset)a, (IDataset)DatasetFactory.createFromObject((Object)x), (Number)0, (Number)0);
        double v = dv.getElementDoubleAbs(0);
        if (x <= -1.0 || x >= (double)s) {
            Assert.assertEquals((double)0.0, (double)v, (double)1.0E-15);
            return;
        }
        int i = (int)Math.floor(x);
        double f1 = 0.0;
        double f2 = 0.0;
        double t = x - (double)i;
        if (!(x < 0.0) && !(x > (double)(s - 1))) {
            if (x == (double)(s - 1)) {
                f1 = a.getDouble(i);
            } else {
                f1 = a.getDouble(i);
                f2 = a.getDouble(i + 1);
            }
        }
        Assert.assertEquals((double)((1.0 - t) * f1 + t * f2), (double)v, (double)1.0E-15);
    }

    private void checkInterpolateArray(CompoundDataset a, double x) {
        int s = a.getShapeRef()[0];
        int is = a.getElementsPerItem();
        double[] v = new double[is];
        Maths.interpolate((double[])v, (CompoundDataset)a, (double)x);
        int i = (int)Math.floor(x);
        double[] e = new double[is];
        double[] f1 = new double[is];
        double[] f2 = new double[is];
        if (!(x <= -1.0) && !(x >= (double)s)) {
            if (x < 0.0) {
                a.getDoubleArray(f2, 0);
            } else if (x >= (double)(s - 1)) {
                a.getDoubleArray(f1, s - 1);
            } else {
                a.getDoubleArray(f1, i);
                a.getDoubleArray(f2, i + 1);
            }
        }
        double t = x - (double)i;
        int j = 0;
        while (j < is) {
            e[j] = (1.0 - t) * f1[j] + t * f2[j];
            ++j;
        }
        Assert.assertArrayEquals((double[])e, (double[])v, (double)1.0E-15);
    }

    private void checkInterpolate(Dataset a, double x, double y) {
        int s0 = a.getShapeRef()[0];
        int s1 = a.getShapeRef()[1];
        double v = Maths.interpolate((Dataset)a, (double[])new double[]{x, y});
        if (x <= -1.0 || x >= (double)s0 || y <= -1.0 || y >= (double)s1) {
            Assert.assertEquals((double)0.0, (double)v, (double)1.0E-15);
            return;
        }
        int i = (int)Math.floor(x);
        int j = (int)Math.floor(y);
        double t1 = x - (double)i;
        double t2 = y - (double)j;
        double f1 = 0.0;
        double f2 = 0.0;
        double f3 = 0.0;
        double f4 = 0.0;
        if (y < 0.0) {
            if (x < 0.0) {
                f4 = a.getDouble(0, 0);
            } else if (x >= (double)(s0 - 1)) {
                f3 = a.getDouble(s0 - 1, 0);
            } else {
                f3 = a.getDouble(i, 0);
                f4 = a.getDouble(i + 1, 0);
            }
        } else if (y >= (double)(s1 - 1)) {
            if (x < 0.0) {
                f2 = a.getDouble(0, s1 - 1);
            } else if (x >= (double)(s0 - 1)) {
                f1 = a.getDouble(s0 - 1, s1 - 1);
            } else {
                f1 = a.getDouble(i, s1 - 1);
                f2 = a.getDouble(i + 1, s1 - 1);
            }
        } else if (x < 0.0) {
            f2 = a.getDouble(0, j);
            f4 = a.getDouble(0, j + 1);
        } else if (x >= (double)(s0 - 1)) {
            f1 = a.getDouble(s0 - 1, j);
            f3 = a.getDouble(s0 - 1, j + 1);
        } else {
            f1 = a.getDouble(i, j);
            f2 = a.getDouble(i + 1, j);
            f3 = a.getDouble(i, j + 1);
            f4 = a.getDouble(i + 1, j + 1);
        }
        double r = (1.0 - t1) * (1.0 - t2) * f1 + t1 * (1.0 - t2) * f2 + (1.0 - t1) * t2 * f3 + t1 * t2 * f4;
        Assert.assertEquals((double)r, (double)v, (double)1.0E-15);
        v = Maths.interpolate((Dataset)a, (Dataset)DatasetFactory.ones((Dataset)a), (double)x, (double)y);
        Assert.assertEquals((double)r, (double)v, (double)1.0E-15);
    }

    private void checkInterpolateArray(CompoundDataset a, double x, double y) {
        int s0 = a.getShapeRef()[0];
        int s1 = a.getShapeRef()[1];
        int is = a.getElementsPerItem();
        double[] v = new double[is];
        Maths.interpolate((double[])v, (CompoundDataset)a, (double)x, (double)y);
        if (x <= -1.0 || x >= (double)s0 || y <= -1.0 || y >= (double)s1) {
            Assert.assertArrayEquals((double[])new double[is], (double[])v, (double)1.0E-15);
            return;
        }
        double[] f1 = new double[is];
        double[] f2 = new double[is];
        double[] f3 = new double[is];
        double[] f4 = new double[is];
        int i = (int)Math.floor(x);
        int j = (int)Math.floor(y);
        double t1 = x - (double)i;
        double t2 = y - (double)j;
        if (y < 0.0) {
            if (x < 0.0) {
                a.getDoubleArray(f4, 0, 0);
            } else if (x >= (double)(s0 - 1)) {
                a.getDoubleArray(f3, s0 - 1, 0);
            } else {
                a.getDoubleArray(f3, i, 0);
                a.getDoubleArray(f4, i + 1, 0);
            }
        } else if (y >= (double)(s1 - 1)) {
            if (x < 0.0) {
                a.getDoubleArray(f2, 0, s1 - 1);
            } else if (x >= (double)(s0 - 1)) {
                a.getDoubleArray(f1, s0 - 1, s1 - 1);
            } else {
                a.getDoubleArray(f1, i, s1 - 1);
                a.getDoubleArray(f2, i + 1, s1 - 1);
            }
        } else if (x < 0.0) {
            a.getDoubleArray(f2, 0, j);
            a.getDoubleArray(f4, 0, j + 1);
        } else if (x >= (double)(s0 - 1)) {
            a.getDoubleArray(f1, s0 - 1, j);
            a.getDoubleArray(f3, s0 - 1, j + 1);
        } else {
            a.getDoubleArray(f1, i, j);
            a.getDoubleArray(f2, i + 1, j);
            a.getDoubleArray(f3, i, j + 1);
            a.getDoubleArray(f4, i + 1, j + 1);
        }
        j = 0;
        while (j < is) {
            f1[j] = (1.0 - t1) * (1.0 - t2) * f1[j] + t1 * (1.0 - t2) * f2[j] + (1.0 - t1) * t2 * f3[j] + t1 * t2 * f4[j];
            ++j;
        }
        Assert.assertArrayEquals((double[])f1, (double[])v, (double)1.0E-15);
    }

    @Test
    public void testLinearInterpolation() {
        double y;
        int n;
        int n2;
        double[] dArray;
        double[] xc;
        Dataset xa = DatasetFactory.createRange((double)60.0, (int)3);
        xa.iadd((Object)1);
        double[] dArray2 = xc = new double[]{-1.25, -1.0, -0.25, 0.0, 0.25, 58.25, 59.0, 59.25, 60.0, 60.25};
        int n3 = xc.length;
        int n4 = 0;
        while (n4 < n3) {
            double x = dArray2[n4];
            this.checkInterpolate(xa, x);
            this.checkInterpolate2(xa, x);
            this.checkInterpolate3(xa, x);
            ++n4;
        }
        Dataset xb = DatasetFactory.createRange((double)120.0, (int)3);
        xb.setShape(new int[]{60, 2});
        xb.ifloorDivide((Object)2);
        xb = DatasetUtils.createCompoundDatasetFromLastAxis((Dataset)xb, (boolean)true);
        double[] dArray3 = xc;
        int n5 = xc.length;
        n3 = 0;
        while (n3 < n5) {
            double x = dArray3[n3];
            this.checkInterpolate(xb, x);
            this.checkInterpolate2(xb, x);
            this.checkInterpolate3(xb, x);
            ++n3;
        }
        TestUtils.assertDatasetEquals((Dataset)Maths.interpolate((Dataset)DatasetFactory.createFromObject((Object)new double[]{1.0, 2.0, 3.0}), (Dataset)DatasetFactory.createFromObject((Object)new double[]{3.0, 2.0, 0.0}), (IDataset)DatasetFactory.createFromObject((Object)new double[]{0.0, 1.0, 1.5, 2.72, 3.14}), (Number)3, (Number)0), (Dataset)DatasetFactory.createFromObject((Object)new double[]{3.0, 3.0, 2.5, 0.56, 0.0}));
        CompoundDataset cxb = (CompoundDataset)xb;
        double[] dArray4 = xc;
        int n6 = xc.length;
        n5 = 0;
        while (n5 < n6) {
            double x = dArray4[n5];
            this.checkInterpolateArray(cxb, x);
            ++n5;
        }
        xa.setShape(new int[]{6, 10});
        xc = new double[]{-1.25, -1.0, -0.25, 0.0, 0.25, 5.25, 6.0, 6.25, 7.0};
        double[] yc = new double[]{-1.25, -1.0, -0.25, 0.0, 0.25, 8.25, 9.0, 9.25, 10.0, 10.25};
        double[] dArray5 = xc;
        int n7 = xc.length;
        n6 = 0;
        while (n6 < n7) {
            double x = dArray5[n6];
            dArray = yc;
            n2 = yc.length;
            n = 0;
            while (n < n2) {
                y = dArray[n];
                this.checkInterpolate(xa, x, y);
                ++n;
            }
            ++n6;
        }
        cxb.setShape(new int[]{6, 10});
        dArray5 = xc;
        n7 = xc.length;
        n6 = 0;
        while (n6 < n7) {
            double x = dArray5[n6];
            dArray = yc;
            n2 = yc.length;
            n = 0;
            while (n < n2) {
                y = dArray[n];
                this.checkInterpolateArray(cxb, x, y);
                ++n;
            }
            ++n6;
        }
    }

    @Test
    public void testBitwise() {
        Dataset xa = DatasetFactory.createRange((double)-4.0, (double)4.0, (double)1.0, (int)1);
        Dataset xb = DatasetFactory.createRange((double)8.0, (int)1);
        byte[] byArray = new byte[8];
        byArray[1] = 1;
        byArray[2] = 2;
        byArray[3] = 3;
        byArray[5] = 1;
        byArray[6] = 2;
        byArray[7] = 3;
        TestUtils.assertDatasetEquals((Dataset)DatasetFactory.createFromObject((Object)byArray), (Dataset)Maths.bitwiseAnd((Object)xa, (Object)xb), (double)1.0E-8, (double)1.0E-8);
        TestUtils.assertDatasetEquals((Dataset)DatasetFactory.createFromObject((Object)new byte[]{-4, -3, -2, -1, 4, 5, 6, 7}), (Dataset)Maths.bitwiseOr((Object)xa, (Object)xb), (double)1.0E-8, (double)1.0E-8);
        TestUtils.assertDatasetEquals((Dataset)DatasetFactory.createFromObject((Object)new byte[]{-4, -4, -4, -4, 4, 4, 4, 4}), (Dataset)Maths.bitwiseXor((Object)xa, (Object)xb), (double)1.0E-8, (double)1.0E-8);
        byte[] byArray2 = new byte[8];
        byArray2[0] = 3;
        byArray2[1] = 2;
        byArray2[2] = 1;
        byArray2[4] = -1;
        byArray2[5] = -2;
        byArray2[6] = -3;
        byArray2[7] = -4;
        TestUtils.assertDatasetEquals((Dataset)DatasetFactory.createFromObject((Object)byArray2), (Dataset)Maths.bitwiseInvert((Object)xa), (double)1.0E-8, (double)1.0E-8);
        TestUtils.assertDatasetEquals((Dataset)DatasetFactory.createFromObject((Object)new byte[]{-1, -2, -3, -4, -5, -6, -7, -8}), (Dataset)Maths.bitwiseInvert((Object)xb), (double)1.0E-8, (double)1.0E-8);
        byte[] byArray3 = new byte[8];
        byArray3[0] = -4;
        byArray3[1] = -6;
        byArray3[2] = -8;
        byArray3[3] = -8;
        byArray3[5] = 32;
        byArray3[6] = -128;
        byArray3[7] = -128;
        TestUtils.assertDatasetEquals((Dataset)DatasetFactory.createFromObject((Object)byArray3), (Dataset)Maths.leftShift((Object)xa, (Object)xb), (double)1.0E-8, (double)1.0E-8);
        byte[] byArray4 = new byte[8];
        byArray4[4] = 4;
        byArray4[5] = 10;
        byArray4[6] = 24;
        byArray4[7] = 56;
        TestUtils.assertDatasetEquals((Dataset)DatasetFactory.createFromObject((Object)byArray4), (Dataset)Maths.leftShift((Object)xb, (Object)xa), (double)1.0E-8, (double)1.0E-8);
        byte[] byArray5 = new byte[8];
        byArray5[5] = 2;
        byArray5[6] = 8;
        byArray5[7] = 24;
        TestUtils.assertDatasetEquals((Dataset)DatasetFactory.createFromObject((Object)byArray5), (Dataset)Maths.leftShift((Object)xa, (Object)xa), (double)1.0E-8, (double)1.0E-8);
        byte[] byArray6 = new byte[8];
        byArray6[0] = -4;
        byArray6[1] = -2;
        byArray6[2] = -1;
        byArray6[3] = -1;
        TestUtils.assertDatasetEquals((Dataset)DatasetFactory.createFromObject((Object)byArray6), (Dataset)Maths.rightShift((Object)xa, (Object)xb), (double)1.0E-8, (double)1.0E-8);
        byte[] byArray7 = new byte[8];
        byArray7[4] = 4;
        byArray7[5] = 2;
        byArray7[6] = 1;
        TestUtils.assertDatasetEquals((Dataset)DatasetFactory.createFromObject((Object)byArray7), (Dataset)Maths.rightShift((Object)xb, (Object)xa), (double)1.0E-8, (double)1.0E-8);
        byte[] byArray8 = new byte[8];
        byArray8[0] = -1;
        byArray8[1] = -1;
        byArray8[2] = -1;
        byArray8[3] = -1;
        TestUtils.assertDatasetEquals((Dataset)DatasetFactory.createFromObject((Object)byArray8), (Dataset)Maths.rightShift((Object)xa, (Object)xa), (double)1.0E-8, (double)1.0E-8);
        byte[] byArray9 = new byte[8];
        byArray9[0] = -4;
        byArray9[1] = 126;
        byArray9[2] = 63;
        byArray9[3] = 31;
        TestUtils.assertDatasetEquals((Dataset)DatasetFactory.createFromObject((Object)byArray9), (Dataset)Maths.unsignedRightShift((Object)xa, (Object)xb), (double)1.0E-8, (double)1.0E-8);
        byte[] byArray10 = new byte[8];
        byArray10[4] = 4;
        byArray10[5] = 2;
        byArray10[6] = 1;
        TestUtils.assertDatasetEquals((Dataset)DatasetFactory.createFromObject((Object)byArray10), (Dataset)Maths.unsignedRightShift((Object)xb, (Object)xa), (double)1.0E-8, (double)1.0E-8);
        TestUtils.assertDatasetEquals((Dataset)DatasetFactory.createFromObject((Object)new byte[8]), (Dataset)Maths.unsignedRightShift((Object)xa, (Object)xa), (double)1.0E-8, (double)1.0E-8);
    }

    @Test
    public void testDivideTowardsFloor() {
        Dataset xa = DatasetFactory.createRange((double)-4.0, (double)4.0, (double)1.0, (int)1);
        byte[] byArray = new byte[8];
        byArray[0] = -2;
        byArray[1] = -2;
        byArray[2] = -1;
        byArray[3] = -1;
        byArray[6] = 1;
        byArray[7] = 1;
        TestUtils.assertDatasetEquals((Dataset)DatasetFactory.createFromObject((Object)byArray), (Dataset)Maths.divideTowardsFloor((Object)xa, (Object)2), (boolean)true, (double)1.0E-8, (double)1.0E-8);
        byte[] byArray2 = new byte[8];
        byArray2[0] = 2;
        byArray2[1] = 1;
        byArray2[2] = 1;
        byArray2[5] = -1;
        byArray2[6] = -1;
        byArray2[7] = -2;
        TestUtils.assertDatasetEquals((Dataset)DatasetFactory.createFromObject((Object)byArray2), (Dataset)Maths.divideTowardsFloor((Object)xa, (Object)-2), (boolean)true, (double)1.0E-8, (double)1.0E-8);
        TestUtils.assertDatasetEquals((Dataset)DatasetFactory.createFromObject((Object)new double[]{-1.6, -1.2, -0.8, -0.4, 0.0, 0.4, 0.8, 1.2}), (Dataset)Maths.divideTowardsFloor((Object)xa, (Object)2.5), (boolean)true, (double)1.0E-8, (double)1.0E-8);
        TestUtils.assertDatasetEquals((Dataset)DatasetFactory.createFromObject((Object)new float[]{1.6f, 1.2f, 0.8f, 0.4f, 0.0f, -0.4f, -0.8f, -1.2f}), (Dataset)Maths.divideTowardsFloor((Object)xa, (Object)Float.valueOf(-2.5f)), (boolean)true, (double)1.0E-8, (double)1.0E-8);
    }

    @Test
    public void testFloorDivide() {
        Dataset xa = DatasetFactory.createRange((double)-4.0, (double)4.0, (double)1.0, (int)1);
        byte[] byArray = new byte[8];
        byArray[0] = -2;
        byArray[1] = -2;
        byArray[2] = -1;
        byArray[3] = -1;
        byArray[6] = 1;
        byArray[7] = 1;
        TestUtils.assertDatasetEquals((Dataset)DatasetFactory.createFromObject((Object)byArray), (Dataset)Maths.floorDivide((Object)xa, (Object)2), (boolean)true, (double)1.0E-8, (double)1.0E-8);
        byte[] byArray2 = new byte[8];
        byArray2[0] = 2;
        byArray2[1] = 1;
        byArray2[2] = 1;
        byArray2[5] = -1;
        byArray2[6] = -1;
        byArray2[7] = -2;
        TestUtils.assertDatasetEquals((Dataset)DatasetFactory.createFromObject((Object)byArray2), (Dataset)Maths.floorDivide((Object)xa, (Object)-2), (boolean)true, (double)1.0E-8, (double)1.0E-8);
        TestUtils.assertDatasetEquals((Dataset)DatasetFactory.createFromObject((Object)new double[]{-2.0, -2.0, -1.0, -1.0, 0.0, 0.0, 0.0, 1.0}), (Dataset)Maths.floorDivide((Object)xa, (Object)2.5), (boolean)true, (double)1.0E-8, (double)1.0E-8);
        TestUtils.assertDatasetEquals((Dataset)DatasetFactory.createFromObject((Object)new float[]{1.0f, 1.0f, 0.0f, 0.0f, 0.0f, -1.0f, -1.0f, -2.0f}), (Dataset)Maths.floorDivide((Object)xa, (Object)Float.valueOf(-2.5f)), (boolean)true, (double)1.0E-8, (double)1.0E-8);
    }

    @Test
    public void testFloorRemainder() {
        Dataset xa = DatasetFactory.createRange((double)-4.0, (double)4.0, (double)1.0, (int)1);
        byte[] byArray = new byte[8];
        byArray[1] = 1;
        byArray[3] = 1;
        byArray[5] = 1;
        byArray[7] = 1;
        TestUtils.assertDatasetEquals((Dataset)DatasetFactory.createFromObject((Object)byArray), (Dataset)Maths.floorRemainder((Object)xa, (Object)2), (boolean)true, (double)1.0E-8, (double)1.0E-8);
        byte[] byArray2 = new byte[8];
        byArray2[1] = -1;
        byArray2[3] = -1;
        byArray2[5] = -1;
        byArray2[7] = -1;
        TestUtils.assertDatasetEquals((Dataset)DatasetFactory.createFromObject((Object)byArray2), (Dataset)Maths.floorRemainder((Object)xa, (Object)-2), (boolean)true, (double)1.0E-8, (double)1.0E-8);
        TestUtils.assertDatasetEquals((Dataset)DatasetFactory.createFromObject((Object)new double[]{1.0, 2.0, 0.5, 1.5, 0.0, 1.0, 2.0, 0.5}), (Dataset)Maths.floorRemainder((Object)xa, (Object)2.5), (boolean)true, (double)1.0E-8, (double)1.0E-8);
        TestUtils.assertDatasetEquals((Dataset)DatasetFactory.createFromObject((Object)new float[]{-1.5f, -0.5f, -2.0f, -1.0f, 0.0f, -1.5f, -0.5f, -2.0f}), (Dataset)Maths.floorRemainder((Object)xa, (Object)Float.valueOf(-2.5f)), (boolean)true, (double)1.0E-8, (double)1.0E-8);
    }
}

