/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.kuksa.honoConnector;

import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.core.json.DecodeException;
import io.vertx.core.json.JsonObject;
import io.vertx.proton.ProtonClientOptions;
import java.io.UncheckedIOException;
import java.net.MalformedURLException;
import java.util.function.Function;
import org.apache.qpid.proton.message.Message;
import org.eclipse.hono.client.HonoClient;
import org.eclipse.hono.config.ClientConfigProperties;
import org.eclipse.hono.util.MessageHelper;
import org.eclipse.kuksa.honoConnector.config.ConnectionConfig;
import org.eclipse.kuksa.honoConnector.influxdb.InfluxDBClient;
import org.eclipse.kuksa.honoConnector.message.MessageDTO;
import org.eclipse.kuksa.honoConnector.message.MessageHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Exception performing whole class analysis ignored.
 */
public class HonoInfluxConnection {
    private static final Logger LOGGER = LoggerFactory.getLogger(HonoInfluxConnection.class);
    private final String tenantId;
    private final Vertx vertx;
    private final HonoClient honoClient;
    private final ProtonClientOptions options;
    private final MessageHandler messageHandler;
    private final Handler<AsyncResult<HonoClient>> connectionHandler;

    public HonoInfluxConnection(ClientConfigProperties honoConfig, String influxURL, ConnectionConfig config) throws MalformedURLException {
        this(honoConfig, influxURL, config.getTenantId(), config.getInfluxDatabaseName());
    }

    public HonoInfluxConnection(ClientConfigProperties honoConfig, String influxURL, String tenantId, String dbName) throws MalformedURLException {
        this.tenantId = tenantId;
        this.vertx = Vertx.vertx();
        this.honoClient = HonoClient.newClient((Vertx)this.vertx, (ClientConfigProperties)honoConfig);
        this.options = new ProtonClientOptions();
        this.options.setConnectTimeout(10000);
        this.messageHandler = new InfluxDBClient(influxURL, dbName);
        Handler closeHandler = x -> this.reconnect();
        this.connectionHandler = result -> {
            if (result.succeeded()) {
                LOGGER.info("Connected to Hono at {}:{} for tenantId {}", new Object[]{honoConfig.getHost(), honoConfig.getPort(), tenantId});
                this.honoClient.createTelemetryConsumer(tenantId, arg_0 -> this.handleTelemetryMessage(arg_0), closeHandler);
            } else {
                LOGGER.error("Failed to connect to Hono for tenantId {}.", (Object)result.cause(), (Object)tenantId);
                this.disconnect();
            }
        };
    }

    public void connectToHono() {
        try {
            Future future = this.honoClient.connect(this.options);
            LOGGER.info("Started connection attempt to Hono for tenantId {}.", (Object)this.tenantId);
            future.setHandler(this.connectionHandler);
        }
        catch (Exception e) {
            LOGGER.error("Failed to connect to Hono for tenantId {}.", (Object)e, (Object)this.tenantId);
        }
    }

    private void reconnect() {
        LOGGER.info("Reconnecting to Hono for tenantId {}", (Object)this.tenantId);
        this.connectToHono();
    }

    private void handleTelemetryMessage(Message msg) {
        if (msg == null) {
            LOGGER.debug("The received message from Hono is null.");
            return;
        }
        MessageDTO messageDTO = HonoInfluxConnection.createMessageDTO((Message)msg);
        LOGGER.debug(messageDTO.toString());
        this.messageHandler.process(messageDTO);
    }

    private static MessageDTO createMessageDTO(Message msg) {
        String deviceId = MessageHelper.getDeviceId((Message)msg);
        JsonObject json = new JsonObject();
        try {
            json = MessageHelper.getJsonPayload((Message)msg);
        }
        catch (DecodeException e) {
            LOGGER.warn("Failed to parse the message body to JSON.", (Throwable)e);
        }
        return new MessageDTO(deviceId, json.getMap());
    }

    public void disconnect() {
        LOGGER.warn("Hono connector for tenantId {} is closing connections to Hono and InfluxDB.", (Object)this.tenantId);
        this.messageHandler.close();
        this.vertx.close();
        LOGGER.info("Hono connector for tenantId {} closed all connections.", (Object)this.tenantId);
    }

    public static Function<ConnectionConfig, HonoInfluxConnection> toConnection(ClientConfigProperties honoConfig, String influxURL) {
        return connectionConfig -> {
            try {
                return new HonoInfluxConnection(honoConfig, influxURL, connectionConfig);
            }
            catch (MalformedURLException e) {
                throw new UncheckedIOException(e);
            }
        };
    }
}

