/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.kuksa.honoConnector;

import java.net.MalformedURLException;
import java.util.List;
import java.util.stream.Collectors;
import org.eclipse.hono.config.ClientConfigProperties;
import org.eclipse.kuksa.honoConnector.HonoInfluxConnection;
import org.eclipse.kuksa.honoConnector.config.ConfigProperties;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.ApplicationArguments;
import org.springframework.boot.ApplicationRunner;
import org.springframework.stereotype.Component;

/*
 * Exception performing whole class analysis ignored.
 */
@Component
class HonoInfluxConnector
implements ApplicationRunner {
    private final List<HonoInfluxConnection> connections;

    @Autowired
    public HonoInfluxConnector(@Value(value="${qpid.router.host}") String qpidRouterHost, @Value(value="${qpid.router.port}") int qpidRouterPort, @Value(value="${hono.user}") String honoUser, @Value(value="${hono.password}") String honoPassword, @Value(value="${hono.trustedStorePath}") String honoTrustedStorePath, @Value(value="${hono.verifyHostname}") boolean verifyHostname, @Value(value="${influxdb.url}") String influxURL, ConfigProperties configProperties) throws MalformedURLException {
        ClientConfigProperties honoConfig1 = new ClientConfigProperties();
        honoConfig1.setHost(qpidRouterHost);
        honoConfig1.setPort(qpidRouterPort);
        honoConfig1.setUsername(honoUser);
        honoConfig1.setPassword(honoPassword);
        honoConfig1.setTrustStorePath(honoTrustedStorePath);
        honoConfig1.setHostnameVerificationRequired(verifyHostname);
        ClientConfigProperties honoConfig = honoConfig1;
        this.connections = HonoInfluxConnector.connections((ClientConfigProperties)honoConfig, (String)influxURL, (ConfigProperties)configProperties);
    }

    private static List<HonoInfluxConnection> connections(ClientConfigProperties honoConfig, String influxURL, ConfigProperties configProperties) {
        return configProperties.getConnections().stream().map(HonoInfluxConnection.toConnection((ClientConfigProperties)honoConfig, (String)influxURL)).collect(Collectors.toList());
    }

    public void run(ApplicationArguments applicationArguments) {
        this.connections.stream().forEach(HonoInfluxConnection::connectToHono);
    }
}

