/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.kuksa.notification.mail;

import java.net.ConnectException;
import org.eclipse.kuksa.notification.mail.MailSender;
import org.eclipse.kuksa.notification.mail.config.Configuration;
import org.eclipse.kuksa.notification.mail.entity.Mail;
import org.eclipse.kuksa.notification.mail.smtp.SmtpSender;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class Controller {
    private static final Logger LOGGER = LoggerFactory.getLogger(Controller.class);
    private final MailSender sender;

    public Controller(Configuration config) throws ConnectException {
        this.sender = new SmtpSender(config.getSmtpConfig().getTransport(), config.getSmtpConfig().getHost(), config.getSmtpConfig().getPort(), config.getSmtpConfig().getUsername(), config.getSmtpConfig().getPassword(), config.getSenderConfig().getMail(), config.getSenderConfig().getName());
        if (!this.sender.testConnection()) {
            throw new ConnectException("Failed to connect to smtp server.");
        }
    }

    @PostMapping(value={"/send"})
    public ResponseEntity<String> send(@RequestBody Mail mail) {
        if (mail == null) {
            return ResponseEntity.badRequest().body((Object)"No email to send received.");
        }
        if (mail.getTo() == null || mail.getTo().isEmpty()) {
            return ResponseEntity.badRequest().body((Object)"The email needs at least one receiver.");
        }
        try {
            this.sender.sendEmail(mail);
            String message = "Successful sent email to " + mail.getTo().toString();
            LOGGER.info(message);
            return ResponseEntity.ok((Object)message);
        }
        catch (Exception e) {
            return ResponseEntity.status((HttpStatus)HttpStatus.INTERNAL_SERVER_ERROR).body((Object)e.getMessage());
        }
    }
}

