/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.kuksa.mil.service;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.google.maps.GeoApiContext;
import com.google.maps.NearbySearchRequest;
import com.google.maps.PlacesApi;
import com.google.maps.errors.ApiException;
import com.google.maps.model.LatLng;
import com.google.maps.model.PlacesSearchResponse;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collections;
import java.util.Objects;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import org.eclipse.kuksa.mil.service.Email;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.ApplicationArguments;
import org.springframework.boot.ApplicationRunner;
import org.springframework.stereotype.Component;

/*
 * Exception performing whole class analysis ignored.
 */
@Component
public class Oberserver
implements ApplicationRunner {
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();
    private static final int SLEEP_TIME = 5000;
    private static final int SLEEP_TIME_AFTER_SENT = 3600000;
    private static final Logger LOGGER = LoggerFactory.getLogger(Oberserver.class);
    private static final String SUBJECT = "no mails while driving...";
    private static final String MAPS_QUERY = "Werkstatt";
    private final URL influxUrl;
    private final URL mailUrl;
    private final String receiverAddress;
    private final String mapsKey;

    Oberserver(@Value(value="${influxDB.rest.url}") String influxUrl, @Value(value="${influxDB.rest.p}") int influxPort, @Value(value="${influxDB.rest.deviceID}") int deviceID, @Value(value="${mail.url}") String mailUrl, @Value(value="${mail.p}") int mailPort, @Value(value="${receiver.mail}") String receiverAddress, @Value(value="${maps.api.key}") String mapsKey) throws MalformedURLException {
        Objects.requireNonNull(influxUrl);
        Objects.requireNonNull(mailUrl);
        Objects.requireNonNull(receiverAddress);
        Objects.requireNonNull(mapsKey);
        this.influxUrl = new URL("http", influxUrl, influxPort, "/devices/" + deviceID);
        this.mailUrl = new URL("http", mailUrl, mailPort, "/send");
        this.receiverAddress = receiverAddress;
        this.mapsKey = mapsKey;
    }

    public void run(ApplicationArguments args) throws Exception {
        boolean status = true;
        int counter = 0;
        while (status) {
            block17: {
                try {
                    boolean success;
                    String json = Oberserver.query((URL)this.influxUrl);
                    JsonNode root = Oberserver.parseJson((String)json);
                    if (root.isNull() || !Oberserver.isMilActive((JsonNode)root)) break block17;
                    StringBuilder sb = new StringBuilder("<h1>Malfunction Indicator Light</h1>");
                    this.checkCoordinates(sb, root);
                    Email email = new Email(Collections.singletonList(this.receiverAddress), "no mails while driving...", sb.toString());
                    try (Response response = Oberserver.sendEmail((URL)this.mailUrl, (Email)email);){
                        success = response != null && response.isSuccessful();
                    }
                    if (success) {
                        LOGGER.info("Successfully sent an email to " + this.receiverAddress);
                        Thread.sleep(3600000L);
                        if (++counter >= 10) {
                            status = false;
                        }
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            Thread.sleep(5000L);
        }
        LOGGER.info("Shutting down...");
    }

    private void checkCoordinates(StringBuilder sb, JsonNode root) {
        double latitude;
        double longitude;
        JsonNode coordinates = Oberserver.getCoordinateNode((JsonNode)root);
        if (!Oberserver.validCoordinates((JsonNode)coordinates)) {
            LOGGER.warn("There are no coordinates available to use.");
            sb.append("<p>no coordinates available... still, see a garage soon.</p>");
            return;
        }
        String longString = coordinates.get("longitude").asText();
        String latString = coordinates.get("latitude").asText();
        try {
            longitude = Double.parseDouble(longString);
            latitude = Double.parseDouble(latString);
        }
        catch (NumberFormatException e) {
            LOGGER.warn("Invalid longitude {} and latitude {}", (Object)longString, (Object)latString);
            sb.append("<p>invalid coordinates... still, see a garage soon.</p>");
            return;
        }
        sb.append(this.findClosest(longitude, latitude));
    }

    private static JsonNode parseJson(String json) {
        try {
            return OBJECT_MAPPER.readTree(json);
        }
        catch (IOException e) {
            LOGGER.warn("Failed to parse json string: {}", (Object)json);
            e.printStackTrace();
            return JsonNodeFactory.instance.nullNode();
        }
    }

    private String findClosest(double longitude, double latitude) {
        GeoApiContext context = new GeoApiContext.Builder().apiKey(this.mapsKey).build();
        LatLng coordinates = new LatLng(latitude, longitude);
        NearbySearchRequest request = PlacesApi.nearbySearchQuery((GeoApiContext)context, (LatLng)coordinates);
        try {
            PlacesSearchResponse result = (PlacesSearchResponse)request.keyword("Werkstatt").radius(10000).await();
            if (result != null && result.results != null && result.results.length > 0) {
                return "<p>See your next garage " + result.results[0].name + " at " + result.results[0].vicinity + "</p>";
            }
        }
        catch (ApiException | IOException | InterruptedException e) {
            LOGGER.warn("Failed to query Google Maps for garages.");
            e.printStackTrace();
        }
        return "<p>no garages near you...</p>";
    }

    private static boolean validCoordinates(JsonNode coordinates) {
        return coordinates != null && coordinates.get("latitude") != null && coordinates.get("longitude") != null;
    }

    private static JsonNode getCoordinateNode(JsonNode root) {
        try {
            JsonNode navigation;
            JsonNode infotainment;
            JsonNode cabin;
            JsonNode signal;
            ArrayNode arrayNode;
            if (root != null && root.isArray() && (arrayNode = (ArrayNode)root).size() > 0 && (signal = arrayNode.get(0).get("signal")) != null && (cabin = signal.get("cabin")) != null && (infotainment = cabin.get("infotainment")) != null && (navigation = infotainment.get("navigation")) != null) {
                return navigation.get("currentLocation");
            }
        }
        catch (Exception e) {
            LOGGER.warn("Failed to parse json for location {}", (Object)e.getMessage());
        }
        return null;
    }

    private static Response sendEmail(URL url, Email email) {
        String json;
        try {
            json = OBJECT_MAPPER.writeValueAsString((Object)email);
        }
        catch (JsonProcessingException e) {
            e.printStackTrace();
            return null;
        }
        RequestBody body = RequestBody.create((MediaType)MediaType.parse((String)"application/json"), (String)json);
        Request request = new Request.Builder().url(url).post(body).build();
        OkHttpClient client = new OkHttpClient();
        try {
            return client.newCall(request).execute();
        }
        catch (IOException e) {
            LOGGER.error("Failed to send the email notification.");
            e.printStackTrace();
            return null;
        }
    }

    private static boolean isMilActive(JsonNode root) {
        JsonNode status;
        JsonNode obd;
        JsonNode signal;
        ArrayNode arrayNode;
        if (root != null && root.isArray() && (arrayNode = (ArrayNode)root).size() > 0 && (signal = arrayNode.get(0).get("signal")) != null && (obd = signal.get("obd")) != null && (status = obd.get("status")) != null) {
            JsonNode mil = status.get("mil");
            return mil.asBoolean(false);
        }
        return false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static String query(URL url) {
        Request request = new Request.Builder().url(url).build();
        OkHttpClient client = new OkHttpClient();
        try (Response response = client.newCall(request).execute();){
            if (response == null) return null;
            if (response.body() == null) return null;
            String string = response.body().string();
            return string;
        }
        catch (IOException e) {
            LOGGER.error("Failed to query {}", (Object)url);
            e.printStackTrace();
        }
        return null;
    }
}

