/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.kuksa.appstore;

import org.eclipse.kuksa.appstore.exception.AlreadyExistException;
import org.eclipse.kuksa.appstore.exception.BadRequestException;
import org.eclipse.kuksa.appstore.model.UserType;
import org.eclipse.kuksa.appstore.service.UserService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.autoconfigure.EnableAutoConfiguration;
import org.springframework.boot.autoconfigure.ImportAutoConfiguration;
import org.springframework.boot.autoconfigure.SpringBootApplication;
import org.springframework.boot.context.event.ApplicationReadyEvent;
import org.springframework.cloud.openfeign.EnableFeignClients;
import org.springframework.cloud.openfeign.FeignAutoConfiguration;
import org.springframework.context.event.EventListener;

@SpringBootApplication
@EnableAutoConfiguration
@ImportAutoConfiguration(value={FeignAutoConfiguration.class})
@EnableFeignClients
public class AppStoreApplication {
    private static final Logger LOG = LoggerFactory.getLogger(AppStoreApplication.class);
    @Autowired
    UserService userservice;
    @Value(value="${appstore.username}")
    private String username;
    @Value(value="${appstore.password}")
    private String password;

    public static void main(String[] args) {
        SpringApplication.run(AppStoreApplication.class, (String[])args);
    }

    @EventListener(value={ApplicationReadyEvent.class})
    public void EventListenerExecute() throws AlreadyExistException, BadRequestException {
        if (this.userservice.findByUserName(this.username) == null) {
            this.userservice.createUser(this.username, this.password, UserType.SystemAdmin, null, null);
            LOG.debug("[EventListenerExecute]: The user is added. : {}", (Object)this.username);
        } else {
            LOG.debug("[EventListenerExecute]: The user already exists. : {}", (Object)this.username);
        }
    }
}

