/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.kuksa.appstore.client;

import feign.Response;
import java.util.List;
import org.eclipse.kuksa.appstore.configuration.HawkbitFeignConfig;
import org.eclipse.kuksa.appstore.model.hawkbit.Artifact;
import org.eclipse.kuksa.appstore.model.hawkbit.AssignedResult;
import org.eclipse.kuksa.appstore.model.hawkbit.Distribution;
import org.eclipse.kuksa.appstore.model.hawkbit.DistributionResult;
import org.eclipse.kuksa.appstore.model.hawkbit.Rule;
import org.eclipse.kuksa.appstore.model.hawkbit.SoftwareModule;
import org.eclipse.kuksa.appstore.model.hawkbit.SoftwareModuleResult;
import org.eclipse.kuksa.appstore.model.hawkbit.TargetResult;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;

@FeignClient(name="hawkbit-get-targets", url="${hawkbit.url}", configuration={HawkbitFeignConfig.class})
public interface HawkbitFeignClient {
    @RequestMapping(method={RequestMethod.GET}, value={"/rest/v1/targets"})
    public TargetResult getTargetsByDes(@RequestParam(value="q") String var1, @RequestParam(value="sort") String var2);

    @RequestMapping(value={"/rest/v1/targets"}, method={RequestMethod.GET})
    public TargetResult getTargets();

    @RequestMapping(value={"/rest/v1/distributionsets"}, method={RequestMethod.GET})
    public DistributionResult getDistribution();

    @RequestMapping(value={"/rest/v1/targets/{i}/assignedDS"}, headers={"Content-Type=application/json;charset=UTF-8"}, method={RequestMethod.POST})
    public AssignedResult sendApptoDevice(@PathVariable(value="i") String var1, Rule var2);

    @RequestMapping(value={"/rest/v1/distributionsets"}, method={RequestMethod.GET})
    public DistributionResult getDistributionByName(@RequestParam(value="q") String var1, @RequestParam(value="limit") int var2, @RequestParam(value="sort") String var3);

    @RequestMapping(method={RequestMethod.GET}, value={"/rest/v1/softwaremodules"})
    public SoftwareModuleResult getSoftwaremoduleByName(@RequestParam(value="q") String var1);

    @RequestMapping(method={RequestMethod.POST}, headers={"Content-Type=application/hal+json;charset=UTF-8"}, value={"/rest/v1/softwaremodules"})
    public List<SoftwareModule> createSoftwaremodules(List<SoftwareModule> var1);

    @RequestMapping(method={RequestMethod.DELETE}, value={"rest/v1/softwaremodules/{softwareModuleId}"})
    public Response deletesoftwareModuleById(@PathVariable(value="softwareModuleId") String var1);

    @RequestMapping(method={RequestMethod.GET}, value={"rest/v1/softwaremodules/{softwareModuleId}/artifacts"})
    public List<Artifact> getArtifactsBysoftwareModuleId(@PathVariable(value="softwareModuleId") String var1);

    @RequestMapping(method={RequestMethod.DELETE}, value={"rest/v1/softwaremodules/{softwareModuleId}/artifacts/{artifactId}"})
    public Response deleteArtifactsBysoftwareModuleId(@PathVariable(value="softwareModuleId") String var1, @PathVariable(value="artifactId") String var2);

    @RequestMapping(method={RequestMethod.DELETE}, value={"rest/v1/distributionsets/{distributionSetId}"})
    public Response deleteDistribution(@PathVariable(value="distributionSetId") String var1);

    @RequestMapping(method={RequestMethod.POST}, headers={"Content-Type=application/hal+json;charset=UTF-8"}, value={"/rest/v1/distributionsets"})
    public Response createDistributionSets(List<Distribution> var1);

    @RequestMapping(method={RequestMethod.PUT}, headers={"Content-Type=application/json;charset=UTF-8"}, value={"/rest/v1/distributionsets/{distributionSetId}"})
    public Response updateDistributionSets(@PathVariable(value="distributionSetId") String var1, @RequestBody Distribution var2);

    @RequestMapping(method={RequestMethod.PUT}, headers={"Content-Type=application/json;charset=UTF-8"}, value={"/rest/v1/softwaremodules/{softwareModuleId}"})
    public Response updateSoftwareModule(@PathVariable(value="softwareModuleId") String var1, @RequestBody SoftwareModule var2);
}

