/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.kuksa.appstore.controller;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.Authorization;
import java.util.ArrayList;
import javax.validation.Valid;
import org.eclipse.kuksa.appstore.exception.AlreadyExistException;
import org.eclipse.kuksa.appstore.exception.BadRequestException;
import org.eclipse.kuksa.appstore.exception.NotFoundException;
import org.eclipse.kuksa.appstore.model.App;
import org.eclipse.kuksa.appstore.model.hawkbit.Result;
import org.eclipse.kuksa.appstore.service.AppService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/1.0"})
@Api(value="/api/1.0", description="Applications API", tags={"Applications"}, consumes="application/json")
public class AppController {
    private final Logger LOG = LoggerFactory.getLogger(this.getClass());
    @Autowired
    AppService appService;

    @ApiOperation(notes="Returns the App specified by the appId path parameter. The response includes all details about the App.", value="Getting an App", nickname="getAppbyId", produces="application/json", authorizations={@Authorization(value="api_key")})
    @ApiImplicitParam(name="Authorization", value="Token Format: 'base64(username: password)'", required=true, dataType="String", paramType="Header", defaultValue="Basic Token")
    @GetMapping(value={"/app/{appId}"})
    public ResponseEntity<?> getAppbyId(@PathVariable String appId) throws NotFoundException {
        App app = this.appService.findById(Long.valueOf(Long.parseLong(appId)));
        if (app != null) {
            this.LOG.debug("[getAppbyId]: getAppbyId request is processed successfully. appId: {}", (Object)appId);
            return new ResponseEntity((Object)app, HttpStatus.OK);
        }
        this.LOG.debug("[getAppbyId]: getAppbyId request is received. appId: {}", (Object)appId);
        throw new NotFoundException("App not found!");
    }

    @ApiOperation(notes="Creates an App defined in the request JSON body. Id field should not implemented in post request JSON body because of that it is already given by server.", value="Creating an App", nickname="createApp", produces="application/json", authorizations={@Authorization(value="api_key")})
    @ApiImplicitParam(name="Authorization", value="Token Format: 'base64(username: password)'", required=true, dataType="String", paramType="Header", defaultValue="Basic Token")
    @PostMapping(value={"/app"})
    public ResponseEntity<?> createApp(@Valid @RequestBody App app) throws AlreadyExistException, BadRequestException {
        Result response = this.appService.createApp(app);
        if (response.isSuccess()) {
            this.LOG.debug("[createApp]: createApp request is processed successfully. app: {}", (Object)app);
            return new ResponseEntity(response.getPayload(), HttpStatus.OK);
        }
        this.LOG.debug("[createApp]: createApp request is received. app: {}", (Object)app);
        return new ResponseEntity((Object)HttpStatus.BAD_REQUEST.getReasonPhrase(), HttpStatus.BAD_REQUEST);
    }

    @ApiOperation(notes="Updates the App identified by the appId parameter and the JSON body.", value="Updating an App", nickname="updateApp", produces="application/json", authorizations={@Authorization(value="api_key")})
    @ApiImplicitParam(name="Authorization", value="Token Format: 'base64(username: password)'", required=true, dataType="String", paramType="Header", defaultValue="Basic Token")
    @PutMapping(value={"/app/{appId}"})
    public ResponseEntity<?> updateApp(@PathVariable String appId, @Valid @RequestBody App app) throws AlreadyExistException, BadRequestException, NotFoundException {
        Result response = this.appService.updateApp(appId, app);
        if (response.isSuccess()) {
            this.LOG.debug("[updateApp]: updateApp request is processed successfully. app: {}", (Object)app);
            return new ResponseEntity(response.getPayload(), HttpStatus.OK);
        }
        this.LOG.debug("[updateApp]: updateApp request is received. app: {}", (Object)app);
        return new ResponseEntity((Object)HttpStatus.BAD_REQUEST.getReasonPhrase(), HttpStatus.BAD_REQUEST);
    }

    @ApiOperation(notes="Deletes the App specified by the appId parameter.", value="Deleting an App", nickname="deleteApp", produces="application/json", authorizations={@Authorization(value="api_key")})
    @ApiImplicitParam(name="Authorization", value="Token Format: 'base64(username: password)'", required=true, dataType="String", paramType="Header", defaultValue="Basic Token")
    @DeleteMapping(value={"/app/{appId}"})
    public ResponseEntity<?> deleteApp(@PathVariable String appId) throws NotFoundException {
        this.LOG.debug("[deleteApp]: Delete App request is received. appId: {}", (Object)appId);
        this.appService.deleteApp(appId);
        this.LOG.debug("[deleteApp] Delete App is processed successfully. appId: {}", (Object)appId);
        return new ResponseEntity(null, HttpStatus.OK);
    }

    @ApiOperation(notes="Returns all Apps.", value="Getting all App", nickname="getAllApp", produces="application/json", authorizations={@Authorization(value="api_key")})
    @ApiImplicitParam(name="Authorization", value="Token Format: 'base64(username: password)'", required=true, dataType="String", paramType="Header", defaultValue="Basic Token")
    @GetMapping(value={"/app"})
    public ResponseEntity<?> getAllApp(Pageable pageable) throws NotFoundException {
        Page apps = this.appService.findAll(pageable);
        if (apps.getTotalElements() > 0L) {
            this.LOG.debug("[getAllApp]: getUserbyId request is processed successfully.");
            return new ResponseEntity((Object)apps, HttpStatus.OK);
        }
        this.LOG.debug("[getAllApp]: getUserbyId request is received.");
        throw new NotFoundException("Apps not found!");
    }

    @ApiOperation(notes="Returns user's purchased apps.", value="Getting User's Purchased Apps", nickname="getPurchasedAppsbyUserId", produces="application/json", authorizations={@Authorization(value="api_key")})
    @ApiImplicitParam(name="Authorization", value="Token Format: 'base64(username: password)'", required=true, dataType="String", paramType="Header", defaultValue="Basic Token")
    @GetMapping(value={"/app/purchased/user/{userId}"})
    public ResponseEntity<?> getPurchasedAppsbyUserId(@PathVariable Long userId, Pageable pageable) throws NotFoundException, BadRequestException {
        Page apps = this.appService.findUsersApps(userId.toString(), this.appService.getListOfOem(this.appService.getListOfTargets(userId)), pageable);
        this.LOG.debug("[getPurchasedAppsbyUserId]: getPurchasedAppsbyUserId request is processed successfully. Device: {}", (Object)userId);
        return new ResponseEntity((Object)apps, HttpStatus.OK);
    }

    @ApiOperation(notes="Returns User's installed Apps by userId and name parameter. The name parameter ensures to search by App Name.", value="Getting User's installed Apps.", nickname="getUserApssbyUserId", produces="application/json", authorizations={@Authorization(value="api_key")})
    @ApiImplicitParam(name="Authorization", value="Token Format: 'base64(username: password)'", required=true, dataType="String", paramType="Header", defaultValue="Basic Token")
    @GetMapping(value={"/app/installed/user/{userId}"})
    public ResponseEntity<?> getUsersInstalledAppsbyUserId(@PathVariable Long userId, Pageable pageable) throws NotFoundException {
        Page apps = this.appService.findByInstalledusersId(userId, pageable);
        this.LOG.debug("[getUsersInstalledAppsbyUserId]: getUsersInstalledAppsbyUserId request is processed successfully. userId: {}", (Object)userId);
        return new ResponseEntity((Object)apps, HttpStatus.OK);
    }

    @ApiOperation(notes="Returns User's installed Apps by userId and name parameter. The name parameter ensures to search by App Name.", value="Getting User's installed Apps by name.", nickname="getUserApssbyUserIdAndName", produces="application/json", authorizations={@Authorization(value="api_key")})
    @ApiImplicitParam(name="Authorization", value="Token Format: 'base64(username: password)'", required=true, dataType="String", paramType="Header", defaultValue="Basic Token")
    @GetMapping(value={"/app/installed/user/{userId}/{name}"})
    public ResponseEntity<?> getUsersInstalledAppsbyUserIdAndName(@PathVariable Long userId, @PathVariable String name, Pageable pageable) throws NotFoundException {
        Page apps = this.appService.findByNameStartsWithIgnoreCaseAndInstalledusersId(name, userId, pageable);
        this.LOG.debug("[getUsersInstalledAppsbyUserIdAndName]: getUsersInstalledAppsbyUserIdAndName request is processed successfully. userId: {}", (Object)userId);
        return new ResponseEntity((Object)apps, HttpStatus.OK);
    }

    @ApiOperation(notes="Returns Apps specified by appCategoryId parameter.", value="Getting Apps By App Category Id", nickname="getApssbyAppCategoryId", produces="application/json", authorizations={@Authorization(value="api_key")})
    @ApiImplicitParam(name="Authorization", value="Token Format: 'base64(username: password)'", required=true, dataType="String", paramType="Header", defaultValue="Basic Token")
    @GetMapping(value={"/app/category/{appCategoryId}"})
    public ResponseEntity<?> getApssbyAppCategoryId(@PathVariable Long appCategoryId, Pageable pageable) throws NotFoundException {
        Page apps = this.appService.findByAppcategoryId(appCategoryId, pageable);
        this.LOG.debug("[getApssbyAppCategoryId]: getApssbyAppCategoryId request is processed successfully. appCategoryId: {}", (Object)appCategoryId);
        return new ResponseEntity((Object)apps, HttpStatus.OK);
    }

    @ApiOperation(notes="Returns Apps specified by appCategoryId parameter and name parameter. The name parameter ensures to search by App Name.", value="Getting Apps By App Category Id with Filter Text", nickname="getApssbyNameAndAppcategoryId", produces="application/json", authorizations={@Authorization(value="api_key")})
    @ApiImplicitParam(name="Authorization", value="Token Format: 'base64(username: password)'", required=true, dataType="String", paramType="Header", defaultValue="Basic Token")
    @GetMapping(value={"/app/category/{appCategoryId}/{name}"})
    public ResponseEntity<?> getApssbyNameAndAppcategoryId(@PathVariable Long appCategoryId, @PathVariable String name, Pageable pageable) throws NotFoundException {
        Page apps = this.appService.findByNameStartsWithIgnoreCaseAndAppcategoryId(name, appCategoryId, pageable);
        this.LOG.debug("[getApssbyNameAndAppcategoryId]: getApssbyNameAndAppcategoryId request is processed successfully. appCategoryId: {}", (Object)appCategoryId);
        return new ResponseEntity((Object)apps, HttpStatus.OK);
    }

    @ApiOperation(notes="This process is used to purchase an App specified by userId and appId.", value="Purchase an App", nickname="purchaseApp", produces="application/json", authorizations={@Authorization(value="api_key")})
    @ApiImplicitParam(name="Authorization", value="Token Format: 'base64(username: password)'", required=true, dataType="String", paramType="Header", defaultValue="Basic Token")
    @PostMapping(value={"/app/{appId}/purchase/{userId}"})
    public ResponseEntity<?> purchaseApp(@PathVariable Long userId, @PathVariable Long appId) throws NotFoundException, BadRequestException {
        this.LOG.debug("[purchaseApp]: purchaseApp request is processed successfully. purchaseApp: {}", (Object)appId);
        return new ResponseEntity((Object)this.appService.purchaseApp(userId, appId), HttpStatus.OK);
    }

    @ApiOperation(notes="This process is used to install an App specified by appId to the given device for user specified by userId .", value="Install an App", nickname="InstallApp", produces="application/json", authorizations={@Authorization(value="api_key")})
    @ApiImplicitParam(name="Authorization", value="Token Format: 'base64(username: password)'", required=true, dataType="String", paramType="Header", defaultValue="Basic Token")
    @PostMapping(value={"/app/{appId}/install/{userId}"})
    public ResponseEntity<?> InstallApp(@PathVariable Long userId, @PathVariable Long appId, @RequestBody String deviceName) throws NotFoundException, BadRequestException, AlreadyExistException {
        this.LOG.debug("[InstallApp]: InstallApp request is processed successfully. InstallApp: {}", new Object[]{appId, userId, deviceName});
        return new ResponseEntity((Object)this.appService.InstallApp(deviceName, userId, appId), HttpStatus.OK);
    }

    @ApiOperation(notes="This process is used to uninstall an App specified by appId from the given device for user specified by userId.", value="Uninstall an App", nickname="UninstallApp", produces="application/json", authorizations={@Authorization(value="api_key")})
    @ApiImplicitParam(name="Authorization", value="Token Format: 'base64(username: password)'", required=true, dataType="String", paramType="Header", defaultValue="Basic Token")
    @DeleteMapping(value={"/app/{appId}/uninstall/{userId}"})
    public ResponseEntity<?> UninstallApp(@PathVariable Long userId, @PathVariable Long appId, @RequestBody String deviceName) throws NotFoundException, BadRequestException, AlreadyExistException {
        this.LOG.debug("[UninstallApp]: UninstallApp request is processed successfully. UninstallApp: {}", new Object[]{appId, userId, deviceName});
        ArrayList<Long> appIds = new ArrayList<Long>();
        appIds.add(appId);
        return new ResponseEntity((Object)this.appService.UninstallMultiApp(deviceName, userId, appIds), HttpStatus.OK);
    }
}

