/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.kuksa.appstore.model.hawkbit.upload;

import feign.RequestTemplate;
import feign.codec.EncodeException;
import feign.codec.Encoder;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.reflect.Type;
import java.nio.charset.Charset;
import java.util.List;
import java.util.Map;
import org.eclipse.kuksa.appstore.model.hawkbit.upload.FeignMultipartEncoder;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpOutputMessage;
import org.springframework.http.MediaType;
import org.springframework.http.converter.HttpMessageConverter;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;
import org.springframework.web.multipart.MultipartFile;

/*
 * Exception performing whole class analysis ignored.
 */
public class FeignMultipartEncoder
implements Encoder {
    private final List<HttpMessageConverter<?>> converters = new RestTemplate().getMessageConverters();
    private final HttpHeaders multipartHeaders = new HttpHeaders();
    private final HttpHeaders jsonHeaders = new HttpHeaders();
    private static final Charset UTF_8 = Charset.forName("UTF-8");

    public FeignMultipartEncoder() {
        this.multipartHeaders.setContentType(MediaType.MULTIPART_FORM_DATA);
        this.jsonHeaders.setContentType(MediaType.APPLICATION_JSON);
    }

    public void encode(Object object, Type bodyType, RequestTemplate template) {
        this.encodeMultipartFormRequest(object, template);
    }

    private void encodeMultipartFormRequest(Object value, RequestTemplate template) {
        if (value == null) {
            throw new EncodeException("Cannot encode request with null value.");
        }
        if (!FeignMultipartEncoder.isMultipartFile((Object)value)) {
            throw new EncodeException("Only multipart can be handled by this encoder");
        }
        this.encodeRequest((Object)this.encodeMultipartFile((MultipartFile)value), this.multipartHeaders, template);
    }

    private void encodeRequest(Object value, HttpHeaders requestHeaders, RequestTemplate template) {
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        HttpOutputMessageImpl dummyRequest = new HttpOutputMessageImpl((OutputStream)outputStream, requestHeaders, null);
        try {
            Class<?> requestType = value.getClass();
            MediaType requestContentType = requestHeaders.getContentType();
            for (HttpMessageConverter messageConverter : this.converters) {
                if (!messageConverter.canWrite(requestType, requestContentType)) continue;
                messageConverter.write(value, requestContentType, (HttpOutputMessage)dummyRequest);
                break;
            }
        }
        catch (IOException ex) {
            throw new EncodeException("Cannot encode request.", (Throwable)ex);
        }
        HttpHeaders headers = dummyRequest.getHeaders();
        if (headers != null) {
            for (Map.Entry entry : headers.entrySet()) {
                template.header((String)entry.getKey(), (Iterable)entry.getValue());
            }
        }
        template.body(outputStream.toByteArray(), UTF_8);
    }

    private MultiValueMap<String, Object> encodeMultipartFile(MultipartFile file) {
        try {
            LinkedMultiValueMap multiValueMap = new LinkedMultiValueMap();
            multiValueMap.add((Object)"file", (Object)new MultipartFileResource(file.getName(), file.getSize(), file.getInputStream()));
            return multiValueMap;
        }
        catch (IOException ex) {
            throw new EncodeException("Cannot encode request.", (Throwable)ex);
        }
    }

    private static boolean isMultipartFile(Object object) {
        return object instanceof MultipartFile;
    }
}

