/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.kuksa.appstore.service;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.kuksa.appstore.exception.AlreadyExistException;
import org.eclipse.kuksa.appstore.exception.BadRequestException;
import org.eclipse.kuksa.appstore.exception.NotFoundException;
import org.eclipse.kuksa.appstore.model.AppCategory;
import org.eclipse.kuksa.appstore.model.hawkbit.Result;
import org.eclipse.kuksa.appstore.repo.AppCategoryRepository;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Service;

@Service
public class AppCategoryService {
    @Autowired
    AppCategoryRepository appCategoryRepository;

    public Result<?> createAppCategory(AppCategory appCategory) throws AlreadyExistException, BadRequestException {
        if (appCategory.getName().contains(" ")) {
            throw new BadRequestException("Name should not contain whitespace!");
        }
        if (this.appCategoryRepository.findByNameStartsWithIgnoreCase(appCategory.getName()).size() > 0) {
            throw new AlreadyExistException("AppCategory name already exist. name: " + appCategory.getName());
        }
        this.appCategoryRepository.save((Object)appCategory);
        return Result.success((HttpStatus)HttpStatus.CREATED, (Object)appCategory);
    }

    public AppCategory findById(Long id) {
        return this.appCategoryRepository.findById(id);
    }

    public AppCategory findByName(String name) {
        return this.appCategoryRepository.findByName(name);
    }

    public void updateAppCategory(AppCategory appCategory) {
        this.appCategoryRepository.save((Object)appCategory);
    }

    public Result<?> updateAppCategory(String appCategoryId, AppCategory appCategory) throws NotFoundException, BadRequestException, AlreadyExistException {
        AppCategory currentAppCategory = this.appCategoryRepository.findById(Long.valueOf(Long.parseLong(appCategoryId)));
        if (currentAppCategory == null) {
            throw new NotFoundException("AppCategory not found. appId: " + appCategoryId);
        }
        if (appCategory.getName() == null || appCategory.getName().equals("") || appCategory.getName().contains(" ")) {
            throw new BadRequestException("AppCategory name is mandatory field!");
        }
        if (!currentAppCategory.getName().equals(appCategory.getName()) && this.appCategoryRepository.findByName(appCategory.getName()) != null) {
            throw new AlreadyExistException("New AppCategory name already exist. New name: " + appCategory.getName());
        }
        appCategory.setId(currentAppCategory.getId());
        this.appCategoryRepository.save((Object)appCategory);
        return Result.success((HttpStatus)HttpStatus.OK, (Object)appCategory);
    }

    public void deleteAppCategory(AppCategory appCategory) {
        this.appCategoryRepository.delete((Object)appCategory);
    }

    public void deleteAppCategory(String appCategoryId) throws NotFoundException, BadRequestException {
        AppCategory currentAppCategory = this.appCategoryRepository.findById(Long.valueOf(Long.parseLong(appCategoryId)));
        if (currentAppCategory == null) {
            throw new NotFoundException("AppCategory not found. userId: " + appCategoryId);
        }
        try {
            this.appCategoryRepository.delete((Object)currentAppCategory);
        }
        catch (Exception e) {
            throw new BadRequestException("This category is being used by applications. Please update the applications's categories before deleting.");
        }
    }

    public List<AppCategory> findAll() {
        return this.appCategoryRepository.findAll();
    }

    public Page<AppCategory> findAll(Pageable pageable) {
        return this.appCategoryRepository.findAll(pageable);
    }

    public List<String> getAllId() {
        ArrayList<String> list = new ArrayList<String>();
        for (Long component : this.appCategoryRepository.getAllId()) {
            list.add(component.toString());
        }
        return list;
    }
}

