/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.kuksa.appstore.service;

import feign.Response;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.kuksa.appstore.client.HawkbitFeignClient;
import org.eclipse.kuksa.appstore.exception.AlreadyExistException;
import org.eclipse.kuksa.appstore.exception.BadRequestException;
import org.eclipse.kuksa.appstore.exception.NotFoundException;
import org.eclipse.kuksa.appstore.model.App;
import org.eclipse.kuksa.appstore.model.Oem;
import org.eclipse.kuksa.appstore.model.User;
import org.eclipse.kuksa.appstore.model.hawkbit.AssignedResult;
import org.eclipse.kuksa.appstore.model.hawkbit.Distribution;
import org.eclipse.kuksa.appstore.model.hawkbit.DistributionResult;
import org.eclipse.kuksa.appstore.model.hawkbit.Result;
import org.eclipse.kuksa.appstore.model.hawkbit.Rule;
import org.eclipse.kuksa.appstore.model.hawkbit.RuleMain;
import org.eclipse.kuksa.appstore.model.hawkbit.SoftwareModule;
import org.eclipse.kuksa.appstore.model.hawkbit.SoftwareModuleResult;
import org.eclipse.kuksa.appstore.model.hawkbit.Target;
import org.eclipse.kuksa.appstore.repo.AppCategoryRepository;
import org.eclipse.kuksa.appstore.repo.AppRepository;
import org.eclipse.kuksa.appstore.repo.OemRepository;
import org.eclipse.kuksa.appstore.repo.UserRepository;
import org.eclipse.kuksa.appstore.service.UserService;
import org.eclipse.kuksa.appstore.utils.Utils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Service;

@Service
public class AppService {
    @Autowired
    AppRepository appRepository;
    @Autowired
    UserRepository userRepository;
    @Autowired
    OemRepository oemRepository;
    @Autowired
    AppCategoryRepository appCategoryRepository;
    @Autowired
    HawkbitFeignClient hawkbitFeignClient;
    @Autowired
    UserService userService;

    public Result<?> createApp(App app) throws AlreadyExistException, BadRequestException {
        if (app.getName() == null || app.getName().equals("")) {
            throw new BadRequestException("Name is mandatory field!");
        }
        if (app.getName().contains(" ")) {
            throw new BadRequestException("Name should not contain space character!");
        }
        if (app.getVersion() == null || app.getVersion().equals("")) {
            throw new BadRequestException("Version is mandatory field!");
        }
        if (app.getDescription() == null || app.getDescription().equals("")) {
            throw new BadRequestException("Description is mandatory field!");
        }
        if (app.getOwner() == null || app.getOwner().equals("")) {
            throw new BadRequestException("Owner is mandatory field!");
        }
        if (this.appRepository.findByNameIgnoreCase(app.getName()) != null) {
            throw new AlreadyExistException("App name already exist. name: " + app.getName());
        }
        if (app.getAppcategory() == null) {
            throw new BadRequestException("App Category is mandatory field!");
        }
        if (app.getAppcategory() != null && this.appCategoryRepository.findById(app.getAppcategory().getId()) == null) {
            throw new BadRequestException("App Category should exist!");
        }
        this.appRepository.save((Object)app);
        return this.createApptoHawkbit(app);
    }

    public Result<?> createApptoHawkbit(App app) throws BadRequestException {
        List responsesoftwareModule;
        App currentApp = this.appRepository.findByName(app.getName());
        try {
            ArrayList<SoftwareModule> softwareModuleList = new ArrayList<SoftwareModule>();
            softwareModuleList.add(new SoftwareModule(app.getName(), app.getDescription(), app.getVersion(), "application", app.getOwner()));
            responsesoftwareModule = this.hawkbitFeignClient.createSoftwaremodules(softwareModuleList);
        }
        catch (Exception e) {
            this.appRepository.delete((Object)currentApp);
            throw new BadRequestException("Hawkbit connection error. Check your Hawkbit's IP in the propreties file!");
        }
        if (responsesoftwareModule.size() > 0) {
            return Result.success((HttpStatus)HttpStatus.CREATED, (Object)this.appRepository.findByName(app.getName()));
        }
        this.appRepository.delete((Object)currentApp);
        throw new BadRequestException("App could not be saved to Hawkbit and Appstore!");
    }

    public App findById(Long id) {
        return this.appRepository.findById(id);
    }

    public App findByName(String name) {
        return this.appRepository.findByName(name);
    }

    public Result<?> updateApp(String appId, App app) throws NotFoundException, BadRequestException, AlreadyExistException {
        App currentApp = this.appRepository.findById(Long.valueOf(Long.parseLong(appId)));
        if (currentApp == null) {
            throw new NotFoundException("App not found. appId: " + appId);
        }
        if (app.getName() == null || app.getName().equals("")) {
            throw new BadRequestException("Name is mandatory field!");
        }
        if (app.getName().contains(" ")) {
            throw new BadRequestException("Name should not contain space character!");
        }
        if (app.getVersion() == null || app.getVersion().equals("")) {
            throw new BadRequestException("Version is mandatory field!");
        }
        if (app.getDescription() == null || app.getDescription().equals("")) {
            throw new BadRequestException("Description is mandatory field!");
        }
        if (app.getOwner() == null || app.getOwner().equals("")) {
            throw new BadRequestException("Owner is mandatory field!");
        }
        if (!currentApp.getName().equals(app.getName()) && this.appRepository.findByNameIgnoreCase(app.getName()) != null) {
            throw new AlreadyExistException("New App name already exist. New name: " + app.getName());
        }
        if (app.getAppcategory() == null) {
            throw new BadRequestException("App Category is mandatory field!");
        }
        if (app.getAppcategory() != null && this.appCategoryRepository.findById(app.getAppcategory().getId()) == null) {
            throw new BadRequestException("App Category should exist!");
        }
        app.setId(currentApp.getId());
        if (!currentApp.getDescription().equals(app.getDescription()) || !currentApp.getOwner().equals(app.getOwner())) {
            SoftwareModuleResult softwareModuleResult;
            try {
                softwareModuleResult = this.hawkbitFeignClient.getSoftwaremoduleByName(Utils.createFIQLEqual((String)"name", (String)currentApp.getName()) + ";" + Utils.createFIQLEqual((String)"version", (String)currentApp.getVersion()));
            }
            catch (Exception e) {
                throw new BadRequestException("Hawkbit connection error. Check your Hawkbit's IP in the propreties file!");
            }
            if (softwareModuleResult.getSize() > 0) {
                Integer softawareModuleId = Utils.getExistsSoftwareModule((List)softwareModuleResult.getContent());
                Response responseSoftwareModule = this.hawkbitFeignClient.updateSoftwareModule(softawareModuleId.toString(), new SoftwareModule(app.getDescription(), app.getOwner()));
                if (responseSoftwareModule.status() == HttpStatus.OK.value()) {
                    this.appRepository.save((Object)app);
                }
                return Result.success((HttpStatus)HttpStatus.OK, (Object)app);
            }
            throw new BadRequestException("App not found on Hawkbit!");
        }
        this.appRepository.save((Object)app);
        return Result.success((HttpStatus)HttpStatus.OK, (Object)app);
    }

    public void deleteApp(String appId) throws NotFoundException {
        SoftwareModuleResult softwareModuleResult;
        App currentApp = this.appRepository.findById(Long.valueOf(Long.parseLong(appId)));
        if (currentApp == null) {
            throw new NotFoundException("App not found. appId: " + appId);
        }
        try {
            softwareModuleResult = this.hawkbitFeignClient.getSoftwaremoduleByName(Utils.createFIQLEqual((String)"name", (String)currentApp.getName()) + ";" + Utils.createFIQLEqual((String)"version", (String)currentApp.getVersion()));
        }
        catch (Exception e) {
            throw new NotFoundException("Hawkbit connection error. Check your Hawkbit's IP in the propreties file!");
        }
        if (softwareModuleResult.getSize() > 0) {
            Integer softawareModuleId = Utils.getExistsSoftwareModule((List)softwareModuleResult.getContent());
            Response responseSoftwareModule = this.hawkbitFeignClient.deletesoftwareModuleById(softawareModuleId.toString());
            if (responseSoftwareModule.status() != HttpStatus.OK.value()) {
                throw new NotFoundException(responseSoftwareModule.body().toString());
            }
        } else {
            throw new NotFoundException("Software Module not found on Hawkbit. . Software:" + Utils.createSoftwareName((Long)currentApp.getId()));
        }
        this.appRepository.delete((Object)currentApp);
    }

    public List<App> findAll() {
        return this.appRepository.findAll();
    }

    public List<App> findByNameStartsWithIgnoreCase(String name) {
        return this.appRepository.findByNameStartsWithIgnoreCase(name);
    }

    public Page<App> findAll(Pageable pageable) {
        return this.appRepository.findAll(pageable);
    }

    public Page<App> findByNameStartsWithIgnoreCase(String name, Pageable pageable) {
        return this.appRepository.findByNameStartsWithIgnoreCase(name, pageable);
    }

    public App incrementAppDownloadCount(App app) {
        app.setDownloadcount(app.getDownloadcount() + 1);
        return app;
    }

    public Page<App> findByNameStartsWithIgnoreCaseAndInstalledusersUserName(String appname, String username, Pageable pageable) {
        return this.appRepository.findByNameStartsWithIgnoreCaseAndInstalledusersUsername(appname, username, pageable);
    }

    public Page<App> findByInstalledusersId(Long userid, Pageable pageable) {
        return this.appRepository.findByInstalledusersId(userid, pageable);
    }

    public Page<App> findByNameStartsWithIgnoreCaseAndInstalledusersId(String appname, Long userid, Pageable pageable) {
        return this.appRepository.findByNameStartsWithIgnoreCaseAndInstalledusersId(appname, userid, pageable);
    }

    public Page<App> findByIdIn(List<Long> myappsid, Pageable pageable) {
        return this.appRepository.findByIdIn(myappsid, pageable);
    }

    public Page<App> findByAppcategoryId(Long id, Pageable pageable) {
        return this.appRepository.findByAppcategoryId(id, pageable);
    }

    public Page<App> findByNameStartsWithIgnoreCaseAndAppcategoryId(String name, Long id, Pageable pageable) {
        return this.appRepository.findByNameStartsWithIgnoreCaseAndAppcategoryId(name, id, pageable);
    }

    public List<Long> createUsersAppList(String userId, List<String> oemList) {
        int i;
        List listOem = new ArrayList();
        List listUser = new ArrayList();
        if (oemList.size() > 0) {
            listOem = this.oemRepository.findIdByNameIn(oemList);
            ArrayList<Long> listOemId = new ArrayList<Long>();
            for (int i2 = 0; i2 < listOem.size(); ++i2) {
                listOemId.add(((Oem)listOem.get(i2)).getId());
            }
            listUser = this.userRepository.findByOemIdIn(listOemId);
        }
        ArrayList listUsersApp = new ArrayList();
        ArrayList<Long> listUsersAppId = new ArrayList<Long>();
        for (i = 0; i < listUser.size(); ++i) {
            listUsersApp.addAll(((User)listUser.get(i)).getUserapps());
        }
        for (i = 0; i < listUsersApp.size(); ++i) {
            listUsersAppId.add(((App)listUsersApp.get(i)).getId());
        }
        List listUsersAppIdFromRelationQuery = new ArrayList();
        listUsersAppIdFromRelationQuery = this.appRepository.findUsersAppsIdFromUsersRelationship(userId);
        listUsersAppId.addAll(listUsersAppIdFromRelationQuery);
        return listUsersAppId;
    }

    public Page<App> findUsersApps(String userId, List<String> oemList, Pageable pageable) {
        return this.appRepository.findUsersApps(this.createUsersAppList(userId, oemList), pageable);
    }

    public Result<?> purchaseApp(Long userId, Long appId) throws NotFoundException, BadRequestException {
        App currentApp = this.appRepository.findById(appId);
        if (currentApp == null) {
            throw new NotFoundException("App not found. appId: " + appId);
        }
        User currentUser = this.userRepository.findById(userId);
        if (currentUser == null) {
            throw new NotFoundException("User not found. userId: " + userId);
        }
        if (currentApp.getOwnerusers().contains(currentUser)) {
            throw new BadRequestException("This User already purchased this app!");
        }
        List ownerUserList = currentApp.getOwnerusers();
        ownerUserList.add(currentUser);
        currentApp.setOwnerusers(ownerUserList);
        this.appRepository.save((Object)currentApp);
        return Result.success((HttpStatus)HttpStatus.OK, (Object)currentApp);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Result<?> InstallApp(String targetDeviceName, Long userId, Long appId) throws NotFoundException, BadRequestException, AlreadyExistException {
        App currentApp = this.appRepository.findById(appId);
        if (currentApp == null) {
            throw new NotFoundException("App not found. appId: " + appId);
        }
        User currentUser = this.userRepository.findById(userId);
        if (currentUser == null) {
            throw new NotFoundException("User not found. userId: " + userId);
        }
        List listOfTargets = this.getListOfTargets(userId);
        boolean isOwner = this.userService.isUsersAppOwner(currentUser.getId().toString(), currentApp.getId(), this.getListOfOem(listOfTargets));
        if (!isOwner) {
            throw new BadRequestException("This User is not owner of this app!");
        }
        if (targetDeviceName == null) {
            throw new BadRequestException("targetDeviceName should not be empty!");
        }
        SoftwareModuleResult currentSoftwareModuleResult = this.hawkbitFeignClient.getSoftwaremoduleByName(Utils.createFIQLEqual((String)"name", (String)currentApp.getName()) + ";" + Utils.createFIQLEqual((String)"version", (String)currentApp.getVersion()));
        DistributionResult lastDistributionResult = this.hawkbitFeignClient.getDistributionByName(Utils.createFIQLEqual((String)"name", (String)targetDeviceName), 1, "id:DESC");
        String version = null;
        version = lastDistributionResult.getSize() > 0 ? ((Distribution)lastDistributionResult.getContent().get(0)).getVersion() : "0";
        int newVersion = Integer.parseInt(version) + 1;
        boolean isAlreadyAssigned = false;
        Rule ruleNew = new Rule();
        ruleNew.setForcetime("1530893371603");
        ruleNew.setType("timeforced");
        RuleMain rulemain = new RuleMain();
        rulemain.setDuration("00:10:00");
        rulemain.setSchedule("0 37 8 22 6 ? 2019");
        rulemain.setTimezone("+00:00");
        ruleNew.setMaintenanceWindow(rulemain);
        List softwareModules = new ArrayList();
        if (newVersion > 1) {
            softwareModules = ((Distribution)lastDistributionResult.getContent().get(lastDistributionResult.getSize() - 1)).getModules();
            if (softwareModules.size() == 1 && ((SoftwareModule)softwareModules.get(0)).getName().equals("UNINSTALLED_ALL")) {
                softwareModules.remove(0);
            }
            if (!Utils.isAppAlreadyInstalled((SoftwareModule)((SoftwareModule)currentSoftwareModuleResult.getContent().get(0)), softwareModules)) {
                softwareModules.addAll(currentSoftwareModuleResult.getContent());
            } else {
                isAlreadyAssigned = true;
            }
        } else {
            softwareModules.addAll(currentSoftwareModuleResult.getContent());
        }
        if (!isAlreadyAssigned) {
            Distribution newDistribution = new Distribution(targetDeviceName, Integer.toString(newVersion));
            newDistribution.setName(targetDeviceName);
            newDistribution.setDescription(currentApp.getDescription());
            newDistribution.setType("app");
            newDistribution.setModules(softwareModules);
            Response responseCreateDistribution = this.hawkbitFeignClient.createDistributionSets(Arrays.asList(newDistribution));
            if (responseCreateDistribution.status() != HttpStatus.CREATED.value()) {
                throw new BadRequestException("Fail Creating Distribution");
            }
            DistributionResult newDistributionResult = this.hawkbitFeignClient.getDistributionByName(Utils.createFIQLEqual((String)"name", (String)targetDeviceName), 1, "id:DESC");
            if (newDistributionResult.getSize() <= 0) throw new BadRequestException("This app not found on Hawkbit!");
            ruleNew.setId(((Distribution)newDistributionResult.getContent().get(0)).getId());
        } else {
            ruleNew.setId(((Distribution)lastDistributionResult.getContent().get(lastDistributionResult.getSize() - 1)).getId());
        }
        AssignedResult response = this.hawkbitFeignClient.sendApptoDevice(targetDeviceName, ruleNew);
        if (response.getAssigned() > 0) {
            List list = currentApp.getInstalledusers();
            if (Utils.isUserAlreadyOwner((User)currentUser, (List)list)) return Result.success((HttpStatus)HttpStatus.OK);
            currentApp = this.incrementAppDownloadCount(currentApp);
            list.add(currentUser);
            currentApp.setInstalledusers(list);
            this.updateApp(currentApp.getId().toString(), currentApp);
            return Result.success((HttpStatus)HttpStatus.OK);
        }
        if (response.getAlreadyAssigned() <= 0) throw new BadRequestException("The updating action hasnt been sent to Hawkbit for selected device.");
        throw new BadRequestException("The updating action is already assigned for selected device.");
    }

    public Result<?> UninstallMultiApp(String targetDeviceName, Long userId, List<Long> appIds) throws NotFoundException, BadRequestException, AlreadyExistException {
        User currentUser = this.userRepository.findById(userId);
        if (currentUser == null) {
            throw new NotFoundException("User not found. userId: " + userId);
        }
        if (targetDeviceName == null) {
            throw new BadRequestException("targetDeviceName should not be empty!");
        }
        Rule ruleNew = new Rule();
        ruleNew.setForcetime("1530893371603");
        ruleNew.setType("timeforced");
        RuleMain rulemain = new RuleMain();
        rulemain.setDuration("00:10:00");
        rulemain.setSchedule("0 37 8 22 6 ? 2019");
        rulemain.setTimezone("+00:00");
        ruleNew.setMaintenanceWindow(rulemain);
        int newVersion = 0;
        List softwareModules = new ArrayList();
        DistributionResult lastDistributionResult = this.hawkbitFeignClient.getDistributionByName(Utils.createFIQLEqual((String)"name", (String)targetDeviceName), 1, "id:DESC");
        if (lastDistributionResult.getSize() == 0) {
            throw new BadRequestException("This application is already not installed to the selected device!");
        }
        softwareModules = ((Distribution)lastDistributionResult.getContent().get(lastDistributionResult.getSize() - 1)).getModules();
        String version = null;
        if (lastDistributionResult.getSize() <= 0) {
            throw new BadRequestException("Distribution not found for the TargetDevice!");
        }
        version = ((Distribution)lastDistributionResult.getContent().get(0)).getVersion();
        newVersion = Integer.parseInt(version) + 1;
        for (Long appId : appIds) {
            App currentApp = this.appRepository.findById(appId);
            if (currentApp == null) {
                throw new NotFoundException("App not found. appId: " + appId);
            }
            SoftwareModuleResult currentSoftwareModuleResult = this.hawkbitFeignClient.getSoftwaremoduleByName(Utils.createFIQLEqual((String)"name", (String)currentApp.getName()) + ";" + Utils.createFIQLEqual((String)"version", (String)currentApp.getVersion()));
            boolean isAlreadyAssigned = false;
            isAlreadyAssigned = Utils.isAppAlreadyInstalled((SoftwareModule)((SoftwareModule)currentSoftwareModuleResult.getContent().get(0)), softwareModules);
            if (isAlreadyAssigned) {
                softwareModules = Utils.UninstallApp((SoftwareModule)((SoftwareModule)currentSoftwareModuleResult.getContent().get(0)), softwareModules);
                continue;
            }
            throw new BadRequestException("This App is not installed right now on the device!");
        }
        if (softwareModules.size() == 0) {
            SoftwareModuleResult softwareModuleResult;
            try {
                softwareModuleResult = this.hawkbitFeignClient.getSoftwaremoduleByName(Utils.createFIQLEqual((String)"name", (String)"UNINSTALLED_ALL"));
            }
            catch (Exception e) {
                throw new BadRequestException("Hawkbit connection error. Check your Hawkbit's IP in the propreties file!");
            }
            if (softwareModuleResult.getSize() == 0) {
                List responsesoftwareModule;
                try {
                    ArrayList<SoftwareModule> softwareModuleList = new ArrayList<SoftwareModule>();
                    softwareModuleList.add(new SoftwareModule("UNINSTALLED_ALL", "This software module is a Dummy software module. It was created to assign empty distribution to the device. This situation is for uninstalling device's all apps.", "0", "application", "KUKSA_APPSTORE"));
                    responsesoftwareModule = this.hawkbitFeignClient.createSoftwaremodules(softwareModuleList);
                }
                catch (Exception e) {
                    throw new BadRequestException("Hawkbit connection error. Check your Hawkbit's IP in the propreties file!");
                }
                if (responsesoftwareModule.size() == 0) {
                    throw new BadRequestException("UNINSTALLED_ALL Dummy App could not be saved to Hawkbit and Appstore!");
                }
                softwareModules.add(responsesoftwareModule.get(0));
            } else {
                softwareModules.add(softwareModuleResult.getContent().get(0));
            }
        }
        Distribution newDistribution = new Distribution(targetDeviceName, Integer.toString(newVersion));
        newDistribution.setName(targetDeviceName);
        newDistribution.setDescription("This distribution is created by Appstore for" + targetDeviceName);
        newDistribution.setType("app");
        newDistribution.setModules(softwareModules);
        Response responseCreateDistribution = this.hawkbitFeignClient.createDistributionSets(Arrays.asList(newDistribution));
        if (responseCreateDistribution.status() != HttpStatus.CREATED.value()) {
            throw new BadRequestException("Fail Creating Distribution");
        }
        DistributionResult newDistributionResult = this.hawkbitFeignClient.getDistributionByName(Utils.createFIQLEqual((String)"name", (String)targetDeviceName), 1, "id:DESC");
        if (newDistributionResult.getSize() <= 0) {
            throw new BadRequestException("This app not found on Hawkbit!");
        }
        ruleNew.setId(((Distribution)newDistributionResult.getContent().get(0)).getId());
        AssignedResult response = this.hawkbitFeignClient.sendApptoDevice(targetDeviceName, ruleNew);
        if (response.getAssigned() > 0) {
            for (Long appId : appIds) {
                App currentApp = this.appRepository.findById(appId);
                List list = currentApp.getInstalledusers();
                if (!Utils.isUserAlreadyOwner((User)currentUser, (List)list)) continue;
                currentApp.setInstalledusers(Utils.removeOwnerUser((User)currentUser, (List)list));
                this.updateApp(currentApp.getId().toString(), currentApp);
            }
            return Result.success((HttpStatus)HttpStatus.OK);
        }
        if (response.getAlreadyAssigned() > 0) {
            throw new BadRequestException("The updating action is already assigned for selected device.");
        }
        throw new BadRequestException("The updating action hasnt been sent to Hawkbit for selected device.");
    }

    public List<String> getListOfOem(List<String> listOfTargets) throws BadRequestException {
        ArrayList<String> listOfOem = new ArrayList<String>();
        for (int i = 0; i < listOfTargets.size(); ++i) {
            try {
                String deviceName = listOfTargets.get(i);
                int index = deviceName.indexOf("_");
                String oem = deviceName.substring(0, index);
                listOfOem.add(oem);
                continue;
            }
            catch (Exception e) {
                throw new BadRequestException("The names of device/target are invalid!, The names of device/target should be like this format OEM_TARGETNAME .");
            }
        }
        return listOfOem;
    }

    public List<String> getListOfTargets(Long userId) throws BadRequestException {
        ArrayList<String> listOfTargets = new ArrayList<String>();
        String dis = this.userRepository.findById(userId).getUsername();
        dis = "*" + dis + "*";
        dis = "description==" + dis;
        List deviceList = new ArrayList();
        try {
            deviceList = this.hawkbitFeignClient.getTargetsByDes(dis, "name:ASC").getContent();
        }
        catch (Exception e) {
            throw new BadRequestException("Not Found Hawkbit Instance, Make sure that you connect any Hawkbit instance with this AppStore!");
        }
        for (Target target : deviceList) {
            listOfTargets.add(target.getControllerId());
        }
        return listOfTargets;
    }

    public DistributionResult getDistributionOfTarget(String targetDeviceName) throws BadRequestException {
        DistributionResult lastDistributionResult = this.hawkbitFeignClient.getDistributionByName(Utils.createFIQLEqual((String)"name", (String)targetDeviceName), 1, "id:DESC");
        return lastDistributionResult;
    }
}

