/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.kuksa.appstore.ui;

import com.vaadin.data.HasValue;
import com.vaadin.data.ValueProvider;
import com.vaadin.navigator.View;
import com.vaadin.navigator.ViewChangeListener;
import com.vaadin.server.FileResource;
import com.vaadin.server.FontAwesome;
import com.vaadin.server.Page;
import com.vaadin.server.Resource;
import com.vaadin.server.ThemeResource;
import com.vaadin.server.VaadinSession;
import com.vaadin.shared.ui.grid.HeightMode;
import com.vaadin.spring.annotation.SpringView;
import com.vaadin.ui.Button;
import com.vaadin.ui.Component;
import com.vaadin.ui.CustomComponent;
import com.vaadin.ui.Grid;
import com.vaadin.ui.HorizontalLayout;
import com.vaadin.ui.Notification;
import com.vaadin.ui.TextField;
import com.vaadin.ui.VerticalLayout;
import com.vaadin.ui.Window;
import com.vaadin.ui.components.grid.ItemClickListener;
import com.vaadin.ui.renderers.AbstractRenderer;
import com.vaadin.ui.renderers.ClickableRenderer;
import com.vaadin.ui.renderers.ImageRenderer;
import java.io.File;
import java.io.Serializable;
import java.sql.Timestamp;
import java.util.Collection;
import java.util.Date;
import javax.annotation.PostConstruct;
import org.eclipse.kuksa.appstore.client.HawkbitFeignClient;
import org.eclipse.kuksa.appstore.client.HawkbitMultiPartFileFeignClient;
import org.eclipse.kuksa.appstore.exception.AlreadyExistException;
import org.eclipse.kuksa.appstore.exception.BadRequestException;
import org.eclipse.kuksa.appstore.exception.NotFoundException;
import org.eclipse.kuksa.appstore.model.App;
import org.eclipse.kuksa.appstore.service.AppCategoryService;
import org.eclipse.kuksa.appstore.service.AppService;
import org.eclipse.kuksa.appstore.ui.AppEditor;
import org.eclipse.kuksa.appstore.ui.VaadinUI;
import org.eclipse.kuksa.appstore.ui.component.NavHeader;
import org.eclipse.kuksa.appstore.utils.Utils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.StringUtils;

@SpringView(name="appedit")
public class AppEditView
extends CustomComponent
implements View {
    public static final String VIEW_NAME = "appedit";
    public static final String TITLE_NAME = "App Edit";
    final AppEditor appEditor = new AppEditor();
    final Grid<App> grid;
    final TextField searchText;
    final Window appEditorWindow = new Window("App Editor");
    private final Button addNewBtn;
    @Autowired
    AppService appService;
    @Autowired
    AppCategoryService appCategoryService;
    @Autowired
    HawkbitFeignClient hawkbitFeignClient;
    @Autowired
    HawkbitMultiPartFileFeignClient hawkbitMultiPartFileFeignClient;

    @Autowired
    public AppEditView() {
        Page.getCurrent().setTitle(TITLE_NAME);
        this.grid = new Grid(App.class);
        this.searchText = new TextField();
        this.addNewBtn = new Button("New App", (Resource)FontAwesome.PLUS);
        this.addNewBtn.setStyleName("v-button-primary");
        VerticalLayout popupContent = new VerticalLayout();
        popupContent.addComponent((Component)this.appEditor);
        this.appEditorWindow.setContent((Component)popupContent);
        this.appEditorWindow.center();
        this.appEditorWindow.setModal(true);
        this.appEditorWindow.setResizable(false);
        HorizontalLayout actions = new HorizontalLayout(new Component[]{this.searchText, this.addNewBtn});
        actions.setStyleName("v-actions");
        HorizontalLayout gridLayout = new HorizontalLayout();
        gridLayout.addComponent((Component)this.grid);
        gridLayout.setWidth("100%");
        gridLayout.setStyleName("v-mainGrid");
        VerticalLayout mainLayout = new VerticalLayout(new Component[]{new NavHeader().create(VIEW_NAME, VaadinSession.getCurrent().getAttribute("isCurrentUserAdmin").toString()), actions, gridLayout});
        this.grid.setWidth("100%");
        this.grid.setHeightMode(HeightMode.UNDEFINED);
        this.grid.setColumns(new String[]{"id", "name", "version", "owner"});
        this.grid.setHeightMode(HeightMode.UNDEFINED);
        Grid.Column categoryColumn = this.grid.addColumn((ValueProvider & Serializable)app -> app.getAppcategory().getName());
        categoryColumn.setCaption("Category");
        this.addEditColumn("Edit");
        this.addNewBtn.addClickListener((Button.ClickListener & Serializable)e -> {
            this.appEditorWindow.center();
            VaadinUI.getCurrent().addWindow(this.appEditorWindow);
            this.appEditor.editApp(new App(null, "", "", "", "", "", 0, null));
        });
        this.appEditor.save.addClickListener((Button.ClickListener & Serializable)e -> {
            if (this.appEditor.app.getId() != null) {
                this.appEditor.app.setPublishdate((Date)new Timestamp(new Date().getTime()));
                try {
                    this.appService.updateApp(this.appEditor.app.getId().toString(), this.appEditor.app);
                    this.listApps(null);
                    VaadinUI.getCurrent().removeWindow(this.appEditorWindow);
                    new Notification("Succes Updating", "The App has been updated.", Notification.Type.TRAY_NOTIFICATION).show(Page.getCurrent());
                }
                catch (NotFoundException e1) {
                    new Notification("Not Found Exception", e1.getMessage(), Notification.Type.ERROR_MESSAGE).show(Page.getCurrent());
                }
                catch (BadRequestException e1) {
                    new Notification(e1.getMessage(), Notification.Type.ERROR_MESSAGE).show(Page.getCurrent());
                }
                catch (AlreadyExistException e1) {
                    new Notification("Already Exist Exception", "App Name already exists.", Notification.Type.ERROR_MESSAGE).show(Page.getCurrent());
                }
            } else {
                this.appEditor.app.setPublishdate((Date)new Timestamp(new Date().getTime()));
                try {
                    this.appService.createApp(this.appEditor.app);
                    this.listApps(null);
                    VaadinUI.getCurrent().removeWindow(this.appEditorWindow);
                    new Notification("Succes Updating", "The App has been updated.", Notification.Type.TRAY_NOTIFICATION).show(Page.getCurrent());
                }
                catch (AlreadyExistException e1) {
                    new Notification("Already Exist Exception", "App Name already exists.", Notification.Type.ERROR_MESSAGE).show(Page.getCurrent());
                }
                catch (BadRequestException e1) {
                    new Notification("Bad Request Exception", e1.getMessage(), Notification.Type.ERROR_MESSAGE).show(Page.getCurrent());
                }
            }
        });
        this.appEditor.delete.addClickListener((Button.ClickListener & Serializable)e -> {
            try {
                this.appService.deleteApp(this.appEditor.app.getId().toString());
                this.listApps(null);
                VaadinUI.getCurrent().removeWindow(this.appEditorWindow);
                new Notification("Succes Deleting", "The App has been deleted.", Notification.Type.TRAY_NOTIFICATION).show(Page.getCurrent());
            }
            catch (NotFoundException e1) {
                new Notification(e1.getMessage(), Notification.Type.ERROR_MESSAGE).show(Page.getCurrent());
            }
        });
        this.searchText.setPlaceholder("Search by App Name");
        this.searchText.addValueChangeListener((HasValue.ValueChangeListener & Serializable)event -> {
            VaadinUI.getCurrent().removeWindow(this.appEditorWindow);
            this.listApps((String)event.getValue());
        });
        this.setCompositionRoot((Component)mainLayout);
    }

    private void addEditColumn(String caption) {
        ImageRenderer renderer = new ImageRenderer();
        renderer.addClickListener((ClickableRenderer.RendererClickListener & Serializable)e -> this.iconClicked((App)e.getItem()));
        Grid.Column iconColumn = this.grid.addColumn((ValueProvider & Serializable)i -> new ThemeResource("img/edit.png"), (AbstractRenderer)renderer);
        iconColumn.setCaption(caption);
        iconColumn.setMaximumWidth(70.0);
        this.grid.addItemClickListener((ItemClickListener & Serializable)e -> {
            if (e.getColumn().equals((Object)iconColumn)) {
                this.iconClicked((App)e.getItem());
            }
        });
    }

    private void iconClicked(App app) {
        App item = this.appService.findById(app.getId());
        this.appEditor.editApp(item);
        this.appEditor.appimage.setVisible(true);
        try {
            new File(Utils.getImageFolderPath()).mkdirs();
            File new_file = new File(Utils.getImageFilePath() + item.getId() + ".png");
            if (new_file.exists()) {
                this.appEditor.appimage.setSource((Resource)new FileResource(new_file));
                this.appEditor.upload.setButtonCaption("Change Image");
            } else {
                this.appEditor.upload.setButtonCaption("Add Image");
                this.appEditor.appimage.setSource((Resource)new ThemeResource("img/noimage.png"));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.grid.select((Object)item);
        this.appEditorWindow.center();
        VaadinUI.getCurrent().addWindow(this.appEditorWindow);
    }

    @PostConstruct
    public void init() {
        this.listApps(null);
        this.appEditor.setAppCategoryService(this.appCategoryService);
        this.appEditor.setAppService(this.appService);
        this.appEditor.setMessageFeignClient(this.hawkbitFeignClient);
        this.appEditor.setHawkbitFeignClient(this.hawkbitMultiPartFileFeignClient);
    }

    void listApps(String searchText) {
        if (StringUtils.isEmpty((Object)searchText)) {
            this.grid.setItems((Collection)this.appService.findAll());
        } else {
            this.grid.setItems((Collection)this.appService.findByNameStartsWithIgnoreCase(searchText));
        }
    }

    public void enter(ViewChangeListener.ViewChangeEvent event) {
    }
}

