/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.kuksa.appstore.ui;

import com.vaadin.navigator.View;
import com.vaadin.navigator.ViewChangeListener;
import com.vaadin.server.FileResource;
import com.vaadin.server.Page;
import com.vaadin.server.Resource;
import com.vaadin.server.Sizeable;
import com.vaadin.server.ThemeResource;
import com.vaadin.server.VaadinSession;
import com.vaadin.spring.annotation.SpringView;
import com.vaadin.ui.Button;
import com.vaadin.ui.ComboBox;
import com.vaadin.ui.Component;
import com.vaadin.ui.CustomComponent;
import com.vaadin.ui.CustomLayout;
import com.vaadin.ui.Image;
import com.vaadin.ui.Label;
import com.vaadin.ui.Notification;
import com.vaadin.ui.VerticalLayout;
import java.io.File;
import java.util.Collection;
import java.util.List;
import javax.annotation.PostConstruct;
import org.eclipse.kuksa.appstore.client.HawkbitFeignClient;
import org.eclipse.kuksa.appstore.exception.BadRequestException;
import org.eclipse.kuksa.appstore.model.App;
import org.eclipse.kuksa.appstore.model.User;
import org.eclipse.kuksa.appstore.service.AppService;
import org.eclipse.kuksa.appstore.service.UserService;
import org.eclipse.kuksa.appstore.ui.component.NavHeader;
import org.eclipse.kuksa.appstore.utils.Utils;
import org.springframework.beans.factory.annotation.Autowired;

@SpringView(name="app")
public class AppView
extends CustomComponent
implements View {
    public static final String VIEW_NAME = "app";
    public static final String TITLE_NAME = "App";
    private String imgPath = "img";
    User currentUser;
    CustomLayout appslayout;
    VerticalLayout mainlayout;
    @Autowired
    HawkbitFeignClient hawkbitFeignClient;
    App currentApp;
    @Autowired
    UserService userService;
    @Autowired
    AppService appService;
    Button purchase_install;
    Button uninstallButton;

    @PostConstruct
    public void init() {
        if (VaadinSession.getCurrent().getAttribute(VIEW_NAME) != null) {
            this.currentApp = this.appService.findById(Long.valueOf(Long.parseLong(VaadinSession.getCurrent().getAttribute(VIEW_NAME).toString())));
        } else {
            new Notification("No Selected App", "You have to select an app to show it's details.", Notification.Type.ERROR_MESSAGE).show(Page.getCurrent());
            Page.getCurrent().setUriFragment("!applist");
        }
        this.currentUser = this.userService.findByUserName(VaadinSession.getCurrent().getAttribute("user").toString());
        Page.getCurrent().setTitle("App-" + this.currentApp.getName());
        this.mainlayout = new VerticalLayout();
        this.appslayout = new CustomLayout("my-layout");
        this.mainlayout.addComponent((Component)new NavHeader().create(VIEW_NAME, VaadinSession.getCurrent().getAttribute("isCurrentUserAdmin").toString()));
        Image image = new Image();
        image.setWidth("300");
        image.setHeight("200");
        File new_file = new File(Utils.getImageFilePath() + this.currentApp.getId() + ".png");
        if (new_file.exists()) {
            image.setSource((Resource)new FileResource(new_file));
        } else {
            image.setSource((Resource)new ThemeResource(this.imgPath + "/noimage.png"));
        }
        this.appslayout.addComponent((Component)image, "appimage");
        this.appslayout.addComponent((Component)new Label(this.currentApp.getName()), "appname");
        this.createInstallButtonorBuyButton();
        Label categorylabel = new Label(this.currentApp.getAppcategory().getName());
        categorylabel.setStyleName("alnleft");
        categorylabel.setWidth(100.0f, Sizeable.Unit.PERCENTAGE);
        this.appslayout.addComponent((Component)categorylabel, "appcategory");
        Label desclabel = new Label(this.currentApp.getDescription());
        desclabel.setStyleName("alnleft");
        desclabel.setWidth(100.0f, Sizeable.Unit.PERCENTAGE);
        this.appslayout.addComponent((Component)desclabel, "appdesc");
        Label publishdatelabel = new Label(this.currentApp.getPublishdate().toLocaleString());
        publishdatelabel.setStyleName("alnleft");
        publishdatelabel.setWidth(100.0f, Sizeable.Unit.PERCENTAGE);
        this.appslayout.addComponent((Component)publishdatelabel, "apppublishdate");
        Label versionlabel = new Label(this.currentApp.getVersion());
        versionlabel.setStyleName("alnleft");
        versionlabel.setWidth(100.0f, Sizeable.Unit.PERCENTAGE);
        this.appslayout.addComponent((Component)versionlabel, "appversion");
        Label ownerlabel = new Label(this.currentApp.getOwner());
        ownerlabel.setStyleName("alnleft");
        ownerlabel.setWidth(100.0f, Sizeable.Unit.PERCENTAGE);
        this.appslayout.addComponent((Component)ownerlabel, "appowner");
        Label countlabel = new Label(Integer.toString(this.currentApp.getDownloadcount()));
        countlabel.setStyleName("alnleft");
        countlabel.setWidth(100.0f, Sizeable.Unit.PERCENTAGE);
        this.appslayout.addComponent((Component)countlabel, "appcount");
        this.mainlayout.addComponent((Component)this.appslayout);
        this.setCompositionRoot((Component)this.mainlayout);
    }

    public void enter(ViewChangeListener.ViewChangeEvent event) {
    }

    private void createInstallButtonorBuyButton() {
        boolean isOwner;
        List listOfTargets;
        try {
            listOfTargets = this.appService.getListOfTargets(this.currentUser.getId());
            isOwner = this.userService.isUsersAppOwner(this.currentUser.getId().toString(), this.currentApp.getId(), this.appService.getListOfOem(listOfTargets));
        }
        catch (BadRequestException e1) {
            new Notification(e1.getMessage(), Notification.Type.ERROR_MESSAGE).show(Page.getCurrent());
            return;
        }
        if (isOwner) {
            ComboBox comboBoxDevice = new ComboBox("Select A Device");
            comboBoxDevice.setItems((Collection)listOfTargets);
            comboBoxDevice.setPlaceholder("No device selected");
            comboBoxDevice.setEmptySelectionAllowed(false);
            comboBoxDevice.setWidth("300");
            this.appslayout.addComponent((Component)comboBoxDevice, "appselectdevice");
            this.purchase_install = new Button("Install App");
            this.purchase_install.addClickListener((Button.ClickListener)new /* Unavailable Anonymous Inner Class!! */);
            this.uninstallButton = new Button("Uninstall App");
            this.uninstallButton.addClickListener((Button.ClickListener)new /* Unavailable Anonymous Inner Class!! */);
            this.uninstallButton.setWidth("300");
            this.appslayout.addComponent((Component)this.uninstallButton, "appuninstall");
        } else {
            this.purchase_install = new Button("Purchase this App");
            this.purchase_install.addClickListener((Button.ClickListener)new /* Unavailable Anonymous Inner Class!! */);
        }
        this.purchase_install.setWidth("300");
        this.appslayout.addComponent((Component)this.purchase_install, "appinstall");
    }
}

