/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.kuksa.appstore.ui;

import com.vaadin.addon.pagination.Pagination;
import com.vaadin.addon.pagination.PaginationChangeListener;
import com.vaadin.addon.pagination.PaginationResource;
import com.vaadin.data.HasValue;
import com.vaadin.navigator.View;
import com.vaadin.navigator.ViewChangeListener;
import com.vaadin.server.VaadinSession;
import com.vaadin.spring.annotation.SpringView;
import com.vaadin.ui.ComboBox;
import com.vaadin.ui.Component;
import com.vaadin.ui.CssLayout;
import com.vaadin.ui.CustomComponent;
import com.vaadin.ui.HorizontalLayout;
import com.vaadin.ui.ItemCaptionGenerator;
import com.vaadin.ui.TextField;
import com.vaadin.ui.VerticalLayout;
import java.io.Serializable;
import java.util.Collection;
import javax.annotation.PostConstruct;
import org.eclipse.kuksa.appstore.model.App;
import org.eclipse.kuksa.appstore.service.AppCategoryService;
import org.eclipse.kuksa.appstore.service.AppService;
import org.eclipse.kuksa.appstore.ui.AppsListView;
import org.eclipse.kuksa.appstore.ui.component.AppGridView;
import org.eclipse.kuksa.appstore.ui.component.NavHeader;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;

@SpringView(name="applist")
public class AppsListView
extends CustomComponent
implements View {
    public static final String VIEW_NAME = "applist";
    public static final String TITLE_NAME = "App List";
    final TextField serachText;
    final ComboBox<String> comboBox = new ComboBox();
    VerticalLayout mainlayout;
    CssLayout appslayout;
    Component paginationComponent;
    HorizontalLayout navHeaderLayout;
    HorizontalLayout actions;
    @Autowired
    AppService appService;
    @Autowired
    AppCategoryService appCategoryService;

    @Autowired
    public AppsListView() {
        com.vaadin.server.Page.getCurrent().setTitle(TITLE_NAME);
        this.serachText = new TextField();
        this.appslayout = new CssLayout();
        this.mainlayout = new VerticalLayout();
    }

    @PostConstruct
    public void init() {
        int currentpage = 1;
        int limit = 9;
        Page appsList = this.findByText(this.serachText.getValue(), (String)this.comboBox.getValue(), currentpage - 1, limit);
        int total = (int)appsList.getTotalElements();
        this.appslayout = AppGridView.crateAppGridView((Page)appsList, (int)3);
        this.navHeaderLayout = new NavHeader().create(VIEW_NAME, VaadinSession.getCurrent().getAttribute("isCurrentUserAdmin").toString());
        this.mainlayout.addComponent((Component)this.navHeaderLayout);
        1 icg = new /* Unavailable Anonymous Inner Class!! */;
        this.comboBox.setItemCaptionGenerator((ItemCaptionGenerator)icg);
        this.comboBox.setItems((Collection)this.appCategoryService.getAllId());
        this.comboBox.setPlaceholder("Select a category");
        this.comboBox.setEmptySelectionCaption("All");
        this.comboBox.setEmptySelectionAllowed(true);
        this.comboBox.addValueChangeListener((HasValue.ValueChangeListener & Serializable)event -> this.listApps(this.serachText.getValue(), (String)event.getValue()));
        this.actions = new HorizontalLayout(new Component[]{this.comboBox, this.serachText});
        this.actions.setStyleName("v-actions");
        this.serachText.setPlaceholder("Search by App Name");
        this.serachText.addValueChangeListener((HasValue.ValueChangeListener & Serializable)event -> this.listApps((String)event.getValue(), (String)this.comboBox.getValue()));
        this.mainlayout.addComponent((Component)this.actions);
        this.mainlayout.addComponent((Component)this.appslayout);
        this.paginationComponent = this.createPaginationComponent(total, currentpage, limit);
        this.mainlayout.addComponent(this.paginationComponent);
        this.setCompositionRoot((Component)this.mainlayout);
    }

    public void listApps(String text, String categoryId) {
        int currentpage = 1;
        int limit = 9;
        Page appsList = this.findByText(text, categoryId, currentpage - 1, limit);
        int total = (int)appsList.getTotalElements();
        CssLayout appslayoutnew = new CssLayout();
        appslayoutnew = AppGridView.crateAppGridView((Page)appsList, (int)3);
        this.mainlayout.removeAllComponents();
        this.mainlayout.addComponent((Component)this.navHeaderLayout);
        this.mainlayout.addComponent((Component)this.actions);
        this.mainlayout.addComponent((Component)appslayoutnew);
        this.paginationComponent = this.createPaginationComponent(total, currentpage, limit);
        this.mainlayout.addComponent(this.paginationComponent);
        this.setCompositionRoot((Component)this.mainlayout);
    }

    public Component createPaginationComponent(int total, int currentpage, int limit) {
        Pagination pagination = this.createPagination((long)total, currentpage, limit);
        pagination.setItemsPerPageVisible(false);
        pagination.setEnabled(true);
        pagination.setResponsive(true);
        pagination.setTotalCount((long)total);
        pagination.setCurrentPage(currentpage);
        pagination.addPageChangeListener((PaginationChangeListener)new /* Unavailable Anonymous Inner Class!! */);
        VerticalLayout layout = this.createContent(pagination);
        return layout;
    }

    public Page<App> findByText(String text, String categoryId, int page, int size) {
        PageRequest pageable = new PageRequest(page, size);
        if (text == null && categoryId == null) {
            return null;
        }
        Page users = text == null && categoryId != null ? this.appService.findByAppcategoryId(Long.valueOf(Long.parseLong(categoryId)), (Pageable)pageable) : (text != null && categoryId == null ? this.appService.findByNameStartsWithIgnoreCase(text, (Pageable)pageable) : this.appService.findByNameStartsWithIgnoreCaseAndAppcategoryId(text, Long.valueOf(Long.parseLong(categoryId)), (Pageable)pageable));
        return users;
    }

    private Pagination createPagination(long total, int page, int limit) {
        PaginationResource paginationResource = PaginationResource.newBuilder().setTotal(total).setPage(page).setLimit(limit).build();
        Pagination pagination = new Pagination(paginationResource);
        pagination.setItemsPerPage(new int[]{10, 20, 50, 100});
        return pagination;
    }

    private VerticalLayout createContent(Pagination pagination) {
        VerticalLayout layout = new VerticalLayout();
        layout.setSizeFull();
        layout.setSpacing(true);
        layout.addComponents(new Component[]{pagination});
        return layout;
    }

    public void enter(ViewChangeListener.ViewChangeEvent event) {
    }

    static /* synthetic */ void access$000(AppsListView x0, Component x1) {
        x0.setCompositionRoot(x1);
    }
}

