/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.kuksa.appstore.ui;

import com.vaadin.addon.pagination.Pagination;
import com.vaadin.addon.pagination.PaginationChangeListener;
import com.vaadin.addon.pagination.PaginationResource;
import com.vaadin.navigator.View;
import com.vaadin.navigator.ViewChangeListener;
import com.vaadin.server.VaadinSession;
import com.vaadin.spring.annotation.SpringView;
import com.vaadin.ui.Component;
import com.vaadin.ui.CssLayout;
import com.vaadin.ui.CustomComponent;
import com.vaadin.ui.HorizontalLayout;
import com.vaadin.ui.Notification;
import com.vaadin.ui.VerticalLayout;
import javax.annotation.PostConstruct;
import org.eclipse.kuksa.appstore.exception.BadRequestException;
import org.eclipse.kuksa.appstore.model.App;
import org.eclipse.kuksa.appstore.model.User;
import org.eclipse.kuksa.appstore.service.AppService;
import org.eclipse.kuksa.appstore.service.UserService;
import org.eclipse.kuksa.appstore.ui.component.AppGridView;
import org.eclipse.kuksa.appstore.ui.component.NavHeader;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;

@SpringView(name="purchasedapps")
public class PurchasedAppsListView
extends CustomComponent
implements View {
    public static final String VIEW_NAME = "purchasedapps";
    public static final String TITLE_NAME = "Purchased Apps";
    User currentUser;
    VerticalLayout mainlayout;
    CssLayout appslayout;
    Component paginationComponent;
    HorizontalLayout navHeaderLayout;
    @Autowired
    UserService userService;
    @Autowired
    AppService appService;

    @Autowired
    public PurchasedAppsListView() {
        com.vaadin.server.Page.getCurrent().setTitle(TITLE_NAME);
        this.appslayout = new CssLayout();
        this.mainlayout = new VerticalLayout();
    }

    @PostConstruct
    public void init() {
        int currentpage = 1;
        int limit = 6;
        Page appsList = this.findOwnApps(currentpage - 1, limit);
        int total = (int)appsList.getTotalElements();
        this.appslayout = AppGridView.crateAppGridView((Page)appsList, (int)2);
        this.navHeaderLayout = new NavHeader().create(VIEW_NAME, VaadinSession.getCurrent().getAttribute("isCurrentUserAdmin").toString());
        this.mainlayout.addComponent((Component)this.navHeaderLayout);
        this.mainlayout.addComponent((Component)this.appslayout);
        this.paginationComponent = this.createPaginationComponent(total, currentpage, limit);
        this.mainlayout.addComponent(this.paginationComponent);
        this.setCompositionRoot((Component)this.mainlayout);
    }

    public void listApps(String text) {
        int currentpage = 1;
        int limit = 6;
        Page appsList = this.findOwnApps(currentpage - 1, limit);
        int total = (int)appsList.getTotalElements();
        CssLayout appslayoutnew = new CssLayout();
        appslayoutnew = AppGridView.crateAppGridView((Page)appsList, (int)2);
        this.mainlayout.removeAllComponents();
        this.mainlayout.addComponent((Component)this.navHeaderLayout);
        this.mainlayout.addComponent((Component)appslayoutnew);
        this.paginationComponent = this.createPaginationComponent(total, currentpage, limit);
        this.mainlayout.addComponent(this.paginationComponent);
        this.setCompositionRoot((Component)this.mainlayout);
    }

    public Component createPaginationComponent(int total, int currentpage, int limit) {
        Pagination pagination = this.createPagination((long)total, currentpage, limit);
        pagination.setItemsPerPageVisible(false);
        pagination.setEnabled(true);
        pagination.setResponsive(true);
        pagination.setTotalCount((long)total);
        pagination.setCurrentPage(currentpage);
        pagination.addPageChangeListener((PaginationChangeListener)new /* Unavailable Anonymous Inner Class!! */);
        VerticalLayout layout = this.createContent(pagination);
        return layout;
    }

    public Page<App> findOwnApps(int page, int size) {
        Page apps;
        PageRequest pageable = new PageRequest(page, size);
        this.currentUser = this.userService.findByUserName(VaadinSession.getCurrent().getAttribute("user").toString());
        try {
            apps = this.appService.findUsersApps(this.currentUser.getId().toString(), this.appService.getListOfOem(this.appService.getListOfTargets(this.currentUser.getId())), (Pageable)pageable);
        }
        catch (BadRequestException e) {
            new Notification(e.getMessage(), Notification.Type.ERROR_MESSAGE).show(com.vaadin.server.Page.getCurrent());
            return null;
        }
        return apps;
    }

    private Pagination createPagination(long total, int page, int limit) {
        PaginationResource paginationResource = PaginationResource.newBuilder().setTotal(total).setPage(page).setLimit(limit).build();
        Pagination pagination = new Pagination(paginationResource);
        pagination.setItemsPerPage(new int[]{10, 20, 50, 100});
        return pagination;
    }

    private VerticalLayout createContent(Pagination pagination) {
        VerticalLayout layout = new VerticalLayout();
        layout.setSizeFull();
        layout.setSpacing(true);
        layout.addComponents(new Component[]{pagination});
        return layout;
    }

    public void enter(ViewChangeListener.ViewChangeEvent event) {
    }

    static /* synthetic */ void access$000(PurchasedAppsListView x0, Component x1) {
        x0.setCompositionRoot(x1);
    }
}

