/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.kuksa.appstore.ui;

import com.vaadin.data.HasValue;
import com.vaadin.data.ValueProvider;
import com.vaadin.navigator.View;
import com.vaadin.navigator.ViewChangeListener;
import com.vaadin.server.FontAwesome;
import com.vaadin.server.Page;
import com.vaadin.server.Resource;
import com.vaadin.server.ThemeResource;
import com.vaadin.server.VaadinSession;
import com.vaadin.shared.ui.grid.HeightMode;
import com.vaadin.spring.annotation.SpringView;
import com.vaadin.ui.Button;
import com.vaadin.ui.Component;
import com.vaadin.ui.CustomComponent;
import com.vaadin.ui.Grid;
import com.vaadin.ui.HorizontalLayout;
import com.vaadin.ui.Notification;
import com.vaadin.ui.TextField;
import com.vaadin.ui.VerticalLayout;
import com.vaadin.ui.Window;
import com.vaadin.ui.components.grid.ItemClickListener;
import com.vaadin.ui.renderers.AbstractRenderer;
import com.vaadin.ui.renderers.ClickableRenderer;
import com.vaadin.ui.renderers.ImageRenderer;
import java.io.Serializable;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import javax.annotation.PostConstruct;
import org.eclipse.kuksa.appstore.exception.AlreadyExistException;
import org.eclipse.kuksa.appstore.exception.BadRequestException;
import org.eclipse.kuksa.appstore.exception.NotFoundException;
import org.eclipse.kuksa.appstore.model.User;
import org.eclipse.kuksa.appstore.model.UserType;
import org.eclipse.kuksa.appstore.service.OemService;
import org.eclipse.kuksa.appstore.service.UserService;
import org.eclipse.kuksa.appstore.ui.UserEditor;
import org.eclipse.kuksa.appstore.ui.VaadinUI;
import org.eclipse.kuksa.appstore.ui.component.NavHeader;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.StringUtils;

@SpringView(name="userlist")
public class UserEditView
extends CustomComponent
implements View {
    public static final String VIEW_NAME = "userlist";
    public static final String TITLE_NAME = "User List";
    final UserEditor userEditor = new UserEditor();
    final Grid<User> grid;
    final TextField searchText;
    final Window userEditorWindow = new Window("User Editor");
    private final Button addNewBtn;
    @Autowired
    UserService userService;
    @Autowired
    OemService oemService;
    User currentUser;
    HorizontalLayout actions;

    @Autowired
    public UserEditView() {
        Page.getCurrent().setTitle(TITLE_NAME);
        this.grid = new Grid(User.class);
        this.searchText = new TextField();
        this.addNewBtn = new Button("New User", (Resource)FontAwesome.PLUS);
        this.addNewBtn.setStyleName("v-button-primary");
        VerticalLayout popupContent = new VerticalLayout();
        popupContent.addComponent((Component)this.userEditor);
        this.userEditorWindow.setContent((Component)popupContent);
        this.userEditorWindow.center();
        this.userEditorWindow.setModal(true);
        this.userEditorWindow.setResizable(false);
        this.actions = new HorizontalLayout(new Component[]{this.searchText, this.addNewBtn});
        this.actions.setStyleName("v-actions");
        HorizontalLayout gridLayout = new HorizontalLayout();
        gridLayout.addComponent((Component)this.grid);
        gridLayout.setWidth("100%");
        gridLayout.setStyleName("v-mainGrid");
        VerticalLayout mainLayout = new VerticalLayout(new Component[]{new NavHeader().create(VIEW_NAME, VaadinSession.getCurrent().getAttribute("isCurrentUserAdmin").toString()), this.actions, gridLayout});
        this.grid.setWidth("100%");
        this.grid.setHeightMode(HeightMode.UNDEFINED);
        this.grid.setColumns(new String[]{"id", "username", "password", "userType"});
        this.grid.getColumn("username").setCaption("User Name");
        this.grid.getColumn("password").setCaption("Password");
        this.grid.getColumn("userType").setCaption("User Type");
        this.addEditColumn("Edit");
        this.userEditor.comboBoxUserType.addValueChangeListener((HasValue.ValueChangeListener & Serializable)event -> this.userEditorWindow.center());
        this.addNewBtn.addClickListener((Button.ClickListener & Serializable)e -> {
            this.userEditorWindow.center();
            VaadinUI.getCurrent().addWindow(this.userEditorWindow);
            this.userEditor.editUser(new User(null, "", "", UserType.Normal, null, null));
        });
        this.userEditor.save.addClickListener((Button.ClickListener & Serializable)e -> {
            if (this.userEditor.user.getUsername() != null && !this.userEditor.user.getUsername().isEmpty() && this.userEditor.user.getPassword() != null && !this.userEditor.user.getPassword().isEmpty()) {
                if (this.userEditor.user.getUserType() != UserType.GroupAdmin && this.userEditor.user.getOem() != null) {
                    this.userEditor.user.setOem(null);
                }
                if (this.userEditor.user.getUserType() != UserType.GroupAdmin && this.userEditor.user.getId() != null) {
                    this.userService.deleteAllMembers(this.userEditor.user.getId().toString());
                }
                List rightList = this.userEditor.right.getDataCommunicator().fetchItemsWithRange(0, this.userEditor.right.getDataCommunicator().getDataProviderSize());
                HashSet<User> newmemberList = new HashSet<User>();
                for (int i = 0; i < rightList.size(); ++i) {
                    newmemberList.add(this.userService.findById(((User)rightList.get(i)).getId().toString()));
                }
                this.userEditor.user.setMembers(newmemberList);
                if (this.userEditor.user.getId() != null) {
                    try {
                        this.userService.deleteAllMembers(this.userEditor.user.getId().toString());
                        this.userService.updateUser(this.userEditor.user.getId().toString(), this.userEditor.user);
                        this.listUsers(null);
                        VaadinUI.getCurrent().removeWindow(this.userEditorWindow);
                        new Notification("Succes Updating", "The User has been updated.", Notification.Type.TRAY_NOTIFICATION).show(Page.getCurrent());
                    }
                    catch (NotFoundException e1) {
                        new Notification("NotFound Exist Exception", "User not found.", Notification.Type.ERROR_MESSAGE).show(Page.getCurrent());
                    }
                    catch (BadRequestException e1) {
                        new Notification("Bad Request Exception", e1.getMessage(), Notification.Type.ERROR_MESSAGE).show(Page.getCurrent());
                    }
                    catch (AlreadyExistException e1) {
                        new Notification("Already Exist Exception", "Username already exists.", Notification.Type.ERROR_MESSAGE).show(Page.getCurrent());
                    }
                } else {
                    try {
                        this.userService.createUser(this.userEditor.user.getUsername(), this.userEditor.user.getPassword(), this.userEditor.user.getUserType(), this.userEditor.user.getOem(), this.userEditor.user.getMembers());
                        this.listUsers(null);
                        VaadinUI.getCurrent().removeWindow(this.userEditorWindow);
                        new Notification("Succes Creating", "The User has been created.", Notification.Type.TRAY_NOTIFICATION).show(Page.getCurrent());
                    }
                    catch (AlreadyExistException e1) {
                        new Notification("Already Exist Exception", e1.getMessage(), Notification.Type.ERROR_MESSAGE).show(Page.getCurrent());
                    }
                    catch (BadRequestException e1) {
                        new Notification("Bad Request Exception", e1.getMessage(), Notification.Type.ERROR_MESSAGE).show(Page.getCurrent());
                    }
                }
            } else {
                new Notification("Fill the mandatory fields", "Username and Password are mandatory fields.", Notification.Type.ERROR_MESSAGE).show(Page.getCurrent());
            }
        });
        this.userEditor.delete.addClickListener((Button.ClickListener & Serializable)e -> {
            this.userService.deleteUser(this.userEditor.user);
            this.listUsers(null);
            VaadinUI.getCurrent().removeWindow(this.userEditorWindow);
            new Notification("Succes Deleting", "The User has been deleted.", Notification.Type.TRAY_NOTIFICATION).show(Page.getCurrent());
        });
        this.searchText.setPlaceholder("Search by Username");
        this.searchText.addValueChangeListener((HasValue.ValueChangeListener & Serializable)event -> this.listUsers((String)event.getValue()));
        this.setCompositionRoot((Component)mainLayout);
    }

    private void addEditColumn(String caption) {
        ImageRenderer renderer = new ImageRenderer();
        renderer.addClickListener((ClickableRenderer.RendererClickListener & Serializable)e -> this.iconClicked((User)e.getItem()));
        Grid.Column iconColumn = this.grid.addColumn((ValueProvider & Serializable)i -> new ThemeResource("img/edit.png"), (AbstractRenderer)renderer);
        iconColumn.setCaption(caption);
        iconColumn.setMaximumWidth(70.0);
        this.grid.addItemClickListener((ItemClickListener & Serializable)e -> {
            if (e.getColumn().equals((Object)iconColumn)) {
                this.iconClicked((User)e.getItem());
            }
        });
    }

    private void iconClicked(User user) {
        User item = this.userService.findById(user.getId().toString());
        this.userEditor.editUser(item);
        this.grid.select((Object)item);
        this.userEditorWindow.center();
        VaadinUI.getCurrent().addWindow(this.userEditorWindow);
    }

    @PostConstruct
    public void init() {
        this.currentUser = this.userService.findByUserName(VaadinSession.getCurrent().getAttribute("user").toString());
        if (!this.currentUser.getUserType().equals((Object)UserType.SystemAdmin)) {
            this.actions.setVisible(false);
        }
        this.listUsers(null);
        this.userEditor.setUserService(this.userService);
        this.userEditor.setOemService(this.oemService);
    }

    public void listUsers(String searchText) {
        if (this.currentUser.getUserType().equals((Object)UserType.SystemAdmin)) {
            if (StringUtils.isEmpty((Object)searchText)) {
                this.grid.setItems((Collection)this.userService.findAll());
            } else {
                this.grid.setItems((Collection)this.userService.findByUserNameStartsWithIgnoreCase(searchText));
            }
            this.userEditor.comboBoxUserType.setEnabled(true);
        } else {
            this.grid.setItems((Object[])new User[]{this.userService.findByUserName(this.currentUser.getUsername())});
            this.userEditor.comboBoxUserType.setEnabled(false);
        }
    }

    public void enter(ViewChangeListener.ViewChangeEvent event) {
    }
}

